/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.AssemblyPlanner;
import cascading.operation.AssertionLevel;
import cascading.operation.DebugLevel;
import cascading.pipe.Checkpoint;
import cascading.pipe.Pipe;
import cascading.property.UnitOfWorkDef;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FlowDef
extends UnitOfWorkDef<FlowDef> {
    protected Map<String, Tap> sources = new HashMap<String, Tap>();
    protected Map<String, Tap> sinks = new HashMap<String, Tap>();
    protected Map<String, Tap> traps = new HashMap<String, Tap>();
    protected Map<String, Tap> checkpoints = new HashMap<String, Tap>();
    protected List<String> classPath = new ArrayList<String>();
    protected List<Pipe> tails = new ArrayList<Pipe>();
    protected List<AssemblyPlanner> assemblyPlanners = new ArrayList<AssemblyPlanner>();
    protected HashMap<String, String> flowDescriptor = new LinkedHashMap<String, String>();
    protected AssertionLevel assertionLevel;
    protected DebugLevel debugLevel;
    protected String runID;

    public static FlowDef flowDef() {
        return new FlowDef();
    }

    public List<AssemblyPlanner> getAssemblyPlanners() {
        return this.assemblyPlanners;
    }

    public FlowDef addAssemblyPlanner(AssemblyPlanner assemblyPlanner) {
        this.assemblyPlanners.add(assemblyPlanner);
        this.addDescriptions(assemblyPlanner.getFlowDescriptor());
        return this;
    }

    public Map<String, Tap> getSources() {
        return this.sources;
    }

    public Map<String, Tap> getSourcesCopy() {
        return new HashMap<String, Tap>(this.sources);
    }

    public HashMap<String, String> getFlowDescriptor() {
        return this.flowDescriptor;
    }

    public FlowDef addSource(String name2, Tap source2) {
        if (this.sources.containsKey(name2)) {
            throw new IllegalArgumentException("cannot add duplicate source: " + name2);
        }
        this.sources.put(name2, source2);
        return this;
    }

    public FlowDef addSource(Pipe pipe, Tap source2) {
        if (pipe == null) {
            throw new IllegalArgumentException("pipe may not be null");
        }
        Pipe[] heads2 = pipe.getHeads();
        if (heads2.length != 1) {
            throw new IllegalArgumentException("pipe has too many heads, found: " + Arrays.toString(Pipe.names(heads2)));
        }
        this.addSource(heads2[0].getName(), source2);
        return this;
    }

    public FlowDef addSources(Map<String, Tap> sources) {
        if (sources != null) {
            for (Map.Entry<String, Tap> entry2 : sources.entrySet()) {
                this.addSource(entry2.getKey(), entry2.getValue());
            }
        }
        return this;
    }

    public FlowDef addDescription(String description) {
        this.addDescription("description", description);
        return this;
    }

    public FlowDef addDescription(String key, String value2) {
        String original;
        if (Util.isEmpty(value2)) {
            return this;
        }
        if (this.flowDescriptor.containsKey(key) && !Util.isEmpty(original = this.flowDescriptor.get(key))) {
            value2 = original + "\u001e" + value2;
        }
        this.flowDescriptor.put(key, value2);
        return this;
    }

    public FlowDef addDescriptions(Map<String, String> descriptions) {
        for (Map.Entry<String, String> entry2 : descriptions.entrySet()) {
            this.addDescription(entry2.getKey(), entry2.getValue());
        }
        return this;
    }

    public Map<String, Tap> getSinks() {
        return this.sinks;
    }

    public Map<String, Tap> getSinksCopy() {
        return new HashMap<String, Tap>(this.sinks);
    }

    public FlowDef addSink(String name2, Tap sink2) {
        if (this.sinks.containsKey(name2)) {
            throw new IllegalArgumentException("cannot add duplicate sink: " + name2);
        }
        this.sinks.put(name2, sink2);
        return this;
    }

    public FlowDef addSink(Pipe tail, Tap sink2) {
        this.addSink(tail.getName(), sink2);
        return this;
    }

    public FlowDef addTailSink(Pipe tail, Tap sink2) {
        this.addSink(tail.getName(), sink2);
        this.addTail(tail);
        return this;
    }

    public FlowDef addSinks(Map<String, Tap> sinks) {
        if (sinks != null) {
            for (Map.Entry<String, Tap> entry2 : sinks.entrySet()) {
                this.addSink(entry2.getKey(), entry2.getValue());
            }
        }
        return this;
    }

    public Map<String, Tap> getTraps() {
        return this.traps;
    }

    public Map<String, Tap> getTrapsCopy() {
        return new HashMap<String, Tap>(this.traps);
    }

    public FlowDef addTrap(String name2, Tap trap) {
        if (this.traps.containsKey(name2)) {
            throw new IllegalArgumentException("cannot add duplicate trap: " + name2);
        }
        this.traps.put(name2, trap);
        return this;
    }

    public FlowDef addTrap(Pipe pipe, Tap trap) {
        this.addTrap(pipe.getName(), trap);
        return this;
    }

    public FlowDef addTraps(Map<String, Tap> traps) {
        if (traps != null) {
            for (Map.Entry<String, Tap> entry2 : traps.entrySet()) {
                this.addTrap(entry2.getKey(), entry2.getValue());
            }
        }
        return this;
    }

    public Map<String, Tap> getCheckpoints() {
        return this.checkpoints;
    }

    public Map<String, Tap> getCheckpointsCopy() {
        return new HashMap<String, Tap>(this.checkpoints);
    }

    public FlowDef addCheckpoint(String name2, Tap checkpoint) {
        if (this.checkpoints.containsKey(name2)) {
            throw new IllegalArgumentException("cannot add duplicate checkpoint: " + name2);
        }
        this.checkpoints.put(name2, checkpoint);
        return this;
    }

    public FlowDef addCheckpoint(Checkpoint pipe, Tap checkpoint) {
        this.addCheckpoint(pipe.getName(), checkpoint);
        return this;
    }

    public FlowDef addCheckpoints(Map<String, Tap> checkpoints) {
        if (checkpoints != null) {
            for (Map.Entry<String, Tap> entry2 : checkpoints.entrySet()) {
                this.addCheckpoint(entry2.getKey(), entry2.getValue());
            }
        }
        return this;
    }

    public List<Pipe> getTails() {
        return this.tails;
    }

    public Pipe[] getTailsArray() {
        return this.tails.toArray(new Pipe[this.tails.size()]);
    }

    public FlowDef addTail(Pipe tail) {
        if (tail != null) {
            this.tails.add(tail);
        }
        return this;
    }

    public FlowDef addTails(Collection<Pipe> tails2) {
        for (Pipe tail : tails2) {
            this.addTail(tail);
        }
        return this;
    }

    public FlowDef addTails(Pipe ... tails2) {
        for (Pipe tail : tails2) {
            this.addTail(tail);
        }
        return this;
    }

    public FlowDef setAssertionLevel(AssertionLevel assertionLevel) {
        this.assertionLevel = assertionLevel;
        return this;
    }

    public AssertionLevel getAssertionLevel() {
        return this.assertionLevel;
    }

    public FlowDef setDebugLevel(DebugLevel debugLevel) {
        this.debugLevel = debugLevel;
        return this;
    }

    public DebugLevel getDebugLevel() {
        return this.debugLevel;
    }

    public FlowDef setRunID(String runID) {
        if (runID != null && runID.isEmpty()) {
            return this;
        }
        this.runID = runID;
        return this;
    }

    public String getRunID() {
        return this.runID;
    }

    public List<String> getClassPath() {
        return this.classPath;
    }

    public FlowDef addToClassPath(String artifact) {
        if (artifact == null || artifact.isEmpty()) {
            return this;
        }
        this.classPath.add(artifact);
        return this;
    }
}

