/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.CascadingException;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.planner.FlowPlanner;
import cascading.flow.planner.PlatformInfo;
import cascading.pipe.Pipe;
import cascading.property.AppProps;
import cascading.property.PropertyUtil;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public abstract class FlowConnector {
    protected Map<Object, Object> properties;

    public Class getIntermediateSchemeClass(Map<Object, Object> properties) {
        Object type = PropertyUtil.getProperty(properties, "cascading.flowconnector.intermediateschemeclass", null);
        if (type == null) {
            return this.getDefaultIntermediateSchemeClass();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        try {
            return FlowConnector.class.getClassLoader().loadClass(type.toString());
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + type.toString(), exception);
        }
    }

    @Deprecated
    public static void setApplicationJarClass(Map<Object, Object> properties, Class type) {
        AppProps.setApplicationJarClass(properties, type);
    }

    @Deprecated
    public static void setApplicationJarPath(Map<Object, Object> properties, String path) {
        AppProps.setApplicationJarPath(properties, path);
    }

    protected abstract Class<? extends Scheme> getDefaultIntermediateSchemeClass();

    protected FlowConnector() {
        this.properties = new HashMap<Object, Object>();
    }

    protected FlowConnector(Map<Object, Object> properties) {
        this.properties = properties == null ? new HashMap<Object, Object>() : (properties instanceof Properties ? new Properties((Properties)properties) : new HashMap<Object, Object>(properties));
    }

    public Map<Object, Object> getProperties() {
        return Collections.unmodifiableMap(PropertyUtil.asFlatMap(this.properties));
    }

    public Flow connect(Tap source2, Tap sink2, Pipe tail) {
        return this.connect(null, source2, sink2, tail);
    }

    public Flow connect(String name2, Tap source2, Tap sink2, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source2);
        return this.connect(name2, sources, sink2, tail);
    }

    public Flow connect(String name2, Tap source2, Tap sink2, Tap trap, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source2);
        HashMap<String, Tap> traps = new HashMap<String, Tap>();
        traps.put(tail.getHeads()[0].getName(), trap);
        return this.connect(name2, sources, sink2, traps, tail);
    }

    public Flow connect(Map<String, Tap> sources, Tap sink2, Pipe tail) {
        return this.connect(null, sources, sink2, tail);
    }

    public Flow connect(String name2, Map<String, Tap> sources, Tap sink2, Pipe tail) {
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink2);
        return this.connect(name2, sources, sinks, tail);
    }

    public Flow connect(String name2, Map<String, Tap> sources, Tap sink2, Map<String, Tap> traps, Pipe tail) {
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink2);
        return this.connect(name2, sources, sinks, traps, tail);
    }

    public Flow connect(String name2, Tap source2, Tap sink2, Map<String, Tap> traps, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source2);
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink2);
        return this.connect(name2, sources, sinks, traps, tail);
    }

    public Flow connect(Tap source2, Map<String, Tap> sinks, Collection<Pipe> tails2) {
        return this.connect(null, source2, sinks, tails2.toArray(new Pipe[tails2.size()]));
    }

    public Flow connect(String name2, Tap source2, Map<String, Tap> sinks, Collection<Pipe> tails2) {
        return this.connect(name2, source2, sinks, tails2.toArray(new Pipe[tails2.size()]));
    }

    public Flow connect(Tap source2, Map<String, Tap> sinks, Pipe ... tails2) {
        return this.connect(null, source2, sinks, tails2);
    }

    public Flow connect(String name2, Tap source2, Map<String, Tap> sinks, Pipe ... tails2) {
        HashSet heads2 = new HashSet();
        for (Pipe pipe : tails2) {
            Collections.addAll(heads2, pipe.getHeads());
        }
        if (heads2.isEmpty()) {
            throw new IllegalArgumentException("no pipe instance found");
        }
        if (heads2.size() != 1) {
            throw new IllegalArgumentException("there may be only 1 head pipe instance, found " + heads2.size());
        }
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        for (Pipe pipe : heads2) {
            sources.put(pipe.getName(), source2);
        }
        return this.connect(name2, sources, sinks, tails2);
    }

    public Flow connect(Map<String, Tap> sources, Map<String, Tap> sinks, Pipe ... tails2) {
        return this.connect(null, sources, sinks, tails2);
    }

    public Flow connect(String name2, Map<String, Tap> sources, Map<String, Tap> sinks, Pipe ... tails2) {
        return this.connect(name2, sources, sinks, new HashMap<String, Tap>(), tails2);
    }

    public Flow connect(String name2, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, Pipe ... tails2) {
        name2 = name2 == null ? this.makeName(tails2) : name2;
        FlowDef flowDef = ((FlowDef)FlowDef.flowDef().setName(name2)).addSources(sources).addSinks(sinks).addTraps(traps).addTails(tails2);
        return this.connect(flowDef);
    }

    public Flow connect(FlowDef flowDef) {
        FlowPlanner flowPlanner = this.createFlowPlanner();
        flowPlanner.initialize(this, this.properties);
        return flowPlanner.buildFlow(flowDef);
    }

    protected abstract FlowPlanner createFlowPlanner();

    public PlatformInfo getPlatformInfo() {
        return this.createFlowPlanner().getPlatformInfo();
    }

    private String makeName(Pipe[] pipes) {
        Object[] names2 = new String[pipes.length];
        for (int i = 0; i < pipes.length; ++i) {
            names2[i] = pipes[i].getName();
        }
        String name2 = Util.join(names2, "+");
        if (name2.length() > 32) {
            name2 = name2.substring(0, 32);
        }
        return name2;
    }
}

