/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.FlowListener;
import cascading.flow.FlowProcess;
import cascading.flow.FlowSkipStrategy;
import cascading.flow.FlowStep;
import cascading.flow.FlowStepListener;
import cascading.flow.FlowStepStrategy;
import cascading.flow.planner.PlatformInfo;
import cascading.management.UnitOfWork;
import cascading.stats.FlowStats;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface Flow<Config>
extends UnitOfWork<FlowStats> {
    public static final String CASCADING_FLOW_ID = "cascading.flow.id";

    @Override
    public String getName();

    @Override
    public void prepare();

    @Override
    public void start();

    @Override
    public void stop();

    @Override
    public void complete();

    @Override
    public void cleanup();

    public Config getConfig();

    public Config getConfigCopy();

    public Map<Object, Object> getConfigAsProperties();

    public String getProperty(String var1);

    @Override
    public String getID();

    public Map<String, String> getFlowDescriptor();

    @Override
    public String getTags();

    public int getSubmitPriority();

    public void setSubmitPriority(int var1);

    public FlowProcess<Config> getFlowProcess();

    public FlowStats getFlowStats();

    public boolean hasListeners();

    public void addListener(FlowListener var1);

    public boolean removeListener(FlowListener var1);

    public boolean hasStepListeners();

    public void addStepListener(FlowStepListener var1);

    public boolean removeStepListener(FlowStepListener var1);

    public Map<String, Tap> getSources();

    public List<String> getSourceNames();

    public Tap getSource(String var1);

    public Collection<Tap> getSourcesCollection();

    public Map<String, Tap> getSinks();

    public List<String> getSinkNames();

    public Tap getSink(String var1);

    public Collection<Tap> getSinksCollection();

    public Tap getSink();

    public Map<String, Tap> getTraps();

    public List<String> getTrapNames();

    public Collection<Tap> getTrapsCollection();

    public Map<String, Tap> getCheckpoints();

    public List<String> getCheckpointNames();

    public Collection<Tap> getCheckpointsCollection();

    public FlowSkipStrategy getFlowSkipStrategy();

    public FlowSkipStrategy setFlowSkipStrategy(FlowSkipStrategy var1);

    public boolean isSkipFlow() throws IOException;

    public boolean areSinksStale() throws IOException;

    public boolean areSourcesNewer(long var1) throws IOException;

    public long getSinkModified() throws IOException;

    public FlowStepStrategy getFlowStepStrategy();

    public void setFlowStepStrategy(FlowStepStrategy var1);

    public List<FlowStep<Config>> getFlowSteps();

    public TupleEntryIterator openSource() throws IOException;

    public TupleEntryIterator openSource(String var1) throws IOException;

    public TupleEntryIterator openSink() throws IOException;

    public TupleEntryIterator openSink(String var1) throws IOException;

    public TupleEntryIterator openTrap() throws IOException;

    public TupleEntryIterator openTrap(String var1) throws IOException;

    public boolean resourceExists(Tap var1) throws IOException;

    public TupleEntryIterator openTapForRead(Tap var1) throws IOException;

    public TupleEntryCollector openTapForWrite(Tap var1) throws IOException;

    public void writeDOT(String var1);

    public void writeStepsDOT(String var1);

    public String getCascadeID();

    public String getRunID();

    public PlatformInfo getPlatformInfo();

    public boolean stepsAreLocal();

    public boolean isStopJobsOnExit();
}

