/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.CascadingException;
import cascading.cascade.Cascade;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.FlowException;
import cascading.flow.FlowListener;
import cascading.flow.FlowSession;
import cascading.flow.FlowSkipIfSinkNotStale;
import cascading.flow.FlowSkipStrategy;
import cascading.flow.FlowStep;
import cascading.flow.FlowStepListener;
import cascading.flow.FlowStepStrategy;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.ElementGraph;
import cascading.flow.planner.FlowStepGraph;
import cascading.flow.planner.FlowStepJob;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.Scope;
import cascading.management.CascadingServices;
import cascading.management.UnitOfWorkExecutorStrategy;
import cascading.management.UnitOfWorkSpawnStrategy;
import cascading.management.state.ClientState;
import cascading.property.AppProps;
import cascading.property.PropertyUtil;
import cascading.stats.FlowStats;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.ShutdownUtil;
import cascading.util.Update;
import cascading.util.Util;
import cascading.util.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import riffle.process.DependencyIncoming;
import riffle.process.DependencyOutgoing;
import riffle.process.Process;
import riffle.process.ProcessCleanup;
import riffle.process.ProcessComplete;
import riffle.process.ProcessPrepare;
import riffle.process.ProcessStart;
import riffle.process.ProcessStop;

@Process
public abstract class BaseFlow<Config>
implements Flow<Config> {
    private static final Logger LOG = LoggerFactory.getLogger(Flow.class);
    private PlatformInfo platformInfo;
    private String id;
    private String name;
    private String runID;
    private List<String> classPath;
    private String tags;
    private List<SafeFlowListener> listeners;
    private FlowSkipStrategy flowSkipStrategy = new FlowSkipIfSinkNotStale();
    protected FlowStats flowStats;
    protected Map<String, Tap> sources = Collections.EMPTY_MAP;
    protected Map<String, Tap> sinks = Collections.EMPTY_MAP;
    private Map<String, Tap> traps = Collections.EMPTY_MAP;
    private Map<String, Tap> checkpoints = Collections.EMPTY_MAP;
    protected boolean stopJobsOnExit = true;
    private int submitPriority = 5;
    private FlowStepGraph<Config> flowStepGraph;
    protected transient Thread thread;
    private Throwable throwable;
    protected boolean stop;
    private ElementGraph pipeGraph;
    private transient CascadingServices cascadingServices;
    private FlowStepStrategy<Config> flowStepStrategy = null;
    private transient List<FlowStep<Config>> steps;
    private transient Map<String, FlowStepJob<Config>> jobsMap;
    private transient UnitOfWorkSpawnStrategy spawnStrategy = new UnitOfWorkExecutorStrategy();
    private transient ReentrantLock stopLock = new ReentrantLock(true);
    protected ShutdownUtil.Hook shutdownHook;
    private HashMap<String, String> flowDescriptor;

    static boolean getStopJobsOnExit(Map<Object, Object> properties) {
        return Boolean.parseBoolean(PropertyUtil.getProperty(properties, "cascading.flow.stopjobsonexit", "true"));
    }

    protected BaseFlow() {
        this.name = "NA";
        this.flowStats = this.createPrepareFlowStats();
    }

    protected BaseFlow(PlatformInfo platformInfo, Map<Object, Object> properties, Config defaultConfig, String name2) {
        this(platformInfo, properties, defaultConfig, name2, new LinkedHashMap<String, String>());
    }

    protected BaseFlow(PlatformInfo platformInfo, Map<Object, Object> properties, Config defaultConfig, String name2, Map<String, String> flowDescriptor) {
        this.platformInfo = platformInfo;
        this.name = name2;
        if (flowDescriptor != null) {
            this.flowDescriptor = new LinkedHashMap<String, String>(flowDescriptor);
        }
        this.addSessionProperties(properties);
        this.initConfig(properties, defaultConfig);
        this.flowStats = this.createPrepareFlowStats();
    }

    protected BaseFlow(PlatformInfo platformInfo, Map<Object, Object> properties, Config defaultConfig, FlowDef flowDef) {
        this.platformInfo = platformInfo;
        this.name = flowDef.getName();
        this.tags = flowDef.getTags();
        this.runID = flowDef.getRunID();
        this.classPath = flowDef.getClassPath();
        if (!flowDef.getFlowDescriptor().isEmpty()) {
            this.flowDescriptor = new LinkedHashMap<String, String>(flowDef.getFlowDescriptor());
        }
        this.addSessionProperties(properties);
        this.initConfig(properties, defaultConfig);
        this.setSources(flowDef.getSourcesCopy());
        this.setSinks(flowDef.getSinksCopy());
        this.setTraps(flowDef.getTrapsCopy());
        this.setCheckpoints(flowDef.getCheckpointsCopy());
        this.initFromTaps();
        this.retrieveSourceFields();
        this.retrieveSinkFields();
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    public void initialize(ElementGraph pipeGraph, FlowStepGraph<Config> flowStepGraph) {
        this.pipeGraph = pipeGraph;
        this.flowStepGraph = flowStepGraph;
        this.initSteps();
        this.flowStats = this.createPrepareFlowStats();
        this.initializeNewJobsMap();
    }

    public ElementGraph updateSchemes(ElementGraph pipeGraph) {
        this.presentSourceFields(pipeGraph);
        this.presentSinkFields(pipeGraph);
        return new ElementGraph(pipeGraph);
    }

    protected void retrieveSourceFields() {
        for (Tap tap : this.sources.values()) {
            tap.retrieveSourceFields(this.getFlowProcess());
        }
    }

    protected void presentSourceFields(ElementGraph pipeGraph) {
        for (Tap tap : this.sources.values()) {
            if (!pipeGraph.containsVertex(tap)) continue;
            tap.presentSourceFields(this.getFlowProcess(), this.getFieldsFor(pipeGraph, tap));
        }
        for (Tap tap : this.checkpoints.values()) {
            if (!pipeGraph.containsVertex(tap)) continue;
            tap.presentSourceFields(this.getFlowProcess(), this.getFieldsFor(pipeGraph, tap));
        }
    }

    protected void retrieveSinkFields() {
        for (Tap tap : this.sinks.values()) {
            tap.retrieveSinkFields(this.getFlowProcess());
        }
    }

    protected void presentSinkFields(ElementGraph pipeGraph) {
        for (Tap tap : this.sinks.values()) {
            if (!pipeGraph.containsVertex(tap)) continue;
            tap.presentSinkFields(this.getFlowProcess(), this.getFieldsFor(pipeGraph, tap));
        }
        for (Tap tap : this.checkpoints.values()) {
            if (!pipeGraph.containsVertex(tap)) continue;
            tap.presentSinkFields(this.getFlowProcess(), this.getFieldsFor(pipeGraph, tap));
        }
    }

    protected Fields getFieldsFor(ElementGraph pipeGraph, Tap tap) {
        return ((Scope)pipeGraph.outgoingEdgesOf(tap).iterator().next()).getOutValuesFields();
    }

    private void addSessionProperties(Map<Object, Object> properties) {
        if (properties == null) {
            return;
        }
        PropertyUtil.setProperty(properties, "cascading.flow.id", this.getID());
        PropertyUtil.setProperty(properties, "cascading.flow.tags", this.getTags());
        AppProps.setApplicationID(properties);
        PropertyUtil.setProperty(properties, "cascading.app.name", this.makeAppName(properties));
        PropertyUtil.setProperty(properties, "cascading.app.version", this.makeAppVersion(properties));
    }

    private String makeAppName(Map<Object, Object> properties) {
        if (properties == null) {
            return null;
        }
        String name2 = AppProps.getApplicationName(properties);
        if (name2 != null) {
            return name2;
        }
        return Util.findName(AppProps.getApplicationJarPath(properties));
    }

    private String makeAppVersion(Map<Object, Object> properties) {
        if (properties == null) {
            return null;
        }
        String name2 = AppProps.getApplicationVersion(properties);
        if (name2 != null) {
            return name2;
        }
        return Util.findVersion(AppProps.getApplicationJarPath(properties));
    }

    private FlowStats createPrepareFlowStats() {
        FlowStats flowStats = new FlowStats(this, this.getClientState());
        flowStats.prepare();
        flowStats.markPending();
        return flowStats;
    }

    public CascadingServices getCascadingServices() {
        if (this.cascadingServices == null) {
            this.cascadingServices = new CascadingServices(this.getConfigAsProperties());
        }
        return this.cascadingServices;
    }

    private ClientState getClientState() {
        return this.getFlowSession().getCascadingServices().createClientState(this.getID());
    }

    protected void initSteps() {
        if (this.flowStepGraph == null) {
            return;
        }
        for (FlowStep flowStep : this.flowStepGraph.vertexSet()) {
            ((BaseFlowStep)flowStep).setFlow(this);
        }
    }

    private void initFromTaps() {
        this.initFromTaps(this.sources);
        this.initFromTaps(this.sinks);
        this.initFromTaps(this.traps);
    }

    private void initFromTaps(Map<String, Tap> taps) {
        for (Tap tap : taps.values()) {
            tap.flowConfInit(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name2) {
        this.name = name2;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = Util.createUniqueID();
        }
        return this.id;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public int getSubmitPriority() {
        return this.submitPriority;
    }

    @Override
    public void setSubmitPriority(int submitPriority) {
        if (submitPriority < 1 || submitPriority > 10) {
            throw new IllegalArgumentException("submitPriority must be between 1 and 10 inclusive, was: " + submitPriority);
        }
        this.submitPriority = submitPriority;
    }

    ElementGraph getPipeGraph() {
        return this.pipeGraph;
    }

    FlowStepGraph getFlowStepGraph() {
        return this.flowStepGraph;
    }

    protected void setSources(Map<String, Tap> sources) {
        this.addListeners(sources.values());
        this.sources = sources;
    }

    protected void setSinks(Map<String, Tap> sinks) {
        this.addListeners(sinks.values());
        this.sinks = sinks;
    }

    protected void setTraps(Map<String, Tap> traps) {
        this.addListeners(traps.values());
        this.traps = traps;
    }

    protected void setCheckpoints(Map<String, Tap> checkpoints) {
        this.addListeners(checkpoints.values());
        this.checkpoints = checkpoints;
    }

    protected void setFlowStepGraph(FlowStepGraph flowStepGraph) {
        this.flowStepGraph = flowStepGraph;
    }

    protected abstract void initConfig(Map<Object, Object> var1, Config var2);

    public Config createConfig(Map<Object, Object> properties, Config defaultConfig) {
        Config config2 = this.newConfig(defaultConfig);
        if (properties == null) {
            return config2;
        }
        HashSet<Object> keys2 = new HashSet<Object>(properties.keySet());
        if (properties instanceof Properties) {
            keys2.addAll(((Properties)properties).stringPropertyNames());
        }
        for (Object e : keys2) {
            Object value2 = properties.get(e);
            if (value2 == null && properties instanceof Properties && e instanceof String) {
                value2 = ((Properties)properties).getProperty((String)e);
            }
            if (value2 == null) continue;
            this.setConfigProperty(config2, e, value2);
        }
        return config2;
    }

    protected abstract void setConfigProperty(Config var1, Object var2, Object var3);

    protected abstract Config newConfig(Config var1);

    protected void initFromProperties(Map<Object, Object> properties) {
        this.stopJobsOnExit = BaseFlow.getStopJobsOnExit(properties);
    }

    public FlowSession getFlowSession() {
        return new FlowSession(this.getCascadingServices());
    }

    @Override
    public FlowStats getFlowStats() {
        return this.flowStats;
    }

    @Override
    public Map<String, String> getFlowDescriptor() {
        if (this.flowDescriptor == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.flowDescriptor);
    }

    @Override
    public FlowStats getStats() {
        return this.getFlowStats();
    }

    void addListeners(Collection listeners2) {
        for (Object listener : listeners2) {
            if (!(listener instanceof FlowListener)) continue;
            this.addListener((FlowListener)listener);
        }
    }

    List<SafeFlowListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<SafeFlowListener>();
        }
        return this.listeners;
    }

    @Override
    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    @Override
    public void addListener(FlowListener flowListener) {
        this.getListeners().add(new SafeFlowListener(flowListener));
    }

    @Override
    public boolean removeListener(FlowListener flowListener) {
        return this.getListeners().remove(new SafeFlowListener(flowListener));
    }

    @Override
    public boolean hasStepListeners() {
        boolean hasStepListeners = false;
        for (FlowStep<Config> step : this.getFlowSteps()) {
            hasStepListeners |= step.hasListeners();
        }
        return hasStepListeners;
    }

    @Override
    public void addStepListener(FlowStepListener flowStepListener) {
        for (FlowStep<Config> step : this.getFlowSteps()) {
            step.addListener(flowStepListener);
        }
    }

    @Override
    public boolean removeStepListener(FlowStepListener flowStepListener) {
        boolean listenerRemoved = true;
        for (FlowStep<Config> step : this.getFlowSteps()) {
            listenerRemoved &= step.removeListener(flowStepListener);
        }
        return listenerRemoved;
    }

    @Override
    public Map<String, Tap> getSources() {
        return Collections.unmodifiableMap(this.sources);
    }

    @Override
    public List<String> getSourceNames() {
        return new ArrayList<String>(this.sources.keySet());
    }

    @Override
    public Tap getSource(String name2) {
        return this.sources.get(name2);
    }

    @Override
    @DependencyIncoming
    public Collection<Tap> getSourcesCollection() {
        return this.getSources().values();
    }

    @Override
    public Map<String, Tap> getSinks() {
        return Collections.unmodifiableMap(this.sinks);
    }

    @Override
    public List<String> getSinkNames() {
        return new ArrayList<String>(this.sinks.keySet());
    }

    @Override
    public Tap getSink(String name2) {
        return this.sinks.get(name2);
    }

    @Override
    @DependencyOutgoing
    public Collection<Tap> getSinksCollection() {
        return this.getSinks().values();
    }

    @Override
    public Tap getSink() {
        return this.sinks.values().iterator().next();
    }

    @Override
    public Map<String, Tap> getTraps() {
        return Collections.unmodifiableMap(this.traps);
    }

    @Override
    public List<String> getTrapNames() {
        return new ArrayList<String>(this.traps.keySet());
    }

    @Override
    public Collection<Tap> getTrapsCollection() {
        return this.getTraps().values();
    }

    @Override
    public Map<String, Tap> getCheckpoints() {
        return Collections.unmodifiableMap(this.checkpoints);
    }

    @Override
    public List<String> getCheckpointNames() {
        return new ArrayList<String>(this.checkpoints.keySet());
    }

    @Override
    public Collection<Tap> getCheckpointsCollection() {
        return this.getCheckpoints().values();
    }

    @Override
    public boolean isStopJobsOnExit() {
        return this.stopJobsOnExit;
    }

    @Override
    public FlowSkipStrategy getFlowSkipStrategy() {
        return this.flowSkipStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowSkipStrategy setFlowSkipStrategy(FlowSkipStrategy flowSkipStrategy) {
        if (flowSkipStrategy == null) {
            throw new IllegalArgumentException("flowSkipStrategy may not be null");
        }
        try {
            FlowSkipStrategy flowSkipStrategy2 = this.flowSkipStrategy;
            return flowSkipStrategy2;
        }
        finally {
            this.flowSkipStrategy = flowSkipStrategy;
        }
    }

    @Override
    public boolean isSkipFlow() throws IOException {
        return this.flowSkipStrategy.skipFlow(this);
    }

    @Override
    public boolean areSinksStale() throws IOException {
        return this.areSourcesNewer(this.getSinkModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areSourcesNewer(long sinkModified) throws IOException {
        Object confCopy = this.getConfigCopy();
        Iterator<Tap> values2 = this.sources.values().iterator();
        long sourceModified = 0L;
        try {
            sourceModified = Util.getSourceModified(confCopy, values2, sinkModified);
            if (sinkModified < sourceModified) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (LOG.isInfoEnabled()) {
                this.logInfo("source modification date at: " + new Date(sourceModified));
            }
        }
    }

    @Override
    public long getSinkModified() throws IOException {
        long sinkModified = Util.getSinkModified(this.getConfigCopy(), this.sinks.values());
        if (LOG.isInfoEnabled()) {
            if (sinkModified == -1L) {
                this.logInfo("at least one sink is marked for delete");
            }
            if (sinkModified == 0L) {
                this.logInfo("at least one sink does not exist");
            } else {
                this.logInfo("sink oldest modified date: " + new Date(sinkModified));
            }
        }
        return sinkModified;
    }

    @Override
    public FlowStepStrategy getFlowStepStrategy() {
        return this.flowStepStrategy;
    }

    @Override
    public void setFlowStepStrategy(FlowStepStrategy flowStepStrategy) {
        this.flowStepStrategy = flowStepStrategy;
    }

    @Override
    public List<FlowStep<Config>> getFlowSteps() {
        if (this.steps != null) {
            return this.steps;
        }
        if (this.flowStepGraph == null) {
            return Collections.EMPTY_LIST;
        }
        TopologicalOrderIterator<FlowStep<Config>, Integer> topoIterator = this.flowStepGraph.getTopologicalIterator();
        this.steps = new ArrayList<FlowStep<Config>>();
        while (topoIterator.hasNext()) {
            this.steps.add((FlowStep<Config>)topoIterator.next());
        }
        return this.steps;
    }

    @Override
    @ProcessPrepare
    public void prepare() {
        try {
            this.deleteSinksIfNotUpdate();
            this.deleteTrapsIfNotUpdate();
            this.deleteCheckpointsIfNotUpdate();
        }
        catch (IOException exception) {
            throw new FlowException("unable to prepare flow", exception);
        }
    }

    @Override
    @ProcessStart
    public synchronized void start() {
        if (this.thread != null) {
            return;
        }
        if (this.stop) {
            return;
        }
        this.registerShutdownHook();
        this.internalStart();
        String threadName = ("flow " + Util.toNull(this.getName())).trim();
        this.thread = this.createFlowThread(threadName);
        this.thread.start();
    }

    protected Thread createFlowThread(String threadName) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                BaseFlow.this.run();
            }
        }, threadName);
    }

    protected abstract void internalStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ProcessStop
    public synchronized void stop() {
        this.stopLock.lock();
        try {
            if (this.stop) {
                return;
            }
            this.stop = true;
            this.fireOnStopping();
            if (!this.flowStats.isFinished()) {
                this.flowStats.markStopped();
            }
            this.internalStopAllJobs();
            this.handleExecutorShutdown();
            this.internalClean(true);
        }
        finally {
            this.flowStats.cleanup();
            this.stopLock.unlock();
        }
    }

    protected abstract void internalClean(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @ProcessComplete
    public void complete() {
        this.start();
        try {
            BaseFlow baseFlow = this;
            synchronized (baseFlow) {
                while (this.thread == null && !this.stop) {
                    Util.safeSleep(10L);
                }
            }
            if (this.thread != null) {
                this.thread.join();
            }
        }
        catch (InterruptedException exception) {
            throw new FlowException(this.getName(), "thread interrupted", exception);
        }
        try {
            this.stopLock.lock();
        }
        finally {
            this.stopLock.unlock();
        }
        if (this.throwable instanceof FlowException) {
            ((FlowException)this.throwable).setFlowName(this.getName());
        }
        if (this.throwable instanceof CascadingException) {
            throw (CascadingException)this.throwable;
        }
        if (this.throwable instanceof OutOfMemoryError) {
            throw (OutOfMemoryError)this.throwable;
        }
        if (this.throwable != null) {
            throw new FlowException(this.getName(), "unhandled exception", this.throwable);
        }
        if (this.hasListeners()) {
            for (SafeFlowListener safeFlowListener : this.getListeners()) {
                if (safeFlowListener.throwable == null) continue;
                throw new FlowException(this.getName(), "unhandled listener exception", this.throwable);
            }
        }
        this.thread = null;
        this.throwable = null;
        try {
            this.commitTraps();
            if (!this.hasListeners()) return;
            for (SafeFlowListener safeFlowListener : this.getListeners()) {
                safeFlowListener.throwable = null;
            }
            return;
        }
        finally {
            this.flowStats.cleanup();
        }
        catch (Throwable throwable2) {
            this.thread = null;
            this.throwable = null;
            try {
                this.commitTraps();
                if (!this.hasListeners()) throw throwable2;
                for (SafeFlowListener safeFlowListener : this.getListeners()) {
                    safeFlowListener.throwable = null;
                }
                throw throwable2;
            }
            finally {
                this.flowStats.cleanup();
            }
        }
    }

    private void commitTraps() {
        for (Tap tap : this.traps.values()) {
            try {
                if (tap.commitResource(this.getConfig())) continue;
                this.logError("unable to commit trap: " + tap.getFullIdentifier(this.getConfig()), null);
            }
            catch (IOException exception) {
                this.logError("unable to commit trap: " + tap.getFullIdentifier(this.getConfig()), exception);
            }
        }
    }

    @Override
    @ProcessCleanup
    public void cleanup() {
    }

    @Override
    public TupleEntryIterator openSource() throws IOException {
        return this.sources.values().iterator().next().openForRead(this.getFlowProcess());
    }

    @Override
    public TupleEntryIterator openSource(String name2) throws IOException {
        if (!this.sources.containsKey(name2)) {
            throw new IllegalArgumentException("source does not exist: " + name2);
        }
        return this.sources.get(name2).openForRead(this.getFlowProcess());
    }

    @Override
    public TupleEntryIterator openSink() throws IOException {
        return this.sinks.values().iterator().next().openForRead(this.getFlowProcess());
    }

    @Override
    public TupleEntryIterator openSink(String name2) throws IOException {
        if (!this.sinks.containsKey(name2)) {
            throw new IllegalArgumentException("sink does not exist: " + name2);
        }
        return this.sinks.get(name2).openForRead(this.getFlowProcess());
    }

    @Override
    public TupleEntryIterator openTrap() throws IOException {
        return this.traps.values().iterator().next().openForRead(this.getFlowProcess());
    }

    @Override
    public TupleEntryIterator openTrap(String name2) throws IOException {
        if (!this.traps.containsKey(name2)) {
            throw new IllegalArgumentException("trap does not exist: " + name2);
        }
        return this.traps.get(name2).openForRead(this.getFlowProcess());
    }

    public void deleteSinks() throws IOException {
        for (Tap tap : this.sinks.values()) {
            this.deleteOrFail(tap);
        }
    }

    private void deleteOrFail(Tap tap) throws IOException {
        if (!tap.resourceExists(this.getConfig())) {
            return;
        }
        if (!tap.deleteResource(this.getConfig())) {
            throw new FlowException("unable to delete resource: " + tap.getFullIdentifier(this.getFlowProcess()));
        }
    }

    public void deleteSinksIfNotUpdate() throws IOException {
        for (Tap tap : this.sinks.values()) {
            if (tap.isUpdate()) continue;
            this.deleteOrFail(tap);
        }
    }

    public void deleteSinksIfReplace() throws IOException {
        for (Tap tap : this.sinks.values()) {
            if (!tap.isReplace()) continue;
            this.deleteOrFail(tap);
        }
    }

    public void deleteTrapsIfNotUpdate() throws IOException {
        for (Tap tap : this.traps.values()) {
            if (tap.isUpdate()) continue;
            this.deleteOrFail(tap);
        }
    }

    public void deleteCheckpointsIfNotUpdate() throws IOException {
        for (Tap tap : this.checkpoints.values()) {
            if (tap.isUpdate()) continue;
            this.deleteOrFail(tap);
        }
    }

    public void deleteTrapsIfReplace() throws IOException {
        for (Tap tap : this.traps.values()) {
            if (!tap.isReplace()) continue;
            this.deleteOrFail(tap);
        }
    }

    public void deleteCheckpointsIfReplace() throws IOException {
        for (Tap tap : this.checkpoints.values()) {
            if (!tap.isReplace()) continue;
            this.deleteOrFail(tap);
        }
    }

    @Override
    public boolean resourceExists(Tap tap) throws IOException {
        return tap.resourceExists(this.getConfig());
    }

    @Override
    public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
        return tap.openForRead(this.getFlowProcess());
    }

    @Override
    public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
        return tap.openForWrite(this.getFlowProcess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        if (this.thread == null) {
            throw new IllegalStateException("to start a Flow call start() or complete(), not Runnable#run()");
        }
        Version.printBanner();
        Update.checkForUpdate(this.getPlatformInfo());
        try {
            int numThreads;
            if (this.stop) {
                return;
            }
            this.flowStats.markStarted();
            this.fireOnStarting();
            if (LOG.isInfoEnabled()) {
                this.logInfo("starting");
                for (Tap source2 : this.getSourcesCollection()) {
                    this.logInfo(" source: " + source2);
                }
                for (Tap sink2 : this.getSinksCollection()) {
                    this.logInfo(" sink: " + sink2);
                }
            }
            if ((numThreads = this.getMaxNumParallelSteps()) == 0) {
                numThreads = this.jobsMap.size();
            }
            if (numThreads == 0) {
                throw new IllegalStateException("no jobs rendered for flow: " + this.getName());
            }
            if (LOG.isInfoEnabled()) {
                this.logInfo(" parallel execution is enabled: " + (this.getMaxNumParallelSteps() != 1));
                this.logInfo(" starting jobs: " + this.jobsMap.size());
                this.logInfo(" allocating threads: " + numThreads);
            }
            List<Future<Throwable>> futures = this.spawnJobs(numThreads);
            for (Future<Throwable> future : futures) {
                this.throwable = future.get();
                if (this.throwable == null) continue;
                if (!this.stop) {
                    this.internalStopAllJobs();
                }
                this.handleExecutorShutdown();
                break;
            }
        }
        catch (Throwable throwable2) {
            this.throwable = throwable2;
        }
        finally {
            this.handleThrowableAndMarkFailed();
            if (!this.stop && !this.flowStats.isFinished()) {
                this.flowStats.markSuccessful();
            }
            this.internalClean(this.stop);
            try {
                this.fireOnCompleted();
            }
            finally {
                this.flowStats.cleanup();
                this.internalShutdown();
                this.deregisterShutdownHook();
            }
        }
    }

    protected abstract int getMaxNumParallelSteps();

    protected abstract void internalShutdown();

    private List<Future<Throwable>> spawnJobs(int numThreads) throws InterruptedException {
        if (this.stop) {
            return new ArrayList<Future<Throwable>>();
        }
        ArrayList<Callable<Throwable>> list2 = new ArrayList<Callable<Throwable>>();
        for (FlowStepJob<Config> job : this.jobsMap.values()) {
            list2.add(job);
        }
        return this.spawnStrategy.start(this, numThreads, list2);
    }

    private void handleThrowableAndMarkFailed() {
        if (this.throwable != null && !this.stop) {
            this.flowStats.markFailed(this.throwable);
            this.fireOnThrowable();
        }
    }

    Map<String, FlowStepJob<Config>> getJobsMap() {
        return this.jobsMap;
    }

    protected void initializeNewJobsMap() {
        this.jobsMap = new LinkedHashMap<String, FlowStepJob<Config>>();
        TopologicalOrderIterator<FlowStep<Config>, Integer> topoIterator = this.flowStepGraph.getTopologicalIterator();
        while (topoIterator.hasNext()) {
            BaseFlowStep step = (BaseFlowStep)topoIterator.next();
            FlowStepJob flowStepJob = step.getFlowStepJob(this.getFlowProcess(), this.getConfig());
            this.jobsMap.put(step.getName(), flowStepJob);
            ArrayList predecessors2 = new ArrayList();
            for (FlowStep flowStep : Graphs.predecessorListOf(this.flowStepGraph, step)) {
                predecessors2.add(this.jobsMap.get(flowStep.getName()));
            }
            flowStepJob.setPredecessors(predecessors2);
            this.flowStats.addStepStats(flowStepJob.getStepStats());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStopAllJobs() {
        this.logInfo("stopping all jobs");
        try {
            if (this.jobsMap == null) {
                return;
            }
            ArrayList<FlowStepJob<Config>> jobs = new ArrayList<FlowStepJob<Config>>(this.jobsMap.values());
            Collections.reverse(jobs);
            for (FlowStepJob flowStepJob : jobs) {
                flowStepJob.stop();
            }
        }
        finally {
            this.logInfo("stopped all jobs");
        }
    }

    protected void handleExecutorShutdown() {
        if (this.spawnStrategy.isCompleted(this)) {
            return;
        }
        this.logInfo("shutting down job executor");
        try {
            this.spawnStrategy.complete(this, 300, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logInfo("shutdown complete");
    }

    protected void fireOnCompleted() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onCompleted event: " + this.getListeners().size());
            }
            for (SafeFlowListener flowListener : this.getListeners()) {
                flowListener.onCompleted(this);
            }
        }
    }

    protected void fireOnThrowable() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onThrowable event: " + this.getListeners().size());
            }
            boolean isHandled = false;
            for (SafeFlowListener flowListener : this.getListeners()) {
                isHandled = flowListener.onThrowable(this, this.throwable) || isHandled;
            }
            if (isHandled) {
                this.throwable = null;
            }
        }
    }

    protected void fireOnStopping() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onStopping event: " + this.getListeners().size());
            }
            for (SafeFlowListener flowListener : this.getListeners()) {
                flowListener.onStopping(this);
            }
        }
    }

    protected void fireOnStarting() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onStarting event: " + this.getListeners().size());
            }
            for (SafeFlowListener flowListener : this.getListeners()) {
                flowListener.onStarting(this);
            }
        }
    }

    public String toString() {
        StringBuffer buffer2 = new StringBuffer();
        if (this.getName() != null) {
            buffer2.append(this.getName()).append(": ");
        }
        for (FlowStep<Config> step : this.getFlowSteps()) {
            buffer2.append(step);
        }
        return buffer2.toString();
    }

    protected void logInfo(String message) {
        LOG.info("[" + Util.truncate(this.getName(), 25) + "] " + message);
    }

    private void logDebug(String message) {
        LOG.debug("[" + Util.truncate(this.getName(), 25) + "] " + message);
    }

    private void logWarn(String message, Throwable throwable2) {
        LOG.warn("[" + Util.truncate(this.getName(), 25) + "] " + message, throwable2);
    }

    private void logError(String message, Throwable throwable2) {
        LOG.error("[" + Util.truncate(this.getName(), 25) + "] " + message, throwable2);
    }

    @Override
    public void writeDOT(String filename) {
        if (this.pipeGraph == null) {
            throw new UnsupportedOperationException("this flow instance cannot write a DOT file");
        }
        this.pipeGraph.writeDOT(filename);
    }

    @Override
    public void writeStepsDOT(String filename) {
        if (this.flowStepGraph == null) {
            throw new UnsupportedOperationException("this flow instance cannot write a DOT file");
        }
        this.flowStepGraph.writeDOT(filename);
    }

    public FlowHolder getHolder() {
        return new FlowHolder(this);
    }

    public void setCascade(Cascade cascade) {
        this.setConfigProperty(this.getConfig(), "cascading.cascade.id", cascade.getID());
        this.flowStats.recordInfo();
    }

    @Override
    public String getCascadeID() {
        return this.getProperty("cascading.cascade.id");
    }

    @Override
    public String getRunID() {
        return this.runID;
    }

    protected List<String> getClassPath() {
        return this.classPath;
    }

    @Override
    public void setSpawnStrategy(UnitOfWorkSpawnStrategy spawnStrategy) {
        this.spawnStrategy = spawnStrategy;
    }

    @Override
    public UnitOfWorkSpawnStrategy getSpawnStrategy() {
        return this.spawnStrategy;
    }

    protected void registerShutdownHook() {
        if (!this.isStopJobsOnExit()) {
            return;
        }
        this.shutdownHook = new ShutdownUtil.Hook(){

            @Override
            public ShutdownUtil.Hook.Priority priority() {
                return ShutdownUtil.Hook.Priority.WORK_CHILD;
            }

            @Override
            public void execute() {
                BaseFlow.this.logInfo("shutdown hook calling stop on flow");
                BaseFlow.this.stop();
            }
        };
        ShutdownUtil.addHook(this.shutdownHook);
    }

    private void deregisterShutdownHook() {
        if (!this.isStopJobsOnExit() || this.stop) {
            return;
        }
        ShutdownUtil.removeHook(this.shutdownHook);
    }

    private class SafeFlowListener
    implements FlowListener {
        final FlowListener flowListener;
        Throwable throwable;

        private SafeFlowListener(FlowListener flowListener) {
            this.flowListener = flowListener;
        }

        @Override
        public void onStarting(Flow flow) {
            try {
                this.flowListener.onStarting(flow);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public void onStopping(Flow flow) {
            try {
                this.flowListener.onStopping(flow);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public void onCompleted(Flow flow) {
            try {
                this.flowListener.onCompleted(flow);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public boolean onThrowable(Flow flow, Throwable flowThrowable) {
            try {
                return this.flowListener.onThrowable(flow, flowThrowable);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
                return false;
            }
        }

        private void handleThrowable(Throwable throwable2) {
            this.throwable = throwable2;
            BaseFlow.this.logWarn(String.format("flow listener %s threw throwable", this.flowListener), throwable2);
            BaseFlow.this.stop();
        }

        public boolean equals(Object object) {
            if (object instanceof SafeFlowListener) {
                return this.flowListener.equals(((SafeFlowListener)object).flowListener);
            }
            return this.flowListener.equals(object);
        }

        public int hashCode() {
            return this.flowListener.hashCode();
        }
    }

    public static class FlowHolder {
        public Flow flow;

        public FlowHolder() {
        }

        public FlowHolder(Flow flow) {
            this.flow = flow;
        }
    }
}

