/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade.planner;

import cascading.cascade.CascadeException;
import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jgrapht.graph.SimpleDirectedGraph;

public abstract class TopologyGraph<Vertex>
extends SimpleDirectedGraph<Vertex, BaseFlow.FlowHolder> {
    public TopologyGraph(Flow ... flows) {
        super(BaseFlow.FlowHolder.class);
        this.makeGraph(flows);
    }

    private void makeGraph(Flow[] flows) {
        for (Flow flow : flows) {
            LinkedList<Tap> sources = new LinkedList<Tap>(flow.getSourcesCollection());
            LinkedList<Tap> sinks = new LinkedList<Tap>(flow.getSinksCollection());
            sinks.addAll(flow.getCheckpointsCollection());
            this.unwrapCompositeTaps(sources);
            this.unwrapCompositeTaps(sinks);
            for (Tap source2 : sources) {
                this.addVertex(this.getVertex(flow, source2));
            }
            for (Tap sink2 : sinks) {
                this.addVertex(this.getVertex(flow, sink2));
            }
            for (Tap source2 : sources) {
                for (Tap sink3 : sinks) {
                    this.addEdgeFor(flow, source2, sink3);
                }
            }
        }
    }

    private void addEdgeFor(Flow flow, Tap source2, Tap sink2) {
        try {
            this.addEdge(this.getVertex(flow, source2), this.getVertex(flow, sink2), ((BaseFlow)flow).getHolder());
        }
        catch (IllegalArgumentException exception) {
            throw new CascadeException("no loops allowed in cascade, flow: " + flow.getName() + ", source: " + source2 + ", sink: " + sink2);
        }
    }

    protected abstract Vertex getVertex(Flow var1, Tap var2);

    private void unwrapCompositeTaps(LinkedList<Tap> taps) {
        ListIterator iterator2 = taps.listIterator();
        while (iterator2.hasNext()) {
            Tap tap = (Tap)iterator2.next();
            if (!(tap instanceof CompositeTap)) continue;
            iterator2.remove();
            Iterator childTaps = ((CompositeTap)((Object)tap)).getChildTaps();
            while (childTaps.hasNext()) {
                iterator2.add(childTaps.next());
                iterator2.previous();
            }
        }
    }
}

