/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade;

import cascading.cascade.Cascade;
import cascading.cascade.CascadeDef;
import cascading.cascade.planner.FlowGraph;
import cascading.cascade.planner.IdentifierGraph;
import cascading.flow.Flow;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadeConnector {
    private static final Logger LOG = LoggerFactory.getLogger(CascadeConnector.class);
    private Map<Object, Object> properties;

    public CascadeConnector() {
    }

    @ConstructorProperties(value={"properties"})
    public CascadeConnector(Map<Object, Object> properties) {
        this.properties = properties;
    }

    public Cascade connect(Collection<Flow> flows) {
        return this.connect((String)null, flows.toArray(new Flow[flows.size()]));
    }

    public Cascade connect(String name2, Collection<Flow> flows) {
        return this.connect(name2, flows.toArray(new Flow[flows.size()]));
    }

    public Cascade connect(Flow ... flows) {
        return this.connect((String)null, flows);
    }

    public Cascade connect(String name2, Flow ... flows) {
        name2 = name2 == null ? this.makeName(flows) : name2;
        CascadeDef cascadeDef = ((CascadeDef)CascadeDef.cascadeDef().setName(name2)).addFlows(flows);
        return this.connect(cascadeDef);
    }

    public Cascade connect(CascadeDef cascadeDef) {
        IdentifierGraph identifierGraph = new IdentifierGraph(cascadeDef.getFlowsArray());
        FlowGraph flowGraph = new FlowGraph(identifierGraph);
        return new Cascade(cascadeDef, this.properties, flowGraph, identifierGraph);
    }

    private String makeName(Flow[] flows) {
        Object[] names2 = new String[flows.length];
        for (int i = 0; i < flows.length; ++i) {
            names2[i] = flows[i].getName();
        }
        return Util.join(names2, "+");
    }
}

