/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade;

import cascading.CascadingException;
import cascading.cascade.CascadeDef;
import cascading.cascade.CascadeException;
import cascading.cascade.CascadeListener;
import cascading.cascade.planner.FlowGraph;
import cascading.cascade.planner.IdentifierGraph;
import cascading.cascade.planner.TapGraph;
import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.flow.FlowException;
import cascading.flow.FlowSkipStrategy;
import cascading.management.CascadingServices;
import cascading.management.UnitOfWork;
import cascading.management.UnitOfWorkExecutorStrategy;
import cascading.management.UnitOfWorkSpawnStrategy;
import cascading.management.state.ClientState;
import cascading.property.PropertyUtil;
import cascading.stats.CascadeStats;
import cascading.tap.Tap;
import cascading.util.ShutdownUtil;
import cascading.util.Util;
import cascading.util.Version;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgrapht.Graphs;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cascade
implements UnitOfWork<CascadeStats> {
    private static final Logger LOG = LoggerFactory.getLogger(Cascade.class);
    private String id;
    private final String name;
    private String tags;
    private final Map<Object, Object> properties;
    private List<SafeCascadeListener> listeners;
    private final FlowGraph flowGraph;
    private final IdentifierGraph identifierGraph;
    private final CascadeStats cascadeStats;
    private CascadingServices cascadingServices;
    private Thread thread;
    private Throwable throwable;
    private transient UnitOfWorkSpawnStrategy spawnStrategy = new UnitOfWorkExecutorStrategy();
    private ShutdownUtil.Hook shutdownHook;
    private final Map<String, Callable<Throwable>> jobsMap = new LinkedHashMap<String, Callable<Throwable>>();
    private boolean stop;
    private FlowSkipStrategy flowSkipStrategy = null;
    private int maxConcurrentFlows = 0;
    private transient TapGraph tapGraph;

    static int getMaxConcurrentFlows(Map<Object, Object> properties, int maxConcurrentFlows) {
        if (maxConcurrentFlows != -1) {
            return maxConcurrentFlows;
        }
        return Integer.parseInt(PropertyUtil.getProperty(properties, "cascading.cascade.maxconcurrentflows", "0"));
    }

    protected Cascade() {
        this.name = null;
        this.tags = null;
        this.properties = null;
        this.flowGraph = null;
        this.identifierGraph = null;
        this.cascadeStats = null;
    }

    Cascade(CascadeDef cascadeDef, Map<Object, Object> properties, FlowGraph flowGraph, IdentifierGraph identifierGraph) {
        this.name = cascadeDef.getName();
        this.tags = cascadeDef.getTags();
        this.properties = properties;
        this.flowGraph = flowGraph;
        this.identifierGraph = identifierGraph;
        this.cascadeStats = this.createPrepareCascadeStats();
        this.setIDOnFlow();
        this.maxConcurrentFlows = cascadeDef.getMaxConcurrentFlows();
        this.addListeners(this.getAllTaps());
    }

    private CascadeStats createPrepareCascadeStats() {
        CascadeStats cascadeStats = new CascadeStats(this, this.getClientState());
        cascadeStats.prepare();
        cascadeStats.markPending();
        return cascadeStats;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = Util.createUniqueID();
        }
        return this.id;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    void addListeners(Collection listeners2) {
        for (Object listener : listeners2) {
            if (!(listener instanceof CascadeListener)) continue;
            this.addListener((CascadeListener)listener);
        }
    }

    List<SafeCascadeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<SafeCascadeListener>();
        }
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void addListener(CascadeListener flowListener) {
        this.getListeners().add(new SafeCascadeListener(flowListener));
    }

    public boolean removeListener(CascadeListener flowListener) {
        return this.getListeners().remove(new SafeCascadeListener(flowListener));
    }

    private void fireOnCompleted() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onCompleted event: " + this.getListeners().size());
            }
            for (SafeCascadeListener cascadeListener : this.getListeners()) {
                cascadeListener.onCompleted(this);
            }
        }
    }

    private void fireOnThrowable() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onThrowable event: " + this.getListeners().size());
            }
            boolean isHandled = false;
            for (SafeCascadeListener cascadeListener : this.getListeners()) {
                isHandled = cascadeListener.onThrowable(this, this.throwable) || isHandled;
            }
            if (isHandled) {
                this.throwable = null;
            }
        }
    }

    protected void fireOnStopping() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onStopping event: " + this.getListeners().size());
            }
            for (SafeCascadeListener cascadeListener : this.getListeners()) {
                cascadeListener.onStopping(this);
            }
        }
    }

    protected void fireOnStarting() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onStarting event: " + this.getListeners().size());
            }
            for (SafeCascadeListener cascadeListener : this.getListeners()) {
                cascadeListener.onStarting(this);
            }
        }
    }

    private CascadingServices getCascadingServices() {
        if (this.cascadingServices == null) {
            this.cascadingServices = new CascadingServices(this.properties);
        }
        return this.cascadingServices;
    }

    private ClientState getClientState() {
        return this.getCascadingServices().createClientState(this.getID());
    }

    public CascadeStats getCascadeStats() {
        return this.cascadeStats;
    }

    @Override
    public CascadeStats getStats() {
        return this.getCascadeStats();
    }

    private void setIDOnFlow() {
        for (Flow flow : this.getFlows()) {
            ((BaseFlow)flow).setCascade(this);
        }
    }

    protected FlowGraph getFlowGraph() {
        return this.flowGraph;
    }

    protected IdentifierGraph getIdentifierGraph() {
        return this.identifierGraph;
    }

    public List<Flow> getFlows() {
        LinkedList<Flow> flows = new LinkedList<Flow>();
        TopologicalOrderIterator<Flow, Integer> topoIterator = this.flowGraph.getTopologicalIterator();
        while (topoIterator.hasNext()) {
            flows.add((Flow)topoIterator.next());
        }
        return flows;
    }

    public List<Flow> findFlows(String regex) {
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (Flow flow : this.getFlows()) {
            if (!flow.getName().matches(regex)) continue;
            flows.add(flow);
        }
        return flows;
    }

    public Collection<Flow> getHeadFlows() {
        HashSet<Flow> flows = new HashSet<Flow>();
        for (Flow flow : this.flowGraph.vertexSet()) {
            if (this.flowGraph.inDegreeOf(flow) != 0) continue;
            flows.add(flow);
        }
        return flows;
    }

    public Collection<Flow> getTailFlows() {
        HashSet<Flow> flows = new HashSet<Flow>();
        for (Flow flow : this.flowGraph.vertexSet()) {
            if (this.flowGraph.outDegreeOf(flow) != 0) continue;
            flows.add(flow);
        }
        return flows;
    }

    public Collection<Flow> getIntermediateFlows() {
        HashSet<Flow> flows = new HashSet<Flow>(this.flowGraph.vertexSet());
        flows.removeAll(this.getHeadFlows());
        flows.removeAll(this.getTailFlows());
        return flows;
    }

    protected TapGraph getTapGraph() {
        if (this.tapGraph == null) {
            this.tapGraph = new TapGraph(this.flowGraph.vertexSet());
        }
        return this.tapGraph;
    }

    public Collection<Tap> getSourceTaps() {
        TapGraph tapGraph = this.getTapGraph();
        HashSet<Tap> taps = new HashSet<Tap>();
        for (Tap tap : tapGraph.vertexSet()) {
            if (tapGraph.inDegreeOf(tap) != 0) continue;
            taps.add(tap);
        }
        return taps;
    }

    public Collection<Tap> getSinkTaps() {
        TapGraph tapGraph = this.getTapGraph();
        HashSet<Tap> taps = new HashSet<Tap>();
        for (Tap tap : tapGraph.vertexSet()) {
            if (tapGraph.outDegreeOf(tap) != 0) continue;
            taps.add(tap);
        }
        return taps;
    }

    public Collection<Tap> getCheckpointsTaps() {
        HashSet<Tap> taps = new HashSet<Tap>();
        for (Flow flow : this.getFlows()) {
            taps.addAll(flow.getCheckpointsCollection());
        }
        return taps;
    }

    public Collection<Tap> getIntermediateTaps() {
        TapGraph tapGraph = this.getTapGraph();
        HashSet<Tap> taps = new HashSet<Tap>(tapGraph.vertexSet());
        taps.removeAll(this.getSourceTaps());
        taps.removeAll(this.getSinkTaps());
        return taps;
    }

    public Collection<Tap> getAllTaps() {
        return new HashSet<Tap>(this.getTapGraph().vertexSet());
    }

    public Collection<Flow> getSuccessorFlows(Flow flow) {
        return Graphs.successorListOf(this.flowGraph, flow);
    }

    public Collection<Flow> getPredecessorFlows(Flow flow) {
        return Graphs.predecessorListOf(this.flowGraph, flow);
    }

    public Collection<Flow> findFlowsSourcingFrom(String identifier2) {
        try {
            return this.unwrapFlows(this.identifierGraph.outgoingEdgesOf(identifier2));
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    public Collection<Flow> findFlowsSinkingTo(String identifier2) {
        try {
            return this.unwrapFlows(this.identifierGraph.incomingEdgesOf(identifier2));
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    private Collection<Flow> unwrapFlows(Set<BaseFlow.FlowHolder> flowHolders) {
        HashSet<Flow> flows = new HashSet<Flow>();
        for (BaseFlow.FlowHolder flowHolder : flowHolders) {
            flows.add(flowHolder.flow);
        }
        return flows;
    }

    public FlowSkipStrategy getFlowSkipStrategy() {
        return this.flowSkipStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowSkipStrategy setFlowSkipStrategy(FlowSkipStrategy flowSkipStrategy) {
        try {
            FlowSkipStrategy flowSkipStrategy2 = this.flowSkipStrategy;
            return flowSkipStrategy2;
        }
        finally {
            this.flowSkipStrategy = flowSkipStrategy;
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public void start() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Cascade.this.run();
            }
        }, ("cascade " + Util.toNull(this.getName())).trim());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        this.start();
        try {
            try {
                this.thread.join();
            }
            catch (InterruptedException exception) {
                throw new FlowException("thread interrupted", exception);
            }
            if (this.throwable instanceof CascadingException) {
                throw (CascadingException)this.throwable;
            }
            if (this.throwable != null) {
                throw new CascadeException("unhandled exception", this.throwable);
            }
        }
        finally {
            this.thread = null;
            this.throwable = null;
            this.shutdownHook = null;
            this.cascadeStats.cleanup();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.fireOnStopping();
        if (!this.cascadeStats.isFinished()) {
            this.cascadeStats.markStopped();
        }
        this.internalStopAllFlows();
        this.handleExecutorShutdown();
        this.cascadeStats.cleanup();
    }

    @Override
    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Version.printBanner();
        if (LOG.isInfoEnabled()) {
            this.logInfo("starting");
        }
        this.registerShutdownHook();
        try {
            int numLocalFlows;
            boolean runFlowsLocal;
            if (this.stop) {
                return;
            }
            this.cascadeStats.markStartedThenRunning();
            this.fireOnStarting();
            this.initializeNewJobsMap();
            int numThreads = Cascade.getMaxConcurrentFlows(this.properties, this.maxConcurrentFlows);
            if (numThreads == 0) {
                numThreads = this.jobsMap.size();
            }
            boolean bl = runFlowsLocal = (numLocalFlows = this.numLocalFlows()) > 1;
            if (runFlowsLocal) {
                numThreads = 1;
            }
            if (LOG.isInfoEnabled()) {
                this.logInfo(" parallel execution is enabled: " + !runFlowsLocal);
                this.logInfo(" starting flows: " + this.jobsMap.size());
                this.logInfo(" allocating threads: " + numThreads);
            }
            List<Future<Throwable>> futures = this.spawnStrategy.start(this, numThreads, this.jobsMap.values());
            for (Future<Throwable> future : futures) {
                this.throwable = future.get();
                if (this.throwable == null) continue;
                if (!this.stop) {
                    this.cascadeStats.markFailed(this.throwable);
                    this.internalStopAllFlows();
                    this.fireOnThrowable();
                }
                this.handleExecutorShutdown();
                break;
            }
        }
        catch (Throwable throwable2) {
            this.throwable = throwable2;
        }
        finally {
            if (!this.cascadeStats.isFinished()) {
                this.cascadeStats.markSuccessful();
            }
            try {
                this.fireOnCompleted();
            }
            finally {
                this.deregisterShutdownHook();
            }
        }
    }

    private void registerShutdownHook() {
        if (!this.isStopJobsOnExit()) {
            return;
        }
        this.shutdownHook = new ShutdownUtil.Hook(){

            @Override
            public ShutdownUtil.Hook.Priority priority() {
                return ShutdownUtil.Hook.Priority.WORK_PARENT;
            }

            @Override
            public void execute() {
                Cascade.this.logInfo("shutdown hook calling stop on cascade");
                Cascade.this.stop();
            }
        };
        ShutdownUtil.addHook(this.shutdownHook);
    }

    private void deregisterShutdownHook() {
        if (!this.isStopJobsOnExit() || this.stop) {
            return;
        }
        ShutdownUtil.removeHook(this.shutdownHook);
    }

    private boolean isStopJobsOnExit() {
        if (this.getFlows().isEmpty()) {
            return false;
        }
        return this.getFlows().get(0).isStopJobsOnExit();
    }

    private int numLocalFlows() {
        int countLocalJobs = 0;
        for (Flow flow : this.getFlows()) {
            if (!flow.stepsAreLocal()) continue;
            ++countLocalJobs;
        }
        return countLocalJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNewJobsMap() {
        Map<String, Callable<Throwable>> map2 = this.jobsMap;
        synchronized (map2) {
            TopologicalOrderIterator<Flow, Integer> topoIterator = this.flowGraph.getTopologicalIterator();
            while (topoIterator.hasNext()) {
                Flow flow = (Flow)topoIterator.next();
                this.cascadeStats.addFlowStats(flow.getFlowStats());
                CascadeJob job = new CascadeJob(flow);
                this.jobsMap.put(flow.getName(), job);
                ArrayList<CascadeJob> predecessors2 = new ArrayList<CascadeJob>();
                for (Flow predecessor : Graphs.predecessorListOf(this.flowGraph, flow)) {
                    predecessors2.add((CascadeJob)this.jobsMap.get(predecessor.getName()));
                }
                job.init(predecessors2);
            }
        }
    }

    private void handleExecutorShutdown() {
        if (this.spawnStrategy.isCompleted(this)) {
            return;
        }
        this.logInfo("shutting down flow executor");
        try {
            this.spawnStrategy.complete(this, 300, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logInfo("shutdown complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStopAllFlows() {
        this.logInfo("stopping all flows");
        Map<String, Callable<Throwable>> map2 = this.jobsMap;
        synchronized (map2) {
            ArrayList<Callable<Throwable>> jobs = new ArrayList<Callable<Throwable>>(this.jobsMap.values());
            Collections.reverse(jobs);
            for (Callable callable : jobs) {
                ((CascadeJob)callable).stop();
            }
        }
        this.logInfo("stopped all flows");
    }

    public void writeDOT(String filename) {
        this.printElementGraph(filename, this.identifierGraph);
    }

    protected void printElementGraph(String filename, SimpleDirectedGraph<String, BaseFlow.FlowHolder> graph) {
        try {
            FileWriter writer = new FileWriter(filename);
            Util.writeDOT(writer, graph, new IntegerNameProvider(), new VertexNameProvider<String>(){

                @Override
                public String getVertexName(String object) {
                    return object.toString().replaceAll("\"", "'");
                }
            }, new EdgeNameProvider<BaseFlow.FlowHolder>(){

                @Override
                public String getEdgeName(BaseFlow.FlowHolder object) {
                    return object.flow.getName().replaceAll("\"", "'").replaceAll("\n", "\\\\n");
                }
            });
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            LOG.error("failed printing graph to: {}, with exception: {}", (Object)filename, (Object)exception);
        }
    }

    public String toString() {
        return this.getName();
    }

    private void logDebug(String message) {
        LOG.debug("[" + Util.truncate(this.getName(), 25) + "] " + message);
    }

    private void logInfo(String message) {
        LOG.info("[" + Util.truncate(this.getName(), 25) + "] " + message);
    }

    private void logWarn(String message) {
        this.logWarn(message, null);
    }

    private void logWarn(String message, Throwable throwable2) {
        LOG.warn("[" + Util.truncate(this.getName(), 25) + "] " + message, throwable2);
    }

    @Override
    public UnitOfWorkSpawnStrategy getSpawnStrategy() {
        return this.spawnStrategy;
    }

    @Override
    public void setSpawnStrategy(UnitOfWorkSpawnStrategy spawnStrategy) {
        this.spawnStrategy = spawnStrategy;
    }

    private class SafeCascadeListener
    implements CascadeListener {
        final CascadeListener cascadeListener;
        Throwable throwable;

        private SafeCascadeListener(CascadeListener cascadeListener) {
            this.cascadeListener = cascadeListener;
        }

        @Override
        public void onStarting(Cascade cascade) {
            try {
                this.cascadeListener.onStarting(cascade);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public void onStopping(Cascade cascade) {
            try {
                this.cascadeListener.onStopping(cascade);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public void onCompleted(Cascade cascade) {
            try {
                this.cascadeListener.onCompleted(cascade);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public boolean onThrowable(Cascade cascade, Throwable flowThrowable) {
            try {
                return this.cascadeListener.onThrowable(cascade, flowThrowable);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
                return false;
            }
        }

        private void handleThrowable(Throwable throwable2) {
            this.throwable = throwable2;
            Cascade.this.logWarn(String.format("cascade listener %s threw throwable", this.cascadeListener), throwable2);
            Cascade.this.stop();
        }

        public boolean equals(Object object) {
            if (object instanceof SafeCascadeListener) {
                return this.cascadeListener.equals(((SafeCascadeListener)object).cascadeListener);
            }
            return this.cascadeListener.equals(object);
        }

        public int hashCode() {
            return this.cascadeListener.hashCode();
        }
    }

    protected class CascadeJob
    implements Callable<Throwable> {
        final Flow flow;
        private List<CascadeJob> predecessors;
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean stop = false;
        private boolean failed = false;

        public CascadeJob(Flow flow) {
            this.flow = flow;
        }

        public String getName() {
            return this.flow.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Throwable call() {
            try {
                block20: {
                    Iterator<CascadeJob> i$;
                    for (CascadeJob predecessor : this.predecessors) {
                        if (predecessor.isSuccessful()) continue;
                        Throwable throwable2 = null;
                        return throwable2;
                    }
                    if (this.stop) {
                        i$ = null;
                        return i$;
                    }
                    if (LOG.isInfoEnabled()) {
                        Cascade.this.logInfo("starting flow: " + this.flow.getName());
                    }
                    if (!(Cascade.this.flowSkipStrategy == null ? this.flow.isSkipFlow() : Cascade.this.flowSkipStrategy.skipFlow(this.flow))) break block20;
                    if (LOG.isInfoEnabled()) {
                        Cascade.this.logInfo("skipping flow: " + this.flow.getName());
                    }
                    this.flow.getFlowStats().markSkipped();
                    i$ = null;
                    this.flow.cleanup();
                    return i$;
                }
                try {
                    this.flow.prepare();
                    this.flow.complete();
                    if (LOG.isInfoEnabled()) {
                        Cascade.this.logInfo("completed flow: " + this.flow.getName());
                    }
                    this.flow.cleanup();
                }
                catch (Throwable exception) {
                    Throwable throwable3;
                    try {
                        Cascade.this.logWarn("flow failed: " + this.flow.getName(), exception);
                        this.failed = true;
                        throwable3 = new CascadeException("flow failed: " + this.flow.getName(), exception);
                        this.flow.cleanup();
                        this.latch.countDown();
                        return throwable3;
                    }
                    catch (Throwable throwable4) {
                        try {
                            this.flow.cleanup();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            this.failed = true;
                            throwable3 = throwable5;
                            return throwable3;
                        }
                        finally {
                        }
                    }
                }
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        public void init(List<CascadeJob> predecessors2) {
            this.predecessors = predecessors2;
        }

        public void stop() {
            if (LOG.isInfoEnabled()) {
                Cascade.this.logInfo("stopping flow: " + this.flow.getName());
            }
            this.stop = true;
            if (this.flow != null) {
                this.flow.stop();
            }
        }

        public boolean isSuccessful() {
            try {
                this.latch.await();
                return this.flow != null && !this.failed;
            }
            catch (InterruptedException exception) {
                Cascade.this.logWarn("latch interrupted", exception);
                return false;
            }
        }
    }
}

