/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class AvroSpecificRecordSerialization<T>
extends Configured
implements Serialization<T> {
    private static final DecoderFactory FACTORY = DecoderFactory.get();
    private Map<Class<?>, Schema> SCHEMA_CACHE = new WeakHashMap();

    public boolean accept(Class<?> c) {
        return SpecificRecord.class.isAssignableFrom(c);
    }

    private Schema getSchema(Class<T> c) {
        Schema schema = this.SCHEMA_CACHE.get(c);
        if (schema == null) {
            try {
                schema = ((SpecificRecord)c.newInstance()).getSchema();
                this.SCHEMA_CACHE.put(c, schema);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to infer a schema from " + c);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to infer a schema from " + c);
            }
        }
        return schema;
    }

    public Deserializer<T> getDeserializer(Class<T> c) {
        SpecificDatumReader datumReader = new SpecificDatumReader(this.getSchema(c));
        return new AvroSpecificRecordDeserializer(datumReader);
    }

    public Serializer<T> getSerializer(Class<T> c) {
        return new AvroSpecificRecordSerializer(new ReflectDatumWriter(this.getSchema(c)));
    }

    private class AvroSpecificRecordSerializer
    implements Serializer<T> {
        private DatumWriter<T> writer;
        private OutputStream out;
        private BinaryEncoder encoder;

        public AvroSpecificRecordSerializer(DatumWriter<T> writer) {
            this.writer = writer;
        }

        public void open(OutputStream out) {
            this.out = out;
            this.encoder = new EncoderFactory().configureBlockSize(512).binaryEncoder(out, null);
        }

        public void serialize(T record2) throws IOException {
            this.writer.write(record2, this.encoder);
            this.encoder.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    private class AvroSpecificRecordDeserializer
    implements Deserializer<T> {
        private DatumReader<T> reader;
        private BinaryDecoder decoder;
        private boolean isKey;

        public AvroSpecificRecordDeserializer(DatumReader<T> reader) {
            this.reader = reader;
        }

        public void open(InputStream in) {
            this.decoder = FACTORY.directBinaryDecoder(in, this.decoder);
        }

        public T deserialize(T record2) throws IOException {
            Object datum = this.reader.read(record2 == null ? null : (Object)record2, this.decoder);
            return datum;
        }

        public void close() throws IOException {
            this.decoder.inputStream().close();
        }
    }
}

