/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro.local;

import cascading.avro.local.AvroScheme;
import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackedAvroScheme<T>
extends AvroScheme {
    private static final Logger LOG = LoggerFactory.getLogger(PackedAvroScheme.class);

    public PackedAvroScheme() {
        this((Schema)null);
    }

    public PackedAvroScheme(Schema schema) {
        this.schema = schema;
        this.setSinkFields(Fields.FIRST);
        this.setSourceFields(Fields.FIRST);
    }

    DataFileStream createInput(InputStream inputStream) {
        SpecificDatumReader datumReader = new SpecificDatumReader(this.schema);
        try {
            return new DataFileStream(inputStream, datumReader);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    DataFileWriter createOutput(OutputStream outputStream) {
        BinaryEncoder encoder2 = EncoderFactory.get().binaryEncoder(outputStream, null);
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(this.schema);
        DataFileWriter dataWriter = new DataFileWriter(datumWriter);
        try {
            dataWriter.create(this.schema, outputStream);
            return dataWriter;
        }
        catch (IOException e) {
            LOG.error("Unable to create the DataFileWriter output.");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    @Override
    public void sinkPrepare(FlowProcess<Properties> flowProcess, SinkCall<DataFileWriter, OutputStream> sinkCall) {
        if (this.schema == null) {
            throw new RuntimeException("Cannot have a null schema for the sink (yet).");
        }
        sinkCall.setContext(this.createOutput(sinkCall.getOutput()));
    }

    @Override
    public void sink(FlowProcess<Properties> flowProcess, SinkCall<DataFileWriter, OutputStream> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        sinkCall.getContext().append(tupleEntry.getObject(Fields.FIRST));
    }

    @Override
    public Fields retrieveSourceFields(FlowProcess<Properties> flowProcess, Tap tap) {
        if (this.schema == null) {
            this.setSourceFields(Fields.UNKNOWN);
        } else {
            this.setSourceFields(new Fields(new Comparable[]{this.schema.getName()}));
        }
        return this.getSourceFields();
    }

    @Override
    public boolean source(FlowProcess<Properties> flowProcess, SourceCall<DataFileStream, InputStream> sourceCall) {
        if (sourceCall.getContext().hasNext()) {
            Object record2 = sourceCall.getContext().next();
            Tuple tuple = sourceCall.getIncomingEntry().getTuple();
            tuple.clear();
            tuple.add(record2);
            return true;
        }
        return false;
    }
}

