/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro.local;

import cascading.avro.AvroToCascading;
import cascading.avro.CascadingToAvro;
import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroScheme
extends Scheme<Properties, InputStream, OutputStream, DataFileStream, DataFileWriter> {
    private static final Logger LOG = LoggerFactory.getLogger(AvroScheme.class);
    private Encoder encoder;
    protected Schema schema;
    private GenericDatumReader<IndexedRecord> datumReader;
    private GenericDatumWriter<IndexedRecord> datumWriter;

    public AvroScheme(Schema schema) {
        this.schema = schema;
        if (schema == null) {
            this.setSinkFields(Fields.ALL);
            this.setSourceFields(Fields.UNKNOWN);
        } else {
            Fields cascadingFields = new Fields(new Comparable[0]);
            for (Schema.Field avroField : schema.getFields()) {
                cascadingFields = cascadingFields.append(new Fields(new Comparable[]{avroField.name()}));
            }
            this.setSinkFields(cascadingFields);
            this.setSourceFields(cascadingFields);
        }
    }

    public AvroScheme() {
        this((Schema)null);
    }

    DataFileStream<IndexedRecord> createInput(InputStream inputStream) {
        if (this.datumReader == null) {
            this.datumReader = new GenericDatumReader(this.schema);
        }
        try {
            return new DataFileStream<IndexedRecord>(inputStream, this.datumReader);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    DataFileWriter<IndexedRecord> createOutput(OutputStream outputStream) {
        if (this.encoder == null) {
            this.encoder = EncoderFactory.get().binaryEncoder(outputStream, null);
        }
        if (this.datumWriter == null) {
            this.datumWriter = new GenericDatumWriter(this.schema);
        }
        DataFileWriter<IndexedRecord> dataWriter = new DataFileWriter<IndexedRecord>(this.datumWriter);
        try {
            dataWriter.create(this.schema, outputStream);
            return dataWriter;
        }
        catch (IOException e) {
            LOG.error("Unable to create the DataFileWriter output.");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    @Override
    public Fields retrieveSourceFields(FlowProcess<Properties> process2, Tap tap) {
        if (this.schema == null) {
            if (tap instanceof CompositeTap) {
                tap = (Tap)((CompositeTap)((Object)tap)).getChildTaps().next();
            }
            String path = tap.getIdentifier();
            File f2 = new File(path);
            ArrayList<File> secondaryFiles = new ArrayList<File>();
            if (f2.isFile()) {
                try {
                    DataFileReader reader = new DataFileReader(f2, new GenericDatumReader());
                    this.schema = reader.getSchema();
                }
                catch (IOException e) {
                    LOG.info("Couldn't open " + f2.toString(), e);
                }
            }
            if (f2.listFiles() != null) {
                for (File file : f2.listFiles()) {
                    if (file.isFile()) {
                        try {
                            DataFileReader reader = new DataFileReader(file, new GenericDatumReader());
                            this.schema = reader.getSchema();
                            break;
                        }
                        catch (IOException e) {
                            LOG.info("Couldn't open " + file.toString(), e);
                            continue;
                        }
                    }
                    if (!file.isDirectory()) continue;
                    secondaryFiles.addAll(Arrays.asList(file.listFiles()));
                }
            }
            if (this.schema == null) {
                for (File file : secondaryFiles) {
                    if (!file.isFile()) continue;
                    try {
                        DataFileReader reader = new DataFileReader(file, new GenericDatumReader());
                        this.schema = reader.getSchema();
                        break;
                    }
                    catch (IOException e) {
                        LOG.info("Couldn't open " + file.toString(), e);
                    }
                }
            }
            if (this.schema == null) {
                LOG.info("Couldn't find any concrete Schema. Using Schema.Type.NULL. Things will probably break.");
                this.schema = Schema.create(Schema.Type.NULL);
            }
        }
        Fields cascadingFields = new Fields(new Comparable[0]);
        if (this.schema.getType().equals((Object)Schema.Type.NULL)) {
            cascadingFields = Fields.NONE;
        } else {
            for (Schema.Field avroField : this.schema.getFields()) {
                cascadingFields = cascadingFields.append(new Fields(new Comparable[]{avroField.name()}));
            }
        }
        this.setSourceFields(cascadingFields);
        return this.getSourceFields();
    }

    @Override
    public void presentSourceFields(FlowProcess<Properties> process2, Tap tap, Fields fields2) {
    }

    @Override
    public void presentSinkFields(FlowProcess<Properties> flowProcess, Tap tap, Fields fields2) {
    }

    @Override
    public void sourceConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, InputStream, OutputStream> tap, Properties conf) {
    }

    @Override
    public void sourcePrepare(FlowProcess<Properties> flowProcess, SourceCall<DataFileStream, InputStream> sourceCall) throws IOException {
        sourceCall.setContext(this.createInput(sourceCall.getInput()));
    }

    @Override
    public boolean source(FlowProcess<Properties> flowProcess, SourceCall<DataFileStream, InputStream> sourceCall) throws IOException {
        if (sourceCall.getContext().hasNext()) {
            IndexedRecord record2 = (IndexedRecord)sourceCall.getContext().next();
            Tuple tuple = sourceCall.getIncomingEntry().getTuple();
            tuple.clear();
            Object[] split2 = AvroToCascading.parseRecord(record2, this.schema);
            tuple.addAll(split2);
            return true;
        }
        return false;
    }

    @Override
    public void sourceCleanup(FlowProcess<Properties> flowProcess, SourceCall<DataFileStream, InputStream> sourceCall) throws IOException {
        sourceCall.getContext().close();
    }

    @Override
    public void sinkConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, InputStream, OutputStream> tap, Properties conf) {
    }

    @Override
    public void sinkPrepare(FlowProcess<Properties> flowProcess, SinkCall<DataFileWriter, OutputStream> sinkCall) {
        if (this.schema == null) {
            throw new RuntimeException("Cannot have a null schema for the sink (yet).");
        }
        sinkCall.setContext(this.createOutput(sinkCall.getOutput()));
    }

    @Override
    public void sink(FlowProcess<Properties> flowProcess, SinkCall<DataFileWriter, OutputStream> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        GenericData.Record record2 = new GenericData.Record(this.schema);
        Object[] objectArray = CascadingToAvro.parseTupleEntry(tupleEntry, this.schema);
        for (int i = 0; i < objectArray.length; ++i) {
            record2.put(i, objectArray[i]);
        }
        sinkCall.getContext().append(record2);
    }

    @Override
    public void sinkCleanup(FlowProcess<Properties> flowProcess, SinkCall<DataFileWriter, OutputStream> sinkCall) {
        try {
            sinkCall.getContext().flush();
            sinkCall.getContext().close();
        }
        catch (IOException e) {
            LOG.error("Unable to flush and close the output sink.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvroScheme that = (AvroScheme)o;
        return !(this.schema != null ? !this.schema.equals(that.schema) : that.schema != null);
    }

    @Override
    public String toString() {
        return "AvroScheme{schema=" + this.schema + '}';
    }

    @Override
    public int hashCode() {
        return 31 * this.getSinkFields().hashCode() + this.schema.hashCode();
    }
}

