/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro;

import cascading.avro.AvroScheme;
import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class PackedAvroScheme<T>
extends AvroScheme {
    public PackedAvroScheme() {
        this((Schema)null);
    }

    public PackedAvroScheme(Schema schema) {
        this.schema = schema;
        this.setSinkFields(Fields.FIRST);
        this.setSourceFields(Fields.FIRST);
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        sinkCall.getOutput().collect(new AvroWrapper<Object>(tupleEntry.getObject(Fields.FIRST)), (Object)NullWritable.get());
    }

    @Override
    public void sinkPrepare(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
    }

    @Override
    public Fields retrieveSourceFields(FlowProcess<JobConf> flowProcess, Tap tap) {
        if (this.schema == null) {
            this.setSourceFields(Fields.UNKNOWN);
        } else {
            this.setSourceFields(new Fields(new Comparable[]{this.schema.getName()}));
        }
        return this.getSourceFields();
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        AvroWrapper wrapper2;
        RecordReader input2 = sourceCall.getInput();
        if (!input2.next((Object)(wrapper2 = (AvroWrapper)input2.createKey()), input2.createValue())) {
            return false;
        }
        Object record2 = wrapper2.datum();
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        tuple.clear();
        tuple.add(record2);
        return true;
    }
}

