/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.io.BytesWritable;

public class CascadingToAvro {
    private static Map<Class<?>, Schema.Type> TYPE_MAP = new HashMap<Class<?>, Schema.Type>(){
        {
            this.put(Integer.class, Schema.Type.INT);
            this.put(Long.class, Schema.Type.LONG);
            this.put(Boolean.class, Schema.Type.BOOLEAN);
            this.put(Double.class, Schema.Type.DOUBLE);
            this.put(Float.class, Schema.Type.FLOAT);
            this.put(String.class, Schema.Type.STRING);
            this.put(BytesWritable.class, Schema.Type.BYTES);
            this.put(List.class, Schema.Type.ARRAY);
            this.put(Map.class, Schema.Type.MAP);
        }
    };

    public static Object[] parseTupleEntry(TupleEntry tupleEntry, Schema writerSchema) {
        if (writerSchema.getFields().size() != tupleEntry.size()) {
            throw new AvroRuntimeException("Arity mismatch between incoming tuple and schema");
        }
        return CascadingToAvro.parseTuple(tupleEntry.getTuple(), writerSchema);
    }

    public static Object[] parseTuple(Tuple tuple, Schema writerSchema) {
        Object[] result2 = new Object[writerSchema.getFields().size()];
        List<Schema.Field> schemaFields = writerSchema.getFields();
        for (int i = 0; i < schemaFields.size(); ++i) {
            Schema.Field field2 = schemaFields.get(i);
            Object obj = tuple.getObject(i);
            result2[i] = CascadingToAvro.toAvro(obj, field2.schema());
        }
        return result2;
    }

    protected static Object toAvro(Object obj, Schema schema) {
        switch (schema.getType()) {
            case ARRAY: {
                return CascadingToAvro.toAvroArray(obj, schema);
            }
            case STRING: {
                return obj.toString();
            }
            case ENUM: {
                return CascadingToAvro.toAvroEnum(obj, schema);
            }
            case FIXED: {
                return CascadingToAvro.toAvroFixed(obj, schema);
            }
            case BYTES: {
                return CascadingToAvro.toAvroBytes(obj);
            }
            case RECORD: {
                Object[] objs = obj instanceof Tuple ? CascadingToAvro.parseTuple((Tuple)obj, schema) : CascadingToAvro.parseTupleEntry((TupleEntry)obj, schema);
                GenericData.Record record2 = new GenericData.Record(schema);
                for (int i = 0; i < objs.length; ++i) {
                    record2.put(i, objs[i]);
                }
                return record2;
            }
            case MAP: {
                return CascadingToAvro.toAvroMap(obj, schema);
            }
            case UNION: {
                return CascadingToAvro.toAvroUnion(obj, schema);
            }
            case NULL: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: {
                return obj;
            }
        }
        throw new AvroRuntimeException("Can't convert from type " + schema.getType().toString());
    }

    protected static Object toAvroEnum(Object obj, Schema schema) {
        return new GenericData.EnumSymbol(schema, obj.toString());
    }

    protected static Object toAvroFixed(Object obj, Schema schema) {
        BytesWritable bytes2 = (BytesWritable)obj;
        GenericData.Fixed fixed = new GenericData.Fixed(schema, bytes2.getBytes());
        return fixed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Object toAvroMap(Object obj, Schema schema) {
        HashMap<String, Object> convertedMap = new HashMap<String, Object>();
        if (obj instanceof Tuple) {
            Schema.Type mapValueType = schema.getValueType().getType();
            Tuple tuple = (Tuple)obj;
            if (tuple.size() % 2 != 0) throw new AvroRuntimeException("Can't convert from an odd length tuple to a map");
            for (int i = 0; i < tuple.size(); i += 2) {
                if (tuple.getObject(i).getClass() != String.class) {
                    throw new AvroRuntimeException("Invalid map definition - the key should be a String - instead of " + tuple.getObject(i).getClass());
                }
                if (CascadingToAvro.toAvroSchemaType(tuple.getObject(i + 1).getClass()) != mapValueType) {
                    throw new AvroRuntimeException(String.format("Found map value with %s instead of expected %s", new Object[]{tuple.getObject(i + 1).getClass(), mapValueType}));
                }
                convertedMap.put(tuple.get(i).toString(), CascadingToAvro.toAvro(tuple.get(i + 1), schema.getValueType()));
            }
            return convertedMap;
        } else {
            for (Map.Entry e : ((Map)obj).entrySet()) {
                convertedMap.put((String)e.getKey(), CascadingToAvro.toAvro(e.getValue(), schema.getValueType()));
            }
        }
        return convertedMap;
    }

    protected static Object toAvroBytes(Object obj) {
        BytesWritable inBytes = (BytesWritable)obj;
        ByteBuffer buffer2 = ByteBuffer.wrap(inBytes.getBytes());
        return buffer2;
    }

    protected static Object toAvroArray(Object obj, Schema schema) {
        if (obj instanceof Iterable) {
            Schema elementSchema = schema.getElementType();
            ArrayList<Object> array2 = new ArrayList<Object>();
            for (Object element : (Iterable)obj) {
                array2.add(CascadingToAvro.toAvro(element, elementSchema));
            }
            return new GenericData.Array(schema, array2);
        }
        throw new AvroRuntimeException("Can't convert from non-iterable to array");
    }

    protected static Object toAvroUnion(Object obj, Schema schema) {
        if (obj == null) {
            return obj;
        }
        List<Schema> types2 = schema.getTypes();
        if (types2.size() < 1) {
            throw new AvroRuntimeException("Union in writer schema has no types");
        }
        if (types2.size() == 1) {
            return CascadingToAvro.toAvro(obj, types2.get(0));
        }
        if (types2.size() > 2) {
            throw new AvroRuntimeException("Unions may only consist of a concrete type and null in cascading.avro");
        }
        if (!types2.get(0).getType().equals((Object)Schema.Type.NULL) && !types2.get(1).getType().equals((Object)Schema.Type.NULL)) {
            throw new AvroRuntimeException("Unions may only consist of a concrete type and null in cascading.avro");
        }
        Integer concreteIndex = types2.get(0).getType() == Schema.Type.NULL ? 1 : 0;
        return CascadingToAvro.toAvro(obj, types2.get(concreteIndex));
    }

    protected static Schema generateAvroSchemaFromTupleEntry(TupleEntry tupleEntry, String recordName, boolean isNullable) {
        Fields tupleFields = tupleEntry.getFields();
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (Comparable fieldName : tupleFields) {
            if (!(fieldName instanceof String)) {
                throw new AvroRuntimeException("Can't generate schema from non-string named fields");
            }
            Schema fieldSchema = CascadingToAvro.generateAvroSchemaFromElement(tupleEntry.getObject(fieldName), (String)((Object)fieldName), isNullable);
            avroFields.add(new Schema.Field((String)((Object)fieldName), fieldSchema, null, null));
        }
        Schema outputSchema = Schema.createRecord(recordName, "auto-generated by cascading.avro", null, false);
        outputSchema.setFields(avroFields);
        return outputSchema;
    }

    protected static Schema generateAvroSchemaFromElement(Object element, String name2, boolean isNullable) {
        if (element == null) {
            throw new AvroRuntimeException("Can't infer schema from null valued element");
        }
        if (isNullable) {
            return CascadingToAvro.generateUnionSchema(element, name2);
        }
        if (element instanceof TupleEntry) {
            return CascadingToAvro.generateAvroSchemaFromTupleEntry((TupleEntry)element, name2, isNullable);
        }
        if (element instanceof Map) {
            return CascadingToAvro.generateAvroSchemaFromMap((Map)element, name2);
        }
        if (element instanceof Iterable) {
            return CascadingToAvro.generateAvroSchemaFromIterable((Iterable)element, name2);
        }
        if (element instanceof BytesWritable) {
            return Schema.create(Schema.Type.BYTES);
        }
        if (element instanceof String) {
            return Schema.create(Schema.Type.STRING);
        }
        if (element instanceof Double) {
            return Schema.create(Schema.Type.DOUBLE);
        }
        if (element instanceof Float) {
            return Schema.create(Schema.Type.FLOAT);
        }
        if (element instanceof Integer) {
            return Schema.create(Schema.Type.INT);
        }
        if (element instanceof Long) {
            return Schema.create(Schema.Type.LONG);
        }
        if (element instanceof Boolean) {
            return Schema.create(Schema.Type.BOOLEAN);
        }
        throw new AvroRuntimeException("Can't create schema from type " + element.getClass());
    }

    private static Schema generateAvroSchemaFromIterable(Iterable element, String name2) {
        Iterator iterator2 = element.iterator();
        if (!iterator2.hasNext()) {
            throw new AvroRuntimeException("Can't infer list schema from empty iterable");
        }
        Schema itemSchema = CascadingToAvro.generateAvroSchemaFromElement(iterator2.next(), name2 + "ArrayElement", false);
        Schema arraySchema = Schema.createArray(itemSchema);
        return arraySchema;
    }

    private static Schema generateAvroSchemaFromMap(Map<String, Object> element, String name2) {
        if (element.isEmpty()) {
            throw new AvroRuntimeException("Can't infer map schema from empty map");
        }
        Iterator<Object> iterator2 = element.values().iterator();
        Schema valueSchema = CascadingToAvro.generateAvroSchemaFromElement(iterator2.next(), name2 + "MapValue", false);
        Schema mapSchema = Schema.createMap(valueSchema);
        return mapSchema;
    }

    private static Schema generateUnionSchema(Object element, String name2) {
        ArrayList<Schema> types2 = new ArrayList<Schema>();
        types2.add(Schema.create(Schema.Type.NULL));
        types2.add(CascadingToAvro.generateAvroSchemaFromElement(element, name2, false));
        Schema unionSchema = Schema.createUnion(types2);
        return unionSchema;
    }

    public static Schema generateAvroSchemaFromFieldsAndTypes(String recordName, Fields schemeFields, Class<?>[] schemeTypes) {
        if (schemeFields.size() == 0) {
            throw new IllegalArgumentException("There must be at least one field");
        }
        int schemeTypesSize = 0;
        int i = 0;
        while (i < schemeTypes.length) {
            if (schemeTypes[i] == List.class || schemeTypes[i] == Map.class) {
                ++i;
            }
            ++i;
            ++schemeTypesSize;
        }
        if (schemeTypesSize != schemeFields.size()) {
            throw new IllegalArgumentException("You must have a schemeType for every field");
        }
        for (i = 0; i < schemeTypes.length; ++i) {
            if (schemeTypes[i] != List.class && schemeTypes[i] != Map.class || CascadingToAvro.isPrimitiveType(schemeTypes[++i])) continue;
            throw new IllegalArgumentException("Only primitive types are allowed for an Array or Map");
        }
        return CascadingToAvro.generateSchema(recordName, schemeFields, schemeTypes, 0);
    }

    public static void addToTuple(Tuple t, byte[] bytes2) {
        t.add((Comparable)new BytesWritable(bytes2));
    }

    public static void addToTuple(Tuple t, Enum e) {
        t.add((Comparable)((Object)e.toString()));
    }

    public static void addToTuple(Tuple t, List<?> list2) {
        Tuple listTuple = new Tuple();
        for (Object item : list2) {
            listTuple.add(item);
        }
        t.add(listTuple);
    }

    public static void addToTuple(Tuple t, Map<String, ?> map2) {
        Tuple mapTuple = new Tuple();
        for (String key : map2.keySet()) {
            mapTuple.add((Comparable)((Object)key));
            mapTuple.add(map2.get(key));
        }
        t.add(mapTuple);
    }

    private static boolean isPrimitiveType(Class<?> arrayType) {
        return arrayType == Boolean.class || arrayType == Integer.class || arrayType == Long.class || arrayType == Float.class || arrayType == Double.class || arrayType == String.class || arrayType == BytesWritable.class;
    }

    private static Schema generateSchema(String recordName, Fields schemeFields, Class<?>[] schemeTypes, int depth) {
        ArrayList<Schema.Field> fields2 = new ArrayList<Schema.Field>();
        int typeIndex = 0;
        int fieldIndex = 0;
        while (typeIndex < schemeTypes.length) {
            String fieldName = schemeFields.get(fieldIndex).toString();
            Class[] subSchemeTypes = new Class[2];
            subSchemeTypes[0] = schemeTypes[typeIndex];
            if (schemeTypes[typeIndex] == List.class || schemeTypes[typeIndex] == Map.class) {
                subSchemeTypes[1] = schemeTypes[++typeIndex];
            }
            final Schema schema = CascadingToAvro.createAvroSchema(recordName, schemeFields, subSchemeTypes, depth + 1);
            final Schema nullSchema = Schema.create(Schema.Type.NULL);
            LinkedList<Schema> schemas = new LinkedList<Schema>(){
                {
                    this.add(nullSchema);
                    this.add(schema);
                }
            };
            fields2.add(new Schema.Field(fieldName, Schema.createUnion((List<Schema>)schemas), "", null));
            ++typeIndex;
            ++fieldIndex;
        }
        if (depth > 0) {
            recordName = recordName + depth;
        }
        Schema schema = Schema.createRecord(recordName, "auto generated", "", false);
        schema.setFields(fields2);
        return schema;
    }

    private static Schema createAvroSchema(String recordName, Fields schemeFields, Class<?>[] fieldTypes, int depth) {
        Schema.Type avroType = CascadingToAvro.toAvroSchemaType(fieldTypes[0]);
        int remainingFields = schemeFields.size() - 1;
        if (avroType == Schema.Type.ARRAY) {
            Schema schema;
            if (remainingFields == 0) {
                schema = Schema.createArray(Schema.create(CascadingToAvro.toAvroSchemaType(fieldTypes[1])));
            } else {
                Class[] arrayTypes = new Class[]{fieldTypes[1]};
                schema = Schema.createArray(CascadingToAvro.createAvroSchema(recordName, Fields.offsetSelector(schemeFields.size() - 1, 1), arrayTypes, depth + 1));
            }
            return schema;
        }
        if (avroType == Schema.Type.MAP) {
            Schema schema;
            if (remainingFields == 0) {
                schema = Schema.createMap(Schema.create(CascadingToAvro.toAvroSchemaType(fieldTypes[1])));
            } else {
                Class[] mapTypes = new Class[]{fieldTypes[1]};
                schema = Schema.createMap(CascadingToAvro.createAvroSchema(recordName, Fields.offsetSelector(schemeFields.size() - 1, 1), mapTypes, depth + 1));
            }
            return schema;
        }
        if (avroType == Schema.Type.RECORD) {
            return CascadingToAvro.generateSchema(recordName, Fields.offsetSelector(schemeFields.size() - 1, 1), fieldTypes, depth + 1);
        }
        if (avroType == Schema.Type.ENUM) {
            Class<?> clazz2 = fieldTypes[0];
            ?[] names2 = clazz2.getEnumConstants();
            ArrayList<String> enumNames = new ArrayList<String>(names2.length);
            for (Object name2 : names2) {
                enumNames.add(name2.toString());
            }
            return Schema.createEnum(fieldTypes[0].getName(), null, null, enumNames);
        }
        return Schema.create(avroType);
    }

    private static Schema.Type toAvroSchemaType(Class<?> clazz2) {
        if (TYPE_MAP.containsKey(clazz2)) {
            return TYPE_MAP.get(clazz2);
        }
        if (clazz2.isEnum()) {
            return Schema.Type.ENUM;
        }
        throw new UnsupportedOperationException("The class type " + clazz2 + " is currently unsupported");
    }
}

