/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro;

import cascading.tuple.Tuple;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.io.BytesWritable;

public class AvroToCascading {
    public static Object[] parseRecord(IndexedRecord record2, Schema readerSchema) {
        Object[] result2 = new Object[readerSchema.getFields().size()];
        Schema writerSchema = record2.getSchema();
        List<Schema.Field> schemaFields = readerSchema.getFields();
        for (int i = 0; i < schemaFields.size(); ++i) {
            Schema.Field field2 = schemaFields.get(i);
            if (writerSchema.getField(field2.name()) == null) {
                throw new AvroRuntimeException("Not a valid schema field: " + field2.name());
            }
            Object obj = record2.get(i);
            result2[i] = AvroToCascading.fromAvro(obj, field2.schema());
        }
        return result2;
    }

    protected static Object fromAvro(Object obj, Schema schema) {
        if (obj == null) {
            return null;
        }
        switch (schema.getType()) {
            case UNION: {
                return AvroToCascading.fromAvroUnion(obj, schema);
            }
            case ARRAY: {
                return AvroToCascading.fromAvroArray(obj, schema);
            }
            case STRING: 
            case ENUM: {
                return obj.toString();
            }
            case FIXED: {
                return AvroToCascading.fromAvroFixed(obj, schema);
            }
            case BYTES: {
                return AvroToCascading.fromAvroBytes((ByteBuffer)obj);
            }
            case RECORD: {
                Object[] objs = AvroToCascading.parseRecord((IndexedRecord)obj, schema);
                Tuple result2 = new Tuple();
                result2.addAll(objs);
                return result2;
            }
            case MAP: {
                return AvroToCascading.fromAvroMap(obj, schema);
            }
            case NULL: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: {
                return obj;
            }
        }
        throw new RuntimeException("Can't convert from type " + schema.getType().toString());
    }

    protected static Object fromAvroFixed(Object obj, Schema schema) {
        GenericData.Fixed fixed = (GenericData.Fixed)obj;
        return new BytesWritable(fixed.bytes());
    }

    protected static Object fromAvroMap(Object obj, Schema schema) {
        HashMap<String, Object> convertedMap = new HashMap<String, Object>();
        for (Map.Entry e : ((Map)obj).entrySet()) {
            convertedMap.put(((Utf8)e.getKey()).toString(), AvroToCascading.fromAvro(e.getValue(), schema.getValueType()));
        }
        return convertedMap;
    }

    protected static BytesWritable fromAvroBytes(ByteBuffer val) {
        BytesWritable result2 = new BytesWritable(val.array());
        return result2;
    }

    protected static Object fromAvroArray(Object obj, Schema schema) {
        ArrayList<Object> array2 = new ArrayList<Object>();
        for (Object element : (GenericData.Array)obj) {
            array2.add(AvroToCascading.fromAvro(element, schema.getElementType()));
        }
        return array2;
    }

    protected static Object fromAvroUnion(Object obj, Schema schema) {
        List<Schema> types2 = schema.getTypes();
        if (types2.size() < 1) {
            throw new AvroRuntimeException("Union has no types");
        }
        if (types2.size() == 1) {
            return AvroToCascading.fromAvro(obj, types2.get(0));
        }
        if (types2.size() > 2) {
            throw new AvroRuntimeException("Unions may only consist of a concrete type and null in cascading.avro");
        }
        if (!types2.get(0).getType().equals((Object)Schema.Type.NULL) && !types2.get(1).getType().equals((Object)Schema.Type.NULL)) {
            throw new AvroRuntimeException("Unions may only consist of a concrete type and null in cascading.avro");
        }
        Integer concreteIndex = types2.get(0).getType() == Schema.Type.NULL ? 1 : 0;
        return AvroToCascading.fromAvro(obj, types2.get(concreteIndex));
    }
}

