/*
 * Decompiled with CFR 0.152.
 */
package cascading.avro;

import cascading.avro.AvroToCascading;
import cascading.avro.CascadingToAvro;
import cascading.avro.serialization.AvroSpecificRecordSerialization;
import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.avro.mapred.AvroSerialization;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class AvroScheme
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private static final String DEFAULT_RECORD_NAME = "CascadingAvroRecord";
    private static final PathFilter filter = new PathFilter(){

        public boolean accept(Path path) {
            return !path.getName().startsWith("_");
        }
    };
    Schema schema;

    public AvroScheme() {
        this((Schema)null);
    }

    public AvroScheme(Fields fields2, Class<?>[] types2) {
        this(CascadingToAvro.generateAvroSchemaFromFieldsAndTypes(DEFAULT_RECORD_NAME, fields2, types2));
    }

    public AvroScheme(Schema schema) {
        this.schema = schema;
        if (schema == null) {
            this.setSinkFields(Fields.ALL);
            this.setSourceFields(Fields.UNKNOWN);
        } else {
            Fields cascadingFields = new Fields(new Comparable[0]);
            for (Schema.Field avroField : schema.getFields()) {
                cascadingFields = cascadingFields.append(new Fields(new Comparable[]{avroField.name()}));
            }
            this.setSinkFields(cascadingFields);
            this.setSourceFields(cascadingFields);
        }
    }

    protected static Schema readSchema(ObjectInputStream in) throws IOException {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(in.readUTF());
    }

    String getJsonSchema() {
        if (this.schema == null) {
            return "";
        }
        return this.schema.toString();
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        GenericData.Record record2 = new GenericData.Record((Schema)sinkCall.getContext()[0]);
        Object[] objectArray = CascadingToAvro.parseTupleEntry(tupleEntry, (Schema)sinkCall.getContext()[0]);
        for (int i = 0; i < objectArray.length; ++i) {
            record2.put(i, objectArray[i]);
        }
        sinkCall.getOutput().collect(new AvroWrapper<GenericData.Record>(record2), (Object)NullWritable.get());
    }

    @Override
    public void sinkPrepare(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        sinkCall.setContext(new Object[]{this.schema});
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        if (this.schema == null) {
            throw new RuntimeException("Must provide sink schema");
        }
        conf.set("avro.output.schema", this.schema.toString());
        conf.setOutputFormat(AvroOutputFormat.class);
        this.addAvroSerializations(conf);
    }

    @Override
    public Fields retrieveSourceFields(FlowProcess<JobConf> flowProcess, Tap tap) {
        if (this.schema == null) {
            try {
                this.schema = this.getSourceSchema(flowProcess, tap);
            }
            catch (IOException e) {
                throw new RuntimeException("Can't get schema from data source");
            }
        }
        Fields cascadingFields = new Fields(new Comparable[0]);
        if (this.schema.getType().equals((Object)Schema.Type.NULL)) {
            cascadingFields = Fields.NONE;
        } else {
            for (Schema.Field avroField : this.schema.getFields()) {
                cascadingFields = cascadingFields.append(new Fields(new Comparable[]{avroField.name()}));
            }
        }
        this.setSourceFields(cascadingFields);
        return this.getSourceFields();
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        AvroWrapper wrapper2;
        RecordReader input2 = sourceCall.getInput();
        if (!input2.next((Object)(wrapper2 = (AvroWrapper)input2.createKey()), input2.createValue())) {
            return false;
        }
        IndexedRecord record2 = (IndexedRecord)wrapper2.datum();
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        tuple.clear();
        Object[] split2 = AvroToCascading.parseRecord(record2, this.schema);
        tuple.addAll(split2);
        return true;
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        this.retrieveSourceFields(flowProcess, (Tap)tap);
        conf.set("avro.input.schema", this.schema.toString());
        conf.setInputFormat(AvroInputFormat.class);
        this.addAvroSerializations(conf);
    }

    private Schema getSourceSchema(FlowProcess<JobConf> flowProcess, Tap tap) throws IOException {
        if (tap instanceof CompositeTap) {
            tap = (Tap)((CompositeTap)((Object)tap)).getChildTaps().next();
        }
        String path = tap.getIdentifier();
        Path p = new Path(path);
        FileSystem fs = p.getFileSystem((Configuration)flowProcess.getConfigCopy());
        LinkedList<FileStatus> statuses = new LinkedList<FileStatus>(Arrays.asList(fs.globStatus(p, filter)));
        for (FileStatus status : new LinkedList<FileStatus>(statuses)) {
            if (!status.isDir()) continue;
            for (FileStatus child : Arrays.asList(fs.listStatus(status.getPath(), filter))) {
                if (child.isDir()) {
                    statuses.addAll(Arrays.asList(fs.listStatus(child.getPath(), filter)));
                    continue;
                }
                if (!fs.isFile(child.getPath())) continue;
                statuses.add(child);
            }
        }
        for (FileStatus status : statuses) {
            Path statusPath = status.getPath();
            if (!fs.isFile(statusPath)) continue;
            BufferedInputStream stream = new BufferedInputStream((InputStream)fs.open(statusPath));
            DataFileStream reader = new DataFileStream(stream, new GenericDatumReader());
            return reader.getSchema();
        }
        return Schema.create(Schema.Type.NULL);
    }

    private void addAvroSerializations(JobConf conf) {
        Collection serializations = conf.getStringCollection("io.serializations");
        if (!serializations.contains(AvroSerialization.class.getName())) {
            serializations.add(AvroSerialization.class.getName());
            serializations.add(AvroSpecificRecordSerialization.class.getName());
        }
        conf.setStrings("io.serializations", serializations.toArray(new String[serializations.size()]));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.schema.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.schema = AvroScheme.readSchema(in);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvroScheme that = (AvroScheme)o;
        return !(this.schema != null ? !this.schema.equals(that.schema) : that.schema != null);
    }

    @Override
    public String toString() {
        return "AvroScheme{schema=" + this.schema + '}';
    }

    @Override
    public int hashCode() {
        return 31 * this.getSinkFields().hashCode() + this.schema.hashCode();
    }
}

