/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.livy;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterUtils;
import org.apache.zeppelin.interpreter.ResultMessages;
import org.apache.zeppelin.livy.BaseLivyInterpreter;
import org.apache.zeppelin.livy.LivyException;
import org.apache.zeppelin.livy.LivySparkInterpreter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;

public class LivySparkSQLInterpreter
extends BaseLivyInterpreter {
    public static final String ZEPPELIN_LIVY_SPARK_SQL_FIELD_TRUNCATE = "zeppelin.livy.spark.sql.field.truncate";
    public static final String ZEPPELIN_LIVY_SPARK_SQL_MAX_RESULT = "zeppelin.livy.spark.sql.maxResult";
    private LivySparkInterpreter sparkInterpreter;
    private boolean isSpark2 = false;
    private int maxResult = 1000;
    private boolean truncate = true;

    public LivySparkSQLInterpreter(Properties property) {
        super(property);
        this.maxResult = Integer.parseInt(property.getProperty(ZEPPELIN_LIVY_SPARK_SQL_MAX_RESULT));
        if (property.getProperty(ZEPPELIN_LIVY_SPARK_SQL_FIELD_TRUNCATE) != null) {
            this.truncate = Boolean.parseBoolean(property.getProperty(ZEPPELIN_LIVY_SPARK_SQL_FIELD_TRUNCATE));
        }
    }

    @Override
    public String getSessionKind() {
        return "spark";
    }

    @Override
    public void open() throws InterpreterException {
        this.sparkInterpreter = (LivySparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(LivySparkInterpreter.class));
        try {
            InterpreterContext context = InterpreterContext.builder().setInterpreterOut(new InterpreterOutput()).build();
            InterpreterResult result = this.sparkInterpreter.interpret("spark", context);
            if (result.code() == InterpreterResult.Code.SUCCESS && ((InterpreterResultMessage)result.message().get(0)).getData().contains("org.apache.spark.sql.SparkSession")) {
                LOGGER.info("SparkSession is detected so we are using spark 2.x for session {}", (Object)this.sparkInterpreter.getSessionInfo().id);
                this.isSpark2 = true;
            } else {
                result = this.sparkInterpreter.interpret("sqlContext", context);
                if (result.code() == InterpreterResult.Code.SUCCESS) {
                    LOGGER.info("sqlContext is detected.");
                } else if (result.code() == InterpreterResult.Code.ERROR) {
                    LOGGER.info("sqlContext is not detected, try to create SQLContext by ourselves");
                    result = this.sparkInterpreter.interpret("val sqlContext = new org.apache.spark.sql.SQLContext(sc)\nimport sqlContext.implicits._", context);
                    if (result.code() == InterpreterResult.Code.ERROR) {
                        throw new LivyException("Fail to create SQLContext," + ((InterpreterResultMessage)result.message().get(0)).getData());
                    }
                }
            }
        }
        catch (LivyException e) {
            throw new RuntimeException("Fail to Detect SparkVersion", (Throwable)((Object)e));
        }
    }

    @Override
    public InterpreterResult interpret(String line, InterpreterContext context) {
        try {
            if (StringUtils.isEmpty(line)) {
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
            }
            String sqlQuery = null;
            sqlQuery = this.isSpark2 ? (this.tableWithUTFCharacter() ? "val df = spark.sql(\"\"\"" + line + "\"\"\")\nfor ( col <- df.columns ) {\n    print(col+\"\\t\")\n}\nprintln\ndf.toJSON.take(" + this.maxResult + ").foreach(println)" : "spark.sql(\"\"\"" + line + "\"\"\").show(" + this.maxResult + ", " + this.truncate + ")") : "sqlContext.sql(\"\"\"" + line + "\"\"\").show(" + this.maxResult + ", " + this.truncate + ")";
            InterpreterResult result = this.sparkInterpreter.interpret(sqlQuery, context);
            if (result.code() == InterpreterResult.Code.SUCCESS) {
                InterpreterResult result2 = new InterpreterResult(InterpreterResult.Code.SUCCESS);
                for (InterpreterResultMessage message : result.message()) {
                    if (message.getType() == InterpreterResult.Type.TEXT) {
                        List<String> rows = this.tableWithUTFCharacter() ? this.parseSQLJsonOutput(message.getData()) : this.parseSQLOutput(message.getData());
                        result2.add(InterpreterResult.Type.TABLE, StringUtils.join(rows, "\n"));
                        if (rows.size() < this.maxResult + 1) continue;
                        result2.add(ResultMessages.getExceedsLimitRowsMessage((int)this.maxResult, (String)ZEPPELIN_LIVY_SPARK_SQL_MAX_RESULT));
                        continue;
                    }
                    result2.add(message.getType(), message.getData());
                }
                return result2;
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Exception in LivySparkSQLInterpreter while interpret ", e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterUtils.getMostRelevantMessage((Exception)e));
        }
    }

    @Override
    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    protected List<String> parseSQLJsonOutput(String output) {
        ArrayList<String> rows = new ArrayList<String>();
        String[] rowsOutput = output.split("(?<!\\\\)\\n");
        String[] header = rowsOutput[1].split("\t");
        ArrayList<String> cells = new ArrayList<String>(Arrays.asList(header));
        rows.add(StringUtils.join(cells, "\t"));
        for (int i = 2; i < rowsOutput.length; ++i) {
            Map retMap = (Map)new Gson().fromJson(rowsOutput[i], new TypeToken<HashMap<String, String>>(){}.getType());
            cells = new ArrayList();
            for (String s : header) {
                cells.add(retMap.getOrDefault(s, "null").replace("\n", "\\n").replace("\t", "\\t"));
            }
            rows.add(StringUtils.join(cells, "\t"));
        }
        return rows;
    }

    protected List<String> parseSQLOutput(String str) {
        String fullWidthRegex = "([\u1100-\u115f\u2e80-\ua4cf\uac00-\ud7a3\uf900-\ufaff\ufe10-\ufe19\ufe30-\ufe6f\uff00-\uff60\uffe0-\uffe6])";
        String output = str.replaceAll(fullWidthRegex, "$1\u0001");
        ArrayList<String> rows = new ArrayList<String>();
        String firstLine = output.split("\n", 2)[0];
        String[] tokens = StringUtils.split(firstLine, "\\+");
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        int start = 0;
        int end = 0;
        for (String token : tokens) {
            start = end + 1;
            end = start + token.length();
            pairs.add(new Pair(start, end));
        }
        int lineStart = 0;
        int lineEnd = firstLine.length();
        while (lineEnd < output.length()) {
            String line = output.substring(lineStart, lineEnd);
            if (line.matches("(?s)^\\|.*\\|$")) {
                ArrayList<String> cells = new ArrayList<String>();
                for (Pair pair : pairs) {
                    cells.add(LivySparkSQLInterpreter.escapeJavaStyleString(line.substring(pair.start, pair.end).replaceAll("\u0001", "")).trim());
                }
                rows.add(StringUtils.join(cells, "\t"));
            }
            lineEnd = (lineStart += firstLine.length() + 1) + firstLine.length();
        }
        return rows;
    }

    private static String escapeJavaStyleString(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            LivySparkSQLInterpreter.escapeJavaStyleString(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void escapeJavaStyleString(Writer out, String str) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write(ch);
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + LivySparkSQLInterpreter.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.write("\\u00" + LivySparkSQLInterpreter.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + LivySparkSQLInterpreter.hex(ch));
                            break;
                        }
                        out.write("\\u000" + LivySparkSQLInterpreter.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.write(92);
                    continue block13;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block13;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block13;
                }
                case '/': {
                    out.write(92);
                    continue block13;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public boolean concurrentSQL() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.livy.concurrentSQL"));
    }

    public boolean tableWithUTFCharacter() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.livy.tableWithUTFCharacter"));
    }

    public Scheduler getScheduler() {
        if (this.concurrentSQL()) {
            int maxConcurrency = 10;
            return SchedulerFactory.singleton().createOrGetParallelScheduler(LivySparkInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), maxConcurrency);
        }
        if (this.sparkInterpreter != null) {
            return this.sparkInterpreter.getScheduler();
        }
        return super.getScheduler();
    }

    @Override
    public void cancel(InterpreterContext context) {
        if (this.sparkInterpreter != null) {
            this.sparkInterpreter.cancel(context);
        }
    }

    @Override
    public void close() {
        if (this.sparkInterpreter != null) {
            this.sparkInterpreter.close();
        }
    }

    @Override
    public int getProgress(InterpreterContext context) {
        if (this.sparkInterpreter != null) {
            return this.sparkInterpreter.getProgress(context);
        }
        return 0;
    }

    @Override
    protected String extractAppId() throws LivyException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String extractWebUIAddress() throws LivyException {
        throw new UnsupportedOperationException();
    }

    private static class Pair {
        private int start;
        private int end;

        Pair(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

