/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.FindOptions;
import com.influxdb.client.OrganizationsApi;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.OperationLog;
import com.influxdb.client.domain.OperationLogs;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.Organizations;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.SecretKeys;
import com.influxdb.client.domain.SecretKeysResponse;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.OrganizationsService;
import com.influxdb.internal.AbstractRestClient;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import retrofit2.Call;

final class OrganizationsApiImpl
extends AbstractRestClient
implements OrganizationsApi {
    private static final Logger LOG = Logger.getLogger(OrganizationsApiImpl.class.getName());
    private final OrganizationsService service;

    OrganizationsApiImpl(@Nonnull OrganizationsService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Organization findOrganizationByID(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Call<Organization> organization = this.service.getOrgsID(orgID, null);
        return this.execute(organization);
    }

    @Override
    @Nonnull
    public List<Organization> findOrganizations() {
        Call<Organizations> organizationsCall = this.service.getOrgs(null, null, null);
        Organizations organizations = this.execute(organizationsCall);
        LOG.log(Level.FINEST, "findOrganizations found: {0}", organizations);
        return organizations.getOrgs();
    }

    @Override
    @Nonnull
    public Organization createOrganization(@Nonnull String name) {
        Arguments.checkNonEmpty(name, "Organization name");
        Organization organization = new Organization();
        organization.setName(name);
        return this.createOrganization(organization);
    }

    @Override
    @Nonnull
    public Organization createOrganization(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        Call<Organization> call = this.service.postOrgs(organization, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Organization updateOrganization(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        Call<Organization> orgCall = this.service.patchOrgsID(organization.getId(), organization, null);
        return this.execute(orgCall);
    }

    @Override
    public void deleteOrganization(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization is required");
        this.deleteOrganization(organization.getId());
    }

    @Override
    public void deleteOrganization(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Call<Void> call = this.service.deleteOrgsID(orgID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Organization cloneOrganization(@Nonnull String clonedName, @Nonnull String orgID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(orgID, "orgID");
        Organization organization = this.findOrganizationByID(orgID);
        return this.cloneOrganization(clonedName, organization);
    }

    @Override
    @Nonnull
    public Organization cloneOrganization(@Nonnull String clonedName, @Nonnull Organization organization) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(organization, "Organization");
        Organization cloned = new Organization();
        cloned.setName(clonedName);
        cloned.setDescription(organization.getDescription());
        Organization created = this.createOrganization(cloned);
        this.getLabels(organization).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    public SecretKeysResponse getSecrets(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        return this.getSecrets(organization.getId());
    }

    @Override
    public SecretKeysResponse getSecrets(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Call<SecretKeysResponse> call = this.service.getOrgsIDSecrets(orgID, null);
        return this.execute(call);
    }

    @Override
    public void putSecrets(@Nonnull Map<String, String> secrets, @Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        this.putSecrets(secrets, organization.getId());
    }

    @Override
    public void putSecrets(@Nonnull Map<String, String> secrets, @Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Arguments.checkNotNull(secrets, "secrets");
        Call<Void> call = this.service.patchOrgsIDSecrets(orgID, secrets, null);
        this.execute(call);
    }

    @Override
    public void deleteSecrets(@Nonnull List<String> secrets, @Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        Arguments.checkNotNull(secrets, "secrets");
        this.deleteSecrets(secrets, organization.getId());
    }

    @Override
    public void deleteSecrets(@Nonnull List<String> secrets, @Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Arguments.checkNotNull(secrets, "secrets");
        SecretKeys secretKeys = new SecretKeys();
        secrets.forEach(secretKeys::addSecretsItem);
        this.deleteSecrets(secretKeys, orgID);
    }

    @Override
    public void deleteSecrets(@Nonnull SecretKeys secretKeys, @Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Arguments.checkNotNull(secretKeys, "secretKeys");
        Call<Void> call = this.service.postOrgsIDSecrets(orgID, secretKeys, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        return this.getMembers(organization.getId());
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Call<ResourceMembers> call = this.service.getOrgsIDMembers(orgID, null);
        ResourceMembers resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findOrganizationMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        Arguments.checkNotNull(member, "member");
        return this.addMember(member.getId(), organization.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String orgID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(orgID, "Organization ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postOrgsIDMembers(orgID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        Arguments.checkNotNull(member, "member");
        this.deleteMember(member.getId(), organization.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String orgID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Call<Void> call = this.service.deleteOrgsIDMembersID(memberID, orgID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        return this.getOwners(organization.getId());
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Call<ResourceOwners> call = this.service.getOrgsIDOwners(orgID, null);
        ResourceOwners resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findOrganizationOwners found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        Arguments.checkNotNull(owner, "owner");
        return this.addOwner(owner.getId(), organization.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String orgID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(orgID, "Organization ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postOrgsIDOwners(orgID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization");
        Arguments.checkNotNull(owner, "owner");
        this.deleteOwner(owner.getId(), organization.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String orgID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Call<Void> call = this.service.deleteOrgsIDOwnersID(ownerID, orgID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "organization");
        return this.getLabels(organization.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "orgID");
        Call<LabelsResponse> call = this.service.getOrgsIDLabels(orgID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Organization organization) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(organization, "organization");
        return this.addLabel(label.getId(), organization.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String orgID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(orgID, "orgID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postOrgsIDLabels(orgID, labelMapping, null);
        return this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Organization organization) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(organization, "organization");
        this.deleteLabel(label.getId(), organization.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String orgID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(orgID, "orgID");
        Call<Void> call = this.service.deleteOrgsIDLabelsID(orgID, labelID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<OperationLog> findOrganizationLogs(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "organization");
        return this.findOrganizationLogs(organization.getId());
    }

    @Override
    @Nonnull
    public OperationLogs findOrganizationLogs(@Nonnull Organization organization, @Nonnull FindOptions findOptions) {
        Arguments.checkNotNull(organization, "organization");
        Arguments.checkNotNull(findOptions, "findOptions");
        return this.findOrganizationLogs(organization.getId(), findOptions);
    }

    @Override
    @Nonnull
    public List<OperationLog> findOrganizationLogs(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "orgID");
        return this.findOrganizationLogs(orgID, new FindOptions()).getLogs();
    }

    @Override
    @Nonnull
    public OperationLogs findOrganizationLogs(@Nonnull String orgID, @Nonnull FindOptions findOptions) {
        Arguments.checkNonEmpty(orgID, "orgID");
        Arguments.checkNotNull(findOptions, "findOptions");
        Call<OperationLogs> call = this.service.getOrgsIDLogs(orgID, null, findOptions.getOffset(), findOptions.getLimit());
        return this.execute(call);
    }
}

