/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.hazelcastjet;

import com.google.gson.Gson;
import com.hazelcast.jet.core.DAG;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zeppelin.interpreter.graph.GraphResult;
import org.apache.zeppelin.tabledata.Node;
import org.apache.zeppelin.tabledata.Relationship;

public class HazelcastJetInterpreterUtils {
    private static final Gson gson = new Gson();

    public static String displayNetworkFromDAG(DAG dag) {
        GraphResult.Graph graph = new GraphResult.Graph();
        graph.setDirected(true);
        HashMap nodeIds = new HashMap();
        ArrayList nodes = new ArrayList();
        AtomicInteger nodeCount = new AtomicInteger(1);
        dag.forEach(v -> {
            nodeIds.put(v.getName(), nodeCount.getAndIncrement());
            Node node = new Node();
            node.setId((long)((Integer)nodeIds.get(v.getName())).intValue());
            if (v.getName().toLowerCase().contains("sink")) {
                node.setLabel("Sink");
            } else if (v.getName().toLowerCase().contains("source")) {
                node.setLabel("Source");
            } else {
                node.setLabel("Transform");
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("description", v.getName());
            node.setData(data);
            nodes.add(node);
        });
        graph.setNodes(nodes);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("Source", "#00317c");
        labels.put("Transform", "#ff7600");
        labels.put("Sink", "#00317c");
        graph.setLabels(labels);
        HashMap edgeIds = new HashMap();
        ArrayList rels = new ArrayList();
        AtomicInteger relCount = new AtomicInteger(1);
        dag.forEach(v -> {
            dag.getInboundEdges(v.getName()).forEach(e -> {
                String edgeName = e.getSourceName() + " to " + e.getDestName();
                if (edgeIds.get(edgeName) == null) {
                    edgeIds.put(edgeName, relCount.getAndIncrement());
                    Relationship rel = new Relationship();
                    rel.setId((long)((Integer)edgeIds.get(edgeName)).intValue());
                    rel.setSource((long)((Integer)nodeIds.get(e.getSourceName())).intValue());
                    rel.setTarget((long)((Integer)nodeIds.get(e.getDestName())).intValue());
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("routing", e.getRoutingPolicy().toString());
                    data.put("priority", e.getPriority());
                    data.put("distributed", e.isDistributed());
                    rel.setData(data);
                    rels.add(rel);
                }
            });
            dag.getOutboundEdges(v.getName()).forEach(e -> {
                String edgeName = e.getSourceName() + " to " + e.getDestName();
                if (edgeIds.get(edgeName) == null) {
                    edgeIds.put(edgeName, relCount.getAndIncrement());
                    Relationship rel = new Relationship();
                    rel.setId((long)((Integer)edgeIds.get(edgeName)).intValue());
                    rel.setSource((long)((Integer)nodeIds.get(e.getSourceName())).intValue());
                    rel.setTarget((long)((Integer)nodeIds.get(e.getDestName())).intValue());
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("routing", e.getRoutingPolicy().toString());
                    data.put("priority", e.getPriority());
                    data.put("distributed", e.isDistributed());
                    rel.setData(data);
                    rels.add(rel);
                }
            });
        });
        graph.setEdges(rels);
        return "%network " + gson.toJson((Object)graph);
    }
}

