/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;

public class SinkReducer<T, K, V, R>
implements DistributedCollector.Reducer<T, R> {
    final String sinkName;
    final DistributedFunction<JetInstance, ? extends R> toDistributedObject;
    final DistributedFunction<? super T, ? extends K> keyMapper;
    final DistributedFunction<? super T, ? extends V> valueMapper;
    final ProcessorMetaSupplier metaSupplier;

    public SinkReducer(String sinkName, DistributedFunction<JetInstance, ? extends R> toDistributedObject, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends V> valueMapper, ProcessorMetaSupplier metaSupplier) {
        this.sinkName = sinkName;
        this.toDistributedObject = toDistributedObject;
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.metaSupplier = metaSupplier;
    }

    @Override
    public R reduce(StreamContext context, Pipe<? extends T> upstream) {
        DAG dag = new DAG();
        Vertex previous = upstream.buildDAG(dag);
        Vertex mapper = dag.newVertex("map", Processors.mapP(t -> Util.entry(this.keyMapper.apply(t), this.valueMapper.apply(t))));
        Vertex writer = dag.newVertex(this.sinkName, this.metaSupplier);
        dag.edge(Edge.between(previous, mapper));
        dag.edge(Edge.between(mapper, writer));
        StreamUtil.executeJob(context, dag);
        return this.toDistributedObject.apply(context.getJetInstance());
    }
}

