/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.IListJet;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.CollectorAccumulateP;
import com.hazelcast.jet.stream.impl.processor.CollectorCombineP;
import com.hazelcast.jet.stream.impl.processor.CombineP;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

public class CollectorReducer<T, A, R>
implements DistributedCollector.Reducer<T, R> {
    private final Supplier<A> supplier;
    private final BiConsumer<A, T> accumulator;
    private final BinaryOperator<A> combiner;
    private final Function<A, R> finisher;

    public CollectorReducer(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher) {
        this.supplier = supplier;
        this.accumulator = accumulator;
        this.combiner = combiner;
        this.finisher = finisher;
    }

    static <A, R> R execute(StreamContext context, DAG dag, Vertex combiner, Function<A, R> finisher) {
        String listName = StreamUtil.uniqueListName();
        Vertex writer = dag.newVertex("write-" + listName, SinkProcessors.writeListP(listName));
        dag.edge(Edge.between(combiner, writer));
        StreamUtil.executeJob(context, dag);
        IListJet list = context.getJetInstance().getList(listName);
        Object result = list.get(0);
        list.destroy();
        return finisher.apply(result);
    }

    static <T, R> Vertex buildAccumulator(DAG dag, Pipe<T> upstream, Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        Vertex previous;
        Vertex accumulatorVertex = dag.newVertex("accumulator", () -> new CollectorAccumulateP(accumulator, supplier));
        if (upstream.isOrdered()) {
            accumulatorVertex.localParallelism(1);
        }
        if ((previous = upstream.buildDAG(dag)) != accumulatorVertex) {
            dag.edge(Edge.between(previous, accumulatorVertex));
        }
        return accumulatorVertex;
    }

    static <A, R> Vertex buildCombiner(DAG dag, Vertex accumulatorVertex, Object combiner) {
        DistributedSupplier<Processor> processorSupplier = CollectorReducer.getCombinerSupplier(combiner);
        Vertex combinerVertex = dag.newVertex("combiner", processorSupplier).localParallelism(1);
        dag.edge(Edge.between(accumulatorVertex, combinerVertex).distributed().allToOne());
        return combinerVertex;
    }

    private static DistributedSupplier<Processor> getCombinerSupplier(Object combiner) {
        if (combiner instanceof BiConsumer) {
            return () -> new CollectorCombineP((BiConsumer)combiner);
        }
        if (combiner instanceof BinaryOperator) {
            return () -> new CombineP((BinaryOperator)combiner);
        }
        throw new IllegalArgumentException("combiner is of type " + combiner.getClass());
    }

    @Override
    public R reduce(StreamContext context, Pipe<? extends T> upstream) {
        DAG dag = new DAG();
        Vertex accumulatorVertex = CollectorReducer.buildAccumulator(dag, upstream, this.supplier, this.accumulator);
        Vertex combinerVertex = CollectorReducer.buildCombiner(dag, accumulatorVertex, this.combiner);
        return CollectorReducer.execute(context, dag, combinerVertex, this.finisher);
    }
}

