/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Partitioner;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipe;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.DistinctP;
import javax.annotation.Nonnull;

class DistinctPipe<T>
extends AbstractIntermediatePipe<T, T> {
    DistinctPipe(StreamContext context, Pipe<T> upstream) {
        super(context, upstream.isOrdered(), upstream);
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        return this.upstream.isOrdered() ? this.orderedGraph(dag) : this.unorderedGraph(dag);
    }

    @Nonnull
    private Vertex orderedGraph(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        Vertex distinct = dag.newVertex(StreamUtil.uniqueVertexName("distinct"), DistinctP::new).localParallelism(1);
        dag.edge(Edge.between(previous, distinct));
        return distinct;
    }

    @Nonnull
    private Vertex unorderedGraph(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        Vertex distinct = dag.newVertex(StreamUtil.uniqueVertexName("distinct-local"), DistinctP::new);
        Vertex combine = dag.newVertex(StreamUtil.uniqueVertexName("distinct-distributed"), DistinctP::new);
        dag.edge(Edge.between(previous, distinct).partitioned(DistributedFunctions.wholeItem(), Partitioner.HASH_CODE)).edge(Edge.between(distinct, combine).partitioned(DistributedFunctions.wholeItem()).distributed());
        return combine;
    }
}

