/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.pipeline.ContextFactory;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TransformUsingContextP<C, T, R>
extends AbstractProcessor {
    C contextObject;
    private final ContextFactory<C> contextFactory;
    private final DistributedTriFunction<ResettableSingletonTraverser<R>, ? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn;
    private Traverser<? extends R> outputTraverser;
    private final ResettableSingletonTraverser<R> singletonTraverser = new ResettableSingletonTraverser();

    private TransformUsingContextP(@Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedTriFunction<ResettableSingletonTraverser<R>, ? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn, @Nullable C contextObject) {
        this.contextFactory = contextFactory;
        this.flatMapFn = flatMapFn;
        this.contextObject = contextObject;
        assert (contextObject == null ^ contextFactory.isSharedLocally()) : "if contextObject is shared, it must be non-null, or vice versa";
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        if (!this.contextFactory.isSharedLocally()) {
            assert (this.contextObject == null) : "contextObject is not null: " + this.contextObject;
            this.contextObject = this.contextFactory.createFn().apply(context.jetInstance());
        }
    }

    @Override
    public boolean isCooperative() {
        return this.contextFactory.isCooperative();
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        if (this.outputTraverser == null) {
            this.outputTraverser = (Traverser)this.flatMapFn.apply(this.singletonTraverser, this.contextObject, (ResettableSingletonTraverser<R>)item);
        }
        if (this.emitFromTraverser(this.outputTraverser)) {
            this.outputTraverser = null;
            return true;
        }
        return false;
    }

    @Override
    public void close(@Nullable Throwable error) {
        if (this.contextObject != null && !this.contextFactory.isSharedLocally()) {
            this.contextFactory.destroyFn().accept(this.contextObject);
        }
        this.contextObject = null;
    }

    public static <C, T, R> ProcessorSupplier supplier(@Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedTriFunction<ResettableSingletonTraverser<R>, ? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return new Supplier(contextFactory, flatMapFn);
    }

    private static final class Supplier<C, T, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final ContextFactory<C> contextFactory;
        private final DistributedTriFunction<ResettableSingletonTraverser<R>, ? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn;
        private transient C contextObject;

        private Supplier(@Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedTriFunction<ResettableSingletonTraverser<R>, ? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
            this.contextFactory = contextFactory;
            this.flatMapFn = flatMapFn;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            if (this.contextFactory.isSharedLocally()) {
                this.contextObject = this.contextFactory.createFn().apply(context.jetInstance());
            }
        }

        @Override
        @Nonnull
        public Collection<? extends Processor> get(int count) {
            return Stream.generate(() -> new TransformUsingContextP(this.contextFactory, this.flatMapFn, this.contextObject)).limit(count).collect(Collectors.toList());
        }

        @Override
        public void close(Throwable error) {
            if (this.contextObject != null) {
                this.contextFactory.destroyFn().accept(this.contextObject);
            }
        }
    }
}

