/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.core.TimestampKind;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.function.WindowResultFunction;
import com.hazelcast.jet.impl.pipeline.JetEvent;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.SessionWindowDef;
import com.hazelcast.jet.pipeline.SlidingWindowDef;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class WindowAggregateTransform<A, R, OUT>
extends AbstractTransform {
    @Nonnull
    private final AggregateOperation<A, R> aggrOp;
    @Nonnull
    private final WindowDefinition wDef;
    @Nonnull
    private final WindowResultFunction<? super R, ? extends OUT> mapToOutputFn;

    public WindowAggregateTransform(@Nonnull List<Transform> upstream, @Nonnull WindowDefinition wDef, @Nonnull AggregateOperation<A, R> aggrOp, @Nonnull WindowResultFunction<? super R, ? extends OUT> mapToOutputFn) {
        super(WindowAggregateTransform.createName(wDef), upstream);
        this.aggrOp = aggrOp;
        this.wDef = wDef;
        this.mapToOutputFn = mapToOutputFn;
    }

    private static String createName(WindowDefinition wDef) {
        return wDef.kind().name().toLowerCase() + "-window";
    }

    @Override
    public long watermarkFrameSize() {
        return this.wDef.watermarkFrameSize();
    }

    @Override
    public void addToDag(Planner p) {
        if (this.wDef.kind() == WindowDefinition.WindowKind.SESSION) {
            this.addSessionWindow(p, (SessionWindowDef)this.wDef.downcast());
        } else if (this.aggrOp.combineFn() == null) {
            this.addSlidingWindowSingleStage(p, (SlidingWindowDef)this.wDef.downcast());
        } else {
            this.addSlidingWindowTwoStage(p, (SlidingWindowDef)this.wDef.downcast());
        }
    }

    private void addSlidingWindowSingleStage(Planner p, SlidingWindowDef wDef) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, p.uniqueVertexName(this.name(), ""), 1, Processors.aggregateToSlidingWindowP(Collections.nCopies(this.aggrOp.arity(), DistributedFunctions.constantKey()), Collections.nCopies(this.aggrOp.arity(), JetEvent::timestamp), TimestampKind.EVENT, wDef.toSlidingWindowPolicy(), this.aggrOp, this.mapToOutputFn.toKeyedWindowResultFn()));
        p.addEdges((Transform)this, pv.v, edge -> edge.distributed().allToOne());
    }

    private void addSlidingWindowTwoStage(Planner p, SlidingWindowDef wDef) {
        String namePrefix = p.uniqueVertexName(this.name(), "-step");
        SlidingWindowPolicy winPolicy = wDef.toSlidingWindowPolicy();
        Vertex v1 = p.dag.newVertex(namePrefix + '1', Processors.accumulateByFrameP(Collections.nCopies(this.aggrOp.arity(), DistributedFunctions.constantKey()), Collections.nCopies(this.aggrOp.arity(), JetEvent::timestamp), TimestampKind.EVENT, winPolicy, this.aggrOp));
        v1.localParallelism(this.localParallelism());
        Planner.PlannerVertex pv2 = p.addVertex((Transform)this, namePrefix + '2', 1, Processors.combineToSlidingWindowP(winPolicy, this.aggrOp, this.mapToOutputFn.toKeyedWindowResultFn()));
        p.addEdges(this, v1);
        p.dag.edge(Edge.between(v1, pv2.v).distributed().allToOne());
    }

    private void addSessionWindow(Planner p, SessionWindowDef wDef) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, p.uniqueVertexName(this.name(), ""), this.localParallelism(), Processors.aggregateToSessionWindowP(wDef.sessionTimeout(), Collections.nCopies(this.aggrOp.arity(), JetEvent::timestamp), Collections.nCopies(this.aggrOp.arity(), DistributedFunctions.constantKey()), this.aggrOp, this.mapToOutputFn.toKeyedWindowResultFn()));
        p.addEdges((Transform)this, pv.v, edge -> edge.distributed().allToOne());
    }
}

