/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.pipeline.AbstractStage;
import com.hazelcast.jet.impl.pipeline.BatchStageImpl;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.pipeline.SinkStageImpl;
import com.hazelcast.jet.impl.pipeline.StreamStageImpl;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.SinkTransform;
import com.hazelcast.jet.impl.pipeline.transform.StreamSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.pipeline.StreamStage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class PipelineImpl
implements Pipeline {
    private final Map<Transform, List<Transform>> adjacencyMap = new HashMap<Transform, List<Transform>>();

    @Override
    @Nonnull
    public <T> BatchStage<T> drawFrom(@Nonnull BatchSource<? extends T> source) {
        return new BatchStageImpl((BatchSourceTransform)source, this);
    }

    @Override
    @Nonnull
    public <T> StreamStage<T> drawFrom(@Nonnull StreamSource<? extends T> source) {
        StreamSourceTransform xform;
        return new StreamStageImpl((Transform)xform, (xform = (StreamSourceTransform)source).emitsJetEvents() ? ComputeStageImplBase.ADAPT_TO_JET_EVENT : ComputeStageImplBase.DONT_ADAPT, this);
    }

    @Override
    public <T> SinkStage drainTo(@Nonnull Sink<T> sink, GeneralStage<?> ... stagesToDrain) {
        if (stagesToDrain == null || stagesToDrain.length == 0) {
            throw new IllegalArgumentException("No stages supplied to Pipeline.drainTo()");
        }
        List<Transform> upstream = Arrays.stream(stagesToDrain).map(s -> (AbstractStage)((Object)s)).map(s -> s.transform).collect(Collectors.toList());
        int[] ordinalsToAdapt = IntStream.range(0, stagesToDrain.length).filter(i -> ((ComputeStageImplBase)((Object)stagesToDrain[i])).fnAdapter == ComputeStageImplBase.ADAPT_TO_JET_EVENT).toArray();
        SinkImpl sinkImpl = (SinkImpl)sink;
        SinkTransform sinkTransform = new SinkTransform(sinkImpl, upstream, ordinalsToAdapt);
        SinkStageImpl sinkStage = new SinkStageImpl(sinkTransform, this);
        sinkImpl.onAssignToStage();
        this.connect(upstream, sinkTransform);
        return sinkStage;
    }

    @Override
    @Nonnull
    public DAG toDag() {
        return new Planner(this).createDag();
    }

    public void connect(Transform upstream, Transform downstream) {
        this.adjacencyMap.get(upstream).add(downstream);
    }

    public void connect(List<Transform> upstream, Transform downstream) {
        upstream.forEach(u -> this.connect((Transform)u, downstream));
    }

    public String toString() {
        return "Pipeline " + this.adjacencyMap;
    }

    Map<Transform, List<Transform>> adjacencyMap() {
        HashMap<Transform, List<Transform>> safeCopy = new HashMap<Transform, List<Transform>>();
        this.adjacencyMap.forEach((k, v) -> {
            List cfr_ignored_0 = safeCopy.put((Transform)k, new ArrayList(v));
        });
        return safeCopy;
    }

    void register(Transform stage, List<Transform> downstream) {
        List<Transform> prev = this.adjacencyMap.put(stage, downstream);
        assert (prev == null) : "Double registering of a Stage with this Pipeline: " + stage;
    }
}

