/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.connector.SerializableClientConfig;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HazelcastWriters {
    private HazelcastWriters() {
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier mergeMapP(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull DistributedFunction<T, K> toKeyFn, @Nonnull DistributedFunction<T, V> toValueFn, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return HazelcastWriters.updateMapP(name, clientConfig, toKeyFn, (oldValue, item) -> {
            Object newValue = toValueFn.apply(item);
            if (oldValue == null) {
                return newValue;
            }
            return mergeFn.apply(oldValue, newValue);
        });
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapP(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull DistributedFunction<T, K> toKeyFn, @Nonnull DistributedBiFunction<V, T, V> updateFn) {
        boolean isLocal = clientConfig == null;
        return ProcessorMetaSupplier.preferLocalParallelismOne(new HazelcastWriterSupplier(HazelcastWriters.serializableConfig(clientConfig), index -> new ArrayList(), ArrayList::add, instance -> {
            IMap map = instance.getMap(name);
            HashMap tmpMap = new HashMap();
            ApplyFnEntryProcessor entryProcessor = new ApplyFnEntryProcessor(tmpMap, updateFn);
            return buffer -> {
                try {
                    if (buffer.isEmpty()) {
                        return;
                    }
                    for (Object object : buffer) {
                        Object item = object;
                        Object key = toKeyFn.apply(item);
                        if (tmpMap.containsKey(key)) {
                            map.executeOnKeys(tmpMap.keySet(), entryProcessor);
                            tmpMap.clear();
                        }
                        tmpMap.put(key, item);
                    }
                    map.executeOnKeys(tmpMap.keySet(), entryProcessor);
                    tmpMap.clear();
                }
                catch (HazelcastInstanceNotActiveException e) {
                    HazelcastWriters.handleInstanceNotActive(instance, e, isLocal);
                }
                buffer.clear();
            };
        }, DistributedFunctions.noopConsumer()));
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapP(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull DistributedFunction<T, K> toKeyFn, @Nonnull DistributedFunction<T, EntryProcessor<K, V>> toEntryProcessorFn) {
        boolean isLocal = clientConfig == null;
        return ProcessorMetaSupplier.preferLocalParallelismOne(new EntryProcessorWriterSupplier(name, HazelcastWriters.serializableConfig(clientConfig), toKeyFn, toEntryProcessorFn, isLocal));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeMapP(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        boolean isLocal = clientConfig == null;
        return ProcessorMetaSupplier.preferLocalParallelismOne(new HazelcastWriterSupplier(HazelcastWriters.serializableConfig(clientConfig), index -> new ArrayMap(), ArrayMap::add, instance -> {
            IMap map = instance.getMap(name);
            return buffer -> {
                try {
                    map.putAll(buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    HazelcastWriters.handleInstanceNotActive(instance, e, isLocal);
                }
                buffer.clear();
            };
        }, DistributedFunctions.noopConsumer()));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeCacheP(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        boolean isLocal = clientConfig == null;
        return ProcessorMetaSupplier.preferLocalParallelismOne(new HazelcastWriterSupplier(HazelcastWriters.serializableConfig(clientConfig), index -> new ArrayMap(), ArrayMap::add, CacheFlush.flushToCache(name, isLocal), DistributedFunctions.noopConsumer()));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeListP(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        boolean isLocal = clientConfig == null;
        return ProcessorMetaSupplier.preferLocalParallelismOne(new HazelcastWriterSupplier(HazelcastWriters.serializableConfig(clientConfig), index -> new ArrayList(), ArrayList::add, instance -> {
            IList list = instance.getList(name);
            return buffer -> {
                try {
                    list.addAll(buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    HazelcastWriters.handleInstanceNotActive(instance, e, isLocal);
                }
                buffer.clear();
            };
        }, DistributedFunctions.noopConsumer()));
    }

    private static void handleInstanceNotActive(HazelcastInstance instance, HazelcastInstanceNotActiveException e, boolean isLocal) {
        if (isLocal) {
            instance.getLoggingService().getLogger(HazelcastWriters.class).fine("Ignoring HazelcastInstanceNotActiveException from local cluster as the job will be restarted automatically.", e);
            return;
        }
        throw e;
    }

    private static SerializableClientConfig serializableConfig(ClientConfig clientConfig) {
        return clientConfig != null ? new SerializableClientConfig(clientConfig) : null;
    }

    public static class ApplyFnEntryProcessor<K, V, T>
    implements EntryProcessor<K, V>,
    EntryBackupProcessor<K, V>,
    IdentifiedDataSerializable {
        private Map<K, T> keysToUpdate;
        private DistributedBiFunction<V, T, V> updateFn;

        public ApplyFnEntryProcessor() {
        }

        public ApplyFnEntryProcessor(Map<K, T> keysToUpdate, DistributedBiFunction<V, T, V> updateFn) {
            this.keysToUpdate = keysToUpdate;
            this.updateFn = updateFn;
        }

        @Override
        public Object process(Map.Entry<K, V> entry) {
            V oldValue = entry.getValue();
            T item = this.keysToUpdate.get(entry.getKey());
            Object newValue = this.updateFn.apply(oldValue, item);
            entry.setValue(newValue);
            return null;
        }

        @Override
        public EntryBackupProcessor<K, V> getBackupProcessor() {
            return this;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.keysToUpdate);
            out.writeObject(this.updateFn);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.keysToUpdate = (Map)in.readObject();
            this.updateFn = (DistributedBiFunction)in.readObject();
        }

        @Override
        public void processBackup(Map.Entry<K, V> entry) {
            this.process(entry);
        }

        @Override
        public int getFactoryId() {
            return SerializationConstants.FACTORY_ID;
        }

        @Override
        public int getId() {
            return 3;
        }
    }

    private static class HazelcastWriterSupplier<B, T>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final SerializableClientConfig clientConfig;
        private final DistributedFunction<HazelcastInstance, DistributedConsumer<B>> instanceToFlushBufferFn;
        private final DistributedFunction<Processor.Context, B> newBufferFn;
        private final DistributedBiConsumer<B, T> addToBufferFn;
        private final DistributedConsumer<B> disposeBufferFn;
        private transient DistributedConsumer<B> flushBuffer;
        private transient HazelcastInstance client;

        HazelcastWriterSupplier(SerializableClientConfig clientConfig, DistributedFunction<Processor.Context, B> newBufferFn, DistributedBiConsumer<B, T> addToBufferFn, DistributedFunction<HazelcastInstance, DistributedConsumer<B>> instanceToFlushBufferFn, DistributedConsumer<B> disposeBufferFn) {
            this.clientConfig = clientConfig;
            this.instanceToFlushBufferFn = instanceToFlushBufferFn;
            this.newBufferFn = newBufferFn;
            this.addToBufferFn = addToBufferFn;
            this.disposeBufferFn = disposeBufferFn;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            HazelcastInstance instance = this.isRemote() ? (this.client = HazelcastClient.newHazelcastClient(this.clientConfig.asClientConfig())) : context.jetInstance().getHazelcastInstance();
            this.flushBuffer = (DistributedConsumer)this.instanceToFlushBufferFn.apply(instance);
        }

        @Override
        public void close(Throwable error) {
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        private boolean isRemote() {
            return this.clientConfig != null;
        }

        @Nonnull
        public List<Processor> get(int count) {
            return Stream.generate(() -> new WriteBufferedP<B, T>(this.newBufferFn, this.addToBufferFn, this.flushBuffer, this.disposeBufferFn)).limit(count).collect(Collectors.toList());
        }
    }

    private static final class EntryProcessorWriterSupplier<T, K, V>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String name;
        private final SerializableClientConfig clientConfig;
        private final DistributedFunction<T, K> toKeyFn;
        private final DistributedFunction<T, EntryProcessor<K, V>> toEntryProcessorFn;
        private final boolean isLocal;
        private transient HazelcastInstance client;
        private transient HazelcastInstance instance;

        private EntryProcessorWriterSupplier(String name, SerializableClientConfig clientConfig, DistributedFunction<T, K> toKeyFn, DistributedFunction<T, EntryProcessor<K, V>> toEntryProcessorFn, boolean isLocal) {
            this.name = name;
            this.clientConfig = clientConfig;
            this.toKeyFn = toKeyFn;
            this.toEntryProcessorFn = toEntryProcessorFn;
            this.isLocal = isLocal;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.instance = this.isRemote() ? (this.client = HazelcastClient.newHazelcastClient(this.clientConfig.asClientConfig())) : context.jetInstance().getHazelcastInstance();
        }

        @Override
        public void close(Throwable error) {
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        private boolean isRemote() {
            return this.clientConfig != null;
        }

        @Nonnull
        public List<Processor> get(int count) {
            return Stream.generate(() -> new EntryProcessorWriter(this.instance, this.name, this.toKeyFn, this.toEntryProcessorFn, this.isLocal)).limit(count).collect(Collectors.toList());
        }
    }

    private static final class EntryProcessorWriter<T, K, V>
    extends AbstractProcessor {
        private static final int MAX_PARALLEL_ASYNC_OPS = 1000;
        private final AtomicInteger numConcurrentOps = new AtomicInteger();
        private final IMap<K, V> map;
        private final DistributedFunction<T, K> toKeyFn;
        private final DistributedFunction<T, EntryProcessor<K, V>> toEntryProcessorFn;
        private final AtomicReference<Throwable> lastError = new AtomicReference();
        private final HazelcastInstance instance;
        private final ExecutionCallback callback = Util.callbackOf(response -> this.numConcurrentOps.decrementAndGet(), exception -> {
            this.numConcurrentOps.decrementAndGet();
            if (exception != null) {
                this.lastError.compareAndSet((Throwable)null, (Throwable)exception);
            }
        });
        private final boolean isLocal;

        private EntryProcessorWriter(HazelcastInstance instance, String name, DistributedFunction toKeyFn, DistributedFunction<T, EntryProcessor<K, V>> toEntryProcessorFn, boolean isLocal) {
            this.instance = instance;
            this.map = instance.getMap(name);
            this.toKeyFn = toKeyFn;
            this.toEntryProcessorFn = toEntryProcessorFn;
            this.isLocal = isLocal;
        }

        @Override
        public boolean isCooperative() {
            return false;
        }

        @Override
        public boolean tryProcess() {
            this.checkError();
            return true;
        }

        @Override
        protected boolean tryProcess(int ordinal, @Nonnull Object object) throws Exception {
            this.checkError();
            if (!Util.tryIncrement(this.numConcurrentOps, 1, 1000)) {
                return false;
            }
            try {
                Object item = object;
                EntryProcessor entryProcessor = (EntryProcessor)this.toEntryProcessorFn.apply(item);
                Object key = this.toKeyFn.apply(item);
                this.map.submitToKey(key, entryProcessor, this.callback);
                return true;
            }
            catch (HazelcastInstanceNotActiveException e) {
                HazelcastWriters.handleInstanceNotActive(this.instance, e, this.isLocal);
                return false;
            }
        }

        @Override
        public boolean complete() {
            return this.ensureAllWritten();
        }

        @Override
        public boolean saveToSnapshot() {
            return this.ensureAllWritten();
        }

        private boolean ensureAllWritten() {
            boolean allWritten = this.numConcurrentOps.get() == 0;
            this.checkError();
            return allWritten;
        }

        private void checkError() {
            Throwable t = this.lastError.get();
            if (t != null) {
                throw ExceptionUtil.sneakyThrow(t);
            }
        }
    }

    private static final class ArrayMap
    extends AbstractMap<Object, Object> {
        private final List<Map.Entry<Object, Object>> entries;
        private final ArraySet set = new ArraySet();

        ArrayMap() {
            this.entries = new ArrayList<Map.Entry<Object, Object>>();
        }

        @Override
        @Nonnull
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.set;
        }

        public void add(Map.Entry entry) {
            this.entries.add(entry);
        }

        @Override
        public String toString() {
            return this.entries.toString();
        }

        private class ArraySet
        extends AbstractSet<Map.Entry<Object, Object>> {
            private ArraySet() {
            }

            @Override
            @Nonnull
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return ArrayMap.this.entries.iterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.entries.size();
            }
        }
    }

    private static class CacheFlush {
        private CacheFlush() {
        }

        static DistributedFunction<HazelcastInstance, DistributedConsumer<ArrayMap>> flushToCache(String name, boolean isLocal) {
            return instance -> {
                ICache cache = instance.getCacheManager().getCache(name);
                return buffer -> {
                    try {
                        cache.putAll((Map)buffer);
                    }
                    catch (HazelcastInstanceNotActiveException e) {
                        HazelcastWriters.handleInstanceNotActive(instance, e, isLocal);
                    }
                    buffer.clear();
                };
            };
        }
    }
}

