/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.queue.impl;

import com.google.common.io.BaseEncoding;
import io.atomix.core.queue.AsyncDistributedQueue;
import io.atomix.core.queue.DistributedQueue;
import io.atomix.core.queue.DistributedQueueBuilder;
import io.atomix.core.queue.DistributedQueueConfig;
import io.atomix.core.queue.impl.CachingAsyncDistributedQueue;
import io.atomix.core.queue.impl.DistributedQueueProxy;
import io.atomix.core.queue.impl.DistributedQueueService;
import io.atomix.core.queue.impl.TranscodingAsyncDistributedQueue;
import io.atomix.core.queue.impl.UnmodifiableAsyncDistributedQueue;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedQueueBuilder<E>
extends DistributedQueueBuilder<E> {
    public DefaultDistributedQueueBuilder(String name, DistributedQueueConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedQueue<E>> buildAsync() {
        return ((CompletableFuture)this.newProxy(DistributedQueueService.class, new ServiceConfig()).thenCompose(proxy -> new DistributedQueueProxy((ProxyClient<DistributedQueueService>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(rawQueue -> {
            Serializer serializer = this.serializer();
            DelegatingAsyncPrimitive queue = new TranscodingAsyncDistributedQueue<Object, String>((AsyncDistributedQueue<String>)rawQueue, element -> BaseEncoding.base16().encode(serializer.encode(element)), string -> serializer.decode(BaseEncoding.base16().decode((CharSequence)string)));
            if (((DistributedQueueConfig)this.config).getCacheConfig().isEnabled()) {
                queue = new CachingAsyncDistributedQueue(queue, ((DistributedQueueConfig)this.config).getCacheConfig());
            }
            if (((DistributedQueueConfig)this.config).isReadOnly()) {
                queue = new UnmodifiableAsyncDistributedQueue(queue);
            }
            return queue.sync();
        });
    }
}

