/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.search;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventAsyncListener;
import org.apache.zeppelin.notebook.Paragraph;

public abstract class SearchService
extends NoteEventAsyncListener {
    public SearchService(String name) {
        super(name);
    }

    public abstract List<Map<String, String>> query(String var1);

    public abstract void updateNoteIndex(Note var1) throws IOException;

    public abstract void updateParagraphIndex(Paragraph var1) throws IOException;

    public abstract void addNoteIndex(Note var1) throws IOException;

    public abstract void addParagraphIndex(Paragraph var1) throws IOException;

    public abstract void deleteNoteIndex(Note var1) throws IOException;

    public abstract void deleteParagraphIndex(String var1, Paragraph var2) throws IOException;

    @Override
    @PreDestroy
    public void close() {
        super.close();
    }

    @Override
    public void handleNoteCreateEvent(NoteEventAsyncListener.NoteCreateEvent noteCreateEvent) throws Exception {
        this.addNoteIndex(noteCreateEvent.getNote());
    }

    @Override
    public void handleNoteRemoveEvent(NoteEventAsyncListener.NoteRemoveEvent noteRemoveEvent) throws Exception {
        this.deleteNoteIndex(noteRemoveEvent.getNote());
    }

    @Override
    public void handleNoteUpdateEvent(NoteEventAsyncListener.NoteUpdateEvent noteUpdateEvent) throws Exception {
        this.updateNoteIndex(noteUpdateEvent.getNote());
    }

    @Override
    public void handleParagraphCreateEvent(NoteEventAsyncListener.ParagraphCreateEvent paragraphCreateEvent) throws Exception {
        this.addParagraphIndex(paragraphCreateEvent.getParagraph());
    }

    @Override
    public void handleParagraphRemoveEvent(NoteEventAsyncListener.ParagraphRemoveEvent paragraphRemoveEvent) throws Exception {
        Paragraph p = paragraphRemoveEvent.getParagraph();
        this.deleteParagraphIndex(p.getNote().getId(), p);
    }

    @Override
    public void handleParagraphUpdateEvent(NoteEventAsyncListener.ParagraphUpdateEvent paragraphUpdateEvent) throws Exception {
        this.updateParagraphIndex(paragraphUpdateEvent.getParagraph());
    }

    public abstract void startRebuildIndex(Stream<Note> var1);
}

