/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.common.Message;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.Client;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.listener.ZeppelinhubWebsocket;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.protocol.ZeppelinHubOp;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.protocol.ZeppelinhubMessage;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.scheduler.SchedulerService;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.scheduler.ZeppelinHubHeartbeat;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.session.ZeppelinhubSession;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.utils.ZeppelinhubUtils;
import org.apache.zeppelin.ticket.TicketContainer;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinhubClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinhubClient.class);
    private final WebSocketClient client;
    private final URI zeppelinhubWebsocketUrl;
    private final String zeppelinhubToken;
    private static final String TOKEN_HEADER = "X-Zeppelin-Token";
    private static final long CONNECTION_IDLE_TIME = TimeUnit.SECONDS.toMillis(30L);
    private static ZeppelinhubClient instance = null;
    private static final Gson gson = new Gson();
    private SchedulerService schedulerService;
    private Map<String, ZeppelinhubSession> sessionMap = new ConcurrentHashMap<String, ZeppelinhubSession>();

    public static ZeppelinhubClient initialize(String zeppelinhubUrl, String token) {
        if (instance == null) {
            instance = new ZeppelinhubClient(zeppelinhubUrl, token);
        }
        return instance;
    }

    public static ZeppelinhubClient getInstance() {
        return instance;
    }

    private ZeppelinhubClient(String url, String token) {
        this.zeppelinhubWebsocketUrl = URI.create(url);
        this.client = this.createNewWebsocketClient();
        this.zeppelinhubToken = token;
        this.schedulerService = SchedulerService.create(10);
        LOGGER.info("Initialized ZeppelinHub websocket client on {}", (Object)this.zeppelinhubWebsocketUrl);
    }

    public void start() {
        try {
            this.client.start();
            this.addRoutines();
        }
        catch (Exception e) {
            LOGGER.error("Cannot connect to zeppelinhub via websocket", (Throwable)e);
        }
    }

    public void initUser(String token) {
    }

    public void stop() {
        LOGGER.info("Stopping Zeppelinhub websocket client");
        try {
            this.schedulerService.close();
            this.client.stop();
        }
        catch (Exception e) {
            LOGGER.error("Cannot stop zeppelinhub websocket client", (Throwable)e);
        }
    }

    public void stopUser(String token) {
        this.removeSession(token);
    }

    public String getToken() {
        return this.zeppelinhubToken;
    }

    public void send(String msg, String token) {
        ZeppelinhubSession zeppelinhubSession = this.getSession(token);
        if (!this.isConnectedToZeppelinhub(zeppelinhubSession)) {
            LOGGER.info("Zeppelinhub connection is not open, opening it");
            zeppelinhubSession = this.connect(token);
            if (zeppelinhubSession == ZeppelinhubSession.EMPTY) {
                LOGGER.warn("While connecting to ZeppelinHub received empty session, cannot send the message");
                return;
            }
        }
        zeppelinhubSession.sendByFuture(msg);
    }

    private boolean isConnectedToZeppelinhub(ZeppelinhubSession zeppelinhubSession) {
        return zeppelinhubSession != null && zeppelinhubSession.isSessionOpen();
    }

    private ZeppelinhubSession connect(String token) {
        ZeppelinhubSession zeppelinhubSession;
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.debug("Can't connect with empty token");
            return ZeppelinhubSession.EMPTY;
        }
        try {
            ZeppelinhubWebsocket ws = ZeppelinhubWebsocket.newInstance(token);
            ClientUpgradeRequest request = this.getConnectionRequest(token);
            Future future = this.client.connect((Object)ws, this.zeppelinhubWebsocketUrl, request);
            Session session = (Session)future.get();
            zeppelinhubSession = ZeppelinhubSession.createInstance(session, token);
            this.setSession(token, zeppelinhubSession);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOGGER.info("Couldnt connect to zeppelinhub", (Throwable)e);
            zeppelinhubSession = ZeppelinhubSession.EMPTY;
        }
        return zeppelinhubSession;
    }

    private void setSession(String token, ZeppelinhubSession session) {
        this.sessionMap.put(token, session);
    }

    private ZeppelinhubSession getSession(String token) {
        return this.sessionMap.get(token);
    }

    public void removeSession(String token) {
        ZeppelinhubSession zeppelinhubSession = this.getSession(token);
        if (zeppelinhubSession == null) {
            return;
        }
        zeppelinhubSession.close();
        this.sessionMap.remove(token);
    }

    private ClientUpgradeRequest getConnectionRequest(String token) {
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setCookies((List)Lists.newArrayList((Object[])new HttpCookie[]{new HttpCookie(TOKEN_HEADER, token)}));
        return request;
    }

    private WebSocketClient createNewWebsocketClient() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        WebSocketClient client = new WebSocketClient(sslContextFactory);
        client.setMaxTextMessageBufferSize(Client.getMaxNoteSize());
        client.getPolicy().setMaxTextMessageSize(Client.getMaxNoteSize());
        client.setMaxIdleTimeout(CONNECTION_IDLE_TIME);
        return client;
    }

    private void addRoutines() {
        this.schedulerService.add(ZeppelinHubHeartbeat.newInstance(this), 10, 23);
    }

    public void handleMsgFromZeppelinHub(String message) {
        ZeppelinhubMessage hubMsg = ZeppelinhubMessage.fromJson(message);
        if (hubMsg.equals(ZeppelinhubMessage.EMPTY)) {
            LOGGER.error("Cannot handle ZeppelinHub message is empty");
            return;
        }
        String op = "";
        if (!(hubMsg.op instanceof String)) {
            LOGGER.error("Message OP from ZeppelinHub isn't string {}", hubMsg.op);
            return;
        }
        op = (String)hubMsg.op;
        if (ZeppelinhubUtils.isZeppelinHubOp(op)) {
            this.handleZeppelinHubOpMsg(ZeppelinhubUtils.toZeppelinHubOp(op), hubMsg, message);
        } else if (ZeppelinhubUtils.isZeppelinOp(op)) {
            this.forwardToZeppelin(ZeppelinhubUtils.toZeppelinOp(op), hubMsg);
        }
    }

    private void handleZeppelinHubOpMsg(ZeppelinHubOp op, ZeppelinhubMessage hubMsg, String msg) {
        if (op == null || msg.equals(ZeppelinhubMessage.EMPTY)) {
            LOGGER.error("Cannot handle empty op or msg");
            return;
        }
        switch (op) {
            case RUN_NOTEBOOK: {
                this.runAllParagraph(hubMsg.meta.get("noteId"), msg);
                break;
            }
            default: {
                LOGGER.debug("Received {} from ZeppelinHub, not handled", (Object)op);
            }
        }
    }

    private void forwardToZeppelin(Message.OP op, ZeppelinhubMessage hubMsg) {
        Message zeppelinMsg = new Message(op);
        if (!(hubMsg.data instanceof Map)) {
            LOGGER.error("Data field of message from ZeppelinHub isn't in correct Map format");
            return;
        }
        zeppelinMsg.data = (Map)hubMsg.data;
        zeppelinMsg.principal = hubMsg.meta.get("owner");
        zeppelinMsg.ticket = TicketContainer.instance.getTicketEntry(zeppelinMsg.principal, null).getTicket();
        Client client = Client.getInstance();
        if (client == null) {
            LOGGER.warn("Base client isn't initialized, returning");
            return;
        }
        client.relayToZeppelin(zeppelinMsg, hubMsg.meta.get("noteId"));
    }

    boolean runAllParagraph(String noteId, String hubMsg) {
        LOGGER.info("Running paragraph with noteId {}", (Object)noteId);
        try {
            JSONObject data = new JSONObject(hubMsg);
            if (data.equals(JSONObject.NULL) || !(data.get("data") instanceof JSONArray)) {
                LOGGER.error("Wrong \"data\" format for RUN_NOTEBOOK");
                return false;
            }
            Client client = Client.getInstance();
            if (client == null) {
                LOGGER.warn("Base client isn't initialized, returning");
                return false;
            }
            Message zeppelinMsg = new Message(Message.OP.RUN_PARAGRAPH);
            JSONArray paragraphs = data.getJSONArray("data");
            String principal = data.getJSONObject("meta").getString("owner");
            for (int i = 0; i < paragraphs.length(); ++i) {
                if (!(paragraphs.get(i) instanceof JSONObject)) {
                    LOGGER.warn("Wrong \"paragraph\" format for RUN_NOTEBOOK");
                    continue;
                }
                zeppelinMsg.data = (Map)gson.fromJson(paragraphs.getString(i), new TypeToken<Map<String, Object>>(){}.getType());
                zeppelinMsg.principal = principal;
                zeppelinMsg.ticket = TicketContainer.instance.getTicketEntry(principal, null).getTicket();
                client.relayToZeppelin(zeppelinMsg, noteId);
                LOGGER.info("\nSending RUN_PARAGRAPH message to Zeppelin ");
            }
        }
        catch (JSONException e) {
            LOGGER.error("Failed to parse RUN_NOTEBOOK message from ZeppelinHub ", (Throwable)e);
            return false;
        }
        return true;
    }
}

