/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.StandardInterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkInterpreterLauncher
extends StandardInterpreterLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkInterpreterLauncher.class);
    public static final String SPARK_MASTER_KEY = "spark.master";
    private static final String DEFAULT_MASTER = "local[*]";
    Optional<String> sparkMaster = Optional.empty();

    public SparkInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    @Override
    public Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) throws IOException {
        Map<String, String> env = super.buildEnvFromProperties(context);
        Properties sparkProperties = new Properties();
        String spMaster = this.getSparkMaster();
        if (spMaster != null) {
            sparkProperties.put(SPARK_MASTER_KEY, spMaster);
        }
        for (String key : this.properties.stringPropertyNames()) {
            String propValue = this.properties.getProperty(key);
            if (RemoteInterpreterUtils.isEnvString((String)key) && !StringUtils.isBlank((CharSequence)propValue)) {
                env.put(key, propValue);
            }
            if (!this.isSparkConf(key, propValue)) continue;
            sparkProperties.setProperty(key, propValue);
        }
        if (!sparkProperties.containsKey("spark.app.name") || StringUtils.isBlank((CharSequence)sparkProperties.getProperty("spark.app.name"))) {
            sparkProperties.setProperty("spark.app.name", context.getInterpreterGroupId());
        }
        this.setupPropertiesForPySpark(sparkProperties);
        this.setupPropertiesForSparkR(sparkProperties);
        String condaEnvName = context.getProperties().getProperty("zeppelin.interpreter.conda.env.name");
        if (StringUtils.isNotBlank((CharSequence)condaEnvName)) {
            if (!this.isYarnCluster()) {
                throw new IOException("zeppelin.interpreter.conda.env.name only works for yarn-cluster mode");
            }
            sparkProperties.setProperty("spark.pyspark.python", condaEnvName + "/bin/python");
        }
        if (this.isYarnMode() && this.getDeployMode().equals("cluster")) {
            env.put("ZEPPELIN_SPARK_YARN_CLUSTER", "true");
            sparkProperties.setProperty("spark.yarn.submit.waitAppCompletion", "false");
        } else if (this.zConf.isOnlyYarnCluster()) {
            throw new IOException("Only yarn-cluster mode is allowed, please set " + ZeppelinConfiguration.ConfVars.ZEPPELIN_SPARK_ONLY_YARN_CLUSTER.getVarName() + " to false if you want to use other modes.");
        }
        if (this.isYarnMode() && this.getDeployMode().equals("cluster")) {
            if (sparkProperties.containsKey("spark.files")) {
                sparkProperties.put("spark.files", sparkProperties.getProperty("spark.files") + "," + this.zConf.getConfDir() + "/log4j_yarn_cluster.properties");
            } else {
                sparkProperties.put("spark.files", this.zConf.getConfDir() + "/log4j_yarn_cluster.properties");
            }
            sparkProperties.put("spark.yarn.maxAppAttempts", "1");
        }
        if (this.isYarnMode() && this.getDeployMode().equals("cluster")) {
            try {
                Object scalaJars;
                ArrayList additionalJars = new ArrayList();
                String[] localRepoPath = Paths.get(this.zConf.getInterpreterLocalRepoPath(), context.getInterpreterSettingId());
                if (Files.exists((Path)localRepoPath, new LinkOption[0]) && Files.isDirectory((Path)localRepoPath, new LinkOption[0])) {
                    try (DirectoryStream<Path> localRepoStream = Files.newDirectoryStream((Path)localRepoPath, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                        List localRepoJars = StreamSupport.stream(localRepoStream.spliterator(), false).map(jar -> jar.toAbsolutePath().toString()).collect(Collectors.toList());
                        additionalJars.addAll(localRepoJars);
                    }
                }
                String scalaVersion = this.detectSparkScalaVersion(this.getEnv("SPARK_HOME"), env);
                Path scalaFolder = Paths.get(this.zConf.getZeppelinHome(), "/interpreter/spark/scala-" + scalaVersion);
                if (!scalaFolder.toFile().exists()) {
                    throw new IOException("spark scala folder " + scalaFolder.toFile() + " doesn't exist");
                }
                try (DirectoryStream<Path> scalaStream = Files.newDirectoryStream(scalaFolder, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                    scalaJars = StreamSupport.stream(scalaStream.spliterator(), false).map(jar -> jar.toAbsolutePath().toString()).collect(Collectors.toList());
                    additionalJars.addAll(scalaJars);
                }
                Path interpreterFolder = Paths.get(this.zConf.getZeppelinHome(), "/interpreter");
                DirectoryStream<Path> interpreterStream = Files.newDirectoryStream(interpreterFolder, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                scalaJars = null;
                try {
                    List interpreterJars = StreamSupport.stream(interpreterStream.spliterator(), false).filter(jar -> jar.toFile().getName().startsWith("zeppelin-interpreter-shaded") && jar.toFile().getName().endsWith(".jar")).map(jar -> jar.toAbsolutePath().toString()).collect(Collectors.toList());
                    if (interpreterJars.isEmpty()) {
                        throw new IOException("zeppelin-interpreter-shaded jar is not found");
                    }
                    if (interpreterJars.size() > 1) {
                        throw new IOException("more than 1 zeppelin-interpreter-shaded jars are found: " + StringUtils.join(interpreterJars, (String)","));
                    }
                    additionalJars.addAll(interpreterJars);
                }
                catch (Throwable interpreterJars) {
                    scalaJars = interpreterJars;
                    throw interpreterJars;
                }
                finally {
                    if (interpreterStream != null) {
                        if (scalaJars != null) {
                            try {
                                interpreterStream.close();
                            }
                            catch (Throwable interpreterJars) {
                                ((Throwable)scalaJars).addSuppressed(interpreterJars);
                            }
                        } else {
                            interpreterStream.close();
                        }
                    }
                }
                if (sparkProperties.containsKey("spark.jars")) {
                    sparkProperties.put("spark.jars", sparkProperties.getProperty("spark.jars") + "," + StringUtils.join(additionalJars, (String)","));
                } else {
                    sparkProperties.put("spark.jars", StringUtils.join(additionalJars, (String)","));
                }
            }
            catch (Exception e) {
                throw new IOException("Fail to set additional jars for spark interpreter", e);
            }
        }
        StringJoiner sparkConfSJ = new StringJoiner("|");
        if (context.getOption().isUserImpersonate() && this.zConf.getZeppelinImpersonateSparkProxyUser()) {
            sparkConfSJ.add("--proxy-user");
            sparkConfSJ.add(context.getUserName());
            sparkProperties.remove("spark.yarn.keytab");
            sparkProperties.remove("spark.yarn.principal");
        }
        for (String name : sparkProperties.stringPropertyNames()) {
            sparkConfSJ.add("--conf");
            sparkConfSJ.add(name + "=" + sparkProperties.getProperty(name) + "");
        }
        env.put("ZEPPELIN_SPARK_CONF", sparkConfSJ.toString());
        for (String envName : new String[]{"SPARK_HOME", "SPARK_CONF_DIR", "HADOOP_CONF_DIR"}) {
            String envValue = this.getEnv(envName);
            if (StringUtils.isBlank((CharSequence)envValue)) continue;
            env.put(envName, envValue);
        }
        String keytab = this.properties.getProperty("spark.yarn.keytab", this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_KEYTAB));
        String principal = this.properties.getProperty("spark.yarn.principal", this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_PRINCIPAL));
        if (!StringUtils.isBlank((CharSequence)keytab) && !StringUtils.isBlank((CharSequence)principal)) {
            env.put("ZEPPELIN_SERVER_KERBEROS_KEYTAB", keytab);
            env.put("ZEPPELIN_SERVER_KERBEROS_PRINCIPAL", principal);
            LOGGER.info("Run Spark under secure mode with keytab: {}, principal: {}", (Object)keytab, (Object)principal);
        } else {
            LOGGER.info("Run Spark under non-secure mode as no keytab and principal is specified");
        }
        env.put("PYSPARK_PIN_THREAD", "true");
        String sparkConfDir = this.getEnv("SPARK_CONF_DIR");
        if (StringUtils.isBlank((CharSequence)sparkConfDir)) {
            String sparkHome = this.getEnv("SPARK_HOME");
            sparkConfDir = sparkHome + "/conf";
        }
        Properties sparkDefaultProperties = new Properties();
        File sparkDefaultFile = new File(sparkConfDir, "spark-defaults.conf");
        if (sparkDefaultFile.exists()) {
            sparkDefaultProperties.load(new FileInputStream(sparkDefaultFile));
            String driverExtraClassPath = sparkDefaultProperties.getProperty("spark.driver.extraClassPath");
            if (!StringUtils.isBlank((CharSequence)driverExtraClassPath)) {
                env.put("ZEPPELIN_INTP_CLASSPATH", driverExtraClassPath);
            }
        } else {
            LOGGER.warn("spark-defaults.conf doesn't exist: {}", (Object)sparkDefaultFile.getAbsolutePath());
        }
        if (this.isYarnMode()) {
            boolean runAsLoginUser = Boolean.parseBoolean(context.getProperties().getProperty("zeppelin.spark.run.asLoginUser", "true"));
            String userName = context.getUserName();
            if (runAsLoginUser && !"anonymous".equals(userName)) {
                env.put("HADOOP_USER_NAME", userName);
            }
        }
        LOGGER.info("buildEnvFromProperties: {}", env);
        return env;
    }

    private String detectSparkScalaVersion(String sparkHome, Map<String, String> env) throws Exception {
        LOGGER.info("Detect scala version from SPARK_HOME: {}", (Object)sparkHome);
        ProcessBuilder builder = new ProcessBuilder(sparkHome + "/bin/spark-submit", "--version");
        builder.environment().putAll(env);
        File processOutputFile = File.createTempFile("zeppelin-spark", ".out");
        builder.redirectError(processOutputFile);
        Process process = builder.start();
        process.waitFor();
        String processOutput = IOUtils.toString((InputStream)new FileInputStream(processOutputFile), (Charset)StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile(".*Using Scala version (.*),.*");
        Matcher matcher = pattern.matcher(processOutput);
        if (matcher.find()) {
            String scalaVersion = matcher.group(1);
            if (scalaVersion.startsWith("2.10")) {
                return "2.10";
            }
            if (scalaVersion.startsWith("2.11")) {
                return "2.11";
            }
            if (scalaVersion.startsWith("2.12")) {
                return "2.12";
            }
            throw new Exception("Unsupported scala version: " + scalaVersion);
        }
        return this.detectSparkScalaVersionByReplClass(sparkHome);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String detectSparkScalaVersionByReplClass(String sparkHome) throws Exception {
        File sparkLibFolder = new File(sparkHome + "/lib");
        if (!sparkLibFolder.exists()) {
            File sparkJarsFolder = new File(sparkHome + "/jars");
            boolean sparkRepl211Exists = Stream.of(sparkJarsFolder.listFiles()).anyMatch(file -> file.getName().contains("spark-repl_2.11"));
            if (!sparkRepl211Exists) return "2.10";
            return "2.11";
        }
        File[] sparkAssemblyJars = new File(sparkHome + "/lib").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("spark-assembly");
            }
        });
        if (sparkAssemblyJars.length == 0) {
            throw new Exception("No spark assembly file found in SPARK_HOME: " + sparkHome);
        }
        if (sparkAssemblyJars.length > 1) {
            throw new Exception("Multiple spark assembly file found in SPARK_HOME: " + sparkHome);
        }
        try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{sparkAssemblyJars[0].toURI().toURL()});){
            urlClassLoader.loadClass("org.apache.spark.repl.SparkCommandLine");
            String string = "2.10";
            return string;
        }
        catch (ClassNotFoundException e) {
            return "2.11";
        }
    }

    private String getEnv(String envName) {
        String env = this.properties.getProperty(envName);
        if (env == null) {
            env = System.getenv(envName);
        }
        return env;
    }

    private boolean isSparkConf(String key, String value) {
        return !StringUtils.isEmpty((CharSequence)key) && key.startsWith("spark.") && !StringUtils.isEmpty((CharSequence)value);
    }

    private void setupPropertiesForPySpark(Properties sparkProperties) {
        if (this.isYarnMode()) {
            sparkProperties.setProperty("spark.yarn.isPython", "true");
        }
    }

    private void mergeSparkProperty(Properties sparkProperties, String propertyName, String propertyValue) {
        if (sparkProperties.containsKey(propertyName)) {
            String oldPropertyValue = sparkProperties.getProperty(propertyName);
            sparkProperties.setProperty(propertyName, oldPropertyValue + "," + propertyValue);
        } else {
            sparkProperties.setProperty(propertyName, propertyValue);
        }
    }

    private void setupPropertiesForSparkR(Properties sparkProperties) {
        if (this.isYarnMode()) {
            String sparkHome = this.getEnv("SPARK_HOME");
            File sparkRBasePath = null;
            if (sparkHome == null) {
                if (!this.getSparkMaster().startsWith("local")) {
                    throw new RuntimeException("SPARK_HOME is not specified in interpreter-setting for non-local mode, if you specify it in zeppelin-env.sh, please move that into  interpreter setting");
                }
                String zeppelinHome = this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME);
                sparkRBasePath = new File(zeppelinHome, "interpreter" + File.separator + "spark" + File.separator + "R");
            } else {
                sparkRBasePath = new File(sparkHome, "R" + File.separator + "lib");
            }
            File sparkRPath = new File(sparkRBasePath, "sparkr.zip");
            if (sparkRPath.exists() && sparkRPath.isFile()) {
                this.mergeSparkProperty(sparkProperties, "spark.yarn.dist.archives", sparkRPath.getAbsolutePath() + "#sparkr");
            } else {
                LOGGER.warn("sparkr.zip is not found, SparkR may not work.");
            }
        }
    }

    private String getSparkMaster() {
        if (!this.sparkMaster.isPresent()) {
            String master = this.properties.getProperty(SPARK_MASTER_KEY);
            if (master == null) {
                master = this.properties.getProperty("master");
                if (master == null) {
                    String masterEnv = System.getenv("SPARK_MASTER");
                    master = masterEnv == null ? DEFAULT_MASTER : masterEnv;
                }
                this.properties.put(SPARK_MASTER_KEY, master);
            }
            this.sparkMaster = Optional.of(master);
        }
        return this.sparkMaster.get();
    }

    private String getDeployMode() {
        if (this.getSparkMaster().equals("yarn-client")) {
            return "client";
        }
        if (this.getSparkMaster().equals("yarn-cluster")) {
            return "cluster";
        }
        if (this.getSparkMaster().startsWith("local")) {
            return "client";
        }
        String deployMode = this.properties.getProperty("spark.submit.deployMode");
        if (deployMode == null) {
            throw new RuntimeException("master is set as yarn, but spark.submit.deployMode is not specified");
        }
        if (!deployMode.equals("client") && !deployMode.equals("cluster")) {
            throw new RuntimeException("Invalid value for spark.submit.deployMode: " + deployMode);
        }
        return deployMode;
    }

    private boolean isYarnMode() {
        return this.getSparkMaster().startsWith("yarn");
    }

    private boolean isYarnCluster() {
        return this.isYarnMode() && "cluster".equalsIgnoreCase(this.getDeployMode());
    }

    private boolean isYarnClient() {
        return this.isYarnMode() && "client".equalsIgnoreCase(this.getDeployMode());
    }
}

