/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumRegistry;
import org.apache.zeppelin.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliumOnlineRegistry
extends HeliumRegistry {
    private Logger logger = LoggerFactory.getLogger(HeliumOnlineRegistry.class);
    private final Gson gson;
    private final File registryCacheFile;

    public HeliumOnlineRegistry(String name, String uri, File registryCacheDir) {
        super(name, uri);
        registryCacheDir.mkdirs();
        UUID registryCacheFileUuid = UUID.nameUUIDFromBytes(uri.getBytes());
        this.registryCacheFile = new File(registryCacheDir, registryCacheFileUuid.toString());
        this.gson = new Gson();
    }

    @Override
    public synchronized List<HeliumPackage> getAll() throws IOException {
        HttpResponse response;
        CloseableHttpClient client = HttpClientBuilder.create().setUserAgent("ApacheZeppelin/" + Util.getVersion()).setProxy(this.getProxy(this.uri())).build();
        HttpGet get = new HttpGet(this.uri());
        try {
            ZeppelinConfiguration cfg = ZeppelinConfiguration.create();
            if (get.getURI().getHost().equals(cfg.getS3Endpoint()) && cfg.getS3Timeout() != null) {
                int timeout = Integer.valueOf(cfg.getS3Timeout());
                RequestConfig requestCfg = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
                get.setConfig(requestCfg);
            }
            response = client.execute((HttpUriRequest)get);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return this.readFromCache();
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            this.logger.error(this.uri() + " returned " + response.getStatusLine().toString());
            return this.readFromCache();
        }
        LinkedList<HeliumPackage> packageList = new LinkedList<HeliumPackage>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        List packages = (List)this.gson.fromJson((Reader)reader, new TypeToken<List<Map<String, Map<String, HeliumPackage>>>>(){}.getType());
        reader.close();
        for (Map pkg : packages) {
            for (Map versions : pkg.values()) {
                packageList.addAll(versions.values());
            }
        }
        this.writeToCache(packageList);
        return packageList;
    }

    private HttpHost getProxy(String uri) {
        String httpProxy = StringUtils.isBlank((CharSequence)System.getenv("http_proxy")) ? System.getenv("HTTP_PROXY") : System.getenv("http_proxy");
        String httpsProxy = StringUtils.isBlank((CharSequence)System.getenv("https_proxy")) ? System.getenv("HTTPS_PROXY") : System.getenv("https_proxy");
        try {
            String scheme = new URI(uri).getScheme();
            if (scheme.toLowerCase().startsWith("https") && StringUtils.isNotBlank((CharSequence)httpsProxy)) {
                URI httpsProxyUri = new URI(httpsProxy);
                return new HttpHost(httpsProxyUri.getHost(), httpsProxyUri.getPort(), httpsProxyUri.getScheme());
            }
            if (scheme.toLowerCase().startsWith("http") && StringUtils.isNotBlank((CharSequence)httpProxy)) {
                URI httpProxyUri = new URI(httpProxy);
                return new HttpHost(httpProxyUri.getHost(), httpProxyUri.getPort(), httpProxyUri.getScheme());
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HeliumPackage> readFromCache() {
        File file = this.registryCacheFile;
        synchronized (file) {
            if (this.registryCacheFile.isFile()) {
                try {
                    return (List)this.gson.fromJson((Reader)new FileReader(this.registryCacheFile), new TypeToken<List<HeliumPackage>>(){}.getType());
                }
                catch (FileNotFoundException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    return new LinkedList<HeliumPackage>();
                }
            }
            return new LinkedList<HeliumPackage>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCache(List<HeliumPackage> pkg) throws IOException {
        File file = this.registryCacheFile;
        synchronized (file) {
            if (this.registryCacheFile.exists()) {
                this.registryCacheFile.delete();
            }
            String jsonToCache = this.gson.toJson(pkg);
            FileUtils.writeStringToFile((File)this.registryCacheFile, (String)jsonToCache);
        }
    }
}

