/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import scala.tools.asm.AnnotationVisitor;
import scala.tools.asm.Attribute;
import scala.tools.asm.ClassReader;
import scala.tools.asm.ClassVisitor;
import scala.tools.asm.FieldVisitor;
import scala.tools.asm.Label;
import scala.tools.asm.MethodVisitor;
import scala.tools.asm.Type;
import scala.tools.asm.tree.ClassNode;
import scala.tools.asm.tree.MethodNode;
import scala.tools.asm.tree.analysis.Analyzer;
import scala.tools.asm.tree.analysis.BasicValue;
import scala.tools.asm.tree.analysis.Frame;
import scala.tools.asm.tree.analysis.SimpleVerifier;
import scala.tools.asm.util.CheckAnnotationAdapter;
import scala.tools.asm.util.CheckFieldAdapter;
import scala.tools.asm.util.CheckMethodAdapter;
import scala.tools.asm.util.Textifier;
import scala.tools.asm.util.TraceMethodVisitor;

public class CheckClassAdapter
extends ClassVisitor {
    private int version;
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;
    private Map<Label, Integer> labels = new HashMap<Label, Integer>();
    private boolean checkDataFlow;

    public static void main(String[] args2) throws Exception {
        if (args2.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader cr = args2[0].endsWith(".class") ? new ClassReader(new FileInputStream(args2[0])) : new ClassReader(args2[0]);
        CheckClassAdapter.verify(cr, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader cr, ClassLoader loader, boolean dump, PrintWriter pw) {
        ClassNode cn = new ClassNode();
        cr.accept(new CheckClassAdapter(cn, false), 2);
        Type syperType = cn.superName == null ? null : Type.getObjectType(cn.superName);
        List<MethodNode> methods2 = cn.methods;
        ArrayList<Type> interfaces2 = new ArrayList<Type>();
        Iterator<String> i = cn.interfaces.iterator();
        while (i.hasNext()) {
            interfaces2.add(Type.getObjectType(i.next().toString()));
        }
        for (int i2 = 0; i2 < methods2.size(); ++i2) {
            MethodNode method = methods2.get(i2);
            SimpleVerifier verifier = new SimpleVerifier(Type.getObjectType(cn.name), syperType, interfaces2, (cn.access & 0x200) != 0);
            Analyzer<BasicValue> a = new Analyzer<BasicValue>(verifier);
            if (loader != null) {
                verifier.setClassLoader(loader);
            }
            try {
                a.analyze(cn.name, method);
                if (!dump) {
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace(pw);
            }
            CheckClassAdapter.printAnalyzerResult(method, a, pw);
        }
        pw.flush();
    }

    public static void verify(ClassReader cr, boolean dump, PrintWriter pw) {
        CheckClassAdapter.verify(cr, null, dump, pw);
    }

    static void printAnalyzerResult(MethodNode method, Analyzer<BasicValue> a, PrintWriter pw) {
        int j;
        Frame<BasicValue>[] frames = a.getFrames();
        Textifier t = new Textifier();
        TraceMethodVisitor mv = new TraceMethodVisitor(t);
        pw.println(method.name + method.desc);
        for (j = 0; j < method.instructions.size(); ++j) {
            method.instructions.get(j).accept(mv);
            StringBuffer s2 = new StringBuffer();
            Frame<BasicValue> f2 = frames[j];
            if (f2 == null) {
                s2.append('?');
            } else {
                int k;
                for (k = 0; k < f2.getLocals(); ++k) {
                    s2.append(CheckClassAdapter.getShortName(f2.getLocal(k).toString())).append(' ');
                }
                s2.append(" : ");
                for (k = 0; k < f2.getStackSize(); ++k) {
                    s2.append(CheckClassAdapter.getShortName(f2.getStack(k).toString())).append(' ');
                }
            }
            while (s2.length() < method.maxStack + method.maxLocals + 1) {
                s2.append(' ');
            }
            pw.print(Integer.toString(j + 100000).substring(1));
            pw.print(" " + s2 + " : " + t.text.get(t.text.size() - 1));
        }
        for (j = 0; j < method.tryCatchBlocks.size(); ++j) {
            method.tryCatchBlocks.get(j).accept(mv);
            pw.print(" " + t.text.get(t.text.size() - 1));
        }
        pw.println();
    }

    private static String getShortName(String name2) {
        int n = name2.lastIndexOf(47);
        int k = name2.length();
        if (name2.charAt(k - 1) == ';') {
            --k;
        }
        return n == -1 ? name2 : name2.substring(n + 1, k);
    }

    public CheckClassAdapter(ClassVisitor cv) {
        this(cv, true);
    }

    public CheckClassAdapter(ClassVisitor cv, boolean checkDataFlow) {
        this(262144, cv, checkDataFlow);
    }

    protected CheckClassAdapter(int api, ClassVisitor cv, boolean checkDataFlow) {
        super(api, cv);
        this.checkDataFlow = checkDataFlow;
    }

    @Override
    public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaces2) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 423473);
        if (name2 == null || !name2.endsWith("package-info")) {
            CheckMethodAdapter.checkInternalName(name2, "class name");
        }
        if ("java/lang/Object".equals(name2)) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(superName, "super class name");
        }
        if (signature2 != null) {
            CheckMethodAdapter.checkClassSignature(signature2);
        }
        if ((access & 0x200) != 0 && !"java/lang/Object".equals(superName)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces2 != null) {
            for (int i = 0; i < interfaces2.length; ++i) {
                CheckMethodAdapter.checkInternalName(interfaces2[i], "interface name at index " + i);
            }
        }
        this.version = version;
        super.visit(version, access, name2, signature2, superName, interfaces2);
    }

    @Override
    public void visitSource(String file, String debug) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        super.visitSource(file, debug);
    }

    @Override
    public void visitOuterClass(String owner, String name2, String desc) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.outer = true;
        if (owner == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (desc != null) {
            CheckMethodAdapter.checkMethodDesc(desc);
        }
        super.visitOuterClass(owner, name2, desc);
    }

    @Override
    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(name2, "class name");
        if (outerName != null) {
            CheckMethodAdapter.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            CheckMethodAdapter.checkIdentifier(innerName, "inner class name");
        }
        CheckClassAdapter.checkAccess(access, 30239);
        super.visitInnerClass(name2, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String desc, String signature2, Object value2) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 413919);
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "field name");
        CheckMethodAdapter.checkDesc(desc, false);
        if (signature2 != null) {
            CheckMethodAdapter.checkFieldSignature(signature2);
        }
        if (value2 != null) {
            CheckMethodAdapter.checkConstant(value2);
        }
        FieldVisitor av = super.visitField(access, name2, desc, signature2, value2);
        return new CheckFieldAdapter(av);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String desc, String signature2, String[] exceptions) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 400895);
        CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "method name");
        CheckMethodAdapter.checkMethodDesc(desc);
        if (signature2 != null) {
            CheckMethodAdapter.checkMethodSignature(signature2);
        }
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                CheckMethodAdapter.checkInternalName(exceptions[i], "exception name at index " + i);
            }
        }
        CheckMethodAdapter cma = this.checkDataFlow ? new CheckMethodAdapter(access, name2, desc, super.visitMethod(access, name2, desc, signature2, exceptions), this.labels) : new CheckMethodAdapter(super.visitMethod(access, name2, desc, signature2, exceptions), this.labels);
        cma.version = this.version;
        return cma;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkState();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(desc, visible));
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.checkState();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attr);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.end = true;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        int abs;
        int pro;
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int pub = (access & 1) == 0 ? 0 : 1;
        int pri = (access & 2) == 0 ? 0 : 1;
        int n = pro = (access & 4) == 0 ? 0 : 1;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access);
        }
        int fin = (access & 0x10) == 0 ? 0 : 1;
        int n2 = abs = (access & 0x400) == 0 ? 0 : 1;
        if (fin + abs > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }
}

