/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;

public class OSInfo {
    private static HashMap<String, String> archMapping = new HashMap();
    public static final String X86 = "x86";
    public static final String X86_64 = "x86_64";
    public static final String IA64_32 = "ia64_32";
    public static final String IA64 = "ia64";
    public static final String PPC = "ppc";
    public static final String PPC64 = "ppc64";
    public static final String IBMZ = "s390";
    public static final String IBMZ_64 = "s390x";
    public static final String AARCH_64 = "aarch64";

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            if ("--os".equals(stringArray[0])) {
                System.out.print(OSInfo.getOSName());
                return;
            }
            if ("--arch".equals(stringArray[0])) {
                System.out.print(OSInfo.getArchName());
                return;
            }
        }
        System.out.print(OSInfo.getNativeLibFolderPathForCurrentOS());
    }

    public static String getNativeLibFolderPathForCurrentOS() {
        return OSInfo.getOSName() + "/" + OSInfo.getArchName();
    }

    public static String getOSName() {
        return OSInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    public static boolean isAndroid() {
        return System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getHardwareName() {
        String string2;
        block7: {
            Process process2 = Runtime.getRuntime().exec("uname -m");
            process2.waitFor();
            InputStream inputStream = process2.getInputStream();
            try {
                int n = 0;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[32];
                while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                string2 = byteArrayOutputStream.toString();
                if (inputStream == null) break block7;
            }
            catch (Throwable throwable2) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    System.err.println("Error while running uname -m: " + throwable3.getMessage());
                    return "unknown";
                }
            }
            inputStream.close();
        }
        return string2;
    }

    static String resolveArmArchType() {
        if (System.getProperty("os.name").contains("Linux")) {
            String string2 = OSInfo.getHardwareName();
            if (string2.startsWith("armv6")) {
                return "armv6";
            }
            if (string2.startsWith("armv7")) {
                return "armv7";
            }
            String string3 = System.getProperty("sun.arch.abi");
            if (string3 != null && string3.startsWith("gnueabihf")) {
                return "armv7";
            }
            try {
                int n = Runtime.getRuntime().exec("which readelf").waitFor();
                if (n == 0) {
                    String string4 = System.getProperty("java.home");
                    String[] stringArray = new String[]{"/bin/sh", "-c", "find '" + string4 + "' -name 'libjvm.so' | head -1 | xargs readelf -A | grep 'Tag_ABI_VFP_args: VFP registers'"};
                    n = Runtime.getRuntime().exec(stringArray).waitFor();
                    if (n == 0) {
                        return "armv7";
                    }
                } else {
                    System.err.println("WARNING! readelf not found. Cannot check if running on an armhf system, armel architecture will be presumed.");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "arm";
    }

    public static String getArchName() {
        String string2 = System.getProperty("os.arch");
        if (OSInfo.isAndroid()) {
            return "android-arm";
        }
        if (string2.startsWith("arm")) {
            string2 = OSInfo.resolveArmArchType();
        } else {
            String string3 = string2.toLowerCase(Locale.US);
            if (archMapping.containsKey(string3)) {
                return archMapping.get(string3);
            }
        }
        return OSInfo.translateArchNameToFolderName(string2);
    }

    static String translateOSNameToFolderName(String string2) {
        if (string2.contains("Windows")) {
            return "Windows";
        }
        if (string2.contains("Mac")) {
            return "Mac";
        }
        if (string2.contains("Linux")) {
            return "Linux";
        }
        if (string2.contains("AIX")) {
            return "AIX";
        }
        return string2.replaceAll("\\W", "");
    }

    static String translateArchNameToFolderName(String string2) {
        return string2.replaceAll("\\W", "");
    }

    static {
        archMapping.put(X86, X86);
        archMapping.put("i386", X86);
        archMapping.put("i486", X86);
        archMapping.put("i586", X86);
        archMapping.put("i686", X86);
        archMapping.put("pentium", X86);
        archMapping.put(X86_64, X86_64);
        archMapping.put("amd64", X86_64);
        archMapping.put("em64t", X86_64);
        archMapping.put("universal", X86_64);
        archMapping.put(IA64, IA64);
        archMapping.put("ia64w", IA64);
        archMapping.put(IA64_32, IA64_32);
        archMapping.put("ia64n", IA64_32);
        archMapping.put(PPC, PPC);
        archMapping.put("power", PPC);
        archMapping.put("powerpc", PPC);
        archMapping.put("power_pc", PPC);
        archMapping.put("power_rs", PPC);
        archMapping.put(PPC64, PPC64);
        archMapping.put("power64", PPC64);
        archMapping.put("powerpc64", PPC64);
        archMapping.put("power_pc64", PPC64);
        archMapping.put("power_rs64", PPC64);
        archMapping.put(IBMZ, IBMZ);
        archMapping.put(IBMZ_64, IBMZ_64);
        archMapping.put(AARCH_64, AARCH_64);
    }
}

