/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialVersionUIDAdder
extends ClassVisitor {
    private static final String CLINIT = "<clinit>";
    private boolean computeSvuid;
    private boolean hasSvuid;
    private int access;
    private String name;
    private String[] interfaces;
    private Collection<Item> svuidFields;
    private boolean hasStaticInitializer;
    private Collection<Item> svuidConstructors;
    private Collection<Item> svuidMethods;

    public SerialVersionUIDAdder(ClassVisitor classVisitor) {
        this(458752, classVisitor);
        if (this.getClass() != SerialVersionUIDAdder.class) {
            throw new IllegalStateException();
        }
    }

    protected SerialVersionUIDAdder(int api, ClassVisitor classVisitor) {
        super(api, classVisitor);
    }

    @Override
    public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaces2) {
        boolean bl = this.computeSvuid = (access & 0x4000) == 0;
        if (this.computeSvuid) {
            this.name = name2;
            this.access = access;
            this.interfaces = new String[interfaces2.length];
            this.svuidFields = new ArrayList<Item>();
            this.svuidConstructors = new ArrayList<Item>();
            this.svuidMethods = new ArrayList<Item>();
            System.arraycopy(interfaces2, 0, this.interfaces, 0, interfaces2.length);
        }
        super.visit(version, access, name2, signature2, superName, interfaces2);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature2, String[] exceptions) {
        if (this.computeSvuid) {
            if (CLINIT.equals(name2)) {
                this.hasStaticInitializer = true;
            }
            int mods = access & 0xD3F;
            if ((access & 2) == 0) {
                if ("<init>".equals(name2)) {
                    this.svuidConstructors.add(new Item(name2, mods, descriptor));
                } else if (!CLINIT.equals(name2)) {
                    this.svuidMethods.add(new Item(name2, mods, descriptor));
                }
            }
        }
        return super.visitMethod(access, name2, descriptor, signature2, exceptions);
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String desc, String signature2, Object value2) {
        if (this.computeSvuid) {
            if ("serialVersionUID".equals(name2)) {
                this.computeSvuid = false;
                this.hasSvuid = true;
            }
            if ((access & 2) == 0 || (access & 0x88) == 0) {
                int mods = access & 0xDF;
                this.svuidFields.add(new Item(name2, mods, desc));
            }
        }
        return super.visitField(access, name2, desc, signature2, value2);
    }

    @Override
    public void visitInnerClass(String innerClassName, String outerName, String innerName, int innerClassAccess) {
        if (this.name != null && this.name.equals(innerClassName)) {
            this.access = innerClassAccess;
        }
        super.visitInnerClass(innerClassName, outerName, innerName, innerClassAccess);
    }

    @Override
    public void visitEnd() {
        if (this.computeSvuid && !this.hasSvuid) {
            try {
                this.addSVUID(this.computeSVUID());
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while computing SVUID for " + this.name, e);
            }
        }
        super.visitEnd();
    }

    public boolean hasSVUID() {
        return this.hasSvuid;
    }

    protected void addSVUID(long svuid) {
        FieldVisitor fieldVisitor = super.visitField(24, "serialVersionUID", "J", null, svuid);
        if (fieldVisitor != null) {
            fieldVisitor.visitEnd();
        }
    }

    protected long computeSVUID() throws IOException {
        long svuid = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Throwable throwable2 = null;
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            Throwable throwable3 = null;
            try {
                dataOutputStream.writeUTF(this.name.replace('/', '.'));
                int mods = this.access;
                if ((mods & 0x200) != 0) {
                    mods = this.svuidMethods.isEmpty() ? mods & 0xFFFFFBFF : mods | 0x400;
                }
                dataOutputStream.writeInt(mods & 0x611);
                Arrays.sort(this.interfaces);
                for (String interfaceName : this.interfaces) {
                    dataOutputStream.writeUTF(interfaceName.replace('/', '.'));
                }
                SerialVersionUIDAdder.writeItems(this.svuidFields, dataOutputStream, false);
                if (this.hasStaticInitializer) {
                    dataOutputStream.writeUTF(CLINIT);
                    dataOutputStream.writeInt(8);
                    dataOutputStream.writeUTF("()V");
                }
                SerialVersionUIDAdder.writeItems(this.svuidConstructors, dataOutputStream, true);
                SerialVersionUIDAdder.writeItems(this.svuidMethods, dataOutputStream, true);
                dataOutputStream.flush();
                byte[] hashBytes = this.computeSHAdigest(byteArrayOutputStream.toByteArray());
                for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
                    svuid = svuid << 8 | (long)(hashBytes[i] & 0xFF);
                }
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                if (dataOutputStream != null) {
                    if (throwable3 != null) {
                        try {
                            dataOutputStream.close();
                        }
                        catch (Throwable throwable5) {
                        }
                    } else {
                        dataOutputStream.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            throwable2 = throwable6;
            throw throwable6;
        }
        finally {
            if (byteArrayOutputStream != null) {
                if (throwable2 != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Throwable throwable7) {
                    }
                } else {
                    byteArrayOutputStream.close();
                }
            }
        }
        return svuid;
    }

    protected byte[] computeSHAdigest(byte[] value2) {
        try {
            return MessageDigest.getInstance("SHA").digest(value2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static void writeItems(Collection<Item> itemCollection, DataOutput dataOutputStream, boolean dotted2) throws IOException {
        Object[] items = itemCollection.toArray(new Item[0]);
        Arrays.sort(items);
        for (Object item : items) {
            dataOutputStream.writeUTF(((Item)item).name);
            dataOutputStream.writeInt(((Item)item).access);
            dataOutputStream.writeUTF(dotted2 ? ((Item)item).descriptor.replace('/', '.') : ((Item)item).descriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Item
    implements Comparable<Item> {
        final String name;
        final int access;
        final String descriptor;

        Item(String name2, int access, String descriptor) {
            this.name = name2;
            this.access = access;
            this.descriptor = descriptor;
        }

        @Override
        public int compareTo(Item item) {
            int result2 = this.name.compareTo(item.name);
            if (result2 == 0) {
                result2 = this.descriptor.compareTo(item.descriptor);
            }
            return result2;
        }

        public boolean equals(Object other) {
            if (other instanceof Item) {
                return this.compareTo((Item)other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.descriptor.hashCode();
        }
    }
}

