/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    public static String escape(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void noSpace(String string2) throws JSONException {
        int n = string2.length();
        if (n == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(string2.charAt(i))) continue;
            throw new JSONException("'" + string2 + "' contains a space character.");
        }
    }

    private static boolean parse(XMLTokener xMLTokener, JSONObject jSONObject, String string2) throws JSONException {
        String string3;
        JSONObject jSONObject2 = null;
        Object object = xMLTokener.nextToken();
        if (object == BANG) {
            char c = xMLTokener.next();
            if (c == '-') {
                if (xMLTokener.next() == '-') {
                    xMLTokener.skipPast("-->");
                    return false;
                }
                xMLTokener.back();
            } else if (c == '[') {
                object = xMLTokener.nextToken();
                if (object.equals("CDATA") && xMLTokener.next() == '[') {
                    String string4 = xMLTokener.nextCDATA();
                    if (string4.length() > 0) {
                        jSONObject.accumulate("content", string4);
                    }
                    return false;
                }
                throw xMLTokener.syntaxError("Expected 'CDATA['");
            }
            int n = 1;
            do {
                if ((object = xMLTokener.nextMeta()) == null) {
                    throw xMLTokener.syntaxError("Missing '>' after '<!'.");
                }
                if (object == LT) {
                    ++n;
                    continue;
                }
                if (object != GT) continue;
                --n;
            } while (n > 0);
            return false;
        }
        if (object == QUEST) {
            xMLTokener.skipPast("?>");
            return false;
        }
        if (object == SLASH) {
            object = xMLTokener.nextToken();
            if (string2 == null) {
                throw xMLTokener.syntaxError("Mismatched close tag" + object);
            }
            if (!object.equals(string2)) {
                throw xMLTokener.syntaxError("Mismatched " + string2 + " and " + object);
            }
            if (xMLTokener.nextToken() != GT) {
                throw xMLTokener.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (object instanceof Character) {
            throw xMLTokener.syntaxError("Misshaped tag");
        }
        String string5 = (String)object;
        object = null;
        jSONObject2 = new JSONObject();
        while (true) {
            if (object == null) {
                object = xMLTokener.nextToken();
            }
            if (!(object instanceof String)) break;
            string3 = (String)object;
            object = xMLTokener.nextToken();
            if (object == EQ) {
                object = xMLTokener.nextToken();
                if (!(object instanceof String)) {
                    throw xMLTokener.syntaxError("Missing value");
                }
                jSONObject2.accumulate(string3, JSONObject.stringToValue((String)object));
                object = null;
                continue;
            }
            jSONObject2.accumulate(string3, "");
        }
        if (object == SLASH) {
            if (xMLTokener.nextToken() != GT) {
                throw xMLTokener.syntaxError("Misshaped tag");
            }
            jSONObject.accumulate(string5, jSONObject2);
            return false;
        }
        if (object == GT) {
            while (true) {
                if ((object = xMLTokener.nextContent()) == null) {
                    if (string5 != null) {
                        throw xMLTokener.syntaxError("Unclosed tag " + string5);
                    }
                    return false;
                }
                if (object instanceof String) {
                    string3 = (String)object;
                    if (string3.length() <= 0) continue;
                    jSONObject2.accumulate("content", JSONObject.stringToValue(string3));
                    continue;
                }
                if (object == LT && XML.parse(xMLTokener, jSONObject2, string5)) break;
            }
            if (jSONObject2.length() == 0) {
                jSONObject.accumulate(string5, "");
            } else if (jSONObject2.length() == 1 && jSONObject2.opt("content") != null) {
                jSONObject.accumulate(string5, jSONObject2.opt("content"));
            } else {
                jSONObject.accumulate(string5, jSONObject2);
            }
            return false;
        }
        throw xMLTokener.syntaxError("Misshaped tag");
    }

    public static JSONObject toJSONObject(String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        XMLTokener xMLTokener = new XMLTokener(string2);
        while (xMLTokener.more() && xMLTokener.skipPast("<")) {
            XML.parse(xMLTokener, jSONObject, null);
        }
        return jSONObject;
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String string2) throws JSONException {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof JSONObject) {
            if (string2 != null) {
                stringBuffer.append('<');
                stringBuffer.append(string2);
                stringBuffer.append('>');
            }
            JSONObject jSONObject = (JSONObject)object;
            Iterator iterator2 = jSONObject.keys();
            while (iterator2.hasNext()) {
                int n;
                int n2;
                JSONArray jSONArray;
                String string4 = iterator2.next().toString();
                Object object2 = jSONObject.opt(string4);
                if (object2 == null) {
                    object2 = "";
                }
                String string5 = object2 instanceof String ? (String)object2 : null;
                if (string4.equals("content")) {
                    if (object2 instanceof JSONArray) {
                        jSONArray = (JSONArray)object2;
                        n2 = jSONArray.length();
                        for (n = 0; n < n2; ++n) {
                            if (n > 0) {
                                stringBuffer.append('\n');
                            }
                            stringBuffer.append(XML.escape(jSONArray.get(n).toString()));
                        }
                        continue;
                    }
                    stringBuffer.append(XML.escape(object2.toString()));
                    continue;
                }
                if (object2 instanceof JSONArray) {
                    jSONArray = (JSONArray)object2;
                    n2 = jSONArray.length();
                    for (n = 0; n < n2; ++n) {
                        object2 = jSONArray.get(n);
                        if (object2 instanceof JSONArray) {
                            stringBuffer.append('<');
                            stringBuffer.append(string4);
                            stringBuffer.append('>');
                            stringBuffer.append(XML.toString(object2));
                            stringBuffer.append("</");
                            stringBuffer.append(string4);
                            stringBuffer.append('>');
                            continue;
                        }
                        stringBuffer.append(XML.toString(object2, string4));
                    }
                    continue;
                }
                if (object2.equals("")) {
                    stringBuffer.append('<');
                    stringBuffer.append(string4);
                    stringBuffer.append("/>");
                    continue;
                }
                stringBuffer.append(XML.toString(object2, string4));
            }
            if (string2 != null) {
                stringBuffer.append("</");
                stringBuffer.append(string2);
                stringBuffer.append('>');
            }
            return stringBuffer.toString();
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                Object object3 = jSONArray.opt(i);
                stringBuffer.append(XML.toString(object3, string2 == null ? "array" : string2));
            }
            return stringBuffer.toString();
        }
        String string6 = string3 = object == null ? "null" : XML.escape(object.toString());
        return string2 == null ? "\"" + string3 + "\"" : (string3.length() == 0 ? "<" + string2 + "/>" : "<" + string2 + ">" + string3 + "</" + string2 + ">");
    }
}

