/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONObject {
    private Map map;
    public static final Object NULL = new Null();

    public JSONObject() {
        this.map = new HashMap();
    }

    public JSONObject(JSONObject jSONObject, String[] stringArray) throws JSONException {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.putOnce(stringArray[i], jSONObject.opt(stringArray[i]));
        }
    }

    public JSONObject(JSONTokener jSONTokener) throws JSONException {
        this();
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = jSONTokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string2 = jSONTokener.nextValue().toString();
            c = jSONTokener.nextClean();
            if (c == '=') {
                if (jSONTokener.next() != '>') {
                    jSONTokener.back();
                }
            } else if (c != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(string2, jSONTokener.nextValue());
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map2) {
        this.map = map2 == null ? new HashMap() : map2;
    }

    public JSONObject(Map map2, boolean bl) {
        this.map = new HashMap();
        if (map2 != null) {
            for (Map.Entry entry2 : map2.entrySet()) {
                this.map.put(entry2.getKey(), new JSONObject(entry2.getValue(), bl));
            }
        }
    }

    public JSONObject(Object object) {
        this();
        this.populateInternalMap(object, false);
    }

    public JSONObject(Object object, boolean bl) {
        this();
        this.populateInternalMap(object, bl);
    }

    private void populateInternalMap(Object object, boolean bl) {
        Class<?> clazz2 = object.getClass();
        if (clazz2.getClassLoader() == null) {
            bl = false;
        }
        Method[] methodArray = bl ? clazz2.getMethods() : clazz2.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            try {
                Method method = methodArray[i];
                String string2 = method.getName();
                String string3 = "";
                if (string2.startsWith("get")) {
                    string3 = string2.substring(3);
                } else if (string2.startsWith("is")) {
                    string3 = string2.substring(2);
                }
                if (string3.length() <= 0 || !Character.isUpperCase(string3.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (string3.length() == 1) {
                    string3 = string3.toLowerCase();
                } else if (!Character.isUpperCase(string3.charAt(1))) {
                    string3 = string3.substring(0, 1).toLowerCase() + string3.substring(1);
                }
                Object object2 = method.invoke(object, (Object[])null);
                if (object2 == null) {
                    this.map.put(string3, NULL);
                    continue;
                }
                if (object2.getClass().isArray()) {
                    this.map.put(string3, new JSONArray(object2, bl));
                    continue;
                }
                if (object2 instanceof Collection) {
                    this.map.put(string3, new JSONArray((Collection)object2, bl));
                    continue;
                }
                if (object2 instanceof Map) {
                    this.map.put(string3, new JSONObject((Map)object2, bl));
                    continue;
                }
                if (this.isStandardProperty(object2.getClass())) {
                    this.map.put(string3, object2);
                    continue;
                }
                if (object2.getClass().getPackage().getName().startsWith("java") || object2.getClass().getClassLoader() == null) {
                    this.map.put(string3, object2.toString());
                    continue;
                }
                this.map.put(string3, new JSONObject(object2, bl));
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private boolean isStandardProperty(Class clazz2) {
        return clazz2.isPrimitive() || clazz2.isAssignableFrom(Byte.class) || clazz2.isAssignableFrom(Short.class) || clazz2.isAssignableFrom(Integer.class) || clazz2.isAssignableFrom(Long.class) || clazz2.isAssignableFrom(Float.class) || clazz2.isAssignableFrom(Double.class) || clazz2.isAssignableFrom(Character.class) || clazz2.isAssignableFrom(String.class) || clazz2.isAssignableFrom(Boolean.class);
    }

    public JSONObject(Object object, String[] stringArray) {
        this();
        Class<?> clazz2 = object.getClass();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                this.putOpt(string2, clazz2.getField(string2).get(object));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(String string2) throws JSONException {
        this(new JSONTokener(string2));
    }

    public JSONObject accumulate(String string2, Object object) throws JSONException {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string2);
        if (object2 == null) {
            this.put(string2, object instanceof JSONArray ? new JSONArray().put(object) : object);
        } else if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
        } else {
            this.put(string2, new JSONArray().put(object2).put(object));
        }
        return this;
    }

    public JSONObject append(String string2, Object object) throws JSONException {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string2);
        if (object2 == null) {
            this.put(string2, new JSONArray().put(object));
        } else if (object2 instanceof JSONArray) {
            this.put(string2, ((JSONArray)object2).put(object));
        } else {
            throw new JSONException("JSONObject[" + string2 + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string2 = Double.toString(d);
        if (string2.indexOf(46) > 0 && string2.indexOf(101) < 0 && string2.indexOf(69) < 0) {
            while (string2.endsWith("0")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    public Object get(String string2) throws JSONException {
        Object object = this.opt(string2);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string2) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String string2) throws JSONException {
        Object object = this.get(string2);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string2) + "] is not a Boolean.");
    }

    public double getDouble(String string2) throws JSONException {
        Object object = this.get(string2);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.valueOf((String)object).doubleValue();
        }
        catch (Exception exception) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string2) + "] is not a number.");
        }
    }

    public int getInt(String string2) throws JSONException {
        Object object = this.get(string2);
        return object instanceof Number ? ((Number)object).intValue() : (int)this.getDouble(string2);
    }

    public JSONArray getJSONArray(String string2) throws JSONException {
        Object object = this.get(string2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string2) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String string2) throws JSONException {
        Object object = this.get(string2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string2) + "] is not a JSONObject.");
    }

    public long getLong(String string2) throws JSONException {
        Object object = this.get(string2);
        return object instanceof Number ? ((Number)object).longValue() : (long)this.getDouble(string2);
    }

    public static String[] getNames(JSONObject jSONObject) {
        int n = jSONObject.length();
        if (n == 0) {
            return null;
        }
        Iterator iterator2 = jSONObject.keys();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator2.hasNext()) {
            stringArray[n2] = (String)iterator2.next();
            ++n2;
        }
        return stringArray;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = object.getClass();
        Field[] fieldArray = clazz2.getFields();
        int n = fieldArray.length;
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = fieldArray[i].getName();
        }
        return stringArray;
    }

    public String getString(String string2) throws JSONException {
        return this.get(string2).toString();
    }

    public boolean has(String string2) {
        return this.map.containsKey(string2);
    }

    public boolean isNull(String string2) {
        return NULL.equals(this.opt(string2));
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    public JSONArray names() {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator2 = this.keys();
        while (iterator2.hasNext()) {
            jSONArray.put(iterator2.next());
        }
        return jSONArray.length() == 0 ? null : jSONArray;
    }

    public static String numberToString(Number number2) throws JSONException {
        if (number2 == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number2);
        String string2 = number2.toString();
        if (string2.indexOf(46) > 0 && string2.indexOf(101) < 0 && string2.indexOf(69) < 0) {
            while (string2.endsWith("0")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    public Object opt(String string2) {
        return string2 == null ? null : this.map.get(string2);
    }

    public boolean optBoolean(String string2) {
        return this.optBoolean(string2, false);
    }

    public boolean optBoolean(String string2, boolean bl) {
        try {
            return this.getBoolean(string2);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public JSONObject put(String string2, Collection collection2) throws JSONException {
        this.put(string2, new JSONArray(collection2));
        return this;
    }

    public double optDouble(String string2) {
        return this.optDouble(string2, Double.NaN);
    }

    public double optDouble(String string2, double d) {
        try {
            Object object = this.opt(string2);
            return object instanceof Number ? ((Number)object).doubleValue() : new Double((String)object).doubleValue();
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int optInt(String string2) {
        return this.optInt(string2, 0);
    }

    public int optInt(String string2, int n) {
        try {
            return this.getInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public JSONArray optJSONArray(String string2) {
        Object object = this.opt(string2);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject optJSONObject(String string2) {
        Object object = this.opt(string2);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(String string2) {
        return this.optLong(string2, 0L);
    }

    public long optLong(String string2, long l) {
        try {
            return this.getLong(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(String string2) {
        return this.optString(string2, "");
    }

    public String optString(String string2, String string3) {
        Object object = this.opt(string2);
        return object != null ? object.toString() : string3;
    }

    public JSONObject put(String string2, boolean bl) throws JSONException {
        this.put(string2, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String string2, double d) throws JSONException {
        this.put(string2, new Double(d));
        return this;
    }

    public JSONObject put(String string2, int n) throws JSONException {
        this.put(string2, new Integer(n));
        return this;
    }

    public JSONObject put(String string2, long l) throws JSONException {
        this.put(string2, new Long(l));
        return this;
    }

    public JSONObject put(String string2, Map map2) throws JSONException {
        this.put(string2, new JSONObject(map2));
        return this;
    }

    public JSONObject put(String string2, Object object) throws JSONException {
        if (string2 == null) {
            throw new JSONException("Null key.");
        }
        if (object != null) {
            JSONObject.testValidity(object);
            this.map.put(string2, object);
        } else {
            this.remove(string2);
        }
        return this;
    }

    public JSONObject putOnce(String string2, Object object) throws JSONException {
        if (string2 != null && object != null) {
            if (this.opt(string2) != null) {
                throw new JSONException("Duplicate key \"" + string2 + "\"");
            }
            this.put(string2, object);
        }
        return this;
    }

    public JSONObject putOpt(String string2, Object object) throws JSONException {
        if (string2 != null && object != null) {
            this.put(string2, object);
        }
        return this;
    }

    public static String quote(String string2) {
        if (string2 == null || string2.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string2.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String string3 = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + string3.substring(string3.length() - 4));
                        continue block9;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object remove(String string2) {
        return this.map.remove(string2);
    }

    public Iterator sortedKeys() {
        return new TreeSet(this.map.keySet()).iterator();
    }

    public static Object stringToValue(String string2) {
        if (string2.equals("")) {
            return string2;
        }
        if (string2.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string2.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string2.equalsIgnoreCase("null")) {
            return NULL;
        }
        char c = string2.charAt(0);
        if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
            if (c == '0') {
                if (string2.length() > 2 && (string2.charAt(1) == 'x' || string2.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(string2.substring(2), 16));
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(string2, 8));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                return new Integer(string2);
            }
            catch (Exception exception) {
                try {
                    return new Long(string2);
                }
                catch (Exception exception2) {
                    try {
                        return new Double(string2);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
        }
        return string2;
    }

    static void testValidity(Object object) throws JSONException {
        if (object != null && (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONArray2.put(this.opt(jSONArray.getString(i)));
        }
        return jSONArray2;
    }

    public String toString() {
        try {
            Iterator iterator2 = this.keys();
            StringBuffer stringBuffer = new StringBuffer("{");
            while (iterator2.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object e = iterator2.next();
                stringBuffer.append(JSONObject.quote(e.toString()));
                stringBuffer.append(':');
                stringBuffer.append(JSONObject.valueToString(this.map.get(e)));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) throws JSONException {
        return this.toString(n, 0);
    }

    String toString(int n, int n2) throws JSONException {
        int n3 = this.length();
        if (n3 == 0) {
            return "{}";
        }
        Iterator iterator2 = this.sortedKeys();
        StringBuffer stringBuffer = new StringBuffer("{");
        int n4 = n2 + n;
        if (n3 == 1) {
            Object e = iterator2.next();
            stringBuffer.append(JSONObject.quote(e.toString()));
            stringBuffer.append(": ");
            stringBuffer.append(JSONObject.valueToString(this.map.get(e), n, n2));
        } else {
            int n5;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(",\n");
                } else {
                    stringBuffer.append('\n');
                }
                for (n5 = 0; n5 < n4; ++n5) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.quote(e.toString()));
                stringBuffer.append(": ");
                stringBuffer.append(JSONObject.valueToString(this.map.get(e), n, n4));
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append('\n');
                for (n5 = 0; n5 < n2; ++n5) {
                    stringBuffer.append(' ');
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static String valueToString(Object object) throws JSONException {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof JSONString) {
            String string2;
            try {
                string2 = ((JSONString)object).toJSONString();
            }
            catch (Exception exception) {
                throw new JSONException(exception);
            }
            if (string2 instanceof String) {
                return string2;
            }
            throw new JSONException("Bad value from toJSONString: " + string2);
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object).toString();
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString();
        }
        return JSONObject.quote(object.toString());
    }

    static String valueToString(Object object, int n, int n2) throws JSONException {
        if (object == null || object.equals(null)) {
            return "null";
        }
        try {
            String string2;
            if (object instanceof JSONString && (string2 = ((JSONString)object).toJSONString()) instanceof String) {
                return string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).toString(n, n2);
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).toString(n, n2);
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object).toString(n, n2);
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString(n, n2);
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString(n, n2);
        }
        return JSONObject.quote(object.toString());
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean bl = false;
            Iterator iterator2 = this.keys();
            writer.write(123);
            while (iterator2.hasNext()) {
                if (bl) {
                    writer.write(44);
                }
                Object e = iterator2.next();
                writer.write(JSONObject.quote(e.toString()));
                writer.write(58);
                Object v = this.map.get(e);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v));
                }
                bl = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

