/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Cookie {
    public static String escape(String string2) {
        String string3 = string2.trim();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string3.length();
        for (int i = 0; i < n; ++i) {
            char c = string3.charAt(i);
            if (c < ' ' || c == '+' || c == '%' || c == '=' || c == ';') {
                stringBuffer.append('%');
                stringBuffer.append(Character.forDigit((char)(c >>> 4 & 0xF), 16));
                stringBuffer.append(Character.forDigit((char)(c & 0xF), 16));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject toJSONObject(String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONTokener jSONTokener = new JSONTokener(string2);
        jSONObject.put("name", jSONTokener.nextTo('='));
        jSONTokener.next('=');
        jSONObject.put("value", jSONTokener.nextTo(';'));
        jSONTokener.next();
        while (jSONTokener.more()) {
            Object object;
            String string3 = Cookie.unescape(jSONTokener.nextTo("=;"));
            if (jSONTokener.next() != '=') {
                if (!string3.equals("secure")) throw jSONTokener.syntaxError("Missing '=' in cookie parameter.");
                object = Boolean.TRUE;
            } else {
                object = Cookie.unescape(jSONTokener.nextTo(';'));
                jSONTokener.next();
            }
            jSONObject.put(string3, object);
        }
        return jSONObject;
    }

    public static String toString(JSONObject jSONObject) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Cookie.escape(jSONObject.getString("name")));
        stringBuffer.append("=");
        stringBuffer.append(Cookie.escape(jSONObject.getString("value")));
        if (jSONObject.has("expires")) {
            stringBuffer.append(";expires=");
            stringBuffer.append(jSONObject.getString("expires"));
        }
        if (jSONObject.has("domain")) {
            stringBuffer.append(";domain=");
            stringBuffer.append(Cookie.escape(jSONObject.getString("domain")));
        }
        if (jSONObject.has("path")) {
            stringBuffer.append(";path=");
            stringBuffer.append(Cookie.escape(jSONObject.getString("path")));
        }
        if (jSONObject.optBoolean("secure")) {
            stringBuffer.append(";secure");
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string2) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '+') {
                c = ' ';
            } else if (c == '%' && i + 2 < n) {
                int n2 = JSONTokener.dehexchar(string2.charAt(i + 1));
                int n3 = JSONTokener.dehexchar(string2.charAt(i + 2));
                if (n2 >= 0 && n3 >= 0) {
                    c = (char)(n2 * 16 + n3);
                    i += 2;
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

