/*
 * Decompiled with CFR 0.152.
 */
package org.javatuples;

import java.util.Collection;
import java.util.Iterator;
import org.javatuples.Tuple;
import org.javatuples.valueintf.IValueLabel;
import org.javatuples.valueintf.IValueValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LabelValue<A, B>
extends Tuple
implements IValueLabel<A>,
IValueValue<B> {
    private static final long serialVersionUID = 5055574980300695706L;
    private static final int SIZE = 2;
    private final A label;
    private final B value;

    public static <A, B> LabelValue<A, B> with(A label, B value2) {
        return new LabelValue<A, B>(label, value2);
    }

    public static <X> LabelValue<X, X> fromArray(X[] array2) {
        if (array2 == null) {
            throw new IllegalArgumentException("Array cannot be null");
        }
        if (array2.length != 2) {
            throw new IllegalArgumentException("Array must have exactly 2 elements in order to create a LabelValue. Size is " + array2.length);
        }
        return new LabelValue<X, X>(array2[0], array2[1]);
    }

    public static <X> LabelValue<X, X> fromCollection(Collection<X> collection2) {
        return LabelValue.fromIterable(collection2);
    }

    public static <X> LabelValue<X, X> fromIterable(Iterable<X> iterable) {
        return LabelValue.fromIterable(iterable, 0, true);
    }

    public static <X> LabelValue<X, X> fromIterable(Iterable<X> iterable, int index2) {
        return LabelValue.fromIterable(iterable, index2, false);
    }

    private static <X> LabelValue<X, X> fromIterable(Iterable<X> iterable, int index2, boolean exactSize) {
        if (iterable == null) {
            throw new IllegalArgumentException("Iterable cannot be null");
        }
        boolean tooFewElements = false;
        Object element0 = null;
        Object element1 = null;
        Iterator<X> iter2 = iterable.iterator();
        for (int i = 0; i < index2; ++i) {
            if (iter2.hasNext()) {
                iter2.next();
                continue;
            }
            tooFewElements = true;
        }
        if (iter2.hasNext()) {
            element0 = iter2.next();
        } else {
            tooFewElements = true;
        }
        if (iter2.hasNext()) {
            element1 = iter2.next();
        } else {
            tooFewElements = true;
        }
        if (tooFewElements && exactSize) {
            throw new IllegalArgumentException("Not enough elements for creating a LabelValue (2 needed)");
        }
        if (iter2.hasNext() && exactSize) {
            throw new IllegalArgumentException("Iterable must have exactly 2 available elements in order to create a LabelValue.");
        }
        return new LabelValue<Object, Object>(element0, element1);
    }

    public LabelValue(A label, B value2) {
        super(label, value2);
        this.label = label;
        this.value = value2;
    }

    @Override
    public A getLabel() {
        return this.label;
    }

    @Override
    public B getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        return 2;
    }

    public <X> LabelValue<X, B> setLabel(X label) {
        return new LabelValue<X, B>(label, this.value);
    }

    public <Y> LabelValue<A, Y> setValue(Y value2) {
        return new LabelValue<A, Y>(this.label, value2);
    }
}

