/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.fusesource.scalate.util.IOUtil$;
import org.fusesource.scalate.util.SourceMap;
import org.fusesource.scalate.util.SourceMap$;
import org.fusesource.scalate.util.SourceMapInstaller;
import org.fusesource.scalate.util.SourceMapStratum;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SourceMapInstaller$ {
    public static final SourceMapInstaller$ MODULE$;
    private final int SOURCE_DEBUG_EXTENSION_MAX_SIZE;
    private final String nameSDE;

    static {
        new SourceMapInstaller$();
    }

    public int SOURCE_DEBUG_EXTENSION_MAX_SIZE() {
        return this.SOURCE_DEBUG_EXTENSION_MAX_SIZE;
    }

    public String nameSDE() {
        return this.nameSDE;
    }

    public String load(File classFile) {
        return this.load(this.read(classFile));
    }

    public String load(byte[] classFile) {
        return new SourceMapInstaller.Reader(classFile).load();
    }

    public void store(File classFile, File sourceDebug) {
        this.store(classFile, this.readText(sourceDebug));
    }

    public void store(File classFile, String sourceDebug) {
        File tmpFile = new File(new StringBuilder().append((Object)classFile.getPath()).append((Object)"tmp").toString());
        this.store(classFile, sourceDebug, tmpFile);
        if (classFile.delete()) {
            if (tmpFile.renameTo(classFile)) {
                return;
            }
            throw new IOException("temp file rename failed");
        }
        throw new IOException("temp file delete failed");
    }

    public void store(File input2, String sourceDebug, File output) {
        this.store(this.read(input2), sourceDebug, output);
    }

    public void store(File input2, File sourceDebug, File output) {
        this.store(this.read(input2), this.readText(sourceDebug), output);
    }

    public void store(byte[] input2, String sourceDebug, File output) {
        IOUtil$.MODULE$.writeBinaryFile(output, this.store(input2, sourceDebug));
    }

    public byte[] store(byte[] input2, String sourceDebug) {
        byte[] bytes2 = sourceDebug.getBytes("UTF-8");
        return bytes2.length <= this.SOURCE_DEBUG_EXTENSION_MAX_SIZE() ? new SourceMapInstaller.Writer(input2, sourceDebug).store() : input2;
    }

    private String readText(File input2) {
        return new String(this.read(input2), "UTF-8");
    }

    private byte[] read(File input2) {
        if (input2.exists()) {
            return IOUtil$.MODULE$.loadBinaryFile(input2);
        }
        throw new FileNotFoundException(new StringBuilder().append((Object)"no such file: ").append(input2).toString());
    }

    public void main(String[] args2) {
        SourceMap smap1 = new SourceMap();
        smap1.setOutputFileName("foo.scala");
        SourceMapStratum straturm = new SourceMapStratum("JSP");
        straturm.addFile("foo.scala", "path/to/foo.scala");
        straturm.addLine(1, 0, 1, 2, 1);
        straturm.addLine(2, 0, 1, 3, 1);
        straturm.addLine(4, 0, 1, 8, 1);
        straturm.addLine(5, 0, 1, 9, 1);
        smap1.addStratum(straturm, true);
        String text1 = smap1.toString();
        Predef$.MODULE$.println(text1);
        SourceMap smap2 = SourceMap$.MODULE$.parse(text1);
        String text2 = smap2.toString();
        Predef$.MODULE$.println(text2);
        String string2 = text2;
        String string3 = text1;
        Predef$.MODULE$.println(BoxesRunTime.boxToBoolean(!(string2 != null ? !string2.equals(string3) : string3 != null)));
        Predef$.MODULE$.println(smap2.mapToStratum(3, smap2.mapToStratum$default$2()));
    }

    private SourceMapInstaller$() {
        MODULE$ = this;
        this.SOURCE_DEBUG_EXTENSION_MAX_SIZE = Integer.getInteger("SOURCE_DEBUG_EXTENSION_MAX_SIZE", 65535);
        this.nameSDE = "SourceDebugExtension";
    }
}

