/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fusesource.scalate.util.FileResource;
import org.fusesource.scalate.util.IOUtil;
import org.fusesource.scalate.util.Log;
import org.fusesource.scalate.util.Log$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.parsing.input.OffsetPosition;

public final class IOUtil$ {
    public static final IOUtil$ MODULE$;
    private final Log log;
    private final Regex includeRegEx;

    static {
        new IOUtil$();
    }

    public Log log() {
        return this.log;
    }

    public FileResource toResource(File file) {
        return new FileResource(file, file.getPath());
    }

    public File toFile(FileResource resource2) {
        return resource2.asFile();
    }

    public void makeParentDirs(String fileName) {
        this.makeParentDirs(new File(fileName));
    }

    public void makeParentDirs(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public boolean recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] children2 = file.listFiles();
            if (children2 != null) {
                Predef$.MODULE$.refArrayOps((Object[])children2).foreach(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File child) {
                        return IOUtil$.MODULE$.recursiveDelete(child);
                    }
                });
            }
        }
        return file.delete();
    }

    public Regex includeRegEx() {
        return this.includeRegEx;
    }

    public String mergeIncludes(String sourceCode, String encoding) {
        Regex.MatchIterator matches2 = this.includeRegEx().findAllIn(sourceCode);
        return matches2.hasNext() ? matches2.foldLeft(sourceCode, new Serializable(encoding){
            public static final long serialVersionUID = 0L;
            private final String encoding$1;

            public final String apply(String result2, String include2) {
                String string2;
                block4: {
                    String fileName;
                    String string3;
                    string2 = include2;
                    Option<List<String>> option2 = IOUtil$.MODULE$.includeRegEx().unapplySeq(string2);
                    if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(1) != 0) break block4;
                    String fileName2 = string3 = (fileName = (String)((LinearSeqOptimized)option2.get()).apply(0));
                    String includeSource = IOUtil$.MODULE$.loadTextFile(new File(fileName2), this.encoding$1);
                    return result2.replace(include2, includeSource);
                }
                try {
                    throw new MatchError((Object)string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw fileNotFoundException;
                }
                catch (MatchError matchError) {
                    throw new IOUtil.InvalidDirectiveException("include", new OffsetPosition(include2, 0));
                }
            }
            {
                this.encoding$1 = encoding$1;
            }
        }) : sourceCode;
    }

    public String mergeIncludes$default$2() {
        return "UTF-8";
    }

    public String loadText(InputStream in, String encoding) {
        String sourceCode = new String(this.loadBytes(in), encoding);
        return this.mergeIncludes(sourceCode, encoding);
    }

    public String loadText$default$2() {
        return "UTF-8";
    }

    public String loadTextFile(File path, String encoding) {
        String sourceCode = new String(this.loadBinaryFile(path), encoding);
        return this.mergeIncludes(sourceCode, encoding);
    }

    public String loadTextFile$default$2() {
        return "UTF-8";
    }

    /*
     * WARNING - void declaration
     */
    public byte[] loadBinaryFile(File path) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(path);
        try {
            this.copy((InputStream)in, (OutputStream)baos);
        }
        catch (Throwable throwable2) {
            void var3_3;
            var3_3.close();
            throw throwable2;
        }
        in.close();
        return baos.toByteArray();
    }

    public byte[] loadBytes(InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.copy(in, (OutputStream)baos);
            return baos.toByteArray();
        }
        finally {
            in.close();
        }
    }

    public void writeText(String path, String text2) {
        this.writeText(new File(path), text2);
    }

    public void writeText(File path, String text2) {
        this.writeText(new FileWriter(path), text2);
    }

    public void writeText(OutputStream stream, String text2) {
        this.writeText(new OutputStreamWriter(stream), text2);
    }

    public void writeText(Writer out, String text2) {
        try {
            out.write(text2);
            return;
        }
        finally {
            out.close();
        }
    }

    public void writeBinaryFile(String path, byte[] contents) {
        this.writeBinaryFile(new File(path), contents);
    }

    public void writeBinaryFile(File path, byte[] contents) {
        FileOutputStream out = new FileOutputStream(path);
        try {
            out.write(contents);
            return;
        }
        finally {
            out.close();
        }
    }

    public long copy(File in, File out) {
        out.getParentFile().mkdirs();
        return this.copy((InputStream)new FileInputStream(in), (OutputStream)new FileOutputStream(out));
    }

    public long copy(File file, OutputStream out) {
        return this.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), out);
    }

    public long copy(InputStream in, File file) {
        FileOutputStream out = new FileOutputStream(file);
        try {
            return this.copy(in, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public long copy(URL url, File file) {
        InputStream in = url.openStream();
        try {
            return this.copy(in, file);
        }
        finally {
            in.close();
        }
    }

    public <R, C extends Closeable> R using(C c, Function1<C, R> func) {
        R r;
        try {
            r = func.apply(c);
        }
        catch (Throwable throwable2) {
            try {
                c.close();
            }
            catch (Exception exception) {}
            throw throwable2;
        }
        try {
            c.close();
        }
        catch (Exception exception) {}
        return r;
    }

    /*
     * WARNING - void declaration
     */
    public long copy(InputStream in, OutputStream out) {
        void var3_3;
        long bytesCopied = 0L;
        byte[] buffer = new byte[8192];
        int bytes2 = in.read(buffer);
        while (bytes2 >= 0) {
            out.write(buffer, 0, bytes2);
            bytesCopied += (long)bytes2;
            bytes2 = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public long copy(Reader in, Writer out) {
        void var3_3;
        long charsCopied = 0L;
        char[] buffer = new char[8192];
        int chars = in.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * Loose catch block
     */
    public void unjar(File outputDir, InputStream input2, Function1<ZipEntry, Object> filter2) {
        ZipInputStream zip2 = new ZipInputStream(input2);
        try {
            FileOutputStream bos;
            byte[] buffer = new byte[65536];
            boolean ok = true;
            while (ok) {
                ZipEntry entry2 = zip2.getNextEntry();
                if (entry2 == null) {
                    ok = false;
                    continue;
                }
                String name2 = entry2.getName();
                if (!entry2.isDirectory() && BoxesRunTime.unboxToBoolean(filter2.apply(entry2))) {
                    this.log().debug((Function0<String>)((Object)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "processing resource: %s";
                        }
                    }), Predef$.MODULE$.genericWrapArray(new Object[]{name2}));
                    File file = new File(new StringBuilder().append((Object)outputDir.getCanonicalPath()).append((Object)"/").append((Object)name2).toString());
                    file.getParentFile().mkdirs();
                    bos = new FileOutputStream(file);
                    int bytes2 = 1;
                    while (bytes2 > 0) {
                        bytes2 = zip2.read(buffer);
                        if (bytes2 <= 0) continue;
                        bos.write(buffer, 0, bytes2);
                    }
                    bos.close();
                }
                zip2.closeEntry();
            }
            return;
            catch (Throwable throwable2) {
                bos.close();
                throw throwable2;
            }
        }
        finally {
            zip2.close();
        }
    }

    public Function1<ZipEntry, Object> unjar$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ZipEntry entry2) {
                return IOUtil$.MODULE$.allZipEntries(entry2);
            }
        };
    }

    public void recursiveDelete(File file, Function1<File, Object> filter2) {
        if (file.exists()) {
            if (file.isDirectory()) {
                Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File c) {
                        return IOUtil$.MODULE$.recursiveDelete(c);
                    }
                });
            }
            if (BoxesRunTime.unboxToBoolean(filter2.apply(file))) {
                file.delete();
            }
        }
    }

    public Function1<File, Object> recursiveDelete$default$2() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return IOUtil$.MODULE$.allFiles(file);
            }
        };
    }

    public boolean allZipEntries(ZipEntry entry2) {
        return true;
    }

    public boolean allFiles(File file) {
        return true;
    }

    private IOUtil$() {
        MODULE$ = this;
        this.log = Log$.MODULE$.apply(this.getClass());
        this.includeRegEx = new StringOps(Predef$.MODULE$.augmentString("@@include\\(\\\"(.+)\\\"\\)")).r();
    }
}

