/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.filter;

import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.scalate.CompilerException;
import org.fusesource.scalate.RenderContext;
import org.fusesource.scalate.filter.CoffeeScriptCompiler$;
import org.fusesource.scalate.filter.CompilationError;
import org.fusesource.scalate.filter.Filter;
import org.fusesource.scalate.support.RenderHelper$;
import org.fusesource.scalate.util.Log;
import org.fusesource.scalate.util.Log$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class CoffeeScriptFilter$
implements Filter,
Log {
    public static final CoffeeScriptFilter$ MODULE$;
    private final boolean serverSideCompile;
    private final AtomicBoolean warnedMissingRhino;
    private final Logger log;
    private volatile boolean bitmap$0;

    static {
        new CoffeeScriptFilter$();
    }

    private Logger log$lzycompute() {
        CoffeeScriptFilter$ coffeeScriptFilter$ = this;
        synchronized (coffeeScriptFilter$) {
            if (!this.bitmap$0) {
                this.log = Log$class.log(this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public void error(Function0<String> m, Seq<Object> args2) {
        Log$class.error(this, m, args2);
    }

    @Override
    public void error(Throwable e, Function0<String> m, Seq<Object> args2) {
        Log$class.error(this, e, m, args2);
    }

    @Override
    public void error(Throwable e) {
        Log$class.error(this, e);
    }

    @Override
    public void warn(Function0<String> m, Seq<Object> args2) {
        Log$class.warn(this, m, args2);
    }

    @Override
    public void warn(Throwable e, Function0<String> m, Seq<Object> args2) {
        Log$class.warn(this, e, m, args2);
    }

    @Override
    public void warn(Throwable e) {
        Log$class.warn(this, e);
    }

    @Override
    public void info(Function0<String> m, Seq<Object> args2) {
        Log$class.info(this, m, args2);
    }

    @Override
    public void info(Throwable e, Function0<String> m, Seq<Object> args2) {
        Log$class.info(this, e, m, args2);
    }

    @Override
    public void info(Throwable e) {
        Log$class.info(this, e);
    }

    @Override
    public void debug(Function0<String> m, Seq<Object> args2) {
        Log$class.debug(this, m, args2);
    }

    @Override
    public void debug(Throwable e, Function0<String> m, Seq<Object> args2) {
        Log$class.debug(this, e, m, args2);
    }

    @Override
    public void debug(Throwable e) {
        Log$class.debug(this, e);
    }

    @Override
    public void trace(Function0<String> m, Seq<Object> args2) {
        Log$class.trace(this, m, args2);
    }

    @Override
    public void trace(Throwable e, Function0<String> m, Seq<Object> args2) {
        Log$class.trace(this, e, m, args2);
    }

    @Override
    public void trace(Throwable e) {
        Log$class.trace(this, e);
    }

    public boolean serverSideCompile() {
        return this.serverSideCompile;
    }

    public AtomicBoolean warnedMissingRhino() {
        return this.warnedMissingRhino;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String filter(RenderContext context, String content) {
        String string2;
        if (!this.serverSideCompile()) {
            string2 = this.clientSideCompile$1(context, content);
            return string2;
        }
        try {
            string2 = CoffeeScriptCompiler$.MODULE$.compile(content, new Some<String>(context.currentTemplate())).fold(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(CompilationError error2) {
                    CoffeeScriptFilter$.MODULE$.warn((Function0<String>)((Object)new Serializable(this, error2){
                        public static final long serialVersionUID = 0L;
                        private final CompilationError error$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Could not compile coffeescript: ").append(this.error$1).toString();
                        }
                        {
                            this.error$1 = error$1;
                        }
                    }), Predef$.MODULE$.genericWrapArray(new Object[]{error2}));
                    throw new CompilerException(error2.message(), Nil$.MODULE$);
                }
            }, new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String coffee) {
                    return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("<script type='text/javascript'>\n            |  //<![CDATA[\n            |    ")).stripMargin()).append((Object)RenderHelper$.MODULE$.indent("    ", coffee)).append((Object)new StringOps(Predef$.MODULE$.augmentString("\n            |  //]]>\n            |</script>")).stripMargin()).toString();
                }
            });
            return string2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            string2 = this.missingRhino$1(classNotFoundException, context, content);
            return string2;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            string2 = this.missingRhino$1(noClassDefFoundError, context, content);
        }
        return string2;
    }

    private final String clientSideCompile$1(RenderContext context$1, String content$1) {
        context$1.attributes().update("REQUIRES_COFFEE_SCRIPT_JS", "true");
        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("<script type='text/coffeescript'>\n         |  //<![CDATA[\n         |    ")).stripMargin()).append((Object)RenderHelper$.MODULE$.indent("    ", content$1)).append((Object)new StringOps(Predef$.MODULE$.augmentString("\n         |  //]]>\n         |</script>")).stripMargin()).toString();
    }

    private final String missingRhino$1(Throwable e, RenderContext context$1, String content$1) {
        if (this.warnedMissingRhino().compareAndSet(false, true)) {
            this.warn((Function0<String>)((Object)new Serializable(e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"No Rhino on the classpath: ").append(this.e$1).append((Object)". Using client side CoffeeScript compile").toString();
                }
                {
                    this.e$1 = e$1;
                }
            }), Predef$.MODULE$.genericWrapArray(new Object[]{e}));
        }
        return this.clientSideCompile$1(context$1, content$1);
    }

    private CoffeeScriptFilter$() {
        MODULE$ = this;
        Log$class.$init$(this);
        this.serverSideCompile = true;
        this.warnedMissingRhino = new AtomicBoolean();
    }
}

