/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin.v7;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.HashMap;
import org.codehaus.groovy.GroovyBugError;

public class IndyArrayAccess {
    private static final MethodHandle notNegative;
    private static final MethodHandle normalizeIndex;
    private static final HashMap<Class, MethodHandle> getterMap;
    private static final HashMap<Class, MethodHandle> setterMap;

    private static MethodHandle buildGetter(Class arrayClass) {
        MethodHandle get2 = MethodHandles.arrayElementGetter(arrayClass);
        MethodHandle fallback = MethodHandles.explicitCastArguments(get2, get2.type().changeParameterType(0, Object.class));
        fallback = MethodHandles.dropArguments(fallback, 2, new Class[]{Integer.TYPE});
        MethodType reorderType = fallback.type().insertParameterTypes(0, Integer.TYPE).dropParameterTypes(2, 3);
        fallback = MethodHandles.permuteArguments(fallback, reorderType, 1, 0, 0);
        fallback = MethodHandles.foldArguments(fallback, normalizeIndex);
        fallback = MethodHandles.explicitCastArguments(fallback, get2.type());
        MethodHandle guard2 = MethodHandles.dropArguments(notNegative, 0, new Class[]{arrayClass});
        MethodHandle handle = MethodHandles.guardWithTest(guard2, get2, fallback);
        return handle;
    }

    private static MethodHandle buildSetter(Class arrayClass) {
        MethodHandle set2 = MethodHandles.arrayElementSetter(arrayClass);
        MethodHandle fallback = MethodHandles.explicitCastArguments(set2, set2.type().changeParameterType(0, Object.class));
        fallback = MethodHandles.dropArguments(fallback, 3, new Class[]{Integer.TYPE});
        MethodType reorderType = fallback.type().insertParameterTypes(0, Integer.TYPE).dropParameterTypes(4, 5);
        fallback = MethodHandles.permuteArguments(fallback, reorderType, 1, 0, 3, 0);
        fallback = MethodHandles.foldArguments(fallback, normalizeIndex);
        fallback = MethodHandles.explicitCastArguments(fallback, set2.type());
        MethodHandle guard2 = MethodHandles.dropArguments(notNegative, 0, new Class[]{arrayClass});
        MethodHandle handle = MethodHandles.guardWithTest(guard2, set2, fallback);
        return handle;
    }

    private static int getLength(Object array2) {
        if (array2 instanceof Object[]) {
            return ((Object[])array2).length;
        }
        if (array2 instanceof boolean[]) {
            return ((boolean[])array2).length;
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2).length;
        }
        if (array2 instanceof char[]) {
            return ((char[])array2).length;
        }
        if (array2 instanceof short[]) {
            return ((short[])array2).length;
        }
        if (array2 instanceof int[]) {
            return ((int[])array2).length;
        }
        if (array2 instanceof long[]) {
            return ((long[])array2).length;
        }
        if (array2 instanceof float[]) {
            return ((float[])array2).length;
        }
        if (array2 instanceof double[]) {
            return ((double[])array2).length;
        }
        return 0;
    }

    private static int normalizeIndex(Object array2, int i) {
        int temp = i;
        int size2 = IndyArrayAccess.getLength(array2);
        if ((i += size2) < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative array index [" + temp + "] too large for array size " + size2);
        }
        return i;
    }

    public static boolean notNegative(int index2) {
        return index2 >= 0;
    }

    public static MethodHandle arrayGet(MethodType type) {
        TypeDescriptor.OfField key = type.parameterType(0);
        MethodHandle res = getterMap.get(key);
        if (res != null) {
            return res;
        }
        res = IndyArrayAccess.buildGetter((Class)key);
        res = MethodHandles.explicitCastArguments(res, type);
        return res;
    }

    public static MethodHandle arraySet(MethodType type) {
        TypeDescriptor.OfField key = type.parameterType(0);
        MethodHandle res = setterMap.get(key);
        if (res != null) {
            return res;
        }
        res = IndyArrayAccess.buildSetter((Class)key);
        res = MethodHandles.explicitCastArguments(res, type);
        return res;
    }

    static {
        MethodHandle handle;
        Class[] classes2;
        try {
            notNegative = MethodHandles.lookup().findStatic(IndyArrayAccess.class, "notNegative", MethodType.methodType(Boolean.TYPE, Integer.TYPE));
            normalizeIndex = MethodHandles.lookup().findStatic(IndyArrayAccess.class, "normalizeIndex", MethodType.methodType(Integer.TYPE, Object.class, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new GroovyBugError(e);
        }
        getterMap = new HashMap();
        for (Class arrayClass : classes2 = new Class[]{int[].class, byte[].class, short[].class, long[].class, double[].class, float[].class, boolean[].class, char[].class, Object[].class}) {
            handle = IndyArrayAccess.buildGetter(arrayClass);
            getterMap.put(arrayClass, handle);
        }
        setterMap = new HashMap();
        for (Class arrayClass : classes2) {
            handle = IndyArrayAccess.buildSetter(arrayClass);
            setterMap.put(arrayClass, handle);
        }
    }
}

