/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin.v5;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.vmplugin.VMPlugin;
import org.codehaus.groovy.vmplugin.VMPluginFactory;
import org.codehaus.groovy.vmplugin.v5.PluginDefaultGroovyMethods;

public class Java5
implements VMPlugin {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Class[] PLUGIN_DGM = new Class[]{PluginDefaultGroovyMethods.class};
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    @Override
    public void setAdditionalClassInformation(ClassNode cn) {
        this.setGenericsTypes(cn);
    }

    private void setGenericsTypes(ClassNode cn) {
        TypeVariable[] tvs = cn.getTypeClass().getTypeParameters();
        GenericsType[] gts = this.configureTypeVariable(tvs);
        cn.setGenericsTypes(gts);
    }

    private GenericsType[] configureTypeVariable(TypeVariable[] tvs) {
        if (tvs.length == 0) {
            return null;
        }
        GenericsType[] gts = new GenericsType[tvs.length];
        for (int i = 0; i < tvs.length; ++i) {
            gts[i] = this.configureTypeVariableDefinition(tvs[i]);
        }
        return gts;
    }

    private GenericsType configureTypeVariableDefinition(TypeVariable tv) {
        return Java5.configureTypeVariableDefinition(Java5.configureTypeVariableReference(tv.getName()), this.configureTypes(tv.getBounds()));
    }

    public static GenericsType configureTypeVariableDefinition(ClassNode base, ClassNode[] cBounds) {
        GenericsType gt;
        ClassNode redirect = base.redirect();
        base.setRedirect(null);
        if (cBounds == null || cBounds.length == 0) {
            gt = new GenericsType(base);
        } else {
            gt = new GenericsType(base, cBounds, null);
            gt.setName(base.getName());
            gt.setPlaceholder(true);
        }
        base.setRedirect(redirect);
        return gt;
    }

    private ClassNode[] configureTypes(Type[] types2) {
        if (types2.length == 0) {
            return null;
        }
        ClassNode[] nodes2 = new ClassNode[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            nodes2[i] = this.configureType(types2[i]);
        }
        return nodes2;
    }

    private ClassNode configureType(Type type) {
        if (type instanceof WildcardType) {
            return this.configureWildcardType((WildcardType)type);
        }
        if (type instanceof ParameterizedType) {
            return this.configureParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.configureGenericArray((GenericArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return Java5.configureTypeVariableReference(((TypeVariable)type).getName());
        }
        if (type instanceof Class) {
            return Java5.configureClass((Class)type);
        }
        if (type == null) {
            throw new GroovyBugError("Type is null. Most probably you let a transform reuse existing ClassNodes with generics information, that is now used in a wrong context.");
        }
        throw new GroovyBugError("unknown type: " + type + " := " + type.getClass());
    }

    private static ClassNode configureClass(Class c) {
        if (c.isPrimitive()) {
            return ClassHelper.make(c);
        }
        return ClassHelper.makeWithoutCaching(c, false);
    }

    private ClassNode configureGenericArray(GenericArrayType genericArrayType) {
        Type component = genericArrayType.getGenericComponentType();
        ClassNode node = this.configureType(component);
        return node.makeArray();
    }

    private ClassNode configureWildcardType(WildcardType wildcardType) {
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        base.setRedirect(ClassHelper.OBJECT_TYPE);
        ClassNode[] lowers = this.configureTypes(wildcardType.getLowerBounds());
        ClassNode lower = null;
        if (lowers != null) {
            lower = lowers[0];
        }
        ClassNode[] upper = this.configureTypes(wildcardType.getUpperBounds());
        GenericsType t = new GenericsType(base, upper, lower);
        t.setWildcard(true);
        ClassNode ref = ClassHelper.makeWithoutCaching(Object.class, false);
        ref.setGenericsTypes(new GenericsType[]{t});
        return ref;
    }

    private ClassNode configureParameterizedType(ParameterizedType parameterizedType) {
        ClassNode base = this.configureType(parameterizedType.getRawType());
        GenericsType[] gts = this.configureTypeArguments(parameterizedType.getActualTypeArguments());
        base.setGenericsTypes(gts);
        return base;
    }

    public static ClassNode configureTypeVariableReference(String name2) {
        ClassNode cn = ClassHelper.makeWithoutCaching(name2);
        cn.setGenericsPlaceHolder(true);
        ClassNode cn2 = ClassHelper.makeWithoutCaching(name2);
        cn2.setGenericsPlaceHolder(true);
        GenericsType[] gts = new GenericsType[]{new GenericsType(cn2)};
        cn.setGenericsTypes(gts);
        cn.setRedirect(ClassHelper.OBJECT_TYPE);
        return cn;
    }

    private GenericsType[] configureTypeArguments(Type[] ta) {
        if (ta.length == 0) {
            return null;
        }
        GenericsType[] gts = new GenericsType[ta.length];
        for (int i = 0; i < ta.length; ++i) {
            ClassNode t = this.configureType(ta[i]);
            if (ta[i] instanceof WildcardType) {
                GenericsType[] gen = t.getGenericsTypes();
                gts[i] = gen[0];
                continue;
            }
            gts[i] = new GenericsType(t);
        }
        return gts;
    }

    @Override
    public Class[] getPluginDefaultGroovyMethods() {
        return PLUGIN_DGM;
    }

    @Override
    public Class[] getPluginStaticGroovyMethods() {
        return EMPTY_CLASS_ARRAY;
    }

    private void setAnnotationMetaData(Annotation[] annotations2, AnnotatedNode an) {
        for (Annotation annotation : annotations2) {
            AnnotationNode node = new AnnotationNode(ClassHelper.make(annotation.annotationType()));
            this.configureAnnotation(node, annotation);
            an.addAnnotation(node);
        }
    }

    @Deprecated
    public void configureAnnotationFromDefinition(AnnotationNode definition, AnnotationNode root2) {
        VMPlugin plugin = VMPluginFactory.getPlugin();
        plugin.configureAnnotationNodeFromDefinition(definition, root2);
    }

    @Override
    public void configureAnnotationNodeFromDefinition(AnnotationNode definition, AnnotationNode root2) {
        ClassNode type = definition.getClassNode();
        if ("java.lang.annotation.Retention".equals(type.getName())) {
            Expression exp = definition.getMember("value");
            if (!(exp instanceof PropertyExpression)) {
                return;
            }
            PropertyExpression pe = (PropertyExpression)exp;
            String name2 = pe.getPropertyAsString();
            RetentionPolicy policy = RetentionPolicy.valueOf(name2);
            Java5.setRetentionPolicy(policy, root2);
        } else if ("java.lang.annotation.Target".equals(type.getName())) {
            Expression exp = definition.getMember("value");
            if (!(exp instanceof ListExpression)) {
                return;
            }
            ListExpression le = (ListExpression)exp;
            int bitmap = 0;
            for (Expression e : le.getExpressions()) {
                if (!(e instanceof PropertyExpression)) {
                    return;
                }
                PropertyExpression element = (PropertyExpression)e;
                String name3 = element.getPropertyAsString();
                ElementType value2 = ElementType.valueOf(name3);
                bitmap |= this.getElementCode(value2);
            }
            root2.setAllowedTargets(bitmap);
        }
    }

    @Override
    public void configureAnnotation(AnnotationNode node) {
        ClassNode type = node.getClassNode();
        VMPlugin plugin = VMPluginFactory.getPlugin();
        List<AnnotationNode> annotations2 = type.getAnnotations();
        for (AnnotationNode an : annotations2) {
            plugin.configureAnnotationNodeFromDefinition(an, node);
        }
        plugin.configureAnnotationNodeFromDefinition(node, node);
    }

    private void configureAnnotation(AnnotationNode node, Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        if (type == Retention.class) {
            Retention r = (Retention)annotation;
            RetentionPolicy value2 = r.value();
            Java5.setRetentionPolicy(value2, node);
            node.setMember("value", new PropertyExpression((Expression)new ClassExpression(ClassHelper.makeWithoutCaching(RetentionPolicy.class, false)), value2.toString()));
        } else if (type == Target.class) {
            Target t = (Target)annotation;
            ElementType[] elements = t.value();
            ListExpression elementExprs = new ListExpression();
            for (ElementType element : elements) {
                elementExprs.addExpression(new PropertyExpression((Expression)new ClassExpression(ClassHelper.ELEMENT_TYPE_TYPE), element.name()));
            }
            node.setMember("value", elementExprs);
        } else {
            Method[] declaredMethods;
            try {
                declaredMethods = type.getDeclaredMethods();
            }
            catch (SecurityException se) {
                declaredMethods = EMPTY_METHOD_ARRAY;
            }
            for (Method declaredMethod : declaredMethods) {
                try {
                    Object value3 = declaredMethod.invoke((Object)annotation, new Object[0]);
                    Expression valueExpression = this.annotationValueToExpression(value3);
                    if (valueExpression == null) continue;
                    node.setMember(declaredMethod.getName(), valueExpression);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
    }

    private Expression annotationValueToExpression(Object value2) {
        if (value2 == null || value2 instanceof String || value2 instanceof Number || value2 instanceof Character || value2 instanceof Boolean) {
            return new ConstantExpression(value2);
        }
        if (value2 instanceof Class) {
            return new ClassExpression(ClassHelper.makeWithoutCaching((Class)value2));
        }
        if (value2.getClass().isArray()) {
            ListExpression elementExprs = new ListExpression();
            int len = Array.getLength(value2);
            for (int i = 0; i != len; ++i) {
                elementExprs.addExpression(this.annotationValueToExpression(Array.get(value2, i)));
            }
            return elementExprs;
        }
        return null;
    }

    private static void setRetentionPolicy(RetentionPolicy value2, AnnotationNode node) {
        switch (value2) {
            case RUNTIME: {
                node.setRuntimeRetention(true);
                break;
            }
            case SOURCE: {
                node.setSourceRetention(true);
                break;
            }
            case CLASS: {
                node.setClassRetention(true);
                break;
            }
            default: {
                throw new GroovyBugError("unsupported Retention " + (Object)((Object)value2));
            }
        }
    }

    protected int getElementCode(ElementType value2) {
        switch (value2) {
            case TYPE: {
                return 65;
            }
            case CONSTRUCTOR: {
                return 2;
            }
            case METHOD: {
                return 4;
            }
            case FIELD: {
                return 8;
            }
            case PARAMETER: {
                return 16;
            }
            case LOCAL_VARIABLE: {
                return 32;
            }
            case ANNOTATION_TYPE: {
                return 64;
            }
            case PACKAGE: {
                return 128;
            }
        }
        if ("MODULE".equals(value2.name())) {
            return 65;
        }
        throw new GroovyBugError("unsupported Target " + (Object)((Object)value2));
    }

    private static void setMethodDefaultValue(MethodNode mn, Method m) {
        Object defaultValue2 = m.getDefaultValue();
        ConstantExpression cExp = ConstantExpression.NULL;
        if (defaultValue2 != null) {
            cExp = new ConstantExpression(defaultValue2);
        }
        mn.setCode(new ReturnStatement(cExp));
        mn.setAnnotationDefault(true);
    }

    @Override
    public void configureClassNode(CompileUnit compileUnit, ClassNode classNode) {
        try {
            Constructor<?>[] constructors2;
            Method[] methods2;
            Field[] fields;
            Class clazz2 = classNode.getTypeClass();
            for (Field f2 : fields = clazz2.getDeclaredFields()) {
                ClassNode ret = this.makeClassNode(compileUnit, f2.getGenericType(), f2.getType());
                FieldNode fn2 = new FieldNode(f2.getName(), f2.getModifiers(), ret, classNode, null);
                this.setAnnotationMetaData(f2.getAnnotations(), fn2);
                classNode.addField(fn2);
            }
            for (Method m : methods2 = clazz2.getDeclaredMethods()) {
                ClassNode ret = this.makeClassNode(compileUnit, m.getGenericReturnType(), m.getReturnType());
                Parameter[] params2 = this.processParameters(compileUnit, m);
                ClassNode[] exceptions = this.makeClassNodes(compileUnit, m.getGenericExceptionTypes(), m.getExceptionTypes());
                MethodNode mn = new MethodNode(m.getName(), m.getModifiers(), ret, params2, exceptions, null);
                mn.setSynthetic(m.isSynthetic());
                Java5.setMethodDefaultValue(mn, m);
                this.setAnnotationMetaData(m.getAnnotations(), mn);
                mn.setGenericsTypes(this.configureTypeVariable(m.getTypeParameters()));
                classNode.addMethod(mn);
            }
            for (Constructor<?> ctor : constructors2 = clazz2.getDeclaredConstructors()) {
                Type[] types2 = ctor.getGenericParameterTypes();
                Parameter[] params1 = Parameter.EMPTY_ARRAY;
                if (types2.length > 0) {
                    params1 = new Parameter[types2.length];
                    for (int i = 0; i < params1.length; ++i) {
                        params1[i] = this.makeParameter(compileUnit, types2[i], ctor.getParameterTypes()[i], this.getConstructorParameterAnnotations(ctor)[i], "param" + i);
                    }
                }
                Parameter[] params3 = params1;
                ClassNode[] exceptions = this.makeClassNodes(compileUnit, ctor.getGenericExceptionTypes(), ctor.getExceptionTypes());
                classNode.addConstructor(ctor.getModifiers(), params3, exceptions, null);
            }
            Class sc = clazz2.getSuperclass();
            if (sc != null) {
                classNode.setUnresolvedSuperClass(this.makeClassNode(compileUnit, clazz2.getGenericSuperclass(), sc));
            }
            this.makeInterfaceTypes(compileUnit, classNode, clazz2);
            this.setAnnotationMetaData(classNode.getTypeClass().getAnnotations(), classNode);
            PackageNode packageNode = classNode.getPackage();
            if (packageNode != null) {
                this.setAnnotationMetaData(classNode.getTypeClass().getPackage().getAnnotations(), packageNode);
            }
        }
        catch (NoClassDefFoundError e) {
            throw new NoClassDefFoundError("Unable to load class " + classNode.toString(false) + " due to missing dependency " + e.getMessage());
        }
        catch (MalformedParameterizedTypeException e) {
            throw new RuntimeException("Unable to configure class node for class " + classNode.toString(false) + " due to malformed parameterized types", e);
        }
    }

    protected Parameter[] processParameters(CompileUnit compileUnit, Method m) {
        Type[] types2 = m.getGenericParameterTypes();
        Parameter[] params2 = Parameter.EMPTY_ARRAY;
        if (types2.length > 0) {
            params2 = new Parameter[types2.length];
            for (int i = 0; i < params2.length; ++i) {
                params2[i] = this.makeParameter(compileUnit, types2[i], m.getParameterTypes()[i], m.getParameterAnnotations()[i], "param" + i);
            }
        }
        return params2;
    }

    private Annotation[][] getConstructorParameterAnnotations(Constructor<?> constructor) {
        Annotation[][] annotations2;
        int parameterCount = constructor.getParameterTypes().length;
        int diff2 = parameterCount - (annotations2 = constructor.getParameterAnnotations()).length;
        if (diff2 > 0) {
            if (!constructor.getDeclaringClass().isEnum() && diff2 > 1 || diff2 > 2) {
                throw new GroovyBugError("Constructor parameter annotations length [" + annotations2.length + "] does not match the parameter length: " + constructor);
            }
            Annotation[][] adjusted = new Annotation[parameterCount][];
            for (int i = 0; i < diff2; ++i) {
                adjusted[i] = EMPTY_ANNOTATION_ARRAY;
            }
            System.arraycopy(annotations2, 0, adjusted, diff2, annotations2.length);
            return adjusted;
        }
        return annotations2;
    }

    private void makeInterfaceTypes(CompileUnit cu, ClassNode classNode, Class clazz2) {
        Type[] interfaceTypes = clazz2.getGenericInterfaces();
        if (interfaceTypes.length == 0) {
            classNode.setInterfaces(ClassNode.EMPTY_ARRAY);
        } else {
            ClassNode[] ret = new ClassNode[interfaceTypes.length];
            for (int i = 0; i < interfaceTypes.length; ++i) {
                Type type = interfaceTypes[i];
                while (!(type instanceof Class)) {
                    ParameterizedType pt = (ParameterizedType)type;
                    Type t2 = pt.getRawType();
                    if (t2 == type) {
                        throw new GroovyBugError("Cannot transform generic signature of " + clazz2 + " with generic interface " + interfaceTypes[i] + " to a class.");
                    }
                    type = t2;
                }
                ret[i] = this.makeClassNode(cu, interfaceTypes[i], (Class)type);
            }
            classNode.setInterfaces(ret);
        }
    }

    private ClassNode[] makeClassNodes(CompileUnit cu, Type[] types2, Class[] cls) {
        ClassNode[] nodes2 = new ClassNode[types2.length];
        for (int i = 0; i < nodes2.length; ++i) {
            nodes2[i] = this.makeClassNode(cu, types2[i], cls[i]);
        }
        return nodes2;
    }

    private ClassNode makeClassNode(CompileUnit cu, Type t, Class c) {
        ClassNode back = null;
        if (cu != null) {
            back = cu.getClass(c.getName());
        }
        if (back == null) {
            back = ClassHelper.make(c);
        }
        if (!(t instanceof Class)) {
            ClassNode front = this.configureType(t);
            front.setRedirect(back);
            return front;
        }
        return back.getPlainNodeReference();
    }

    protected Parameter makeParameter(CompileUnit cu, Type type, Class cl, Annotation[] annotations2, String name2) {
        ClassNode cn = this.makeClassNode(cu, type, cl);
        Parameter parameter = new Parameter(cn, name2);
        this.setAnnotationMetaData(annotations2, parameter);
        return parameter;
    }

    @Override
    public void invalidateCallSites() {
    }

    @Override
    public Object getInvokeSpecialHandle(Method m, Object receiver) {
        throw new GroovyBugError("getInvokeSpecialHandle requires at least JDK 7 wot private access to Lookup");
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    public Object invokeHandle(Object handle, Object[] args2) throws Throwable {
        throw new GroovyBugError("invokeHandle requires at least JDK 7");
    }
}

