/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import org.codehaus.groovy.util.AbstractConcurrentMapBase;

public abstract class AbstractConcurrentMap<K, V>
extends AbstractConcurrentMapBase {
    public AbstractConcurrentMap(Object segmentInfo) {
        super(segmentInfo);
    }

    @Override
    public Segment segmentFor(int hash2) {
        return (Segment)super.segmentFor(hash2);
    }

    public V get(K key) {
        int hash2 = AbstractConcurrentMap.hash(key);
        return this.segmentFor(hash2).get(key, hash2);
    }

    public Entry<K, V> getOrPut(K key, V value2) {
        int hash2 = AbstractConcurrentMap.hash(key);
        return this.segmentFor(hash2).getOrPut(key, hash2, value2);
    }

    public void put(K key, V value2) {
        int hash2 = AbstractConcurrentMap.hash(key);
        this.segmentFor(hash2).put(key, hash2, value2);
    }

    public void remove(K key) {
        int hash2 = AbstractConcurrentMap.hash(key);
        this.segmentFor(hash2).remove(key, hash2);
    }

    public static interface Entry<K, V>
    extends AbstractConcurrentMapBase.Entry<V> {
        public boolean isEqual(K var1, int var2);
    }

    public static abstract class Segment<K, V>
    extends AbstractConcurrentMapBase.Segment {
        private static final long serialVersionUID = -2392526467736920612L;

        protected Segment(int initialCapacity) {
            super(initialCapacity);
        }

        public final V get(K key, int hash2) {
            Object[] tab = this.table;
            Object o = tab[hash2 & tab.length - 1];
            if (o != null) {
                if (o instanceof Entry) {
                    Entry e = (Entry)o;
                    if (e.isEqual(key, hash2)) {
                        return e.getValue();
                    }
                } else {
                    Object[] arr = (Object[])o;
                    for (int i = 0; i < arr.length; ++i) {
                        Entry e = (Entry)arr[i];
                        if (e == null || !e.isEqual(key, hash2)) continue;
                        return e.getValue();
                    }
                }
            }
            return null;
        }

        public final Entry<K, V> getOrPut(K key, int hash2, V value2) {
            Object[] tab = this.table;
            Object o = tab[hash2 & tab.length - 1];
            if (o != null) {
                if (o instanceof Entry) {
                    Entry e = (Entry)o;
                    if (e.isEqual(key, hash2)) {
                        return e;
                    }
                } else {
                    Object[] arr = (Object[])o;
                    for (int i = 0; i < arr.length; ++i) {
                        Entry e = (Entry)arr[i];
                        if (e == null || !e.isEqual(key, hash2)) continue;
                        return e;
                    }
                }
            }
            return this.put(key, hash2, value2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Entry put(K key, int hash2, V value2) {
            this.lock();
            try {
                Entry<K, V> e;
                this.rehashIfThresholdExceeded();
                Object[] tab = this.table;
                int index2 = hash2 & tab.length - 1;
                Object o = tab[index2];
                if (o != null) {
                    if (o instanceof Entry) {
                        Entry e2 = (Entry)o;
                        if (e2.isEqual(key, hash2)) {
                            e2.setValue(value2);
                            Entry entry2 = e2;
                            return entry2;
                        }
                        Entry<K, V> ee = this.createEntry(key, hash2, value2);
                        Object[] arr = new Object[]{ee, e2};
                        tab[index2] = arr;
                        ++this.count;
                        Entry<K, V> entry3 = ee;
                        return entry3;
                    }
                    Object[] arr = (Object[])o;
                    for (int i = 0; i < arr.length; ++i) {
                        Entry e3 = (Entry)arr[i];
                        if (e3 == null || !e3.isEqual(key, hash2)) continue;
                        e3.setValue(value2);
                        Entry entry4 = e3;
                        return entry4;
                    }
                    Entry<K, V> ee = this.createEntry(key, hash2, value2);
                    for (int i = 0; i < arr.length; ++i) {
                        Entry e4 = (Entry)arr[i];
                        if (e4 != null) continue;
                        arr[i] = ee;
                        ++this.count;
                        Entry<K, V> entry5 = ee;
                        return entry5;
                    }
                    Object[] newArr = new Object[arr.length + 1];
                    newArr[0] = ee;
                    System.arraycopy(arr, 0, newArr, 1, arr.length);
                    tab[index2] = newArr;
                    ++this.count;
                    Entry<K, V> entry6 = ee;
                    return entry6;
                }
                tab[index2] = e = this.createEntry(key, hash2, value2);
                ++this.count;
                Entry<K, V> entry7 = e;
                return entry7;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(K key, int hash2) {
            block6: {
                this.lock();
                try {
                    int c = this.count - 1;
                    Object[] tab = this.table;
                    int index2 = hash2 & tab.length - 1;
                    Object o = tab[index2];
                    if (o == null) break block6;
                    if (o instanceof Entry) {
                        if (((Entry)o).isEqual(key, hash2)) {
                            tab[index2] = null;
                            this.count = c;
                        }
                        break block6;
                    }
                    Object[] arr = (Object[])o;
                    for (int i = 0; i < arr.length; ++i) {
                        Entry e = (Entry)arr[i];
                        if (e == null || !e.isEqual(key, hash2)) continue;
                        arr[i] = null;
                        this.count = c;
                        break;
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        protected abstract Entry<K, V> createEntry(K var1, int var2, V var3);
    }
}

