/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.transform.stc.AbstractTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;
import org.codehaus.groovy.transform.trait.TraitASTTransformation;
import org.codehaus.groovy.transform.trait.Traits;

public class TraitTypeCheckingExtension
extends AbstractTypeCheckingExtension {
    private static final List<MethodNode> NOTFOUND = Collections.emptyList();

    public TraitTypeCheckingExtension(StaticTypeCheckingVisitor typeCheckingVisitor) {
        super(typeCheckingVisitor);
    }

    @Override
    public void setup() {
    }

    @Override
    public List<MethodNode> handleMissingMethod(ClassNode receiver, String name2, ArgumentListExpression argumentList, ClassNode[] argumentTypes, MethodCall call2) {
        String[] decomposed = Traits.decomposeSuperCallName(name2);
        if (decomposed != null) {
            return this.convertToDynamicCall(call2, receiver, decomposed, argumentTypes);
        }
        if (call2 instanceof MethodCallExpression) {
            ClassNode dynamic;
            MethodCallExpression mce = (MethodCallExpression)call2;
            if (mce.getReceiver() instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)mce.getReceiver();
                ClassNode type = null;
                if (TraitTypeCheckingExtension.isStaticTraitReceiver(receiver, var)) {
                    type = receiver.getGenericsTypes()[0].getType();
                } else if (TraitTypeCheckingExtension.isThisTraitReceiver(var)) {
                    type = receiver;
                }
                if (Traits.isTrait(type) && !(type instanceof UnionTypeClassNode)) {
                    ArrayList<ClassNode> candidates = new ArrayList<ClassNode>();
                    candidates.add(type);
                    while (!candidates.isEmpty()) {
                        ClassNode next2 = (ClassNode)candidates.remove(0);
                        ClassNode helper = Traits.findHelper(next2);
                        Parameter[] params2 = new Parameter[argumentTypes.length + 1];
                        params2[0] = new Parameter(ClassHelper.CLASS_Type.getPlainNodeReference(), "staticSelf");
                        for (int i = 1; i < params2.length; ++i) {
                            params2[i] = new Parameter(argumentTypes[i - 1], "p" + i);
                        }
                        MethodNode method = helper.getDeclaredMethod(name2, params2);
                        if (method != null) {
                            return Collections.singletonList(this.makeDynamic(call2, method.getReturnType()));
                        }
                        candidates.addAll(Arrays.asList(next2.getInterfaces()));
                    }
                }
            }
            if ((dynamic = (ClassNode)mce.getNodeMetaData(TraitASTTransformation.DO_DYNAMIC)) != null) {
                return Collections.singletonList(this.makeDynamic(call2, dynamic));
            }
        }
        return NOTFOUND;
    }

    private static boolean isStaticTraitReceiver(ClassNode receiver, VariableExpression var) {
        return "$static$self".equals(var.getName()) && StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver);
    }

    private static boolean isThisTraitReceiver(VariableExpression var) {
        return "$self".equals(var.getName());
    }

    private List<MethodNode> convertToDynamicCall(MethodCall call2, ClassNode receiver, String[] decomposed, ClassNode[] argumentTypes) {
        String traitName = decomposed[0];
        String name2 = decomposed[1];
        LinkedHashSet<ClassNode> traitsAsList = Traits.collectAllInterfacesReverseOrder(receiver, new LinkedHashSet<ClassNode>());
        ClassNode[] implementedTraits = traitsAsList.toArray(ClassNode.EMPTY_ARRAY);
        ClassNode nextTrait = null;
        for (int i = 0; i < implementedTraits.length - 1; ++i) {
            ClassNode implementedTrait = implementedTraits[i];
            if (!implementedTrait.getName().equals(traitName)) continue;
            nextTrait = implementedTraits[i + 1];
        }
        ClassNode[] newArgs = new ClassNode[argumentTypes.length];
        System.arraycopy(argumentTypes, 0, newArgs, 0, newArgs.length);
        ClassNode inferredReturnType = this.inferTraitMethodReturnType(nextTrait, name2, newArgs);
        return Collections.singletonList(this.makeDynamic(call2, inferredReturnType));
    }

    private ClassNode inferTraitMethodReturnType(ClassNode nextTrait, String methodName, ClassNode[] paramTypes2) {
        List<MethodNode> candidates;
        ClassNode result2 = ClassHelper.OBJECT_TYPE;
        if (nextTrait != null && (candidates = this.typeCheckingVisitor.findMethod(nextTrait, methodName, paramTypes2)).size() == 1) {
            result2 = candidates.get(0).getReturnType();
        }
        return result2;
    }
}

