/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.DelegatesTo;
import groovy.lang.IntRange;
import groovy.lang.Range;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import groovy.transform.TypeChecked;
import groovy.transform.TypeCheckingMode;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.ClosureSignatureConflictResolver;
import groovy.transform.stc.ClosureSignatureHint;
import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.ReturnAdder;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.TokenUtil;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.DefaultTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.DelegationMetadata;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.PropertyLookupVisitor;
import org.codehaus.groovy.transform.stc.Receiver;
import org.codehaus.groovy.transform.stc.SecondPassExpression;
import org.codehaus.groovy.transform.stc.SharedVariableCollector;
import org.codehaus.groovy.transform.stc.SignatureCodec;
import org.codehaus.groovy.transform.stc.SignatureCodecVersion1;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.transform.stc.TraitTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.TypeCheckingContext;
import org.codehaus.groovy.transform.stc.TypeCheckingExtension;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.groovy.util.ListHashMap;

public class StaticTypeCheckingVisitor
extends ClassCodeVisitorSupport {
    private static final boolean DEBUG_GENERATED_CODE = Boolean.valueOf(System.getProperty("groovy.stc.debug", "false"));
    private static final AtomicLong UNIQUE_LONG = new AtomicLong();
    protected static final Object ERROR_COLLECTOR = ErrorCollector.class;
    protected static final ClassNode ITERABLE_TYPE = ClassHelper.make(Iterable.class);
    protected static final List<MethodNode> EMPTY_METHODNODE_LIST = Collections.emptyList();
    protected static final ClassNode TYPECHECKED_CLASSNODE = ClassHelper.make(TypeChecked.class);
    protected static final ClassNode[] TYPECHECKING_ANNOTATIONS = new ClassNode[]{TYPECHECKED_CLASSNODE};
    protected static final ClassNode TYPECHECKING_INFO_NODE = ClassHelper.make(TypeChecked.TypeCheckingInfo.class);
    protected static final ClassNode DGM_CLASSNODE = ClassHelper.make(DefaultGroovyMethods.class);
    protected static final int CURRENT_SIGNATURE_PROTOCOL_VERSION = 1;
    protected static final Expression CURRENT_SIGNATURE_PROTOCOL = new ConstantExpression(1, true);
    protected static final MethodNode GET_DELEGATE = ClassHelper.CLOSURE_TYPE.getGetterMethod("getDelegate");
    protected static final MethodNode GET_OWNER = ClassHelper.CLOSURE_TYPE.getGetterMethod("getOwner");
    protected static final MethodNode GET_THISOBJECT = ClassHelper.CLOSURE_TYPE.getGetterMethod("getThisObject");
    protected static final ClassNode DELEGATES_TO = ClassHelper.make(DelegatesTo.class);
    protected static final ClassNode DELEGATES_TO_TARGET = ClassHelper.make(DelegatesTo.Target.class);
    protected static final ClassNode LINKEDHASHMAP_CLASSNODE = ClassHelper.make(LinkedHashMap.class);
    protected static final ClassNode CLOSUREPARAMS_CLASSNODE = ClassHelper.make(ClosureParams.class);
    protected static final ClassNode NAMED_PARAMS_CLASSNODE = ClassHelper.make(NamedParams.class);
    protected static final ClassNode MAP_ENTRY_TYPE = ClassHelper.make(Map.Entry.class);
    protected static final ClassNode ENUMERATION_TYPE = ClassHelper.make(Enumeration.class);
    public static final Statement GENERATED_EMPTY_STATEMENT = new EmptyStatement();
    public static final MethodNode CLOSURE_CALL_NO_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", Parameter.EMPTY_ARRAY);
    public static final MethodNode CLOSURE_CALL_ONE_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "arg")});
    public static final MethodNode CLOSURE_CALL_VARGS = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "args")});
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected final ReturnAdder.ReturnStatementListener returnListener = new ReturnAdder.ReturnStatementListener(){

        @Override
        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (returnStatement.getExpression() == ConstantExpression.NULL) {
                return;
            }
            if (StaticTypeCheckingVisitor.isNullConstant(returnStatement.getExpression())) {
                return;
            }
            StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
            if (StaticTypeCheckingVisitor.this.typeCheckingContext.getEnclosingClosure() != null) {
                StaticTypeCheckingVisitor.this.addClosureReturnType(StaticTypeCheckingVisitor.this.getType(returnStatement.getExpression()));
            } else if (StaticTypeCheckingVisitor.this.typeCheckingContext.getEnclosingMethod() == null) {
                throw new GroovyBugError("Unexpected return statement at " + returnStatement.getLineNumber() + ":" + returnStatement.getColumnNumber() + " " + returnStatement.getText());
            }
        }
    };
    protected final ReturnAdder returnAdder = new ReturnAdder(this.returnListener);
    protected TypeCheckingContext typeCheckingContext = new TypeCheckingContext(this);
    protected DefaultTypeCheckingExtension extension = this.createDefaultTypeCheckingExtension();
    protected FieldNode currentField;
    protected PropertyNode currentProperty;

    public StaticTypeCheckingVisitor(SourceUnit source, ClassNode cn) {
        this.typeCheckingContext.source = source;
        this.typeCheckingContext.pushEnclosingClassNode(cn);
        this.typeCheckingContext.pushErrorCollector(source.getErrorCollector());
        this.typeCheckingContext.pushTemporaryTypeInfo();
    }

    private DefaultTypeCheckingExtension createDefaultTypeCheckingExtension() {
        DefaultTypeCheckingExtension ext = new DefaultTypeCheckingExtension(this);
        ext.addHandler(new TraitTypeCheckingExtension(this));
        return ext;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.typeCheckingContext.source;
    }

    public void initialize() {
        this.extension.setup();
    }

    public TypeCheckingContext getTypeCheckingContext() {
        return this.typeCheckingContext;
    }

    public void addTypeCheckingExtension(TypeCheckingExtension extension2) {
        this.extension.addHandler(extension2);
    }

    public void setCompilationUnit(CompilationUnit cu) {
        this.typeCheckingContext.setCompilationUnit(cu);
    }

    @Override
    public void visitClass(ClassNode node) {
        if (this.shouldSkipClassNode(node)) {
            return;
        }
        if (this.extension.beforeVisitClass(node)) {
            this.extension.afterVisitClass(node);
            return;
        }
        Object type = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (type != null) {
            this.typeCheckingContext.pushErrorCollector();
        }
        this.typeCheckingContext.pushEnclosingClassNode(node);
        Set<MethodNode> oldVisitedMethod = this.typeCheckingContext.alreadyVisitedMethods;
        this.typeCheckingContext.alreadyVisitedMethods = new LinkedHashSet<MethodNode>();
        super.visitClass(node);
        Iterator<InnerClassNode> innerClasses = node.getInnerClasses();
        while (innerClasses.hasNext()) {
            InnerClassNode innerClassNode = innerClasses.next();
            this.visitClass(innerClassNode);
        }
        this.typeCheckingContext.alreadyVisitedMethods = oldVisitedMethod;
        node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, node);
        for (MethodNode methodNode : node.getMethods()) {
            methodNode.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
        }
        for (ConstructorNode constructorNode : node.getDeclaredConstructors()) {
            constructorNode.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
        }
        this.extension.afterVisitClass(node);
    }

    protected boolean shouldSkipClassNode(ClassNode node) {
        return this.isSkipMode(node);
    }

    protected ClassNode[] getTypeCheckingAnnotations() {
        return TYPECHECKING_ANNOTATIONS;
    }

    public boolean isSkipMode(AnnotatedNode node) {
        if (node == null) {
            return false;
        }
        for (ClassNode tca : this.getTypeCheckingAnnotations()) {
            List<AnnotationNode> annotations2 = node.getAnnotations(tca);
            if (annotations2 == null) continue;
            for (AnnotationNode annotation : annotations2) {
                Expression value2 = annotation.getMember("value");
                if (value2 == null) continue;
                if (value2 instanceof ConstantExpression) {
                    ConstantExpression ce = (ConstantExpression)value2;
                    if (!TypeCheckingMode.SKIP.toString().equals(ce.getValue().toString())) continue;
                    return true;
                }
                if (!(value2 instanceof PropertyExpression)) continue;
                PropertyExpression pe = (PropertyExpression)value2;
                if (!TypeCheckingMode.SKIP.toString().equals(pe.getPropertyAsString())) continue;
                return true;
            }
        }
        if (node instanceof MethodNode) {
            return this.isSkipMode(node.getDeclaringClass());
        }
        return this.isSkippedInnerClass(node);
    }

    protected boolean isSkippedInnerClass(AnnotatedNode node) {
        if (!(node instanceof InnerClassNode)) {
            return false;
        }
        MethodNode enclosingMethod = ((InnerClassNode)node).getEnclosingMethod();
        return enclosingMethod != null && this.isSkipMode(enclosingMethod);
    }

    @Override
    public void visitClassExpression(ClassExpression expression2) {
        super.visitClassExpression(expression2);
        ClassNode cn = (ClassNode)expression2.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn == null) {
            this.storeType(expression2, this.getType(expression2));
        }
    }

    private static void addPrivateFieldOrMethodAccess(Expression source, ClassNode cn, StaticTypesMarker type, ASTNode accessedMember) {
        LinkedHashSet<ASTNode> set2 = (LinkedHashSet<ASTNode>)cn.getNodeMetaData((Object)type);
        if (set2 == null) {
            set2 = new LinkedHashSet<ASTNode>();
            cn.putNodeMetaData((Object)type, set2);
        }
        set2.add(accessedMember);
        source.putNodeMetaData((Object)type, accessedMember);
    }

    private void checkOrMarkPrivateAccess(Expression source, FieldNode fn2, boolean lhsOfAssignment) {
        if (fn2 == null) {
            return;
        }
        ClassNode enclosingClassNode = this.typeCheckingContext.getEnclosingClassNode();
        ClassNode declaringClass = fn2.getDeclaringClass();
        if (fn2.isPrivate() && (declaringClass != enclosingClassNode || this.typeCheckingContext.getEnclosingClosure() != null) && declaringClass.getModule() == enclosingClassNode.getModule()) {
            if (!lhsOfAssignment && enclosingClassNode.isDerivedFrom(declaringClass)) {
                boolean isPrimBool = fn2.getOriginType().equals(ClassHelper.boolean_TYPE);
                String suffix = Verifier.capitalize(fn2.getName());
                MethodNode getterNode = this.findValidGetter(enclosingClassNode, "get" + suffix);
                if (getterNode == null && isPrimBool) {
                    getterNode = this.findValidGetter(enclosingClassNode, "is" + suffix);
                }
                if (getterNode != null) {
                    source.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, getterNode.getReturnType());
                    return;
                }
            }
            StaticTypesMarker marker = lhsOfAssignment ? StaticTypesMarker.PV_FIELDS_MUTATION : StaticTypesMarker.PV_FIELDS_ACCESS;
            StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, declaringClass, marker, fn2);
        }
    }

    private String checkOrMarkInnerPropertyOwnerAccess(Expression source, FieldNode fn2, boolean lhsOfAssignment, String delegationData) {
        if (fn2 == null || fn2.isStatic() || fn2.isPrivate() || "delegate".equals(delegationData)) {
            return delegationData;
        }
        if (source instanceof PropertyExpression && this.typeCheckingContext.getEnclosingClosureStack().size() == 1) {
            boolean ownerProperty;
            PropertyExpression pe = (PropertyExpression)source;
            boolean bl = ownerProperty = !"this".equals(pe.getPropertyAsString());
            if (ownerProperty && pe.getObjectExpression() instanceof VariableExpression) {
                Variable accessedVariable = ((VariableExpression)pe.getObjectExpression()).getAccessedVariable();
                Variable declaredVariable = this.typeCheckingContext.getEnclosingClosure().getClosureExpression().getVariableScope().getDeclaredVariable(pe.getObjectExpression().getText());
                if (accessedVariable != null && accessedVariable == declaredVariable) {
                    ownerProperty = false;
                }
            }
            if (ownerProperty) {
                delegationData = "owner";
                pe.getObjectExpression().putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
            }
        }
        return delegationData;
    }

    private MethodNode findValidGetter(ClassNode classNode, String name2) {
        MethodNode getterMethod = classNode.getGetterMethod(name2);
        if (getterMethod != null && (getterMethod.isPublic() || getterMethod.isProtected())) {
            return getterMethod;
        }
        return null;
    }

    private void checkOrMarkPrivateAccess(Expression source, MethodNode mn) {
        ClassNode enclosingClassNode;
        if (mn == null) {
            return;
        }
        ClassNode declaringClass = mn.getDeclaringClass();
        if (declaringClass != (enclosingClassNode = this.typeCheckingContext.getEnclosingClassNode()) || this.typeCheckingContext.getEnclosingClosure() != null) {
            int mods = mn.getModifiers();
            boolean sameModule = declaringClass.getModule() == enclosingClassNode.getModule();
            String packageName = declaringClass.getPackageName();
            if (packageName == null) {
                packageName = "";
            }
            if (Modifier.isPrivate(mods) && sameModule) {
                StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, declaringClass, StaticTypesMarker.PV_METHODS_ACCESS, mn);
            } else if (Modifier.isProtected(mods) && !packageName.equals(enclosingClassNode.getPackageName()) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(enclosingClassNode, declaringClass)) {
                ClassNode cn = enclosingClassNode;
                while ((cn = cn.getOuterClass()) != null) {
                    if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(cn, declaringClass)) continue;
                    StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, cn, StaticTypesMarker.PV_METHODS_ACCESS, mn);
                    break;
                }
            }
        }
    }

    private void checkSuperCallFromClosure(Expression call2, MethodNode directCallTarget) {
        VariableExpression var;
        Expression objectExpression;
        if (call2 instanceof MethodCallExpression && this.typeCheckingContext.getEnclosingClosure() != null && (objectExpression = ((MethodCallExpression)call2).getObjectExpression()) instanceof VariableExpression && (var = (VariableExpression)objectExpression).isSuperExpression()) {
            ClassNode current = this.typeCheckingContext.getEnclosingClassNode();
            LinkedList<MethodNode> list2 = (LinkedList<MethodNode>)current.getNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED);
            if (list2 == null) {
                list2 = new LinkedList<MethodNode>();
                current.putNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED, list2);
            }
            list2.add(directCallTarget);
            call2.putNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED, current);
        }
    }

    private static ClassNode makeType(ClassNode cn, boolean usingClass) {
        if (usingClass) {
            ClassNode clazzType = ClassHelper.CLASS_Type.getPlainNodeReference();
            clazzType.setGenericsTypes(new GenericsType[]{new GenericsType(cn)});
            return clazzType;
        }
        return cn;
    }

    private boolean storeTypeForThis(VariableExpression vexp) {
        if (vexp == VariableExpression.THIS_EXPRESSION) {
            return true;
        }
        if (!vexp.isThisExpression()) {
            return false;
        }
        ClassNode enclosingClassNode = this.typeCheckingContext.getEnclosingClassNode();
        this.storeType(vexp, StaticTypeCheckingVisitor.makeType(enclosingClassNode, this.typeCheckingContext.isInStaticContext));
        return true;
    }

    private boolean storeTypeForSuper(VariableExpression vexp) {
        if (vexp == VariableExpression.SUPER_EXPRESSION) {
            return true;
        }
        if (!vexp.isSuperExpression()) {
            return false;
        }
        ClassNode superClassNode = this.typeCheckingContext.getEnclosingClassNode().getSuperClass();
        this.storeType(vexp, StaticTypeCheckingVisitor.makeType(superClassNode, this.typeCheckingContext.isInStaticContext));
        return true;
    }

    @Override
    public void visitVariableExpression(VariableExpression vexp) {
        TypeCheckingContext.EnclosingClosure enclosingClosure;
        super.visitVariableExpression(vexp);
        if (this.storeTypeForThis(vexp)) {
            return;
        }
        if (this.storeTypeForSuper(vexp)) {
            return;
        }
        Variable accessedVariable = vexp.getAccessedVariable();
        if (accessedVariable instanceof PropertyNode) {
            BinaryExpression enclosingBinaryExpression;
            if (this.tryVariableExpressionAsProperty(vexp, vexp.getName()) && (enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression()) != null) {
                Expression leftExpression = enclosingBinaryExpression.getLeftExpression();
                Expression rightExpression = enclosingBinaryExpression.getRightExpression();
                SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(leftExpression);
                if (setterInfo != null && !this.ensureValidSetter(vexp, leftExpression, rightExpression, setterInfo)) {
                    return;
                }
            }
        } else if (accessedVariable instanceof FieldNode) {
            ClassNode actualType;
            FieldNode veFieldNode;
            ClassNode owner;
            FieldNode fieldNode = (FieldNode)accessedVariable;
            Object enclosingClosure2 = this.typeCheckingContext.getEnclosingClosure();
            if (enclosingClosure2 != null && this.tryVariableExpressionAsProperty(vexp, vexp.getName()) && vexp.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER) == null && (owner = (ClassNode)vexp.getNodeMetaData((Object)StaticCompilationMetadataKeys.PROPERTY_OWNER)) != null && (veFieldNode = owner.getField(vexp.getName())) != null) {
                fieldNode = veFieldNode;
                boolean lhsOfEnclosingAssignment = this.isLHSOfEnclosingAssignment(vexp);
                vexp.setAccessedVariable(fieldNode);
                this.checkOrMarkPrivateAccess(vexp, fieldNode, lhsOfEnclosingAssignment);
            }
            if (null != (actualType = GenericsUtils.findActualTypeByGenericsPlaceholderName(fieldNode.getOriginType().getUnresolvedName(), GenericsUtils.makeDeclaringAndActualGenericsTypeMap(fieldNode.getDeclaringClass(), this.typeCheckingContext.getEnclosingClassNode())))) {
                this.storeType(vexp, actualType);
                return;
            }
        }
        if ((enclosingClosure = this.typeCheckingContext.getEnclosingClosure()) != null) {
            switch (vexp.getName()) {
                case "delegate": {
                    DelegationMetadata md = this.getDelegationMetadata(enclosingClosure.getClosureExpression());
                    if (md != null) {
                        this.storeType(vexp, md.getType());
                        return;
                    }
                }
                case "owner": {
                    if (this.typeCheckingContext.getEnclosingClosureStack().size() > 1) {
                        this.storeType(vexp, ClassHelper.CLOSURE_TYPE);
                        return;
                    }
                }
                case "thisObject": {
                    this.storeType(vexp, this.typeCheckingContext.getEnclosingClassNode());
                    return;
                }
            }
        }
        if (!(accessedVariable instanceof DynamicVariable)) {
            if (this.typeCheckingContext.getEnclosingClosure() == null) {
                ClassNode inferredType;
                VariableExpression variable2 = null;
                if (accessedVariable instanceof Parameter) {
                    variable2 = new ParameterVariableExpression((Parameter)accessedVariable);
                } else if (accessedVariable instanceof VariableExpression) {
                    variable2 = (VariableExpression)accessedVariable;
                }
                if (variable2 != null && (inferredType = this.getInferredTypeFromTempInfo(variable2, (ClassNode)variable2.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE))) != null && !inferredType.getName().equals("java.lang.Object")) {
                    vexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferredType);
                }
            }
            return;
        }
        DynamicVariable dyn = (DynamicVariable)accessedVariable;
        String dynName = dyn.getName();
        if (this.tryVariableExpressionAsProperty(vexp, dynName)) {
            return;
        }
        if (!this.extension.handleUnresolvedVariableExpression(vexp)) {
            this.addStaticTypeError("The variable [" + vexp.getName() + "] is undeclared.", vexp);
        }
    }

    private boolean tryVariableExpressionAsProperty(VariableExpression vexp, String dynName) {
        VariableExpression implicitThis = GeneralUtils.varX("this");
        PropertyExpression pe = new PropertyExpression((Expression)implicitThis, dynName);
        pe.setImplicitThis(true);
        if (this.visitPropertyExpressionSilent(pe, vexp)) {
            ClassNode previousIt = (ClassNode)vexp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            vexp.copyNodeMetaData(implicitThis);
            vexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, previousIt);
            this.storeType(vexp, this.getType(pe));
            Object val = pe.getNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
            if (val != null) {
                vexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, val);
            }
            if ((val = pe.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER)) != null) {
                vexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, val);
            }
            return true;
        }
        return false;
    }

    private boolean visitPropertyExpressionSilent(PropertyExpression pe, Expression lhsPart) {
        return this.existsProperty(pe, !this.isLHSOfEnclosingAssignment(lhsPart));
    }

    @Override
    public void visitPropertyExpression(PropertyExpression pexp) {
        this.typeCheckingContext.pushEnclosingPropertyExpression(pexp);
        try {
            if (this.visitPropertyExpressionSilent(pexp, pexp)) {
                return;
            }
            if (!this.extension.handleUnresolvedProperty(pexp)) {
                Expression objectExpression = pexp.getObjectExpression();
                this.addStaticTypeError("No such property: " + pexp.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, this.getType(objectExpression)).toString(false), pexp);
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingPropertyExpression();
        }
    }

    private boolean isLHSOfEnclosingAssignment(Expression expression2) {
        BinaryExpression ec = this.typeCheckingContext.getEnclosingBinaryExpression();
        return ec != null && ec.getLeftExpression() == expression2 && StaticTypeCheckingSupport.isAssignment(ec.getOperation().getType());
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression2) {
        super.visitAttributeExpression(expression2);
        if (!this.existsProperty(expression2, true) && !this.extension.handleUnresolvedAttribute(expression2)) {
            Expression objectExpression = expression2.getObjectExpression();
            this.addStaticTypeError("No such property: " + expression2.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, objectExpression.getType()), expression2);
        }
    }

    @Override
    public void visitRangeExpression(RangeExpression expression2) {
        super.visitRangeExpression(expression2);
        ClassNode fromType2 = ClassHelper.getWrapper(this.getType(expression2.getFrom()));
        ClassNode toType = ClassHelper.getWrapper(this.getType(expression2.getTo()));
        if (ClassHelper.Integer_TYPE.equals(fromType2) && ClassHelper.Integer_TYPE.equals(toType)) {
            this.storeType(expression2, ClassHelper.make(IntRange.class));
        } else {
            ClassNode rangeType = ClassHelper.make(Range.class).getPlainNodeReference();
            rangeType.setGenericsTypes(new GenericsType[]{new GenericsType(WideningCategories.lowestUpperBound(fromType2, toType))});
            this.storeType(expression2, rangeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitBinaryExpression(BinaryExpression expression2) {
        int op = expression2.getOperation().getType();
        if (op == 121 || op == 122) {
            return;
        }
        BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
        this.typeCheckingContext.pushEnclosingBinaryExpression(expression2);
        try {
            boolean isEmptyDeclaration;
            VariableExpression leftVar;
            ClassNode resultType;
            Expression leftExpression = expression2.getLeftExpression();
            Expression rightExpression = expression2.getRightExpression();
            leftExpression.visit(this);
            SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(leftExpression);
            if (setterInfo != null) {
                if (this.ensureValidSetter(expression2, leftExpression, rightExpression, setterInfo)) {
                    return;
                }
            } else {
                rightExpression.visit(this);
            }
            ClassNode lType = this.getType(leftExpression);
            ClassNode rType = this.getType(rightExpression);
            if (StaticTypeCheckingVisitor.isNullConstant(rightExpression) && !ClassHelper.isPrimitiveType(lType)) {
                rType = StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE;
            }
            BinaryExpression reversedBinaryExpression = GeneralUtils.binX(rightExpression, expression2.getOperation(), leftExpression);
            ClassNode classNode = resultType = op == 573 ? this.getResultType(rType, op, lType, reversedBinaryExpression) : this.getResultType(lType, op, rType, expression2);
            if (op == 573) {
                this.storeTargetMethod(expression2, (MethodNode)reversedBinaryExpression.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            } else if (op == 30 && leftExpression instanceof VariableExpression && leftExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) == null) {
                this.storeType(leftExpression, lType);
            }
            if (resultType == null) {
                resultType = lType;
            }
            if (leftExpression instanceof VariableExpression && (leftVar = (VariableExpression)leftExpression).isClosureSharedVariable()) {
                this.typeCheckingContext.secondPassExpressions.add(new SecondPassExpression(expression2));
            }
            if (lType.isUsingGenerics() && StaticTypeCheckingSupport.missesGenericsTypes(resultType) && StaticTypeCheckingSupport.isAssignment(op)) {
                ClassNode completedType;
                resultType = completedType = GenericsUtils.parameterizeType(lType, resultType.getPlainNodeReference());
            }
            if (StaticTypeCheckingSupport.isArrayOp(op) && !lType.isArray() && enclosingBinaryExpression != null && enclosingBinaryExpression.getLeftExpression() == expression2 && StaticTypeCheckingSupport.isAssignment(enclosingBinaryExpression.getOperation().getType())) {
                Expression enclosingBE_rightExpr = enclosingBinaryExpression.getRightExpression();
                if (!(enclosingBE_rightExpr instanceof ClosureExpression)) {
                    enclosingBE_rightExpr.visit(this);
                }
                ClassNode[] arguments = new ClassNode[]{rType, this.getType(enclosingBE_rightExpr)};
                List<MethodNode> nodes2 = this.findMethod(lType.redirect(), "putAt", arguments);
                if (nodes2.size() == 1) {
                    this.typeCheckMethodsWithGenericsOrFail(lType, arguments, nodes2.get(0), enclosingBE_rightExpr);
                } else if (nodes2.isEmpty()) {
                    this.addNoMatchingMethodError(lType, "putAt", arguments, enclosingBinaryExpression);
                }
            }
            boolean bl = isEmptyDeclaration = expression2 instanceof DeclarationExpression && rightExpression instanceof EmptyExpression;
            if (!isEmptyDeclaration && StaticTypeCheckingSupport.isAssignment(op)) {
                if (rightExpression instanceof ConstructorCallExpression) {
                    this.inferDiamondType((ConstructorCallExpression)rightExpression, lType);
                }
                ClassNode originType = this.getOriginalDeclarationType(leftExpression);
                this.typeCheckAssignment(expression2, leftExpression, originType, rightExpression, resultType);
                if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.getWrapper(resultType), ClassHelper.getWrapper(originType))) {
                    resultType = originType;
                } else if (lType.isUsingGenerics() && !lType.isEnum() && StaticTypeCheckingVisitor.hasRHSIncompleteGenericTypeInfo(resultType)) {
                    resultType = lType;
                }
                if (ClassHelper.isPrimitiveType(originType) && resultType.equals(ClassHelper.getWrapper(originType))) {
                    resultType = originType;
                }
                if (this.typeCheckingContext.ifElseForWhileAssignmentTracker != null && leftExpression instanceof VariableExpression && !StaticTypeCheckingVisitor.isNullConstant(rightExpression)) {
                    Variable accessedVariable = ((VariableExpression)leftExpression).getAccessedVariable();
                    if (accessedVariable instanceof Parameter) {
                        accessedVariable = new ParameterVariableExpression((Parameter)accessedVariable);
                    }
                    if (accessedVariable instanceof VariableExpression) {
                        VariableExpression var = (VariableExpression)accessedVariable;
                        List<ClassNode> types2 = this.typeCheckingContext.ifElseForWhileAssignmentTracker.get(var);
                        if (types2 == null) {
                            types2 = new LinkedList<ClassNode>();
                            ClassNode type = (ClassNode)var.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                            types2.add(type);
                            this.typeCheckingContext.ifElseForWhileAssignmentTracker.put(var, types2);
                        }
                        types2.add(resultType);
                    }
                }
                this.storeType(leftExpression, resultType);
                if (leftExpression instanceof VariableExpression) {
                    Variable targetVariable;
                    if (rightExpression instanceof ClosureExpression) {
                        Parameter[] parameters = ((ClosureExpression)rightExpression).getParameters();
                        leftExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, parameters);
                    } else if (rightExpression instanceof VariableExpression && ((VariableExpression)rightExpression).getAccessedVariable() instanceof Expression && ((Expression)((Object)((VariableExpression)rightExpression).getAccessedVariable())).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS) != null && (targetVariable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)leftExpression)) instanceof ASTNode) {
                        ((ASTNode)((Object)targetVariable)).putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, ((Expression)((Object)((VariableExpression)rightExpression).getAccessedVariable())).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS));
                    }
                }
            } else if (op == 544) {
                this.pushInstanceOfTypeInfo(leftExpression, rightExpression);
            }
            if (!isEmptyDeclaration) {
                this.storeType(expression2, resultType);
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingBinaryExpression();
        }
    }

    private boolean ensureValidSetter(Expression expression2, Expression leftExpression, Expression rightExpression, SetterInfo setterInfo) {
        VariableExpression ve = GeneralUtils.varX("%", setterInfo.receiverType);
        Expression newRightExpression = this.isCompoundAssignment(expression2) ? GeneralUtils.binX(leftExpression, this.getOpWithoutEqual(expression2), rightExpression) : rightExpression;
        MethodCallExpression call2 = GeneralUtils.callX((Expression)ve, setterInfo.name, newRightExpression);
        call2.setImplicitThis(false);
        this.visitMethodCallExpression(call2);
        MethodNode directSetterCandidate = (MethodNode)call2.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (directSetterCandidate == null) {
            for (MethodNode setter2 : setterInfo.setters) {
                ClassNode type = ClassHelper.getWrapper(setter2.getParameters()[0].getOriginType());
                if (!ClassHelper.Boolean_TYPE.equals(type) && !ClassHelper.STRING_TYPE.equals(type) && !ClassHelper.CLASS_Type.equals(type)) continue;
                call2 = GeneralUtils.callX((Expression)ve, setterInfo.name, (Expression)GeneralUtils.castX(type, newRightExpression));
                call2.setImplicitThis(false);
                this.visitMethodCallExpression(call2);
                directSetterCandidate = (MethodNode)call2.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                if (directSetterCandidate == null) continue;
                break;
            }
        }
        if (directSetterCandidate != null) {
            for (MethodNode setter2 : setterInfo.setters) {
                if (setter2 != directSetterCandidate) continue;
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directSetterCandidate);
                this.storeType(leftExpression, this.getType(newRightExpression));
                break;
            }
        } else {
            ClassNode firstSetterType = setterInfo.setters.iterator().next().getParameters()[0].getOriginType();
            this.addAssignmentError(firstSetterType, this.getType(newRightExpression), expression2);
            return true;
        }
        return false;
    }

    private boolean isCompoundAssignment(Expression exp) {
        if (!(exp instanceof BinaryExpression)) {
            return false;
        }
        int type = ((BinaryExpression)exp).getOperation().getType();
        return StaticTypeCheckingSupport.isAssignment(type) && type != 100;
    }

    private Token getOpWithoutEqual(Expression exp) {
        if (!(exp instanceof BinaryExpression)) {
            return null;
        }
        Token op = ((BinaryExpression)exp).getOperation();
        int typeWithoutEqual = TokenUtil.removeAssignment(op.getType());
        return new Token(typeWithoutEqual, op.getText(), op.getStartLine(), op.getStartColumn());
    }

    protected ClassNode getOriginalDeclarationType(Expression lhs) {
        if (lhs instanceof VariableExpression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)lhs);
            if (var instanceof PropertyNode) {
                return this.getType(lhs);
            }
            if (var instanceof DynamicVariable) {
                return this.getType(lhs);
            }
            return var.getOriginType();
        }
        if (lhs instanceof FieldExpression) {
            return ((FieldExpression)lhs).getField().getOriginType();
        }
        return this.getType(lhs);
    }

    protected void inferDiamondType(ConstructorCallExpression cce, ClassNode lType) {
        ClassNode node = cce.getType();
        if (node.isUsingGenerics() && node.getGenericsTypes() != null && node.getGenericsTypes().length == 0) {
            ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(cce.getArguments());
            if (argumentListExpression.getExpressions().isEmpty()) {
                this.adjustGenerics(lType, node);
            } else {
                ClassNode type = this.getType(argumentListExpression.getExpression(0));
                if (type.isUsingGenerics()) {
                    this.adjustGenerics(type, node);
                }
            }
            this.storeType(cce, node);
        }
    }

    private void adjustGenerics(ClassNode from2, ClassNode to2) {
        GenericsType[] genericsTypes = from2.getGenericsTypes();
        if (genericsTypes == null) {
            genericsTypes = to2.redirect().getGenericsTypes();
        }
        GenericsType[] copy = new GenericsType[genericsTypes.length];
        for (int i = 0; i < genericsTypes.length; ++i) {
            GenericsType genericsType = genericsTypes[i];
            copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
        }
        to2.setGenericsTypes(copy);
    }

    protected void pushInstanceOfTypeInfo(Expression objectOfInstanceOf, Expression typeExpression) {
        Object key;
        Map<Object, List<ClassNode>> tempo = this.typeCheckingContext.temporaryIfBranchTypeInformation.peek();
        List<ClassNode> potentialTypes = tempo.get(key = this.extractTemporaryTypeInfoKey(objectOfInstanceOf));
        if (potentialTypes == null) {
            potentialTypes = new LinkedList<ClassNode>();
            tempo.put(key, potentialTypes);
        }
        potentialTypes.add(typeExpression.getType());
    }

    private boolean typeCheckMultipleAssignmentAndContinue(Expression leftExpression, Expression rightExpression) {
        if (!(leftExpression instanceof TupleExpression)) {
            return true;
        }
        if (!(rightExpression instanceof ListExpression)) {
            this.addStaticTypeError("Multiple assignments without list expressions on the right hand side are unsupported in static type checking mode", rightExpression);
            return false;
        }
        TupleExpression tuple2 = (TupleExpression)leftExpression;
        ListExpression list2 = (ListExpression)rightExpression;
        List<Expression> listExpressions = list2.getExpressions();
        List<Expression> tupleExpressions = tuple2.getExpressions();
        if (listExpressions.size() < tupleExpressions.size()) {
            this.addStaticTypeError("Incorrect number of values. Expected:" + tupleExpressions.size() + " Was:" + listExpressions.size(), list2);
            return false;
        }
        int tupleExpressionsSize = tupleExpressions.size();
        for (int i = 0; i < tupleExpressionsSize; ++i) {
            ClassNode tupleType;
            Expression tupleExpression = tupleExpressions.get(i);
            Expression listExpression = listExpressions.get(i);
            ClassNode elemType = this.getType(listExpression);
            if (!StaticTypeCheckingSupport.isAssignableTo(elemType, tupleType = this.getType(tupleExpression))) {
                this.addStaticTypeError("Cannot assign value of type " + elemType.toString(false) + " to variable of type " + tupleType.toString(false), rightExpression);
                return false;
            }
            this.storeType(tupleExpression, elemType);
        }
        return true;
    }

    private static ClassNode adjustTypeForSpreading(ClassNode inferredRightExpressionType, Expression leftExpression) {
        ClassNode wrappedRHS = inferredRightExpressionType;
        if (leftExpression instanceof PropertyExpression && ((PropertyExpression)leftExpression).isSpreadSafe()) {
            wrappedRHS = ClassHelper.LIST_TYPE.getPlainNodeReference();
            wrappedRHS.setGenericsTypes(new GenericsType[]{new GenericsType(ClassHelper.getWrapper(inferredRightExpressionType))});
        }
        return wrappedRHS;
    }

    private boolean addedReadOnlyPropertyError(Expression expr2) {
        if (expr2.getNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY) == null) {
            return false;
        }
        String name2 = expr2 instanceof VariableExpression ? ((VariableExpression)expr2).getName() : ((PropertyExpression)expr2).getPropertyAsString();
        this.addStaticTypeError("Cannot set read-only property: " + name2, expr2);
        return true;
    }

    private void addPrecisionErrors(ClassNode leftRedirect, ClassNode lhsType, ClassNode inferredrhsType, Expression rightExpression) {
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(inferredrhsType) && StaticTypeCheckingSupport.checkPossibleLossOfPrecision(leftRedirect, inferredrhsType, rightExpression)) {
            this.addStaticTypeError("Possible loss of precision from " + inferredrhsType + " to " + leftRedirect, rightExpression);
            return;
        }
        if (!lhsType.isArray()) {
            return;
        }
        ClassNode leftComponentType = lhsType.getComponentType();
        ClassNode rightRedirect = rightExpression.getType().redirect();
        if (rightRedirect.isArray()) {
            ClassNode rightComponentType = rightRedirect.getComponentType();
            if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType, rightComponentType)) {
                this.addStaticTypeError("Cannot assign value of type " + rightComponentType.toString(false) + " into array of type " + lhsType.toString(false), rightExpression);
            }
        } else if (rightExpression instanceof ListExpression) {
            for (Expression element : ((ListExpression)rightExpression).getExpressions()) {
                ClassNode rightComponentType = this.getType(element);
                if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType, rightComponentType) || StaticTypeCheckingVisitor.isNullConstant(element) && !ClassHelper.isPrimitiveType(leftComponentType)) continue;
                this.addStaticTypeError("Cannot assign value of type " + rightComponentType.toString(false) + " into array of type " + lhsType.toString(false), rightExpression);
            }
        }
    }

    private void addListAssignmentConstructorErrors(ClassNode leftRedirect, ClassNode leftExpressionType, ClassNode inferredRightExpressionType, Expression rightExpression, Expression assignmentExpression) {
        if (rightExpression instanceof ListExpression && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.LIST_TYPE, leftRedirect)) {
            ArgumentListExpression argList = GeneralUtils.args(((ListExpression)rightExpression).getExpressions());
            ClassNode[] args2 = this.getArgumentTypes(argList);
            MethodNode methodNode = this.checkGroovyStyleConstructor(leftRedirect, args2, assignmentExpression);
            if (methodNode != null) {
                rightExpression.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, methodNode);
            }
        } else if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, leftRedirect) && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, ClassHelper.LIST_TYPE) && !StaticTypeCheckingSupport.isWildcardLeftHandSide(leftExpressionType) && !this.extension.handleIncompatibleAssignment(leftExpressionType, inferredRightExpressionType, assignmentExpression)) {
            this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression);
        }
    }

    private void addMapAssignmentConstructorErrors(ClassNode leftRedirect, Expression leftExpression, Expression rightExpression) {
        if (!(StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.MAP_TYPE) || !(rightExpression instanceof MapExpression) || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isDynamicTyped())) {
            ArgumentListExpression argList = GeneralUtils.args(rightExpression);
            ClassNode[] argTypes = this.getArgumentTypes(argList);
            this.checkGroovyStyleConstructor(leftRedirect, argTypes, rightExpression);
            MapExpression mapExpression = (MapExpression)rightExpression;
            this.checkGroovyConstructorMap(leftExpression, leftRedirect, mapExpression);
        }
    }

    private void checkTypeGenerics(ClassNode leftExpressionType, ClassNode wrappedRHS, Expression rightExpression) {
        if (!leftExpressionType.isUsingGenerics()) {
            return;
        }
        if (StaticTypeCheckingVisitor.hasRHSIncompleteGenericTypeInfo(wrappedRHS)) {
            return;
        }
        GenericsType gt = GenericsUtils.buildWildcardType(leftExpressionType);
        if (StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE.equals(wrappedRHS) || gt.isCompatibleWith(wrappedRHS) || StaticTypeCheckingVisitor.isNullConstant(rightExpression)) {
            return;
        }
        this.addStaticTypeError("Incompatible generic argument types. Cannot assign " + wrappedRHS.toString(false) + " to: " + leftExpressionType.toString(false), rightExpression);
    }

    private boolean hasGStringStringError(ClassNode leftExpressionType, ClassNode wrappedRHS, Expression rightExpression) {
        if (StaticTypeCheckingSupport.isParameterizedWithString(leftExpressionType) && StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(wrappedRHS)) {
            this.addStaticTypeError("You are trying to use a GString in place of a String in a type which explicitly declares accepting String. Make sure to call toString() on all GString values.", rightExpression);
            return true;
        }
        return false;
    }

    protected void typeCheckAssignment(BinaryExpression assignmentExpression, Expression leftExpression, ClassNode leftExpressionType, Expression rightExpression, ClassNode inferredRightExpressionTypeOrig) {
        ClassNode wrappedRHS;
        boolean compatible;
        ClassNode inferredRightExpressionType = inferredRightExpressionTypeOrig;
        if (!this.typeCheckMultipleAssignmentAndContinue(leftExpression, rightExpression)) {
            return;
        }
        if (leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).getAccessedVariable() instanceof FieldNode) {
            this.checkOrMarkPrivateAccess(leftExpression, (FieldNode)((VariableExpression)leftExpression).getAccessedVariable(), true);
        }
        if (this.addedReadOnlyPropertyError(leftExpression)) {
            return;
        }
        ClassNode leftRedirect = leftExpressionType.redirect();
        if (rightExpression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(rightExpression) && assignmentExpression.getOperation().getType() == 100) {
            inferredRightExpressionType = (ClassNode)rightExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        }
        if (!(compatible = StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect, wrappedRHS = StaticTypeCheckingVisitor.adjustTypeForSpreading(inferredRightExpressionType, leftExpression), rightExpression))) {
            if (!this.extension.handleIncompatibleAssignment(leftExpressionType, inferredRightExpressionType, assignmentExpression)) {
                this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression.getRightExpression());
            }
        } else {
            this.addPrecisionErrors(leftRedirect, leftExpressionType, inferredRightExpressionType, rightExpression);
            this.addListAssignmentConstructorErrors(leftRedirect, leftExpressionType, inferredRightExpressionType, rightExpression, assignmentExpression);
            this.addMapAssignmentConstructorErrors(leftRedirect, leftExpression, rightExpression);
            if (this.hasGStringStringError(leftExpressionType, wrappedRHS, rightExpression)) {
                return;
            }
            this.checkTypeGenerics(leftExpressionType, wrappedRHS, rightExpression);
        }
    }

    protected void checkGroovyConstructorMap(Expression receiver, ClassNode receiverType, MapExpression mapExpression) {
        this.typeCheckingContext.pushEnclosingBinaryExpression(null);
        for (MapEntryExpression entryExpression : mapExpression.getMapEntryExpressions()) {
            MethodNode setter2;
            ClassNode toBeAssignedTo;
            Expression keyExpr = entryExpression.getKeyExpression();
            if (!(keyExpr instanceof ConstantExpression)) {
                this.addStaticTypeError("Dynamic keys in map-style constructors are unsupported in static type checking", keyExpr);
                continue;
            }
            AtomicReference<ClassNode> lookup2 = new AtomicReference<ClassNode>();
            PropertyExpression pexp = new PropertyExpression((Expression)GeneralUtils.varX("_", receiverType), keyExpr.getText());
            boolean hasProperty = this.existsProperty(pexp, false, new PropertyLookupVisitor(lookup2));
            if (!hasProperty) {
                this.addStaticTypeError("No such property: " + keyExpr.getText() + " for class: " + receiverType.getName(), receiver);
                continue;
            }
            ClassNode valueType = this.getType(entryExpression.getValueExpression());
            if (StaticTypeCheckingSupport.isAssignableTo(valueType, toBeAssignedTo = (setter2 = receiverType.getSetterMethod("set" + MetaClassHelper.capitalize(pexp.getPropertyAsString()), false)) == null ? lookup2.get() : setter2.getParameters()[0].getType()) || this.extension.handleIncompatibleAssignment(toBeAssignedTo, valueType, entryExpression)) continue;
            this.addAssignmentError(toBeAssignedTo, valueType, entryExpression);
        }
        this.typeCheckingContext.popEnclosingBinaryExpression();
    }

    protected static boolean hasRHSIncompleteGenericTypeInfo(ClassNode inferredRightExpressionType) {
        boolean replaceType = false;
        GenericsType[] genericsTypes = inferredRightExpressionType.getGenericsTypes();
        if (genericsTypes != null) {
            for (GenericsType genericsType : genericsTypes) {
                if (!genericsType.isPlaceholder()) continue;
                replaceType = true;
                break;
            }
        }
        return replaceType;
    }

    @Deprecated
    protected void checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments) {
        this.checkGroovyStyleConstructor(node, arguments, this.typeCheckingContext.getEnclosingClassNode());
    }

    protected MethodNode checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments, ASTNode source) {
        if (node.equals(ClassHelper.OBJECT_TYPE) || node.equals(ClassHelper.DYNAMIC_TYPE)) {
            return null;
        }
        List<ConstructorNode> constructors2 = node.getDeclaredConstructors();
        if (constructors2.isEmpty() && arguments.length == 0) {
            return null;
        }
        List<MethodNode> constructorList = this.findMethod(node, "<init>", arguments);
        if (constructorList.isEmpty()) {
            if (StaticTypeCheckingSupport.isBeingCompiled(node) && arguments.length == 1 && LINKEDHASHMAP_CLASSNODE.equals(arguments[0])) {
                ConstructorNode cn = new ConstructorNode(1, new Parameter[]{new Parameter(LINKEDHASHMAP_CLASSNODE, "args")}, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                return cn;
            }
            this.addStaticTypeError("No matching constructor found: " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), source);
            return null;
        }
        if (constructorList.size() > 1) {
            this.addStaticTypeError("Ambiguous constructor call " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), source);
            return null;
        }
        return constructorList.get(0);
    }

    protected Object extractTemporaryTypeInfoKey(Expression expression2) {
        return expression2 instanceof VariableExpression ? StaticTypeCheckingSupport.findTargetVariable((VariableExpression)expression2) : expression2.getText();
    }

    protected ClassNode findCurrentInstanceOfClass(Expression expr2, ClassNode type) {
        List<ClassNode> nodes2;
        if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.empty() && (nodes2 = this.getTemporaryTypesForExpression(expr2)) != null && nodes2.size() == 1) {
            return nodes2.get(0);
        }
        return type;
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly) {
        return this.existsProperty(pexp, checkForReadOnly, null);
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean readMode, ClassCodeVisitorSupport visitor) {
        ClassNode testClass;
        super.visitPropertyExpression(pexp);
        String propertyName = pexp.getPropertyAsString();
        if (propertyName == null) {
            return false;
        }
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode objectExpressionType = this.getType(objectExpression);
        boolean staticOnlyAccess = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(objectExpressionType);
        if ("this".equals(propertyName) && staticOnlyAccess) {
            ClassNode outerNode = objectExpressionType.getGenericsTypes()[0].getType();
            List<ClassNode> candidates = this.typeCheckingContext.getEnclosingClassNodes();
            ClassNode found = null;
            for (ClassNode current : candidates) {
                if (current.isStaticClass() || !(current instanceof InnerClassNode) || !outerNode.equals(current.getOuterClass())) continue;
                found = current;
                break;
            }
            if (found != null) {
                this.storeType(pexp, outerNode);
                return true;
            }
        }
        if (objectExpressionType.isArray() && "length".equals(pexp.getPropertyAsString())) {
            this.storeType(pexp, ClassHelper.int_TYPE);
            if (visitor != null) {
                PropertyNode node = new PropertyNode("length", 17, ClassHelper.int_TYPE, objectExpressionType, null, null, null);
                visitor.visitProperty(node);
            }
            return true;
        }
        boolean foundGetterOrSetter = false;
        LinkedList<Receiver<String>> receivers = new LinkedList<Receiver<String>>();
        List<Receiver<String>> owners = this.makeOwnerList(objectExpression);
        this.addReceivers(receivers, owners, pexp.isImplicitThis());
        String capName = MetaClassHelper.capitalize(propertyName);
        boolean isAttributeExpression = pexp instanceof AttributeExpression;
        HashSet<ClassNode> handledNodes = new HashSet<ClassNode>();
        for (Receiver receiver : receivers) {
            testClass = receiver.getType();
            LinkedList<ClassNode> queue = new LinkedList<ClassNode>();
            queue.add(testClass);
            if (ClassHelper.isPrimitiveType(testClass)) {
                queue.add(ClassHelper.getWrapper(testClass));
            }
            while (!queue.isEmpty()) {
                boolean checkGetterOrSetter;
                ClassNode current = (ClassNode)queue.removeFirst();
                if (handledNodes.contains(current)) continue;
                handledNodes.add(current);
                Set<ClassNode> allInterfaces = current.getAllInterfaces();
                for (ClassNode intf : allInterfaces) {
                    queue.add(GenericsUtils.parameterizeType(current, intf));
                }
                boolean staticOnly = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(current) ? false : staticOnlyAccess;
                FieldNode field2 = current.getDeclaredField(propertyName);
                if (this.storeField(field2 = this.allowStaticAccessToMember(field2, staticOnly), isAttributeExpression, pexp, current, visitor, (String)receiver.getData(), !readMode)) {
                    return true;
                }
                boolean isThisExpression = objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).isThisExpression() && objectExpressionType.equals(current);
                if (this.storeField(field2, isThisExpression, pexp, receiver.getType(), visitor, (String)receiver.getData(), !readMode)) {
                    return true;
                }
                MethodNode getter2 = this.findGetter(current, "get" + capName, pexp.isImplicitThis());
                if ((getter2 = this.allowStaticAccessToMember(getter2, staticOnly)) == null) {
                    getter2 = this.findGetter(current, "is" + capName, pexp.isImplicitThis());
                }
                getter2 = this.allowStaticAccessToMember(getter2, staticOnly);
                String setterName = "set" + capName;
                List<MethodNode> setters = StaticTypeCheckingSupport.findSetters(current, setterName, false);
                setters = this.allowStaticAccessToMember(setters, staticOnly);
                if (visitor != null && getter2 != null) {
                    visitor.visitMethod(getter2);
                }
                PropertyNode propertyNode = current.getProperty(propertyName);
                propertyNode = this.allowStaticAccessToMember(propertyNode, staticOnly);
                boolean bl = checkGetterOrSetter = !isThisExpression || propertyNode == null;
                if (readMode && checkGetterOrSetter) {
                    if (getter2 != null) {
                        ClassNode cn = this.inferReturnTypeGenerics(current, getter2, ArgumentListExpression.EMPTY_ARGUMENTS);
                        this.storeInferredTypeForPropertyExpression(pexp, cn);
                        this.storeTargetMethod(pexp, getter2);
                        pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                        String delegationData = (String)receiver.getData();
                        if (delegationData != null) {
                            pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
                        }
                        return true;
                    }
                } else if (!readMode && checkGetterOrSetter) {
                    if (!setters.isEmpty()) {
                        String delegationData;
                        if (visitor != null) {
                            if (field2 != null) {
                                visitor.visitField(field2);
                            } else {
                                for (MethodNode setter2 : setters) {
                                    ClassNode setterType = setter2.getParameters()[0].getOriginType();
                                    FieldNode virtual = new FieldNode(propertyName, 0, setterType, current, EmptyExpression.INSTANCE);
                                    visitor.visitField(virtual);
                                }
                            }
                        }
                        SetterInfo info2 = new SetterInfo(current, setterName, setters);
                        BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
                        if (enclosingBinaryExpression != null) {
                            StaticTypeCheckingVisitor.putSetterInfo(enclosingBinaryExpression.getLeftExpression(), info2);
                        }
                        if ((delegationData = (String)receiver.getData()) != null) {
                            pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
                        }
                        return true;
                    }
                    if (getter2 != null && propertyNode == null) {
                        pexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, true);
                    }
                }
                boolean bl2 = foundGetterOrSetter = foundGetterOrSetter || !setters.isEmpty() || getter2 != null;
                if (this.storeProperty(propertyNode, pexp, current, visitor, (String)receiver.getData())) {
                    return true;
                }
                if (this.storeField(field2, true, pexp, current, visitor, (String)receiver.getData(), !readMode)) {
                    return true;
                }
                if (current.getSuperClass() == null) continue;
                queue.add(current.getUnresolvedSuperClass());
            }
            ArrayList<ClassNode> dgmReceivers = new ArrayList<ClassNode>(2);
            dgmReceivers.add(testClass);
            if (ClassHelper.isPrimitiveType(testClass)) {
                dgmReceivers.add(ClassHelper.getWrapper(testClass));
            }
            for (ClassNode dgmReceiver : dgmReceivers) {
                List<MethodNode> methodNodes;
                List<MethodNode> methods2 = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getTransformLoader(), dgmReceiver, "get" + capName, ClassNode.EMPTY_ARRAY);
                for (MethodNode m : StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getTransformLoader(), dgmReceiver, "is" + capName, ClassNode.EMPTY_ARRAY)) {
                    if (!ClassHelper.Boolean_TYPE.equals(ClassHelper.getWrapper(m.getReturnType()))) continue;
                    methods2.add(m);
                }
                if (methods2.isEmpty() || (methodNodes = StaticTypeCheckingSupport.chooseBestMethod(dgmReceiver, methods2, ClassNode.EMPTY_ARRAY)).size() != 1) continue;
                MethodNode getter2 = methodNodes.get(0);
                if (visitor != null) {
                    visitor.visitMethod(getter2);
                }
                ClassNode cn = this.inferReturnTypeGenerics(dgmReceiver, getter2, ArgumentListExpression.EMPTY_ARGUMENTS);
                this.storeInferredTypeForPropertyExpression(pexp, cn);
                this.storeTargetMethod(pexp, getter2);
                return true;
            }
        }
        for (Receiver receiver : receivers) {
            testClass = receiver.getType();
            ClassNode propertyType = this.getTypeForMapPropertyExpression(testClass, objectExpressionType, pexp);
            if (propertyType == null) {
                propertyType = this.getTypeForListPropertyExpression(testClass, objectExpressionType, pexp);
            }
            if (propertyType == null) {
                propertyType = this.getTypeForSpreadExpression(testClass, objectExpressionType, pexp);
            }
            if (propertyType == null) continue;
            if (visitor != null) {
                PropertyNode node = new PropertyNode(propertyName, 1, propertyType, receiver.getType(), null, null, null);
                node.setDeclaringClass(receiver.getType());
                visitor.visitProperty(node);
            }
            this.storeType(pexp, propertyType);
            String delegationData = (String)receiver.getData();
            if (delegationData != null) {
                pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
            }
            return true;
        }
        return foundGetterOrSetter;
    }

    private MethodNode findGetter(ClassNode current, String name2, boolean searchOuterClasses) {
        MethodNode getterMethod = current.getGetterMethod(name2);
        if (getterMethod == null && searchOuterClasses && current instanceof InnerClassNode) {
            return this.findGetter(current.getOuterClass(), name2, true);
        }
        return getterMethod;
    }

    private ClassNode getTypeForSpreadExpression(ClassNode testClass, ClassNode objectExpressionType, PropertyExpression pexp) {
        AtomicReference<ClassNode> result2;
        PropertyExpression subExp;
        if (!pexp.isSpreadSafe()) {
            return null;
        }
        MethodCallExpression mce = GeneralUtils.callX((Expression)GeneralUtils.varX("_", testClass), "iterator", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
        mce.setImplicitThis(false);
        mce.visit(this);
        ClassNode callType = this.getType(mce);
        if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(callType, ClassHelper.Iterator_TYPE)) {
            return null;
        }
        GenericsType[] types2 = callType.getGenericsTypes();
        ClassNode contentType = ClassHelper.OBJECT_TYPE;
        if (types2 != null && types2.length == 1) {
            contentType = types2[0].getType();
        }
        if (this.existsProperty(subExp = new PropertyExpression((Expression)GeneralUtils.varX("{}", contentType), pexp.getPropertyAsString()), true, new PropertyLookupVisitor(result2 = new AtomicReference<ClassNode>()))) {
            ClassNode intf = ClassHelper.LIST_TYPE.getPlainNodeReference();
            intf.setGenericsTypes(new GenericsType[]{new GenericsType(ClassHelper.getWrapper(result2.get()))});
            return intf;
        }
        return null;
    }

    private ClassNode getTypeForListPropertyExpression(ClassNode testClass, ClassNode objectExpressionType, PropertyExpression pexp) {
        AtomicReference<ClassNode> result2;
        if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.LIST_TYPE)) {
            return null;
        }
        ClassNode intf = GenericsUtils.parameterizeType(objectExpressionType, ClassHelper.LIST_TYPE.getPlainNodeReference());
        GenericsType[] types2 = intf.getGenericsTypes();
        if (types2 == null || types2.length != 1) {
            return ClassHelper.OBJECT_TYPE;
        }
        PropertyExpression subExp = new PropertyExpression((Expression)GeneralUtils.varX("{}", types2[0].getType()), pexp.getPropertyAsString());
        if (this.existsProperty(subExp, true, new PropertyLookupVisitor(result2 = new AtomicReference<ClassNode>()))) {
            intf = ClassHelper.LIST_TYPE.getPlainNodeReference();
            ClassNode itemType = result2.get();
            intf.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(itemType))});
            return intf;
        }
        return null;
    }

    private ClassNode getTypeForMapPropertyExpression(ClassNode testClass, ClassNode objectExpressionType, PropertyExpression pexp) {
        if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.MAP_TYPE)) {
            return null;
        }
        ClassNode intf = objectExpressionType.getGenericsTypes() != null ? GenericsUtils.parameterizeType(objectExpressionType, ClassHelper.MAP_TYPE.getPlainNodeReference()) : ClassHelper.MAP_TYPE.getPlainNodeReference();
        GenericsType[] types2 = intf.getGenericsTypes();
        if (types2 == null || types2.length != 2) {
            return ClassHelper.OBJECT_TYPE;
        }
        if (pexp.isSpreadSafe()) {
            if ("key".equals(pexp.getPropertyAsString())) {
                ClassNode listKey = ClassHelper.LIST_TYPE.getPlainNodeReference();
                listKey.setGenericsTypes(new GenericsType[]{types2[0]});
                return listKey;
            }
            if ("value".equals(pexp.getPropertyAsString())) {
                ClassNode listValue = ClassHelper.LIST_TYPE.getPlainNodeReference();
                listValue.setGenericsTypes(new GenericsType[]{types2[1]});
                return listValue;
            }
        } else {
            return types2[1].getType();
        }
        this.addStaticTypeError("Spread operator on map only allows one of [key,value]", pexp);
        return null;
    }

    private <T> T allowStaticAccessToMember(T member2, boolean staticOnly) {
        boolean isStatic;
        if (member2 == null) {
            return null;
        }
        if (!staticOnly) {
            return member2;
        }
        if (member2 instanceof Variable) {
            Variable v = (Variable)member2;
            isStatic = Modifier.isStatic(v.getModifiers());
        } else {
            if (member2 instanceof List) {
                List list2 = (List)member2;
                if (list2.size() == 1) {
                    return (T)Collections.singletonList(this.allowStaticAccessToMember(list2.get(0), staticOnly));
                }
                return (T)Collections.emptyList();
            }
            MethodNode mn = (MethodNode)member2;
            isStatic = mn.isStatic();
        }
        if (staticOnly && !isStatic) {
            return null;
        }
        return member2;
    }

    private void storeWithResolve(ClassNode typeToResolve, ClassNode receiver, ClassNode declaringClass, boolean isStatic, PropertyExpression expressionToStoreOn) {
        ClassNode type = typeToResolve;
        if (StaticTypeCheckingSupport.getGenericsWithoutArray(type) != null) {
            Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = this.resolvePlaceHoldersFromDeclaration(receiver, declaringClass, null, isStatic);
            type = this.resolveGenericsWithContext(resolvedPlaceholders, type);
        }
        this.storeInferredTypeForPropertyExpression(expressionToStoreOn, type);
        this.storeType(expressionToStoreOn, type);
    }

    private boolean storeField(FieldNode field2, boolean returnTrueIfFieldExists, PropertyExpression expressionToStoreOn, ClassNode receiver, ClassCodeVisitorSupport visitor, String delegationData, boolean lhsOfAssignment) {
        if (field2 == null || !returnTrueIfFieldExists) {
            return false;
        }
        if (visitor != null) {
            visitor.visitField(field2);
        }
        this.storeWithResolve(field2.getOriginType(), receiver, field2.getDeclaringClass(), field2.isStatic(), expressionToStoreOn);
        this.checkOrMarkPrivateAccess(expressionToStoreOn, field2, lhsOfAssignment);
        delegationData = this.checkOrMarkInnerPropertyOwnerAccess(expressionToStoreOn, field2, lhsOfAssignment, delegationData);
        if (delegationData != null) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
        }
        return true;
    }

    private boolean storeProperty(PropertyNode propertyNode, PropertyExpression expressionToStoreOn, ClassNode receiver, ClassCodeVisitorSupport visitor, String delegationData) {
        if (propertyNode == null) {
            return false;
        }
        if (visitor != null) {
            visitor.visitProperty(propertyNode);
        }
        this.storeWithResolve(propertyNode.getOriginType(), receiver, propertyNode.getDeclaringClass(), propertyNode.isStatic(), expressionToStoreOn);
        if (delegationData != null) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
        }
        return true;
    }

    protected void storeInferredTypeForPropertyExpression(PropertyExpression pexp, ClassNode flatInferredType) {
        if (pexp.isSpreadSafe()) {
            ClassNode list2 = ClassHelper.LIST_TYPE.getPlainNodeReference();
            list2.setGenericsTypes(new GenericsType[]{new GenericsType(flatInferredType)});
            this.storeType(pexp, list2);
        } else {
            this.storeType(pexp, flatInferredType);
        }
    }

    @Deprecated
    protected SetterInfo hasSetter(PropertyExpression pexp) {
        String propertyName = pexp.getPropertyAsString();
        if (propertyName == null) {
            return null;
        }
        Expression objectExpression = pexp.getObjectExpression();
        LinkedList<Receiver<String>> receivers = new LinkedList<Receiver<String>>();
        List<Receiver<String>> owners = this.makeOwnerList(objectExpression);
        this.addReceivers(receivers, owners, pexp.isImplicitThis());
        String capName = MetaClassHelper.capitalize(propertyName);
        boolean isAttributeExpression = pexp instanceof AttributeExpression;
        for (Receiver receiver : receivers) {
            ClassNode testClass = receiver.getType();
            LinkedList<ClassNode> queue = new LinkedList<ClassNode>();
            queue.add(testClass);
            if (testClass.isInterface()) {
                queue.addAll(testClass.getAllInterfaces());
            }
            while (!queue.isEmpty()) {
                String setterName;
                ClassNode current = (ClassNode)queue.removeFirst();
                List<MethodNode> setterMethods = StaticTypeCheckingSupport.findSetters(current = current.redirect(), setterName = "set" + capName, false);
                if (!setterMethods.isEmpty()) {
                    return new SetterInfo(current, setterName, setterMethods);
                }
                if (isAttributeExpression || current.getSuperClass() == null) continue;
                queue.add(current.getSuperClass());
            }
        }
        return null;
    }

    @Override
    public void visitProperty(PropertyNode node) {
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isInStaticContext();
            this.currentProperty = node;
            super.visitProperty(node);
        }
        finally {
            this.currentProperty = null;
            this.typeCheckingContext.isInStaticContext = osc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitField(FieldNode node) {
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isInStaticContext();
            this.currentField = node;
            super.visitField(node);
            Expression init2 = node.getInitialExpression();
            if (init2 != null) {
                FieldExpression left = new FieldExpression(node);
                BinaryExpression bexp = GeneralUtils.binX(left, Token.newSymbol("=", node.getLineNumber(), node.getColumnNumber()), init2);
                bexp.setSourcePosition(init2);
                this.typeCheckAssignment(bexp, left, node.getOriginType(), init2, this.getType(init2));
                if (init2 instanceof ConstructorCallExpression) {
                    this.inferDiamondType((ConstructorCallExpression)init2, node.getOriginType());
                }
            }
        }
        finally {
            this.currentField = null;
            this.typeCheckingContext.isInStaticContext = osc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitForLoop(ForStatement forLoop) {
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        forLoop.getLoopBlock().visit(new VariableExpressionTypeMemoizer(varOrigType));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        Expression collectionExpression = forLoop.getCollectionExpression();
        if (collectionExpression instanceof ClosureListExpression) {
            super.visitForLoop(forLoop);
        } else {
            collectionExpression.visit(this);
            ClassNode collectionType = this.getType(collectionExpression);
            ClassNode forLoopVariableType = forLoop.getVariableType();
            ClassNode componentType = ClassHelper.Character_TYPE.equals(ClassHelper.getWrapper(forLoopVariableType)) && ClassHelper.STRING_TYPE.equals(collectionType) ? forLoopVariableType : StaticTypeCheckingVisitor.inferLoopElementType(collectionType);
            if (ClassHelper.getUnwrapper(componentType) == forLoopVariableType) {
                componentType = forLoopVariableType;
            }
            if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(forLoopVariableType, componentType)) {
                this.addStaticTypeError("Cannot loop with element of type " + forLoopVariableType.toString(false) + " with collection of type " + collectionType.toString(false), forLoop);
            }
            if (forLoopVariableType != ClassHelper.DYNAMIC_TYPE) {
                componentType = forLoopVariableType;
            }
            this.typeCheckingContext.controlStructureVariables.put(forLoop.getVariable(), componentType);
            try {
                super.visitForLoop(forLoop);
            }
            finally {
                this.typeCheckingContext.controlStructureVariables.remove(forLoop.getVariable());
            }
        }
        boolean typeChanged = this.isSecondPassNeededForControlStructure(varOrigType, oldTracker);
        if (typeChanged) {
            this.visitForLoop(forLoop);
        }
    }

    public static ClassNode inferLoopElementType(ClassNode collectionType) {
        ClassNode componentType = collectionType.getComponentType();
        if (componentType == null) {
            if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ITERABLE_TYPE)) {
                ClassNode intf = GenericsUtils.parameterizeType(collectionType, ITERABLE_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = genericsTypes[0].getType();
            } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ClassHelper.MAP_TYPE)) {
                ClassNode intf = GenericsUtils.parameterizeType(collectionType, ClassHelper.MAP_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = MAP_ENTRY_TYPE.getPlainNodeReference();
                componentType.setGenericsTypes(genericsTypes);
            } else if (ClassHelper.STRING_TYPE.equals(collectionType)) {
                componentType = ClassHelper.STRING_TYPE;
            } else if (ENUMERATION_TYPE.equals(collectionType)) {
                ClassNode intf = GenericsUtils.parameterizeType(collectionType, ENUMERATION_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = genericsTypes[0].getType();
            } else {
                componentType = ClassHelper.OBJECT_TYPE;
            }
        }
        return componentType;
    }

    protected boolean isSecondPassNeededForControlStructure(Map<VariableExpression, ClassNode> varOrigType, Map<VariableExpression, List<ClassNode>> oldTracker) {
        Map<VariableExpression, ClassNode> assignedVars = this.popAssignmentTracking(oldTracker);
        for (Map.Entry<VariableExpression, ClassNode> entry2 : assignedVars.entrySet()) {
            Variable key = StaticTypeCheckingSupport.findTargetVariable(entry2.getKey());
            if (!(key instanceof VariableExpression)) continue;
            ClassNode origType = varOrigType.get(key);
            ClassNode newType = entry2.getValue();
            if (!varOrigType.containsKey(key) || newType.equals(origType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitWhileLoop(WhileStatement loop2) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        super.visitWhileLoop(loop2);
        this.popAssignmentTracking(oldTracker);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression2) {
        MethodNode mn;
        super.visitBitwiseNegationExpression(expression2);
        ClassNode type = this.getType(expression2);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isBigIntCategory(typeRe) ? type : (typeRe == ClassHelper.STRING_TYPE || typeRe == ClassHelper.GSTRING_TYPE ? ClassHelper.PATTERN_TYPE : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : (typeRe.equals(ClassHelper.PATTERN_TYPE) ? ClassHelper.PATTERN_TYPE : ((mn = this.findMethodOrFail(expression2, type, "bitwiseNegate", new ClassNode[0])) != null ? mn.getReturnType() : ClassHelper.OBJECT_TYPE))));
        this.storeType(expression2, resultType);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression2) {
        super.visitUnaryPlusExpression(expression2);
        this.negativeOrPositiveUnary(expression2, "positive");
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression2) {
        super.visitUnaryMinusExpression(expression2);
        this.negativeOrPositiveUnary(expression2, "negative");
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression2) {
        super.visitPostfixExpression(expression2);
        Expression inner2 = expression2.getExpression();
        int op = expression2.getOperation().getType();
        this.visitPrefixOrPostifExpression(expression2, inner2, op);
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression2) {
        super.visitPrefixExpression(expression2);
        Expression inner2 = expression2.getExpression();
        int type = expression2.getOperation().getType();
        this.visitPrefixOrPostifExpression(expression2, inner2, type);
    }

    private static ClassNode getMathWideningClassNode(ClassNode type) {
        if (ClassHelper.byte_TYPE.equals(type) || ClassHelper.short_TYPE.equals(type) || ClassHelper.int_TYPE.equals(type)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(type) || ClassHelper.Short_TYPE.equals(type) || ClassHelper.Integer_TYPE.equals(type)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(type)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(type)) {
            return ClassHelper.Double_TYPE;
        }
        return type;
    }

    private void visitPrefixOrPostifExpression(Expression origin2, Expression innerExpression, int operationType) {
        MethodNode node;
        String name2;
        boolean isPostfix = origin2 instanceof PostfixExpression;
        ClassNode exprType = this.getType(innerExpression);
        String string2 = operationType == 250 ? "next" : (name2 = operationType == 260 ? "previous" : null);
        if (ClassHelper.isPrimitiveType(exprType) || ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(exprType))) {
            if (operationType == 250 || operationType == 260) {
                MethodNode node2;
                if (!ClassHelper.isPrimitiveType(exprType) && (node2 = this.findMethodOrFail(GeneralUtils.varX("_dummy_", exprType), exprType, name2, new ClassNode[0])) != null) {
                    this.storeTargetMethod(origin2, node2);
                    this.storeType(origin2, isPostfix ? exprType : StaticTypeCheckingVisitor.getMathWideningClassNode(exprType));
                    return;
                }
                this.storeType(origin2, exprType);
                return;
            }
            this.addUnsupportedPreOrPostfixExpressionError(origin2);
            return;
        }
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(exprType, ClassHelper.Number_TYPE) && (operationType == 250 || operationType == 260) && (node = this.findMethodOrFail(innerExpression, exprType, name2, new ClassNode[0])) != null) {
            this.storeTargetMethod(origin2, node);
            this.storeType(origin2, StaticTypeCheckingVisitor.getMathWideningClassNode(exprType));
            return;
        }
        if (name2 == null) {
            this.addUnsupportedPreOrPostfixExpressionError(origin2);
            return;
        }
        node = this.findMethodOrFail(innerExpression, exprType, name2, new ClassNode[0]);
        if (node != null) {
            this.storeTargetMethod(origin2, node);
            this.storeType(origin2, isPostfix ? exprType : this.inferReturnTypeGenerics(exprType, node, ArgumentListExpression.EMPTY_ARGUMENTS));
        }
    }

    private void negativeOrPositiveUnary(Expression expression2, String name2) {
        MethodNode mn;
        ClassNode type = this.getType(expression2);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isDoubleCategory(ClassHelper.getUnwrapper(typeRe)) ? type : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : ((mn = this.findMethodOrFail(expression2, type, name2, new ClassNode[0])) != null ? mn.getReturnType() : type));
        this.storeType(expression2, resultType);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.typeCheckingContext.pushEnclosingMethod(node);
        if (!this.isSkipMode(node) && !this.shouldSkipMethodNode(node)) {
            super.visitConstructorOrMethod(node, isConstructor);
        }
        if (!isConstructor) {
            this.returnAdder.visitMethod(node);
        }
        this.typeCheckingContext.popEnclosingMethod();
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement2) {
        this.typeCheckingContext.pushEnclosingReturnStatement(statement2);
        try {
            super.visitReturnStatement(statement2);
            this.returnListener.returnStatementAdded(statement2);
        }
        finally {
            this.typeCheckingContext.popEnclosingReturnStatement();
        }
    }

    private ClassNode infer(ClassNode target, ClassNode source) {
        DeclarationExpression virtualDecl = new DeclarationExpression(GeneralUtils.varX("{target}", target), Token.newSymbol(100, -1, -1), (Expression)GeneralUtils.varX("{source}", source));
        virtualDecl.visit(this);
        ClassNode newlyInferred = (ClassNode)virtualDecl.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        return !StaticTypeCheckingSupport.missesGenericsTypes(newlyInferred) ? newlyInferred : null;
    }

    protected ClassNode checkReturnType(ReturnStatement statement2) {
        MethodNode enclosingMethod;
        Expression expression2 = statement2.getExpression();
        ClassNode type = this.getType(expression2);
        if (this.typeCheckingContext.getEnclosingClosure() != null) {
            return type;
        }
        if (expression2 instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(expression2)) {
            type = (ClassNode)expression2.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        }
        if ((enclosingMethod = this.typeCheckingContext.getEnclosingMethod()) != null && this.typeCheckingContext.getEnclosingClosure() == null) {
            if (!(enclosingMethod.isVoidMethod() || type.equals(ClassHelper.void_WRAPPER_TYPE) || type.equals(ClassHelper.VOID_TYPE) || StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(enclosingMethod.getReturnType(), type, null, false) || StaticTypeCheckingVisitor.isNullConstant(expression2))) {
                if (!this.extension.handleIncompatibleReturnType(statement2, type)) {
                    this.addStaticTypeError("Cannot return value of type " + type.toString(false) + " on method returning type " + enclosingMethod.getReturnType().toString(false), expression2);
                }
            } else if (!enclosingMethod.isVoidMethod()) {
                ClassNode inferred;
                ClassNode previousType = this.getInferredReturnType(enclosingMethod);
                ClassNode classNode = inferred = previousType == null ? type : WideningCategories.lowestUpperBound(type, previousType);
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferred, enclosingMethod.getReturnType())) {
                    if (StaticTypeCheckingSupport.missesGenericsTypes(inferred)) {
                        ClassNode newlyInferred = this.infer(enclosingMethod.getReturnType(), type);
                        if (null != newlyInferred) {
                            type = newlyInferred;
                        }
                    } else {
                        this.checkTypeGenerics(enclosingMethod.getReturnType(), inferred, expression2);
                    }
                    return type;
                }
                return enclosingMethod.getReturnType();
            }
        }
        return type;
    }

    protected void addClosureReturnType(ClassNode returnType) {
        this.typeCheckingContext.getEnclosingClosure().addReturnType(returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call2) {
        this.typeCheckingContext.pushEnclosingConstructorCall(call2);
        try {
            MethodNode node;
            super.visitConstructorCallExpression(call2);
            if (this.extension.beforeMethodCall(call2)) {
                this.extension.afterMethodCall(call2);
                return;
            }
            ClassNode receiver = call2.isThisCall() ? this.typeCheckingContext.getEnclosingClassNode() : (call2.isSuperCall() ? this.typeCheckingContext.getEnclosingClassNode().getSuperClass() : call2.getType());
            Expression arguments = call2.getArguments();
            ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(arguments);
            this.checkForbiddenSpreadArgument(argumentList);
            ClassNode[] args2 = this.getArgumentTypes(argumentList);
            if (args2.length > 0 && this.typeCheckingContext.getEnclosingClosure() != null && argumentList.getExpression(0) instanceof VariableExpression && ((VariableExpression)argumentList.getExpression(0)).isThisExpression() && call2.getType() instanceof InnerClassNode && call2.getType().getOuterClass().equals(args2[0]) && !call2.getType().isStaticClass()) {
                args2[0] = ClassHelper.CLOSURE_TYPE;
            }
            if (this.looksLikeNamedArgConstructor(receiver, args2) && this.findMethod(receiver, "<init>", DefaultGroovyMethods.init(args2)).size() == 1 && this.findMethod(receiver, "<init>", args2).isEmpty() && (node = this.typeCheckMapConstructor(call2, receiver, arguments)) != null) {
                this.storeTargetMethod(call2, node);
                this.extension.afterMethodCall(call2);
                return;
            }
            node = this.findMethodOrFail(call2, receiver, "<init>", args2);
            if (node != null) {
                if (this.looksLikeNamedArgConstructor(receiver, args2) && node.getParameters().length + 1 == args2.length) {
                    node = this.typeCheckMapConstructor(call2, receiver, arguments);
                } else {
                    this.typeCheckMethodsWithGenericsOrFail(receiver, args2, node, call2);
                }
                if (node != null) {
                    this.storeTargetMethod(call2, node);
                }
            }
            this.extension.afterMethodCall(call2);
        }
        finally {
            this.typeCheckingContext.popEnclosingConstructorCall();
        }
    }

    private boolean looksLikeNamedArgConstructor(ClassNode receiver, ClassNode[] args2) {
        return (args2.length == 1 || args2.length == 2 && this.isInnerConstructor(receiver, args2[0])) && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(args2[args2.length - 1], ClassHelper.MAP_TYPE);
    }

    private boolean isInnerConstructor(ClassNode receiver, ClassNode parent) {
        return receiver.isRedirectNode() && receiver.redirect() instanceof InnerClassNode && receiver.redirect().getOuterClass().equals(parent);
    }

    protected MethodNode typeCheckMapConstructor(ConstructorCallExpression call2, ClassNode receiver, Expression arguments) {
        Expression expression2;
        TupleExpression texp;
        List<Expression> expressions;
        ConstructorNode node = null;
        if (arguments instanceof TupleExpression && ((expressions = (texp = (TupleExpression)arguments).getExpressions()).size() == 1 || expressions.size() == 2) && (expression2 = expressions.get(expressions.size() - 1)) instanceof MapExpression) {
            Parameter[] parameterArray;
            MapExpression argList = (MapExpression)expression2;
            this.checkGroovyConstructorMap(call2, receiver, argList);
            if (expressions.size() == 1) {
                Parameter[] parameterArray2 = new Parameter[1];
                parameterArray = parameterArray2;
                parameterArray2[0] = new Parameter(ClassHelper.MAP_TYPE, "map");
            } else {
                Parameter[] parameterArray3 = new Parameter[2];
                parameterArray3[0] = new Parameter(receiver.redirect().getOuterClass(), "$p$");
                parameterArray = parameterArray3;
                parameterArray3[1] = new Parameter(ClassHelper.MAP_TYPE, "map");
            }
            Parameter[] params2 = parameterArray;
            node = new ConstructorNode(1, params2, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
            node.setDeclaringClass(receiver);
        }
        return node;
    }

    protected ClassNode[] getArgumentTypes(ArgumentListExpression args2) {
        List<Expression> arglist = args2.getExpressions();
        ClassNode[] ret = new ClassNode[arglist.size()];
        for (int i = 0; i < arglist.size(); ++i) {
            Expression exp = arglist.get(i);
            ret[i] = StaticTypeCheckingVisitor.isNullConstant(exp) ? StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE : this.getInferredTypeFromTempInfo(exp, this.getType(exp));
        }
        return ret;
    }

    private ClassNode getInferredTypeFromTempInfo(Expression exp, ClassNode result2) {
        List<ClassNode> classNodes;
        Map<Object, List<ClassNode>> info2;
        Map<Object, List<ClassNode>> map2 = info2 = this.typeCheckingContext.temporaryIfBranchTypeInformation.empty() ? null : this.typeCheckingContext.temporaryIfBranchTypeInformation.peek();
        if (exp instanceof VariableExpression && info2 != null && (classNodes = this.getTemporaryTypesForExpression(exp)) != null && !classNodes.isEmpty()) {
            ArrayList<ClassNode> arr = new ArrayList<ClassNode>(classNodes.size() + 1);
            if (result2 != null && !classNodes.contains(result2)) {
                arr.add(result2);
            }
            arr.addAll(classNodes);
            Iterator iterator2 = arr.iterator();
            while (iterator2.hasNext()) {
                ClassNode next2 = (ClassNode)iterator2.next();
                if (!ClassHelper.OBJECT_TYPE.equals(next2)) continue;
                iterator2.remove();
            }
            result2 = arr.isEmpty() ? ClassHelper.OBJECT_TYPE.getPlainNodeReference() : (arr.size() == 1 ? (ClassNode)arr.get(0) : new UnionTypeClassNode(arr.toArray(ClassNode.EMPTY_ARRAY)));
        }
        return result2;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression2) {
        boolean oldStaticContext = this.typeCheckingContext.isInStaticContext;
        this.typeCheckingContext.isInStaticContext = false;
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        Statement code = expression2.getCode();
        code.visit(new VariableExpressionTypeMemoizer(varOrigType));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        SharedVariableCollector collector = new SharedVariableCollector(this.getSourceUnit());
        collector.visitClosureExpression(expression2);
        Set<VariableExpression> closureSharedExpressions = collector.getClosureSharedExpressions();
        HashMap<VariableExpression, ListHashMap> typesBeforeVisit = null;
        if (!closureSharedExpressions.isEmpty()) {
            typesBeforeVisit = new HashMap<VariableExpression, ListHashMap>();
            this.saveVariableExpressionMetadata(closureSharedExpressions, typesBeforeVisit);
        }
        this.typeCheckingContext.pushEnclosingClosureExpression(expression2);
        DelegationMetadata dmd = this.getDelegationMetadata(expression2);
        this.typeCheckingContext.delegationMetadata = dmd == null ? new DelegationMetadata(this.typeCheckingContext.getEnclosingClassNode(), 0, this.typeCheckingContext.delegationMetadata) : new DelegationMetadata(dmd.getType(), dmd.getStrategy(), this.typeCheckingContext.delegationMetadata);
        super.visitClosureExpression(expression2);
        this.typeCheckingContext.delegationMetadata = this.typeCheckingContext.delegationMetadata.getParent();
        MethodNode node = new MethodNode("dummy", 0, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, code);
        this.returnAdder.visitMethod(node);
        TypeCheckingContext.EnclosingClosure enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
        if (!enclosingClosure.getReturnTypes().isEmpty()) {
            ClassNode returnType = WideningCategories.lowestUpperBound(enclosingClosure.getReturnTypes());
            this.storeInferredReturnType(expression2, returnType);
            ClassNode inferredType = StaticTypeCheckingVisitor.wrapClosureType(returnType);
            this.storeType(enclosingClosure.getClosureExpression(), inferredType);
        }
        this.typeCheckingContext.popEnclosingClosure();
        boolean typeChanged = this.isSecondPassNeededForControlStructure(varOrigType, oldTracker);
        if (typeChanged) {
            this.visitClosureExpression(expression2);
        }
        this.restoreVariableExpressionMetadata(typesBeforeVisit);
        this.typeCheckingContext.isInStaticContext = oldStaticContext;
        for (Parameter parameter : ClosureUtils.getParametersSafe(expression2)) {
            this.typeCheckingContext.controlStructureVariables.remove(parameter);
        }
    }

    private static ClassNode wrapClosureType(ClassNode returnType) {
        ClassNode inferredType = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
        inferredType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(returnType))});
        return inferredType;
    }

    protected DelegationMetadata getDelegationMetadata(ClosureExpression expression2) {
        return (DelegationMetadata)expression2.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA);
    }

    protected void restoreVariableExpressionMetadata(Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        if (typesBeforeVisit != null) {
            for (Map.Entry<VariableExpression, ListHashMap> entry2 : typesBeforeVisit.entrySet()) {
                VariableExpression ve = entry2.getKey();
                ListHashMap metadata = entry2.getValue();
                for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                    ve.removeNodeMetaData((Object)marker);
                    Object value2 = metadata.get((Object)marker);
                    if (value2 == null) continue;
                    ve.setNodeMetaData((Object)marker, value2);
                }
            }
        }
    }

    protected void saveVariableExpressionMetadata(Set<VariableExpression> closureSharedExpressions, Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        for (VariableExpression ve : closureSharedExpressions) {
            this.getType(ve);
            ListHashMap metadata = new ListHashMap();
            for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                Object value2 = ve.getNodeMetaData((Object)marker);
                if (value2 == null) continue;
                metadata.put(marker, value2);
            }
            typesBeforeVisit.put(ve, metadata);
            Variable accessedVariable = ve.getAccessedVariable();
            if (accessedVariable == ve || !(accessedVariable instanceof VariableExpression)) continue;
            this.saveVariableExpressionMetadata(Collections.singleton((VariableExpression)accessedVariable), typesBeforeVisit);
        }
    }

    protected boolean shouldSkipMethodNode(MethodNode node) {
        Object type = node.getNodeMetaData(StaticTypeCheckingVisitor.class);
        return Boolean.TRUE.equals(type);
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.shouldSkipMethodNode(node)) {
            return;
        }
        if (!this.extension.beforeVisitMethod(node)) {
            ErrorCollector collector = (ErrorCollector)node.getNodeMetaData(ERROR_COLLECTOR);
            if (collector != null) {
                this.typeCheckingContext.getErrorCollector().addCollectorContents(collector);
            } else {
                this.startMethodInference(node, this.typeCheckingContext.getErrorCollector());
            }
            node.removeNodeMetaData(ERROR_COLLECTOR);
        }
        this.extension.afterVisitMethod(node);
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        if (this.shouldSkipMethodNode(node)) {
            return;
        }
        for (Parameter parameter : node.getParameters()) {
            if (parameter.getInitialExpression() == null) continue;
            parameter.getInitialExpression().visit(this);
        }
        super.visitConstructor(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMethodInference(MethodNode node, ErrorCollector collector) {
        if (this.isSkipMode(node)) {
            return;
        }
        if (!this.typeCheckingContext.methodsToBeVisited.isEmpty() && !this.typeCheckingContext.methodsToBeVisited.contains(node)) {
            return;
        }
        if (this.typeCheckingContext.alreadyVisitedMethods.contains(node)) {
            return;
        }
        this.typeCheckingContext.alreadyVisitedMethods.add(node);
        this.typeCheckingContext.pushErrorCollector(collector);
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isStatic();
            super.visitMethod(node);
            for (Parameter parameter : node.getParameters()) {
                if (parameter.getInitialExpression() == null) continue;
                parameter.getInitialExpression().visit(this);
            }
        }
        finally {
            this.typeCheckingContext.isInStaticContext = osc;
        }
        this.typeCheckingContext.popErrorCollector();
        node.putNodeMetaData(ERROR_COLLECTOR, collector);
    }

    protected void addTypeCheckingInfoAnnotation(MethodNode node) {
        if (node instanceof ConstructorNode) {
            return;
        }
        ClassNode rtype = this.getInferredReturnType(node);
        if (rtype != null && node.getAnnotations(TYPECHECKING_INFO_NODE).isEmpty()) {
            AnnotationNode anno = new AnnotationNode(TYPECHECKING_INFO_NODE);
            anno.setMember("version", CURRENT_SIGNATURE_PROTOCOL);
            SignatureCodec codec = SignatureCodecFactory.getCodec(1, this.getTransformLoader());
            String genericsSignature = codec.encode(rtype);
            if (genericsSignature != null) {
                ConstantExpression signature2 = new ConstantExpression(genericsSignature);
                signature2.setType(ClassHelper.STRING_TYPE);
                anno.setMember("inferredType", signature2);
                node.addAnnotation(anno);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression call2) {
        String name2 = call2.getMethod();
        if (name2 == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call2);
            return;
        }
        if (this.extension.beforeMethodCall(call2)) {
            this.extension.afterMethodCall(call2);
            return;
        }
        Expression callArguments = call2.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        ClassNode receiver = call2.getOwnerType();
        this.visitMethodCallArguments(receiver, argumentList, false, null);
        ClassNode[] args2 = this.getArgumentTypes(argumentList);
        try {
            LinkedList<Receiver<String>> receivers = new LinkedList<Receiver<String>>();
            this.addReceivers(receivers, this.makeOwnerList(new ClassExpression(receiver)), false);
            List<MethodNode> mn = null;
            Receiver chosenReceiver = null;
            for (Receiver receiver2 : receivers) {
                mn = this.findMethod(receiver2.getType(), name2, args2);
                if (mn.isEmpty()) continue;
                if (mn.size() == 1) {
                    this.typeCheckMethodsWithGenericsOrFail(receiver2.getType(), args2, mn.get(0), call2);
                }
                chosenReceiver = receiver2;
                break;
            }
            if (mn.isEmpty()) {
                mn = this.extension.handleMissingMethod(receiver, name2, argumentList, args2, call2);
            }
            boolean callArgsVisited = false;
            if (mn.isEmpty()) {
                this.addNoMatchingMethodError(receiver, name2, args2, call2);
            } else {
                if ((mn = this.disambiguateMethods(mn, receiver, args2, call2)).size() == 1) {
                    MethodNode methodNode = mn.get(0);
                    ClassNode returnType = this.getType(methodNode);
                    if (returnType.isUsingGenerics() && !returnType.isEnum()) {
                        this.visitMethodCallArguments(receiver, argumentList, true, methodNode);
                        ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver.getType(), methodNode, callArguments);
                        returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                        callArgsVisited = true;
                    }
                    this.storeType(call2, returnType);
                    this.storeTargetMethod(call2, methodNode);
                } else {
                    this.addAmbiguousErrorMessage(mn, name2, args2, call2);
                }
                if (!callArgsVisited) {
                    this.visitMethodCallArguments(receiver, argumentList, true, (MethodNode)call2.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
                }
            }
        }
        finally {
            this.extension.afterMethodCall(call2);
        }
    }

    @Deprecated
    protected void checkClosureParameters(Expression callArguments, ClassNode receiver) {
        if (callArguments instanceof ArgumentListExpression) {
            Parameter param2;
            ArgumentListExpression argList = (ArgumentListExpression)callArguments;
            ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
            Parameter[] parameters = closure.getParameters();
            if (parameters.length > 1) {
                this.addStaticTypeError("Unexpected number of parameters for a with call", argList);
            } else if (parameters.length == 1 && !(param2 = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param2.getType().redirect())) {
                this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param2.getType().redirect().toString(false), param2);
            }
            closure.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(receiver, 1, this.typeCheckingContext.delegationMetadata));
        }
    }

    protected void silentlyVisitMethodNode(MethodNode directMethodCallCandidate) {
        ErrorCollector collector = new ErrorCollector(this.typeCheckingContext.getErrorCollector().getConfiguration());
        this.startMethodInference(directMethodCallCandidate, collector);
    }

    protected void visitMethodCallArguments(ClassNode receiver, ArgumentListExpression arguments, boolean visitClosures, MethodNode selectedMethod) {
        Parameter[] params2 = selectedMethod != null ? selectedMethod.getParameters() : Parameter.EMPTY_ARRAY;
        LinkedList<Expression> expressions = new LinkedList<Expression>(arguments.getExpressions());
        if (selectedMethod instanceof ExtensionMethodNode) {
            params2 = ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode().getParameters();
            expressions.add(0, GeneralUtils.varX("$self", receiver));
        }
        ArgumentListExpression newArgs = GeneralUtils.args(expressions);
        int expressionsSize = expressions.size();
        for (int i = 0; i < expressionsSize; ++i) {
            Expression expression2 = (Expression)expressions.get(i);
            if ((!visitClosures || !(expression2 instanceof ClosureExpression)) && (visitClosures || expression2 instanceof ClosureExpression)) continue;
            if (i < params2.length && visitClosures) {
                Parameter param2 = params2[i];
                this.checkClosureWithDelegatesTo(receiver, selectedMethod, newArgs, params2, expression2, param2);
                if (selectedMethod instanceof ExtensionMethodNode) {
                    if (i > 0) {
                        this.inferClosureParameterTypes(receiver, arguments, (ClosureExpression)expression2, param2, selectedMethod);
                    }
                } else {
                    this.inferClosureParameterTypes(receiver, newArgs, (ClosureExpression)expression2, param2, selectedMethod);
                }
            }
            expression2.visit(this);
            if (expression2.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA) == null) continue;
            expression2.removeNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA);
        }
        if (expressions.size() > 0 && expressions.get(0) instanceof MapExpression && params2.length > 0) {
            this.checkNamedParamsAnnotation(params2[0], (MapExpression)expressions.get(0));
        }
    }

    private void checkNamedParamsAnnotation(Parameter param2, MapExpression args2) {
        if (!param2.getType().isDerivedFrom(ClassHelper.MAP_TYPE)) {
            return;
        }
        List<MapEntryExpression> entryExpressions = args2.getMapEntryExpressions();
        LinkedHashMap<Object, Expression> entries = new LinkedHashMap<Object, Expression>();
        for (MapEntryExpression entry2 : entryExpressions) {
            Object key = entry2.getKeyExpression();
            if (key instanceof ConstantExpression) {
                key = ((ConstantExpression)key).getValue();
            }
            entries.put(key, entry2.getValueExpression());
        }
        List<AnnotationNode> annotations2 = param2.getAnnotations(NAMED_PARAMS_CLASSNODE);
        if (annotations2 != null && !annotations2.isEmpty()) {
            AnnotationNode an = null;
            for (AnnotationNode next2 : annotations2) {
                if (!next2.getClassNode().getName().equals(NamedParams.class.getName())) continue;
                an = next2;
            }
            ArrayList<String> collectedNames = new ArrayList<String>();
            if (an != null) {
                Expression value2 = an.getMember("value");
                if (value2 instanceof AnnotationConstantExpression) {
                    this.processNamedParam((AnnotationConstantExpression)value2, entries, args2, collectedNames);
                } else if (value2 instanceof ListExpression) {
                    ListExpression le = (ListExpression)value2;
                    for (Expression next3 : le.getExpressions()) {
                        if (!(next3 instanceof AnnotationConstantExpression)) continue;
                        this.processNamedParam((AnnotationConstantExpression)next3, entries, args2, collectedNames);
                    }
                }
                for (Map.Entry entry3 : entries.entrySet()) {
                    if (collectedNames.contains(entry3.getKey())) continue;
                    this.addStaticTypeError("unexpected named arg: " + entry3.getKey(), args2);
                }
            }
        }
    }

    private void processNamedParam(AnnotationConstantExpression value2, Map<Object, Expression> entries, Expression expression2, List<String> collectedNames) {
        Expression supplied;
        ClassExpression typeX;
        AnnotationNode namedParam = (AnnotationNode)value2.getValue();
        if (!namedParam.getClassNode().getName().equals(NamedParam.class.getName())) {
            return;
        }
        String name2 = null;
        boolean required = false;
        ClassNode expectedType = null;
        ConstantExpression constX = (ConstantExpression)namedParam.getMember("value");
        if (constX != null) {
            name2 = (String)constX.getValue();
            collectedNames.add(name2);
        }
        if ((constX = (ConstantExpression)namedParam.getMember("required")) != null) {
            required = (Boolean)constX.getValue();
        }
        if ((typeX = (ClassExpression)namedParam.getMember("type")) != null) {
            expectedType = typeX.getType();
        }
        if (!entries.keySet().contains(name2)) {
            if (required) {
                this.addStaticTypeError("required named arg '" + name2 + "' not found.", expression2);
            }
        } else if (this.isCompatibleType(expectedType, expectedType != null, (supplied = entries.get(name2)).getType())) {
            this.addStaticTypeError("parameter for named arg '" + name2 + "' has type '" + StaticTypeCheckingSupport.prettyPrintType(supplied.getType()) + "' but expected '" + StaticTypeCheckingSupport.prettyPrintType(expectedType) + "'.", expression2);
        }
    }

    private boolean isCompatibleType(ClassNode expectedType, boolean b, ClassNode type) {
        return b && !StaticTypeCheckingSupport.isAssignableTo(type, expectedType);
    }

    protected void inferClosureParameterTypes(ClassNode receiver, Expression arguments, ClosureExpression expression2, Parameter param2, MethodNode selectedMethod) {
        List<AnnotationNode> annotations2 = param2.getAnnotations(CLOSUREPARAMS_CLASSNODE);
        if (annotations2 != null && !annotations2.isEmpty()) {
            for (AnnotationNode annotation : annotations2) {
                Expression hintClass = annotation.getMember("value");
                Expression options = annotation.getMember("options");
                Expression resolverClass = annotation.getMember("conflictResolutionStrategy");
                if (!(hintClass instanceof ClassExpression)) continue;
                this.doInferClosureParameterTypes(receiver, arguments, expression2, selectedMethod, hintClass, resolverClass, options);
            }
        } else if (ClassHelper.isSAMType(param2.getOriginType())) {
            this.inferSAMType(param2, receiver, selectedMethod, InvocationWriter.makeArgumentList(arguments), expression2);
        }
    }

    private void inferSAMType(Parameter param2, ClassNode receiver, MethodNode methodWithSAMParameter, ArgumentListExpression originalMethodCallArguments, ClosureExpression openBlock) {
        int i;
        HashMap<GenericsType.GenericsTypeName, GenericsType> targetMethodDeclarationClassConnections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        StaticTypeCheckingSupport.extractGenericsConnections(targetMethodDeclarationClassConnections, receiver, receiver.redirect());
        Parameter[] parametersOfMethodContainingSAM = methodWithSAMParameter.getParameters();
        for (int i2 = 0; i2 < parametersOfMethodContainingSAM.length; ++i2) {
            Expression callArg;
            if (i2 == parametersOfMethodContainingSAM.length - 1 && i2 == originalMethodCallArguments.getExpressions().size() && parametersOfMethodContainingSAM[i2].getType().isArray() || (callArg = originalMethodCallArguments.getExpression(i2)) == openBlock) continue;
            ClassNode parameterType = parametersOfMethodContainingSAM[i2].getType();
            StaticTypeCheckingSupport.extractGenericsConnections(targetMethodDeclarationClassConnections, this.getType(callArg), parameterType);
        }
        ClassNode paramTypeWithReceiverInformation = StaticTypeCheckingSupport.applyGenericsContext(targetMethodDeclarationClassConnections, param2.getOriginType());
        HashMap<GenericsType.GenericsTypeName, GenericsType> SAMTypeConnections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        ClassNode classForSAM = paramTypeWithReceiverInformation.redirect();
        StaticTypeCheckingSupport.extractGenericsConnections(SAMTypeConnections, paramTypeWithReceiverInformation, classForSAM);
        MethodNode methodForSAM = ClassHelper.findSAM(classForSAM);
        ClassNode[] parameterTypesForSAM = StaticTypeCheckingVisitor.extractTypesFromParameters(methodForSAM.getParameters());
        ClassNode[] blockParameterTypes = (ClassNode[])openBlock.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
        if (blockParameterTypes == null) {
            Parameter[] p = openBlock.getParameters();
            if (p == null) {
                blockParameterTypes = ClassNode.EMPTY_ARRAY;
            } else if (p.length == 0 && parameterTypesForSAM.length != 0) {
                blockParameterTypes = parameterTypesForSAM;
            } else {
                blockParameterTypes = new ClassNode[p.length];
                for (int i3 = 0; i3 < p.length; ++i3) {
                    blockParameterTypes[i3] = p[i3] != null && !p[i3].isDynamicTyped() ? p[i3].getType() : this.typeOrNull(parameterTypesForSAM, i3);
                }
            }
        }
        for (i = 0; i < blockParameterTypes.length; ++i) {
            StaticTypeCheckingSupport.extractGenericsConnections(SAMTypeConnections, blockParameterTypes[i], this.typeOrNull(parameterTypesForSAM, i));
        }
        for (i = 0; i < blockParameterTypes.length; ++i) {
            ClassNode resolvedParameter;
            blockParameterTypes[i] = resolvedParameter = StaticTypeCheckingSupport.applyGenericsContext(SAMTypeConnections, this.typeOrNull(parameterTypesForSAM, i));
        }
        openBlock.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, blockParameterTypes);
    }

    private ClassNode typeOrNull(ClassNode[] parameterTypesForSAM, int i) {
        return i < parameterTypesForSAM.length ? parameterTypesForSAM[i] : null;
    }

    private List<ClassNode[]> getSignaturesFromHint(ClosureExpression expression2, MethodNode selectedMethod, Expression hintClass, Expression options) {
        List<ClassNode[]> closureSignatures;
        try {
            ClassLoader transformLoader = this.getTransformLoader();
            Class<?> hint = transformLoader.loadClass(hintClass.getText());
            ClosureSignatureHint hintInstance = (ClosureSignatureHint)hint.newInstance();
            closureSignatures = hintInstance.getClosureSignatures(selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod, this.typeCheckingContext.source, this.typeCheckingContext.compilationUnit, StaticTypeCheckingVisitor.convertToStringArray(options), expression2);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new GroovyBugError(e);
        }
        return closureSignatures;
    }

    private List<ClassNode[]> resolveWithResolver(List<ClassNode[]> candidates, ClassNode receiver, Expression arguments, ClosureExpression expression2, MethodNode selectedMethod, Expression resolverClass, Expression options) {
        try {
            ClassLoader transformLoader = this.getTransformLoader();
            Class<?> resolver = transformLoader.loadClass(resolverClass.getText());
            ClosureSignatureConflictResolver resolverInstance = (ClosureSignatureConflictResolver)resolver.newInstance();
            return resolverInstance.resolve(candidates, receiver, arguments, expression2, selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod, this.typeCheckingContext.source, this.typeCheckingContext.compilationUnit, StaticTypeCheckingVisitor.convertToStringArray(options));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new GroovyBugError(e);
        }
    }

    private ClassLoader getTransformLoader() {
        CompilationUnit compilationUnit2 = this.typeCheckingContext.getCompilationUnit();
        return compilationUnit2 != null ? compilationUnit2.getTransformLoader() : this.getSourceUnit().getClassLoader();
    }

    private void doInferClosureParameterTypes(ClassNode receiver, Expression arguments, ClosureExpression expression2, MethodNode selectedMethod, Expression hintClass, Expression resolverClass, Expression options) {
        List<ClassNode[]> closureSignatures = this.getSignaturesFromHint(expression2, selectedMethod, hintClass, options);
        List<ClassNode[]> candidates = new LinkedList<ClassNode[]>();
        Parameter[] closureParams = expression2.getParameters();
        for (ClassNode[] signature2 : closureSignatures) {
            ClassNode[] inferred = this.resolveGenericsFromTypeHint(receiver, arguments, selectedMethod, signature2);
            if (closureParams == null) {
                return;
            }
            if (signature2.length != closureParams.length && (signature2.length != 1 || closureParams.length != 0) && (closureParams.length <= signature2.length || !inferred[inferred.length - 1].isArray())) continue;
            candidates.add(inferred);
        }
        if (candidates.size() > 1) {
            Iterator candIt = candidates.iterator();
            while (candIt.hasNext()) {
                ClassNode[] inferred = (ClassNode[])candIt.next();
                int length = closureParams.length;
                for (int i = 0; i < length; ++i) {
                    ClassNode inferredType;
                    Parameter closureParam = closureParams[i];
                    ClassNode originType = closureParam.getOriginType();
                    if (i < inferred.length - 1 || inferred.length == closureParams.length) {
                        inferredType = inferred[i];
                    } else {
                        ClassNode lastArgInferred = inferred[inferred.length - 1];
                        if (lastArgInferred.isArray()) {
                            inferredType = lastArgInferred.getComponentType();
                        } else {
                            candIt.remove();
                            continue;
                        }
                    }
                    if (StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(originType, inferredType, i == length - 1)) continue;
                    candIt.remove();
                }
            }
            if (candidates.size() > 1 && resolverClass instanceof ClassExpression) {
                candidates = this.resolveWithResolver(candidates, receiver, arguments, expression2, selectedMethod, resolverClass, options);
            }
            if (candidates.size() > 1) {
                this.addError("Ambiguous prototypes for closure. More than one target method matches. Please use explicit argument types.", expression2);
            }
        }
        if (candidates.size() == 1) {
            ClassNode[] inferred = (ClassNode[])candidates.get(0);
            if (closureParams.length == 0 && inferred.length == 1) {
                expression2.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, inferred);
            } else {
                int length = closureParams.length;
                for (int i = 0; i < length; ++i) {
                    boolean lastArg;
                    Parameter closureParam = closureParams[i];
                    ClassNode originType = closureParam.getOriginType();
                    ClassNode inferredType = ClassHelper.OBJECT_TYPE;
                    if (i < inferred.length - 1 || inferred.length == closureParams.length) {
                        inferredType = inferred[i];
                    } else {
                        ClassNode lastArgInferred = inferred[inferred.length - 1];
                        if (lastArgInferred.isArray()) {
                            inferredType = lastArgInferred.getComponentType();
                        } else {
                            this.addError("Incorrect number of parameters. Expected " + inferred.length + " but found " + closureParams.length, expression2);
                        }
                    }
                    boolean bl = lastArg = i == length - 1;
                    if (!StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(originType, inferredType, lastArg)) {
                        this.addError("Expected parameter of type " + inferredType.toString(false) + " but got " + originType.toString(false), closureParam.getType());
                    }
                    this.typeCheckingContext.controlStructureVariables.put(closureParam, inferredType);
                }
            }
        }
    }

    private ClassNode[] resolveGenericsFromTypeHint(ClassNode receiver, Expression arguments, MethodNode selectedMethod, ClassNode[] signature2) {
        ClassNode dummyResultNode = new ClassNode("ClForInference$" + UNIQUE_LONG.incrementAndGet(), 0, ClassHelper.OBJECT_TYPE).getPlainNodeReference();
        GenericsType[] genericTypes = new GenericsType[signature2.length];
        for (int i = 0; i < signature2.length; ++i) {
            genericTypes[i] = new GenericsType(signature2[i]);
        }
        dummyResultNode.setGenericsTypes(genericTypes);
        MethodNode dummyMN = selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod;
        dummyMN = new MethodNode(dummyMN.getName(), dummyMN.getModifiers(), dummyResultNode, dummyMN.getParameters(), dummyMN.getExceptions(), EmptyStatement.INSTANCE);
        dummyMN.setDeclaringClass(selectedMethod.getDeclaringClass());
        dummyMN.setGenericsTypes(selectedMethod.getGenericsTypes());
        if (selectedMethod instanceof ExtensionMethodNode) {
            ExtensionMethodNode orig = (ExtensionMethodNode)selectedMethod;
            dummyMN = new ExtensionMethodNode(dummyMN, dummyMN.getName(), dummyMN.getModifiers(), dummyResultNode, orig.getParameters(), orig.getExceptions(), EmptyStatement.INSTANCE, orig.isStaticExtension());
            dummyMN.setDeclaringClass(orig.getDeclaringClass());
            dummyMN.setGenericsTypes(orig.getGenericsTypes());
        }
        ClassNode classNode = this.inferReturnTypeGenerics(receiver, dummyMN, arguments);
        ClassNode[] inferred = new ClassNode[classNode.getGenericsTypes().length];
        for (int i = 0; i < classNode.getGenericsTypes().length; ++i) {
            ClassNode value2;
            GenericsType genericsType = classNode.getGenericsTypes()[i];
            inferred[i] = value2 = StaticTypeCheckingVisitor.createUsableClassNodeFromGenericsType(genericsType);
        }
        return inferred;
    }

    private static ClassNode createUsableClassNodeFromGenericsType(GenericsType genericsType) {
        ClassNode lowerBound;
        ClassNode value2 = genericsType.getType();
        if (genericsType.isPlaceholder()) {
            value2 = ClassHelper.OBJECT_TYPE;
        }
        if ((lowerBound = genericsType.getLowerBound()) != null) {
            value2 = lowerBound;
        } else {
            ClassNode[] upperBounds = genericsType.getUpperBounds();
            if (upperBounds != null) {
                value2 = WideningCategories.lowestUpperBound(Arrays.asList(upperBounds));
            }
        }
        return value2;
    }

    private static String[] convertToStringArray(Expression options) {
        if (options == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (options instanceof ConstantExpression) {
            return new String[]{options.getText()};
        }
        if (options instanceof ListExpression) {
            List<Expression> list2 = ((ListExpression)options).getExpressions();
            ArrayList<String> result2 = new ArrayList<String>(list2.size());
            for (Expression expression2 : list2) {
                result2.add(expression2.getText());
            }
            return result2.toArray(new String[0]);
        }
        throw new IllegalArgumentException("Unexpected options for @ClosureParams:" + options);
    }

    private void checkClosureWithDelegatesTo(ClassNode receiver, MethodNode mn, ArgumentListExpression arguments, Parameter[] params2, Expression expression2, Parameter param2) {
        List<AnnotationNode> annotations2 = param2.getAnnotations(DELEGATES_TO);
        if (annotations2 != null && !annotations2.isEmpty()) {
            for (AnnotationNode annotation : annotations2) {
                Expression value2 = annotation.getMember("value");
                Expression strategy = annotation.getMember("strategy");
                Expression genericTypeIndex = annotation.getMember("genericTypeIndex");
                Expression type = annotation.getMember("type");
                Integer stInt = 0;
                if (strategy != null) {
                    stInt = (Integer)StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(ClassHelper.Integer_TYPE, strategy), this.typeCheckingContext.source.getConfiguration());
                }
                if (value2 instanceof ClassExpression && !value2.getType().equals(DELEGATES_TO_TARGET)) {
                    if (genericTypeIndex != null) {
                        this.addStaticTypeError("Cannot use @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") without @DelegatesTo.Target because generic argument types are not available at runtime", value2);
                    }
                    expression2.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(value2.getType(), stInt, this.typeCheckingContext.delegationMetadata));
                    continue;
                }
                if (type != null && !"".equals(type.getText()) && type instanceof ConstantExpression) {
                    String typeString = type.getText();
                    ClassNode[] resolved = GenericsUtils.parseClassNodesFromString(typeString, this.getSourceUnit(), this.typeCheckingContext.compilationUnit, mn, type);
                    if (resolved == null) continue;
                    if (resolved.length == 1) {
                        resolved = this.resolveGenericsFromTypeHint(receiver, arguments, mn, resolved);
                        expression2.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(resolved[0], stInt, this.typeCheckingContext.delegationMetadata));
                        continue;
                    }
                    this.addStaticTypeError("Incorrect type hint found in method " + mn, type);
                    continue;
                }
                List<Expression> expressions = arguments.getExpressions();
                int expressionsSize = expressions.size();
                Expression parameter = annotation.getMember("target");
                String parameterName = parameter instanceof ConstantExpression ? parameter.getText() : "";
                int paramsLength = params2.length;
                for (int j = 0; j < paramsLength; ++j) {
                    String id;
                    Parameter methodParam = params2[j];
                    List<AnnotationNode> targets = methodParam.getAnnotations(DELEGATES_TO_TARGET);
                    if (targets == null || targets.size() != 1) continue;
                    AnnotationNode targetAnnotation = targets.get(0);
                    Expression idMember = targetAnnotation.getMember("value");
                    String string2 = id = idMember instanceof ConstantExpression ? idMember.getText() : "";
                    if (!id.equals(parameterName) || j >= expressionsSize) continue;
                    Expression actualArgument = expressions.get(j);
                    ClassNode actualType = this.getType(actualArgument);
                    if (genericTypeIndex instanceof ConstantExpression) {
                        int gti = Integer.parseInt(genericTypeIndex.getText());
                        ClassNode paramType = methodParam.getType();
                        GenericsType[] genericsTypes = paramType.getGenericsTypes();
                        if (genericsTypes == null) {
                            this.addStaticTypeError("Cannot use @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") with a type that doesn't use generics", methodParam);
                        } else if (gti < 0 || gti >= genericsTypes.length) {
                            this.addStaticTypeError("Index of generic type @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") " + (gti < 0 ? "lower" : "greater") + " than those of the selected type", methodParam);
                        } else {
                            ClassNode pType = GenericsUtils.parameterizeType(actualType, paramType);
                            GenericsType[] pTypeGenerics = pType.getGenericsTypes();
                            if (pTypeGenerics != null && pTypeGenerics.length > gti) {
                                actualType = pTypeGenerics[gti].getType();
                            } else {
                                this.addStaticTypeError("Unable to map actual type [" + actualType.toString(false) + "] onto " + paramType.toString(false), methodParam);
                            }
                        }
                    }
                    expression2.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(actualType, stInt, this.typeCheckingContext.delegationMetadata));
                    break;
                }
                if (expression2.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA) != null) continue;
                this.addError("Not enough arguments found for a @DelegatesTo method call. Please check that you either use an explicit class or @DelegatesTo.Target with a correct id", arguments);
            }
        }
    }

    protected void addReceivers(List<Receiver<String>> receivers, Collection<Receiver<String>> owners, boolean implicitThis) {
        if (!implicitThis || this.typeCheckingContext.delegationMetadata == null) {
            receivers.addAll(owners);
        } else {
            StaticTypeCheckingVisitor.addReceivers(receivers, owners, this.typeCheckingContext.delegationMetadata, "");
        }
    }

    private static void addReceivers(List<Receiver<String>> receivers, Collection<Receiver<String>> owners, DelegationMetadata dmd, String path) {
        int strategy = dmd.getStrategy();
        switch (strategy) {
            case 1: 
            case 3: {
                StaticTypeCheckingVisitor.addDelegateReceiver(receivers, dmd.getType(), path + "delegate");
                if (strategy != 1) break;
                if (dmd.getParent() == null) {
                    receivers.addAll(owners);
                    break;
                }
                StaticTypeCheckingVisitor.addReceivers(receivers, owners, dmd.getParent(), path + "owner.");
                break;
            }
            case 0: 
            case 2: {
                if (dmd.getParent() == null) {
                    receivers.addAll(owners);
                } else {
                    StaticTypeCheckingVisitor.addReceivers(receivers, owners, dmd.getParent(), path + "owner.");
                }
                if (strategy != 0) break;
                StaticTypeCheckingVisitor.addDelegateReceiver(receivers, dmd.getType(), path + "delegate");
            }
        }
    }

    private static void addDelegateReceiver(List<Receiver<String>> receivers, ClassNode delegate, String path) {
        receivers.add(new Receiver<String>(delegate, path));
        if (Traits.isTrait(delegate.getOuterClass())) {
            receivers.add(new Receiver<String>(delegate.getOuterClass(), path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitMethodCallExpression(MethodCallExpression call2) {
        String name2 = call2.getMethodAsString();
        if (name2 == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call2.getMethod());
            return;
        }
        if (this.extension.beforeMethodCall(call2)) {
            this.extension.afterMethodCall(call2);
            return;
        }
        this.typeCheckingContext.pushEnclosingMethodCall(call2);
        Expression objectExpression = call2.getObjectExpression();
        objectExpression.visit(this);
        call2.getMethod().visit(this);
        if (call2.isSpreadSafe()) {
            ClassNode expressionType = this.getType(objectExpression);
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, StaticTypeCheckingSupport.Collection_TYPE) && !expressionType.isArray()) {
                this.addStaticTypeError("Spread operator can only be used on collection types", objectExpression);
                return;
            }
            ClassNode componentType = this.inferComponentType(expressionType, ClassHelper.int_TYPE);
            MethodCallExpression subcall = GeneralUtils.callX((Expression)GeneralUtils.castX(componentType, EmptyExpression.INSTANCE), name2, call2.getArguments());
            subcall.setLineNumber(call2.getLineNumber());
            subcall.setColumnNumber(call2.getColumnNumber());
            subcall.setImplicitThis(call2.isImplicitThis());
            this.visitMethodCallExpression(subcall);
            ClassNode subcallReturnType = this.getType(subcall);
            ClassNode listNode = ClassHelper.LIST_TYPE.getPlainNodeReference();
            listNode.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(subcallReturnType))});
            this.storeType(call2, listNode);
            this.storeTargetMethod(call2, (MethodNode)subcall.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            this.typeCheckingContext.popEnclosingMethodCall();
            return;
        }
        Expression callArguments = call2.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        ClassNode receiver = this.getType(objectExpression);
        this.visitMethodCallArguments(receiver, argumentList, false, null);
        ClassNode[] args2 = this.getArgumentTypes(argumentList);
        boolean isCallOnClosure = this.isClosureCall(name2, objectExpression, callArguments);
        try {
            Parameter[] parameters;
            boolean callArgsVisited = false;
            if (isCallOnClosure) {
                int nbOfArgs;
                if (objectExpression == VariableExpression.THIS_EXPRESSION) {
                    FieldNode field2 = this.typeCheckingContext.getEnclosingClassNode().getDeclaredField(name2);
                    GenericsType[] genericsTypes = field2.getType().getGenericsTypes();
                    if (genericsTypes != null) {
                        ClassNode closureReturnType = genericsTypes[0].getType();
                        Object data3 = field2.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (data3 != null) {
                            Parameter[] parameters2 = (Parameter[])data3;
                            this.typeCheckClosureCall(callArguments, args2, parameters2);
                        }
                        this.storeType(call2, closureReturnType);
                    }
                } else if (objectExpression instanceof VariableExpression) {
                    Variable variable2 = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression);
                    if (variable2 instanceof ASTNode) {
                        ClassNode type;
                        Object data2 = ((ASTNode)((Object)variable2)).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (data2 != null) {
                            parameters = (Parameter[])data2;
                            this.typeCheckClosureCall(callArguments, args2, parameters);
                        }
                        if ((type = this.getType((ASTNode)((Object)variable2))) != null && type.equals(ClassHelper.CLOSURE_TYPE)) {
                            GenericsType[] genericsTypes = type.getGenericsTypes();
                            type = ClassHelper.OBJECT_TYPE;
                            if (genericsTypes != null && !genericsTypes[0].isPlaceholder()) {
                                type = genericsTypes[0].getType();
                            }
                        }
                        if (type != null) {
                            this.storeType(call2, type);
                        }
                    }
                } else if (objectExpression instanceof ClosureExpression) {
                    Parameter[] parameters3 = ((ClosureExpression)objectExpression).getParameters();
                    this.typeCheckClosureCall(callArguments, args2, parameters3);
                    ClassNode data2 = this.getInferredReturnType(objectExpression);
                    if (data2 != null) {
                        this.storeType(call2, data2);
                    }
                }
                if (callArguments instanceof ArgumentListExpression) {
                    ArgumentListExpression list2 = (ArgumentListExpression)callArguments;
                    nbOfArgs = list2.getExpressions().size();
                } else {
                    nbOfArgs = 0;
                }
                this.storeTargetMethod(call2, nbOfArgs == 0 ? CLOSURE_CALL_NO_ARG : (nbOfArgs == 1 ? CLOSURE_CALL_ONE_ARG : CLOSURE_CALL_VARGS));
            } else {
                LinkedList<Receiver<String>> receivers = new LinkedList<Receiver<String>>();
                List<Receiver<String>> owners = this.makeOwnerList(objectExpression);
                this.addReceivers(receivers, owners, call2.isImplicitThis());
                List<MethodNode> mn = null;
                Receiver chosenReceiver = null;
                for (Receiver receiver2 : receivers) {
                    ClassNode receiverType = receiver2.getType();
                    mn = this.findMethod(receiverType, name2, args2);
                    if (!mn.isEmpty() && (this.typeCheckingContext.isInStaticContext || (receiverType.getModifiers() & 8) != 0) && (call2.isImplicitThis() || objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).isThisExpression())) {
                        LinkedList<MethodNode> accessibleMethods = new LinkedList<MethodNode>();
                        LinkedList<MethodNode> inaccessibleMethods = new LinkedList<MethodNode>();
                        for (MethodNode node : mn) {
                            if (node.isStatic() || !this.typeCheckingContext.isInStaticContext && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(receiverType, node.getDeclaringClass())) {
                                accessibleMethods.add(node);
                                continue;
                            }
                            inaccessibleMethods.add(node);
                        }
                        mn = accessibleMethods;
                        if (accessibleMethods.isEmpty()) {
                            MethodNode node = (MethodNode)inaccessibleMethods.get(0);
                            ClassNode owner = node.getDeclaringClass();
                            this.addStaticTypeError("Non static method " + owner.getName() + "#" + node.getName() + " cannot be called from static context", call2);
                        }
                    }
                    if (mn.isEmpty()) continue;
                    chosenReceiver = receiver2;
                    break;
                }
                if (mn.isEmpty() && this.typeCheckingContext.getEnclosingClosure() != null && args2.length == 0) {
                    if ("getDelegate".equals(name2)) {
                        mn = Collections.singletonList(GET_DELEGATE);
                    } else if ("getOwner".equals(name2)) {
                        mn = Collections.singletonList(GET_OWNER);
                    } else if ("getThisObject".equals(name2)) {
                        mn = Collections.singletonList(GET_THISOBJECT);
                    }
                }
                if (mn.isEmpty()) {
                    mn = this.extension.handleMissingMethod(receiver, name2, argumentList, args2, call2);
                }
                if (mn.isEmpty()) {
                    this.addNoMatchingMethodError(receiver, name2, args2, call2);
                } else {
                    if (this.areCategoryMethodCalls(mn, name2, args2)) {
                        this.addCategoryMethodCallError(call2);
                    }
                    if ((mn = this.disambiguateMethods(mn, chosenReceiver != null ? chosenReceiver.getType() : null, args2, call2)).size() == 1) {
                        ClassNode classNode;
                        MethodNode directMethodCallCandidate = mn.get(0);
                        if (call2.getNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION) == null && !directMethodCallCandidate.isStatic() && objectExpression instanceof ClassExpression && !"java.lang.Class".equals(directMethodCallCandidate.getDeclaringClass().getName())) {
                            ClassNode classNode2 = directMethodCallCandidate.getDeclaringClass();
                            this.addStaticTypeError("Non static method " + classNode2.getName() + "#" + directMethodCallCandidate.getName() + " cannot be called from static context", call2);
                        }
                        if (chosenReceiver == null) {
                            chosenReceiver = Receiver.make(directMethodCallCandidate.getDeclaringClass());
                        }
                        if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(classNode = this.getType(directMethodCallCandidate))) {
                            this.visitMethodCallArguments(chosenReceiver.getType(), argumentList, true, directMethodCallCandidate);
                            ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver.getType(), directMethodCallCandidate, callArguments, call2.getGenericsTypes());
                            ClassNode classNode3 = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, classNode) ? irtg : classNode;
                            callArgsVisited = true;
                        }
                        if (directMethodCallCandidate == GET_DELEGATE && this.typeCheckingContext.getEnclosingClosure() != null) {
                            DelegationMetadata md = this.getDelegationMetadata(this.typeCheckingContext.getEnclosingClosure().getClosureExpression());
                            ClassNode classNode4 = this.typeCheckingContext.getEnclosingClassNode();
                            if (md != null) {
                                ClassNode classNode5 = md.getType();
                            }
                        }
                        if (this.typeCheckMethodsWithGenericsOrFail(chosenReceiver.getType(), args2, mn.get(0), call2)) {
                            VariableExpression var;
                            String data4;
                            void var15_33;
                            ClassNode classNode6 = StaticTypeCheckingVisitor.adjustWithTraits(directMethodCallCandidate, chosenReceiver.getType(), args2, (ClassNode)var15_33);
                            this.storeType(call2, classNode6);
                            this.storeTargetMethod(call2, directMethodCallCandidate);
                            ClassNode declaringClass = directMethodCallCandidate.getDeclaringClass();
                            if (declaringClass.isInterface() && directMethodCallCandidate.isStatic() && !(directMethodCallCandidate instanceof ExtensionMethodNode)) {
                                this.typeCheckingContext.getEnclosingClassNode().putNodeMetaData("_MINIMUM_BYTECODE_VERSION", 52);
                            }
                            if ((data4 = (String)chosenReceiver.getData()) != null) {
                                call2.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, data4);
                            }
                            if (objectExpression instanceof VariableExpression && (var = (VariableExpression)objectExpression).isClosureSharedVariable()) {
                                SecondPassExpression<ClassNode[]> wrapper2 = new SecondPassExpression<ClassNode[]>(call2, args2);
                                this.typeCheckingContext.secondPassExpressions.add(wrapper2);
                            }
                        }
                    } else {
                        this.addAmbiguousErrorMessage(mn, name2, args2, call2);
                    }
                }
            }
            if (StaticTypeCheckingSupport.NUMBER_OPS.containsKey(name2) && ClassHelper.isNumberType(receiver) && argumentList.getExpressions().size() == 1 && ClassHelper.isNumberType(this.getType(argumentList.getExpression(0)))) {
                ClassNode right = this.getType(argumentList.getExpression(0));
                ClassNode resultType = this.getMathResultType(StaticTypeCheckingSupport.NUMBER_OPS.get(name2), receiver, right, name2);
                if (resultType != null) {
                    this.storeType(call2, resultType);
                }
            }
            if (!callArgsVisited) {
                MethodNode mn = (MethodNode)call2.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                this.visitMethodCallArguments(receiver, argumentList, true, mn);
                if (mn != null) {
                    List<Expression> argExpressions = argumentList.getExpressions();
                    parameters = mn.getParameters();
                    for (int i = 0; i < argExpressions.size() && i < parameters.length; ++i) {
                        Expression arg = argExpressions.get(i);
                        ClassNode classNode = parameters[i].getType();
                        ClassNode aType = this.getType(arg);
                        if (!ClassHelper.CLOSURE_TYPE.equals(classNode) || !ClassHelper.CLOSURE_TYPE.equals(aType) || StaticTypeCheckingSupport.isAssignableTo(aType, classNode)) continue;
                        this.addNoMatchingMethodError(receiver, name2, this.getArgumentTypes(argumentList), call2);
                        call2.removeNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                    }
                }
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingMethodCall();
            this.extension.afterMethodCall(call2);
        }
    }

    private boolean isNestedOrSandwichedMethodCall() {
        return this.typeCheckingContext.getEnclosingMethodCalls().size() > 1 || this.typeCheckingContext.getEnclosingConstructorCalls().size() > 0 || this.typeCheckingContext.getEnclosingPropertyExpressions().size() > 0;
    }

    private static ClassNode adjustWithTraits(MethodNode directMethodCallCandidate, ClassNode receiver, ClassNode[] args2, ClassNode returnType) {
        ExtensionMethodNode emn;
        if (directMethodCallCandidate instanceof ExtensionMethodNode && "withTraits".equals((emn = (ExtensionMethodNode)directMethodCallCandidate).getName()) && "DefaultGroovyMethods".equals(emn.getExtensionMethodNode().getDeclaringClass().getNameWithoutPackage())) {
            LinkedList<ClassNode> nodes2 = new LinkedList<ClassNode>();
            Collections.addAll(nodes2, receiver.getInterfaces());
            for (ClassNode arg : args2) {
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(arg)) {
                    nodes2.add(arg.getGenericsTypes()[0].getType());
                    continue;
                }
                nodes2.add(arg);
            }
            return new WideningCategories.LowestUpperBoundClassNode(returnType.getName() + "Composed", ClassHelper.OBJECT_TYPE, nodes2.toArray(ClassNode.EMPTY_ARRAY));
        }
        return returnType;
    }

    private static void addArrayMethods(List<MethodNode> methods2, ClassNode receiver, String name2, ClassNode[] args2) {
        if (args2.length != 1) {
            return;
        }
        if (!receiver.isArray()) {
            return;
        }
        if (!WideningCategories.isIntCategory(ClassHelper.getUnwrapper(args2[0]))) {
            return;
        }
        if ("getAt".equals(name2)) {
            MethodNode node = new MethodNode(name2, 1, receiver.getComponentType(), new Parameter[]{new Parameter(args2[0], "arg")}, null, null);
            node.setDeclaringClass(receiver.redirect());
            methods2.add(node);
        } else if ("setAt".equals(name2)) {
            MethodNode node = new MethodNode(name2, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(args2[0], "arg")}, null, null);
            node.setDeclaringClass(receiver.redirect());
            methods2.add(node);
        }
    }

    protected ClassNode getInferredReturnTypeFromWithClosureArgument(Expression callArguments) {
        if (!(callArguments instanceof ArgumentListExpression)) {
            return null;
        }
        ArgumentListExpression argList = (ArgumentListExpression)callArguments;
        ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
        this.visitClosureExpression(closure);
        if (this.getInferredReturnType(closure) != null) {
            return this.getInferredReturnType(closure);
        }
        return null;
    }

    protected List<Receiver<String>> makeOwnerList(Expression objectExpression) {
        List<ClassNode> potentialReceiverType;
        ClassNode receiver = this.getType(objectExpression);
        LinkedList<Receiver<String>> owners = new LinkedList<Receiver<String>>();
        owners.add(Receiver.make(receiver));
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver)) {
            GenericsType clazzGT = receiver.getGenericsTypes()[0];
            owners.add(0, Receiver.make(clazzGT.getType()));
        }
        if (receiver.isInterface()) {
            owners.add(Receiver.make(ClassHelper.OBJECT_TYPE));
        }
        StaticTypeCheckingVisitor.addSelfTypes(receiver, owners);
        if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.empty() && (potentialReceiverType = this.getTemporaryTypesForExpression(objectExpression)) != null) {
            for (ClassNode node : potentialReceiverType) {
                owners.add(Receiver.make(node));
            }
        }
        if (this.typeCheckingContext.lastImplicitItType != null && objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).getName().equals("it")) {
            owners.add(Receiver.make(this.typeCheckingContext.lastImplicitItType));
        }
        if (this.typeCheckingContext.delegationMetadata != null && objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).getName().equals("owner") && this.typeCheckingContext.delegationMetadata.getParent() != null) {
            owners.clear();
            List<Receiver<String>> enclosingClass = Collections.singletonList(Receiver.make(this.typeCheckingContext.getEnclosingClassNode()));
            StaticTypeCheckingVisitor.addReceivers(owners, enclosingClass, this.typeCheckingContext.delegationMetadata.getParent(), "owner.");
        }
        return owners;
    }

    private static void addSelfTypes(ClassNode receiver, List<Receiver<String>> owners) {
        LinkedHashSet<ClassNode> selfTypes = new LinkedHashSet<ClassNode>();
        for (ClassNode selfType : Traits.collectSelfTypes(receiver, selfTypes)) {
            owners.add(Receiver.make(selfType));
        }
    }

    protected void checkForbiddenSpreadArgument(ArgumentListExpression argumentList) {
        for (Expression arg : argumentList.getExpressions()) {
            if (!(arg instanceof SpreadExpression)) continue;
            this.addStaticTypeError("The spread operator cannot be used as argument of method or closure calls with static type checking because the number of arguments cannot be determined at compile time", arg);
        }
    }

    protected List<ClassNode> getTemporaryTypesForExpression(Expression objectExpression) {
        List classNodes = null;
        int depth = this.typeCheckingContext.temporaryIfBranchTypeInformation.size();
        while (classNodes == null && depth > 0) {
            Map tempo = (Map)this.typeCheckingContext.temporaryIfBranchTypeInformation.get(--depth);
            Object key = objectExpression instanceof ParameterVariableExpression ? ((ParameterVariableExpression)objectExpression).parameter : this.extractTemporaryTypeInfoKey(objectExpression);
            classNodes = (List)tempo.get(key);
        }
        return classNodes;
    }

    protected void storeTargetMethod(Expression call2, MethodNode directMethodCallCandidate) {
        call2.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directMethodCallCandidate);
        this.checkOrMarkPrivateAccess(call2, directMethodCallCandidate);
        this.checkSuperCallFromClosure(call2, directMethodCallCandidate);
        this.extension.onMethodSelection(call2, directMethodCallCandidate);
    }

    protected boolean isClosureCall(String name2, Expression objectExpression, Expression arguments) {
        if (objectExpression instanceof ClosureExpression && ("call".equals(name2) || "doCall".equals(name2))) {
            return true;
        }
        if (objectExpression == VariableExpression.THIS_EXPRESSION) {
            ClassNode type;
            FieldNode fieldNode = this.typeCheckingContext.getEnclosingClassNode().getDeclaredField(name2);
            if (fieldNode != null && ClassHelper.CLOSURE_TYPE.equals(type = fieldNode.getType()) && !this.typeCheckingContext.getEnclosingClassNode().hasPossibleMethod(name2, arguments)) {
                return true;
            }
        } else if (!"call".equals(name2) && !"doCall".equals(name2)) {
            return false;
        }
        return this.getType(objectExpression).equals(ClassHelper.CLOSURE_TYPE);
    }

    protected void typeCheckClosureCall(Expression callArguments, ClassNode[] args2, Parameter[] parameters) {
        if (StaticTypeCheckingSupport.allParametersAndArgumentsMatch(parameters, args2) < 0 && StaticTypeCheckingSupport.lastArgMatchesVarg(parameters, args2) < 0) {
            StringBuilder sb = new StringBuilder("[");
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                Parameter parameter = parameters[i];
                sb.append(parameter.getType().getName());
                if (i >= parametersLength - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            this.addStaticTypeError("Closure argument types: " + sb + " do not match with parameter types: " + StaticTypeCheckingVisitor.formatArgumentList(args2), callArguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIfElse(IfStatement ifElse) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            this.typeCheckingContext.pushTemporaryTypeInfo();
            this.visitStatement(ifElse);
            ifElse.getBooleanExpression().visit(this);
            ifElse.getIfBlock().visit(this);
            this.typeCheckingContext.popTemporaryTypeInfo();
            this.restoreTypeBeforeConditional();
            Statement elseBlock = ifElse.getElseBlock();
            if (elseBlock instanceof EmptyStatement) {
                this.visitEmptyStatement((EmptyStatement)elseBlock);
            } else {
                elseBlock.visit(this);
            }
        }
        finally {
            this.popAssignmentTracking(oldTracker);
        }
        BinaryExpression instanceOfExpression = this.findInstanceOfNotReturnExpression(ifElse);
        if (instanceOfExpression != null && this.typeCheckingContext.enclosingBlocks.size() > 0) {
            this.visitInstanceofNot(instanceOfExpression);
        }
    }

    public void visitInstanceofNot(BinaryExpression be) {
        BlockStatement currentBlock = this.typeCheckingContext.enclosingBlocks.getFirst();
        assert (currentBlock != null);
        if (!this.typeCheckingContext.blockStatements2Types.containsKey(currentBlock)) {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
            this.getTypeCheckingContext().pushTemporaryTypeInfo();
            this.typeCheckingContext.blockStatements2Types.put(currentBlock, oldTracker);
        }
        this.pushInstanceOfTypeInfo(be.getLeftExpression(), be.getRightExpression());
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        if (block != null) {
            this.typeCheckingContext.enclosingBlocks.addFirst(block);
        }
        super.visitBlockStatement(block);
        if (block != null) {
            this.visitClosingBlock(block);
        }
    }

    public void visitClosingBlock(BlockStatement block) {
        BlockStatement peekBlock = this.typeCheckingContext.enclosingBlocks.removeFirst();
        boolean found = this.typeCheckingContext.blockStatements2Types.containsKey(peekBlock);
        if (found) {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.typeCheckingContext.blockStatements2Types.remove(peekBlock);
            this.getTypeCheckingContext().popTemporaryTypeInfo();
            this.popAssignmentTracking(oldTracker);
        }
    }

    public BinaryExpression findInstanceOfNotReturnExpression(IfStatement ifElse) {
        Statement elseBlock = ifElse.getElseBlock();
        if (!(elseBlock instanceof EmptyStatement)) {
            return null;
        }
        Expression conditionExpression = ifElse.getBooleanExpression().getExpression();
        if (!(conditionExpression instanceof NotExpression)) {
            return null;
        }
        NotExpression notExpression = (NotExpression)conditionExpression;
        Expression expression2 = notExpression.getExpression();
        if (!(expression2 instanceof BinaryExpression)) {
            return null;
        }
        BinaryExpression instanceOfExpression = (BinaryExpression)expression2;
        int op = instanceOfExpression.getOperation().getType();
        if (op != 544) {
            return null;
        }
        Statement block = ifElse.getIfBlock();
        if (!(block instanceof BlockStatement)) {
            return null;
        }
        BlockStatement bs = (BlockStatement)block;
        if (bs.getStatements().size() == 0) {
            return null;
        }
        Statement last2 = DefaultGroovyMethods.last(bs.getStatements());
        if (!(last2 instanceof ReturnStatement)) {
            return null;
        }
        return instanceOfExpression;
    }

    @Override
    public void visitSwitch(SwitchStatement statement2) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            super.visitSwitch(statement2);
        }
        finally {
            this.popAssignmentTracking(oldTracker);
        }
    }

    @Override
    public void visitCaseStatement(CaseStatement statement2) {
        super.visitCaseStatement(statement2);
        this.restoreTypeBeforeConditional();
    }

    private void restoreTypeBeforeConditional() {
        Set<Map.Entry<VariableExpression, List<ClassNode>>> entries = this.typeCheckingContext.ifElseForWhileAssignmentTracker.entrySet();
        for (Map.Entry<VariableExpression, List<ClassNode>> entry2 : entries) {
            VariableExpression var = entry2.getKey();
            List<ClassNode> items = entry2.getValue();
            ClassNode originValue = items.get(0);
            this.storeType(var, originValue);
        }
    }

    protected Map<VariableExpression, ClassNode> popAssignmentTracking(Map<VariableExpression, List<ClassNode>> oldTracker) {
        HashMap<VariableExpression, ClassNode> assignments = new HashMap<VariableExpression, ClassNode>();
        if (!this.typeCheckingContext.ifElseForWhileAssignmentTracker.isEmpty()) {
            for (Map.Entry<VariableExpression, List<ClassNode>> entry2 : this.typeCheckingContext.ifElseForWhileAssignmentTracker.entrySet()) {
                VariableExpression key = entry2.getKey();
                List<ClassNode> allValues = entry2.getValue();
                ArrayList<ClassNode> nonNullValues = new ArrayList<ClassNode>(allValues.size());
                for (ClassNode value2 : allValues) {
                    if (value2 == null) continue;
                    nonNullValues.add(value2);
                }
                ClassNode cn = WideningCategories.lowestUpperBound(nonNullValues);
                this.storeType(key, cn);
                assignments.put(key, cn);
            }
        }
        this.typeCheckingContext.ifElseForWhileAssignmentTracker = oldTracker;
        return assignments;
    }

    protected Map<VariableExpression, List<ClassNode>> pushAssignmentTracking() {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.typeCheckingContext.ifElseForWhileAssignmentTracker;
        this.typeCheckingContext.ifElseForWhileAssignmentTracker = new HashMap<VariableExpression, List<ClassNode>>();
        return oldTracker;
    }

    @Override
    public void visitCastExpression(CastExpression expression2) {
        super.visitCastExpression(expression2);
        if (!expression2.isCoerce()) {
            ClassNode targetType = expression2.getType();
            Expression source = expression2.getExpression();
            ClassNode expressionType = this.getType(source);
            if (!this.checkCast(targetType, source) && !this.isDelegateOrOwnerInClosure(source)) {
                this.addStaticTypeError("Inconvertible types: cannot cast " + expressionType.toString(false) + " to " + targetType.toString(false), expression2);
            }
        }
        this.storeType(expression2, expression2.getType());
    }

    private boolean isDelegateOrOwnerInClosure(Expression exp) {
        return this.typeCheckingContext.getEnclosingClosure() != null && exp instanceof VariableExpression && ("delegate".equals(((VariableExpression)exp).getName()) || "owner".equals(((VariableExpression)exp).getName()));
    }

    protected boolean checkCast(ClassNode targetType, Expression source) {
        boolean sourceIsNull = StaticTypeCheckingVisitor.isNullConstant(source);
        ClassNode expressionType = this.getType(source);
        if (targetType.isArray() && expressionType.isArray()) {
            return this.checkCast(targetType.getComponentType(), GeneralUtils.varX("foo", expressionType.getComponentType()));
        }
        if (!(targetType.equals(ClassHelper.char_TYPE) && expressionType == ClassHelper.STRING_TYPE && source instanceof ConstantExpression && source.getText().length() == 1 || targetType.equals(ClassHelper.Character_TYPE) && (expressionType == ClassHelper.STRING_TYPE || sourceIsNull) && (sourceIsNull || source instanceof ConstantExpression && source.getText().length() == 1) || WideningCategories.isNumberCategory(ClassHelper.getWrapper(targetType)) && (WideningCategories.isNumberCategory(ClassHelper.getWrapper(expressionType)) || ClassHelper.char_TYPE == expressionType) || sourceIsNull && !ClassHelper.isPrimitiveType(targetType) || ClassHelper.char_TYPE == targetType && ClassHelper.isPrimitiveType(expressionType) && ClassHelper.isNumberType(expressionType))) {
            if (sourceIsNull && ClassHelper.isPrimitiveType(targetType) && !ClassHelper.boolean_TYPE.equals(targetType)) {
                return false;
            }
            if ((expressionType.getModifiers() & 0x10) == 0 && targetType.isInterface()) {
                return true;
            }
            if ((targetType.getModifiers() & 0x10) == 0 && expressionType.isInterface()) {
                return true;
            }
            if (!StaticTypeCheckingSupport.isAssignableTo(targetType, expressionType) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, targetType)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression2) {
        BinaryExpression enclosingBinaryExpression;
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        this.typeCheckingContext.pushTemporaryTypeInfo();
        expression2.getBooleanExpression().visit(this);
        Expression trueExpression = expression2.getTrueExpression();
        Expression falseExpression = expression2.getFalseExpression();
        trueExpression.visit(this);
        this.typeCheckingContext.popTemporaryTypeInfo();
        falseExpression.visit(this);
        ClassNode typeOfFalse = this.getType(falseExpression);
        ClassNode typeOfTrue = this.getType(trueExpression);
        if (StaticTypeCheckingVisitor.hasInferredReturnType(falseExpression)) {
            typeOfFalse = (ClassNode)falseExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        }
        if (StaticTypeCheckingVisitor.hasInferredReturnType(trueExpression)) {
            typeOfTrue = (ClassNode)trueExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        }
        typeOfFalse = this.checkForTargetType(falseExpression, typeOfFalse);
        typeOfTrue = this.checkForTargetType(trueExpression, typeOfTrue);
        ClassNode resultType = StaticTypeCheckingVisitor.isNullConstant(trueExpression) || StaticTypeCheckingVisitor.isNullConstant(falseExpression) ? ((enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression()) != null && enclosingBinaryExpression.getRightExpression() == expression2 ? this.getType(enclosingBinaryExpression.getLeftExpression()) : (StaticTypeCheckingVisitor.isNullConstant(trueExpression) && StaticTypeCheckingVisitor.isNullConstant(falseExpression) ? ClassHelper.OBJECT_TYPE : (StaticTypeCheckingVisitor.isNullConstant(trueExpression) ? StaticTypeCheckingVisitor.wrapTypeIfNecessary(typeOfFalse) : StaticTypeCheckingVisitor.wrapTypeIfNecessary(typeOfTrue)))) : WideningCategories.lowestUpperBound(typeOfTrue, typeOfFalse);
        this.storeType(expression2, resultType);
        this.popAssignmentTracking(oldTracker);
    }

    private ClassNode checkForTargetType(Expression expr2, ClassNode type) {
        BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
        if (enclosingBinaryExpression instanceof DeclarationExpression && StaticTypeCheckingVisitor.isEmptyCollection(expr2) && StaticTypeCheckingSupport.isAssignment(enclosingBinaryExpression.getOperation().getType())) {
            VariableExpression target = (VariableExpression)enclosingBinaryExpression.getLeftExpression();
            return StaticTypeCheckingVisitor.adjustForTargetType(target.getType(), type);
        }
        if (this.currentField != null) {
            return StaticTypeCheckingVisitor.adjustForTargetType(this.currentField.getType(), type);
        }
        if (this.currentProperty != null) {
            return StaticTypeCheckingVisitor.adjustForTargetType(this.currentProperty.getType(), type);
        }
        MethodNode enclosingMethod = this.typeCheckingContext.getEnclosingMethod();
        if (enclosingMethod != null) {
            return StaticTypeCheckingVisitor.adjustForTargetType(enclosingMethod.getReturnType(), type);
        }
        return type;
    }

    private static ClassNode adjustForTargetType(ClassNode targetType, ClassNode resultType) {
        if (targetType.isUsingGenerics() && StaticTypeCheckingSupport.missesGenericsTypes(resultType)) {
            return GenericsUtils.parameterizeType(targetType, resultType.getPlainNodeReference());
        }
        return resultType;
    }

    private static boolean isEmptyCollection(Expression expr2) {
        return expr2 instanceof ListExpression && ((ListExpression)expr2).getExpressions().size() == 0 || expr2 instanceof MapExpression && ((MapExpression)expr2).getMapEntryExpressions().size() == 0;
    }

    private static boolean hasInferredReturnType(Expression expression2) {
        ClassNode type = (ClassNode)expression2.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        return type != null && !type.getName().equals("java.lang.Object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitTryCatchFinally(TryCatchStatement statement2) {
        List<CatchStatement> catchStatements = statement2.getCatchStatements();
        for (CatchStatement catchStatement : catchStatements) {
            ClassNode exceptionType = catchStatement.getExceptionType();
            this.typeCheckingContext.controlStructureVariables.put(catchStatement.getVariable(), exceptionType);
        }
        try {
            super.visitTryCatchFinally(statement2);
        }
        finally {
            for (CatchStatement catchStatement : catchStatements) {
                this.typeCheckingContext.controlStructureVariables.remove(catchStatement.getVariable());
            }
        }
    }

    protected void storeType(Expression exp, ClassNode cn) {
        if (exp instanceof VariableExpression && ((VariableExpression)exp).isClosureSharedVariable() && ClassHelper.isPrimitiveType(cn)) {
            cn = ClassHelper.getWrapper(cn);
        } else if (exp instanceof MethodCallExpression && ((MethodCallExpression)exp).isSafe() && ClassHelper.isPrimitiveType(cn)) {
            cn = ClassHelper.getWrapper(cn);
        } else if (exp instanceof PropertyExpression && ((PropertyExpression)exp).isSafe() && ClassHelper.isPrimitiveType(cn)) {
            cn = ClassHelper.getWrapper(cn);
        }
        if (cn == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE) {
            this.storeType(exp, this.getOriginalDeclarationType(exp));
            return;
        }
        ClassNode oldValue = (ClassNode)exp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn);
        if (oldValue != null) {
            ClassNode oldDIT = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            if (oldDIT != null) {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, cn == null ? oldDIT : WideningCategories.lowestUpperBound(oldDIT, cn));
            } else {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, cn == null ? null : WideningCategories.lowestUpperBound(oldValue, cn));
            }
        }
        if (exp instanceof VariableExpression) {
            List<ClassNode> temporaryTypesForExpression;
            VariableExpression var = (VariableExpression)exp;
            Variable accessedVariable = var.getAccessedVariable();
            if (accessedVariable != exp && accessedVariable instanceof VariableExpression) {
                this.storeType((Expression)((Object)accessedVariable), cn);
            }
            if (accessedVariable instanceof Parameter) {
                ((Parameter)accessedVariable).putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn);
            }
            if (var.isClosureSharedVariable() && cn != null) {
                List<ClassNode> assignedTypes = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var);
                if (assignedTypes == null) {
                    assignedTypes = new LinkedList<ClassNode>();
                    this.typeCheckingContext.closureSharedVariablesAssignmentTypes.put(var, assignedTypes);
                }
                assignedTypes.add(cn);
            }
            if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.empty() && (temporaryTypesForExpression = this.getTemporaryTypesForExpression(exp)) != null && !temporaryTypesForExpression.isEmpty()) {
                temporaryTypesForExpression.clear();
            }
        }
    }

    protected ClassNode getResultType(ClassNode left, int op, ClassNode right, BinaryExpression expr2) {
        MethodNode method;
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        Expression leftExpression = expr2.getLeftExpression();
        Expression rightExpression = expr2.getRightExpression();
        if (op == 100 || op == 1100) {
            if (leftRedirect.isArray() && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(rightRedirect, StaticTypeCheckingSupport.Collection_TYPE)) {
                return leftRedirect;
            }
            if (leftRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE)) {
                List<Expression> list2;
                if (rightExpression instanceof ListExpression && (list2 = ((ListExpression)rightExpression).getExpressions()).isEmpty()) {
                    return left;
                }
                return right;
            }
            if (rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.isDerivedFrom(leftRedirect)) {
                return right;
            }
            if (rightRedirect.isDerivedFrom(ClassHelper.CLOSURE_TYPE) && ClassHelper.isSAMType(leftRedirect) && rightExpression instanceof ClosureExpression) {
                return this.inferSAMTypeGenericsInAssignment(left, ClassHelper.findSAM(left), right, (ClosureExpression)rightExpression);
            }
            if (leftExpression instanceof VariableExpression) {
                ClassNode initialType = this.getOriginalDeclarationType(leftExpression).redirect();
                if (ClassHelper.isPrimitiveType(right) && initialType.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getWrapper(right);
                }
                if (ClassHelper.isPrimitiveType(initialType) && rightRedirect.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getUnwrapper(right);
                }
                if (ClassHelper.STRING_TYPE.equals(initialType) || ClassHelper.CLASS_Type.equals(initialType) || ClassHelper.Boolean_TYPE.equals(initialType) || ClassHelper.boolean_TYPE.equals(initialType)) {
                    return initialType;
                }
            }
            return right;
        }
        if (StaticTypeCheckingSupport.isBoolIntrinsicOp(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isArrayOp(op)) {
            BinaryExpression newExpr = GeneralUtils.binX(leftExpression, expr2.getOperation(), rightExpression);
            newExpr.setSourcePosition(expr2);
            MethodNode method2 = this.findMethodOrFail(newExpr, left.getPlainNodeReference(), "getAt", right.getPlainNodeReference());
            if (method2 != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(right, ClassHelper.RANGE_TYPE)) {
                return this.inferReturnTypeGenerics(left, method2, rightExpression);
            }
            return method2 != null ? this.inferComponentType(left, right) : null;
        }
        if (op == 90) {
            return StaticTypeCheckingSupport.Matcher_TYPE;
        }
        String operationName = StaticTypeCheckingSupport.getOperationName(op);
        ClassNode mathResultType = this.getMathResultType(op, leftRedirect, rightRedirect, operationName);
        if (mathResultType != null) {
            return mathResultType;
        }
        if (leftExpression instanceof ClassExpression) {
            left = ClassHelper.CLASS_Type.getPlainNodeReference();
        }
        if ((method = this.findMethodOrFail(expr2, left, operationName, right)) != null) {
            this.storeTargetMethod(expr2, method);
            this.typeCheckMethodsWithGenericsOrFail(left, new ClassNode[]{right}, method, expr2);
            if (StaticTypeCheckingSupport.isAssignment(op)) {
                return left;
            }
            if (StaticTypeCheckingSupport.isCompareToBoolean(op)) {
                return ClassHelper.boolean_TYPE;
            }
            if (op == 128) {
                return ClassHelper.int_TYPE;
            }
            return this.inferReturnTypeGenerics(left, method, GeneralUtils.args(rightExpression));
        }
        return null;
    }

    private ClassNode getMathResultType(int op, ClassNode leftRedirect, ClassNode rightRedirect, String operationName) {
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            if (StaticTypeCheckingSupport.isOperationInGroup(op)) {
                if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                    return ClassHelper.int_TYPE;
                }
                if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                    return ClassHelper.long_TYPE;
                }
                if (WideningCategories.isFloat(leftRedirect) && WideningCategories.isFloat(rightRedirect)) {
                    return ClassHelper.float_TYPE;
                }
                if (WideningCategories.isDouble(leftRedirect) && WideningCategories.isDouble(rightRedirect)) {
                    return ClassHelper.double_TYPE;
                }
            } else {
                if (StaticTypeCheckingSupport.isPowerOperator(op)) {
                    return ClassHelper.Number_TYPE;
                }
                if (StaticTypeCheckingSupport.isBitOperator(op) || op == 204 || op == 214) {
                    if (WideningCategories.isIntCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isIntCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.int_TYPE;
                    }
                    if (WideningCategories.isLongCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isLongCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.long_TYPE;
                    }
                    if (WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.BigInteger_TYPE;
                    }
                } else if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120) {
                    return ClassHelper.boolean_TYPE;
                }
            }
        } else if (ClassHelper.char_TYPE.equals(leftRedirect) && ClassHelper.char_TYPE.equals(rightRedirect) && (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isShiftOperation(operationName) && WideningCategories.isNumberCategory(leftRedirect) && (WideningCategories.isIntCategory(rightRedirect) || WideningCategories.isLongCategory(rightRedirect))) {
            return leftRedirect;
        }
        if (WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && (203 == op || 213 == op)) {
            if (WideningCategories.isFloatingCategory(leftRedirect) || WideningCategories.isFloatingCategory(rightRedirect)) {
                if (!ClassHelper.isPrimitiveType(leftRedirect) || !ClassHelper.isPrimitiveType(rightRedirect)) {
                    return ClassHelper.Double_TYPE;
                }
                return ClassHelper.double_TYPE;
            }
            if (203 == op) {
                return ClassHelper.BigDecimal_TYPE;
            }
            return leftRedirect;
        }
        if (StaticTypeCheckingSupport.isOperationInGroup(op) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect))) {
            return StaticTypeCheckingVisitor.getGroupOperationResultType(leftRedirect, rightRedirect);
        }
        if (WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && (205 == op || 215 == op)) {
            return leftRedirect;
        }
        return null;
    }

    private ClassNode inferSAMTypeGenericsInAssignment(ClassNode samUsage, MethodNode sam, ClassNode closureType, ClosureExpression closureExpression) {
        GenericsType[] samGt = samUsage.getGenericsTypes();
        GenericsType[] closureGt = closureType.getGenericsTypes();
        if (samGt == null || closureGt == null) {
            return samUsage;
        }
        HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        StaticTypeCheckingSupport.extractGenericsConnections(connections, this.getInferredReturnType(closureExpression), sam.getReturnType());
        if (closureExpression.isParameterSpecified()) {
            Parameter[] closureParams = closureExpression.getParameters();
            Parameter[] methodParams = sam.getParameters();
            for (int i = 0; i < closureParams.length; ++i) {
                ClassNode fromClosure = closureParams[i].getType();
                ClassNode fromMethod = methodParams[i].getType();
                StaticTypeCheckingSupport.extractGenericsConnections(connections, fromClosure, fromMethod);
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(connections, samUsage.redirect());
    }

    protected static ClassNode getGroupOperationResultType(ClassNode a, ClassNode b) {
        if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
            return ClassHelper.BigInteger_TYPE;
        }
        if (WideningCategories.isBigDecCategory(a) && WideningCategories.isBigDecCategory(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigDecimal_TYPE.equals(a) || ClassHelper.BigDecimal_TYPE.equals(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigInteger_TYPE.equals(a) || ClassHelper.BigInteger_TYPE.equals(b)) {
            if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
                return ClassHelper.BigInteger_TYPE;
            }
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.double_TYPE.equals(a) || ClassHelper.double_TYPE.equals(b)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Double_TYPE.equals(a) || ClassHelper.Double_TYPE.equals(b)) {
            return ClassHelper.Double_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(a) || ClassHelper.float_TYPE.equals(b)) {
            return ClassHelper.float_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(a) || ClassHelper.Float_TYPE.equals(b)) {
            return ClassHelper.Float_TYPE;
        }
        if (ClassHelper.long_TYPE.equals(a) || ClassHelper.long_TYPE.equals(b)) {
            return ClassHelper.long_TYPE;
        }
        if (ClassHelper.Long_TYPE.equals(a) || ClassHelper.Long_TYPE.equals(b)) {
            return ClassHelper.Long_TYPE;
        }
        if (ClassHelper.int_TYPE.equals(a) || ClassHelper.int_TYPE.equals(b)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Integer_TYPE.equals(a) || ClassHelper.Integer_TYPE.equals(b)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.short_TYPE.equals(a) || ClassHelper.short_TYPE.equals(b)) {
            return ClassHelper.short_TYPE;
        }
        if (ClassHelper.Short_TYPE.equals(a) || ClassHelper.Short_TYPE.equals(b)) {
            return ClassHelper.Short_TYPE;
        }
        if (ClassHelper.byte_TYPE.equals(a) || ClassHelper.byte_TYPE.equals(b)) {
            return ClassHelper.byte_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(a) || ClassHelper.Byte_TYPE.equals(b)) {
            return ClassHelper.Byte_TYPE;
        }
        if (ClassHelper.char_TYPE.equals(a) || ClassHelper.char_TYPE.equals(b)) {
            return ClassHelper.char_TYPE;
        }
        if (ClassHelper.Character_TYPE.equals(a) || ClassHelper.Character_TYPE.equals(b)) {
            return ClassHelper.Character_TYPE;
        }
        return ClassHelper.Number_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassNode inferComponentType(ClassNode containerType, ClassNode indexType) {
        ClassNode componentType = containerType.getComponentType();
        if (componentType == null) {
            this.typeCheckingContext.pushErrorCollector();
            MethodCallExpression vcall = GeneralUtils.callX((Expression)GeneralUtils.localVarX("_hash_", containerType), "getAt", (Expression)GeneralUtils.varX("_index_", indexType));
            vcall.setImplicitThis(false);
            try {
                this.visitMethodCallExpression(vcall);
            }
            finally {
                this.typeCheckingContext.popErrorCollector();
            }
            return this.getType(vcall);
        }
        return componentType;
    }

    protected MethodNode findMethodOrFail(Expression expr2, ClassNode receiver, String name2, ClassNode ... args2) {
        List<MethodNode> methods2 = this.findMethod(receiver, name2, args2);
        if (methods2.isEmpty() && expr2 instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expr2;
            MethodCallExpression call2 = GeneralUtils.callX(be.getLeftExpression(), name2, be.getRightExpression());
            methods2 = this.extension.handleMissingMethod(receiver, name2, GeneralUtils.args(be.getLeftExpression()), args2, call2);
        }
        if (methods2.isEmpty()) {
            this.addNoMatchingMethodError(receiver, name2, args2, expr2);
        } else {
            if (this.areCategoryMethodCalls(methods2, name2, args2)) {
                this.addCategoryMethodCallError(expr2);
            }
            if ((methods2 = this.disambiguateMethods(methods2, receiver, args2, expr2)).size() == 1) {
                return methods2.get(0);
            }
            this.addAmbiguousErrorMessage(methods2, name2, args2, expr2);
        }
        return null;
    }

    private List<MethodNode> disambiguateMethods(List<MethodNode> methods2, ClassNode receiver, ClassNode[] argTypes, Expression expr2) {
        if (methods2.size() > 1 && receiver != null && argTypes != null) {
            LinkedList<MethodNode> filteredWithGenerics = new LinkedList<MethodNode>();
            for (MethodNode methodNode : methods2) {
                if (!StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver, argTypes, methodNode)) continue;
                filteredWithGenerics.add(methodNode);
            }
            if (filteredWithGenerics.size() == 1) {
                return filteredWithGenerics;
            }
            methods2 = this.extension.handleAmbiguousMethods(methods2, expr2);
        }
        return methods2;
    }

    protected static String prettyPrintMethodList(List<MethodNode> nodes2) {
        StringBuilder sb = new StringBuilder("[");
        int nodesSize = nodes2.size();
        for (int i = 0; i < nodesSize; ++i) {
            MethodNode node = nodes2.get(i);
            sb.append(node.getReturnType().toString(false));
            sb.append(" ");
            sb.append(node.getDeclaringClass().toString(false));
            sb.append("#");
            sb.append(StaticTypeCheckingSupport.toMethodParametersString(node.getName(), StaticTypeCheckingVisitor.extractTypesFromParameters(node.getParameters())));
            if (i >= nodesSize - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected boolean areCategoryMethodCalls(List<MethodNode> foundMethods, String name2, ClassNode[] args2) {
        boolean category = false;
        if ("use".equals(name2) && args2 != null && args2.length == 2 && args2[1].equals(ClassHelper.CLOSURE_TYPE)) {
            category = true;
            for (MethodNode method : foundMethods) {
                if (method instanceof ExtensionMethodNode && ((ExtensionMethodNode)method).getExtensionMethodNode().getDeclaringClass().equals(DGM_CLASSNODE)) continue;
                category = false;
                break;
            }
        }
        return category;
    }

    protected List<MethodNode> findMethodsWithGenerated(ClassNode receiver, String name2) {
        List<MethodNode> methods2 = receiver.getMethods(name2);
        if (methods2.isEmpty() || receiver.isResolved()) {
            return methods2;
        }
        List<MethodNode> result2 = StaticTypeCheckingVisitor.addGeneratedMethods(receiver, methods2);
        return result2;
    }

    private static List<MethodNode> addGeneratedMethods(ClassNode receiver, List<MethodNode> methods2) {
        LinkedList<MethodNode> result2 = new LinkedList<MethodNode>();
        for (MethodNode method : methods2) {
            result2.add(method);
            Parameter[] parameters = method.getParameters();
            int counter = 0;
            int size2 = parameters.length;
            for (int i = size2 - 1; i >= 0; --i) {
                Parameter parameter = parameters[i];
                if (parameter == null || !parameter.hasInitialExpression()) continue;
                ++counter;
            }
            for (int j = 1; j <= counter; ++j) {
                MethodNode stubbed;
                Parameter[] newParams = new Parameter[parameters.length - j];
                int index2 = 0;
                int k = 1;
                for (Parameter parameter : parameters) {
                    if (k > counter - j && parameter != null && parameter.hasInitialExpression()) {
                        ++k;
                        continue;
                    }
                    if (parameter != null && parameter.hasInitialExpression()) {
                        newParams[index2++] = parameter;
                        ++k;
                        continue;
                    }
                    newParams[index2++] = parameter;
                }
                if ("<init>".equals(method.getName())) {
                    stubbed = new ConstructorNode(method.getModifiers(), newParams, method.getExceptions(), GENERATED_EMPTY_STATEMENT);
                } else {
                    stubbed = new MethodNode(method.getName(), method.getModifiers(), method.getReturnType(), newParams, method.getExceptions(), GENERATED_EMPTY_STATEMENT);
                    stubbed.setGenericsTypes(method.getGenericsTypes());
                }
                stubbed.setDeclaringClass(method.getDeclaringClass());
                result2.add(stubbed);
            }
        }
        return result2;
    }

    protected List<MethodNode> findMethod(ClassNode receiver, String name2, ClassNode ... args2) {
        List<MethodNode> result2;
        MethodNode constructor;
        List<MethodNode> methods2;
        if (ClassHelper.isPrimitiveType(receiver)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        if (!receiver.isInterface() && "<init>".equals(name2)) {
            methods2 = StaticTypeCheckingVisitor.addGeneratedMethods(receiver, new ArrayList<MethodNode>(receiver.getDeclaredConstructors()));
            if (methods2.isEmpty()) {
                ConstructorNode node = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                node.setDeclaringClass(receiver);
                methods2 = Collections.singletonList(node);
                if (receiver.isArray()) {
                    return methods2;
                }
            }
        } else {
            String pname;
            methods2 = this.findMethodsWithGenerated(receiver, name2);
            if (receiver.isInterface()) {
                this.collectAllInterfaceMethodsByName(receiver, name2, methods2);
                methods2.addAll(ClassHelper.OBJECT_TYPE.getMethods(name2));
            }
            if (this.typeCheckingContext.getEnclosingClosure() == null || receiver instanceof InnerClassNode && !receiver.getName().endsWith("$Trait$Helper")) {
                ClassNode parent = receiver;
                while (parent instanceof InnerClassNode && !parent.isStaticClass()) {
                    parent = parent.getOuterClass();
                    methods2.addAll(this.findMethodsWithGenerated(parent, name2));
                }
            }
            if (methods2.isEmpty()) {
                StaticTypeCheckingVisitor.addArrayMethods(methods2, receiver, name2, args2);
            }
            if (methods2.isEmpty() && (args2 == null || args2.length == 0)) {
                pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("get", name2);
                if (pname == null) {
                    pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("is", name2);
                }
                if (pname != null) {
                    PropertyNode property = null;
                    block1: for (ClassNode curNode = receiver; property == null && curNode != null; curNode = curNode.getSuperClass()) {
                        property = curNode.getProperty(pname);
                        ClassNode svCur = curNode;
                        while (property == null && svCur instanceof InnerClassNode && !svCur.isStaticClass()) {
                            property = (svCur = svCur.getOuterClass()).getProperty(pname);
                            if (property == null) continue;
                            receiver = svCur;
                            continue block1;
                        }
                    }
                    if (property != null) {
                        MethodNode node = new MethodNode(name2, 1, property.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                        if (property.isStatic()) {
                            node.setModifiers(9);
                        }
                        node.setDeclaringClass(receiver);
                        return Collections.singletonList(node);
                    }
                }
            } else if (methods2.isEmpty() && args2 != null && args2.length == 1 && (pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("set", name2)) != null) {
                PropertyNode property = null;
                for (ClassNode curNode = receiver; property == null && curNode != null; curNode = curNode.getSuperClass()) {
                    property = curNode.getProperty(pname);
                }
                if (property != null) {
                    ClassNode type = property.getOriginType();
                    if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(StaticTypeCheckingVisitor.wrapTypeIfNecessary(args2[0]), StaticTypeCheckingVisitor.wrapTypeIfNecessary(type))) {
                        MethodNode node = new MethodNode(name2, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(type, "arg")}, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                        if (property.isStatic()) {
                            node.setModifiers(9);
                        }
                        node.setDeclaringClass(receiver);
                        return Collections.singletonList(node);
                    }
                }
            }
        }
        if (methods2.isEmpty()) {
            this.collectAllInterfaceMethodsByName(receiver, name2, methods2);
        }
        StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getTransformLoader(), receiver, name2, args2, methods2);
        methods2 = this.filterMethodsByVisibility(methods2);
        List<MethodNode> chosen = StaticTypeCheckingSupport.chooseBestMethod(receiver, methods2, args2);
        if (!chosen.isEmpty()) {
            return chosen;
        }
        if (receiver instanceof InnerClassNode && ((InnerClassNode)receiver).isAnonymous() && methods2.size() == 1 && args2 != null && "<init>".equals(name2) && (constructor = methods2.get(0)).getParameters().length == args2.length) {
            return methods2;
        }
        if (receiver.equals(ClassHelper.CLASS_Type) && receiver.getGenericsTypes() != null && !(result2 = this.findMethod(receiver.getGenericsTypes()[0].getType(), name2, args2)).isEmpty()) {
            return result2;
        }
        if (ClassHelper.GSTRING_TYPE.equals(receiver)) {
            return this.findMethod(ClassHelper.STRING_TYPE, name2, args2);
        }
        if (StaticTypeCheckingSupport.isBeingCompiled(receiver) && !(chosen = this.findMethod(ClassHelper.GROOVY_OBJECT_TYPE, name2, args2)).isEmpty()) {
            return chosen;
        }
        return EMPTY_METHODNODE_LIST;
    }

    private List<MethodNode> filterMethodsByVisibility(List<MethodNode> methods2) {
        if (!DefaultGroovyMethods.asBoolean(methods2)) {
            return EMPTY_METHODNODE_LIST;
        }
        LinkedList<MethodNode> result2 = new LinkedList<MethodNode>();
        ClassNode enclosingClassNode = this.typeCheckingContext.getEnclosingClassNode();
        boolean isEnclosingInnerClass = enclosingClassNode instanceof InnerClassNode;
        List<ClassNode> outerClasses = enclosingClassNode.getOuterClasses();
        block0: for (MethodNode methodNode : methods2) {
            if (methodNode instanceof ExtensionMethodNode) {
                result2.add(methodNode);
                continue;
            }
            ClassNode declaringClass = methodNode.getDeclaringClass();
            if (isEnclosingInnerClass) {
                for (ClassNode outerClass : outerClasses) {
                    if (!outerClass.isDerivedFrom(declaringClass)) continue;
                    if (outerClass.equals(declaringClass)) {
                        result2.add(methodNode);
                        continue block0;
                    }
                    if (!methodNode.isPublic() && !methodNode.isProtected()) continue;
                    result2.add(methodNode);
                    continue block0;
                }
            }
            if (declaringClass instanceof InnerClassNode && declaringClass.getOuterClasses().contains(enclosingClassNode)) {
                result2.add(methodNode);
                continue;
            }
            if (methodNode.isPrivate() && !enclosingClassNode.equals(declaringClass) || methodNode.isProtected() && !enclosingClassNode.isDerivedFrom(declaringClass) && !ClassNodeUtils.samePackageName(enclosingClassNode, declaringClass) || methodNode.isPackageScope() && !ClassNodeUtils.samePackageName(enclosingClassNode, declaringClass)) continue;
            result2.add(methodNode);
        }
        return result2;
    }

    public static String extractPropertyNameFromMethodName(String prefix, String methodName) {
        String propertyName;
        String result2;
        if (prefix == null || methodName == null) {
            return null;
        }
        if (methodName.startsWith(prefix) && prefix.length() < methodName.length() && (result2 = methodName.substring(prefix.length())).equals(MetaClassHelper.capitalize(propertyName = Introspector.decapitalize(result2)))) {
            return propertyName;
        }
        return null;
    }

    protected void collectAllInterfaceMethodsByName(ClassNode receiver, String name2, List<MethodNode> methods2) {
        for (ClassNode cNode = receiver; cNode != null; cNode = cNode.getSuperClass()) {
            ClassNode[] interfaces2 = cNode.getInterfaces();
            if (interfaces2 == null || interfaces2.length <= 0) continue;
            for (ClassNode node : interfaces2) {
                List<MethodNode> intfMethods = node.getMethods(name2);
                methods2.addAll(intfMethods);
                this.collectAllInterfaceMethodsByName(node, name2, methods2);
            }
        }
    }

    protected ClassNode getType(ASTNode exp) {
        MethodNode target;
        ClassNode cn = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn != null) {
            return cn;
        }
        if (exp instanceof ClassExpression) {
            ClassNode node = ClassHelper.CLASS_Type.getPlainNodeReference();
            node.setGenericsTypes(new GenericsType[]{new GenericsType(((ClassExpression)exp).getType())});
            return node;
        }
        if (exp instanceof VariableExpression) {
            VariableExpression vexp = (VariableExpression)exp;
            ClassNode selfTrait = StaticTypeCheckingSupport.isTraitSelf(vexp);
            if (selfTrait != null) {
                return StaticTypeCheckingVisitor.makeSelf(selfTrait);
            }
            if (vexp == VariableExpression.THIS_EXPRESSION) {
                return this.makeThis();
            }
            if (vexp == VariableExpression.SUPER_EXPRESSION) {
                return this.makeSuper();
            }
            Variable variable2 = vexp.getAccessedVariable();
            if (variable2 instanceof FieldNode) {
                FieldNode fieldNode = (FieldNode)variable2;
                this.checkOrMarkPrivateAccess(vexp, fieldNode, this.isLHSOfEnclosingAssignment(vexp));
                return this.getType(fieldNode);
            }
            if (variable2 != vexp && variable2 instanceof VariableExpression) {
                return this.getType((Expression)((Object)variable2));
            }
            if (variable2 instanceof Parameter) {
                Parameter parameter = (Parameter)variable2;
                ClassNode type = null;
                List<ClassNode> temporaryTypesForExpression = this.getTemporaryTypesForExpression(vexp);
                if (temporaryTypesForExpression == null || temporaryTypesForExpression.isEmpty()) {
                    type = this.typeCheckingContext.controlStructureVariables.get(parameter);
                }
                TypeCheckingContext.EnclosingClosure enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
                if (type == null && enclosingClosure != null && temporaryTypesForExpression == null) {
                    type = this.getTypeFromClosureArguments(parameter, enclosingClosure);
                }
                if (type != null) {
                    this.storeType(vexp, type);
                    return type;
                }
                return this.getType((Parameter)variable2);
            }
            return vexp.getOriginType();
        }
        if (exp instanceof ListExpression) {
            return this.inferListExpressionType((ListExpression)exp);
        }
        if (exp instanceof MapExpression) {
            return this.inferMapExpressionType((MapExpression)exp);
        }
        if (exp instanceof ConstructorCallExpression) {
            return ((ConstructorCallExpression)exp).getType();
        }
        if (exp instanceof MethodNode) {
            if ((exp == GET_DELEGATE || exp == GET_OWNER || exp == GET_THISOBJECT) && this.typeCheckingContext.getEnclosingClosure() != null) {
                return this.typeCheckingContext.getEnclosingClassNode();
            }
            ClassNode ret = this.getInferredReturnType(exp);
            return ret != null ? ret : ((MethodNode)exp).getReturnType();
        }
        if (exp instanceof RangeExpression) {
            ClassNode toType;
            ClassNode plain = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            RangeExpression re = (RangeExpression)exp;
            ClassNode fromType2 = this.getType(re.getFrom());
            if (fromType2.equals(toType = this.getType(re.getTo()))) {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(fromType2))});
            } else {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(WideningCategories.lowestUpperBound(fromType2, toType)))});
            }
            return plain;
        }
        if (exp instanceof UnaryPlusExpression) {
            return this.getType(((UnaryPlusExpression)exp).getExpression());
        }
        if (exp instanceof UnaryMinusExpression) {
            return this.getType(((UnaryMinusExpression)exp).getExpression());
        }
        if (exp instanceof BitwiseNegationExpression) {
            return this.getType(((BitwiseNegationExpression)exp).getExpression());
        }
        if (exp instanceof Parameter) {
            return ((Parameter)exp).getOriginType();
        }
        if (exp instanceof FieldNode) {
            FieldNode fn2 = (FieldNode)exp;
            return this.getGenericsResolvedTypeOfFieldOrProperty(fn2, fn2.getOriginType());
        }
        if (exp instanceof PropertyNode) {
            PropertyNode pn = (PropertyNode)exp;
            return this.getGenericsResolvedTypeOfFieldOrProperty(pn, pn.getOriginType());
        }
        if (exp instanceof ClosureExpression) {
            ClassNode irt = this.getInferredReturnType(exp);
            if (irt != null) {
                irt = StaticTypeCheckingVisitor.wrapTypeIfNecessary(irt);
                ClassNode result2 = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
                result2.setGenericsTypes(new GenericsType[]{new GenericsType(irt)});
                return result2;
            }
        } else if (exp instanceof MethodCall && (target = (MethodNode)exp.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) != null) {
            return this.getType(target);
        }
        return ((Expression)exp).getType();
    }

    private ClassNode getTypeFromClosureArguments(Parameter parameter, TypeCheckingContext.EnclosingClosure enclosingClosure) {
        ClosureExpression closureExpression = enclosingClosure.getClosureExpression();
        ClassNode[] closureParamTypes = (ClassNode[])closureExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
        if (closureParamTypes == null) {
            return null;
        }
        Parameter[] parameters = closureExpression.getParameters();
        String name2 = parameter.getName();
        if (parameters != null) {
            if (parameters.length == 0) {
                return "it".equals(name2) && closureParamTypes.length != 0 ? closureParamTypes[0] : null;
            }
            for (int index2 = 0; index2 < parameters.length; ++index2) {
                if (!name2.equals(parameters[index2].getName())) continue;
                return closureParamTypes.length > index2 ? closureParamTypes[index2] : null;
            }
        }
        return null;
    }

    private ClassNode getGenericsResolvedTypeOfFieldOrProperty(AnnotatedNode an, ClassNode type) {
        if (!type.isUsingGenerics()) {
            return type;
        }
        HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        StaticTypeCheckingSupport.extractGenericsConnections(connections, this.typeCheckingContext.getEnclosingClassNode(), an.getDeclaringClass());
        type = StaticTypeCheckingSupport.applyGenericsContext(connections, type);
        return type;
    }

    private ClassNode makeSuper() {
        ClassNode ret = this.typeCheckingContext.getEnclosingClassNode().getSuperClass();
        if (this.typeCheckingContext.isInStaticContext) {
            ClassNode staticRet = ClassHelper.CLASS_Type.getPlainNodeReference();
            GenericsType gt = new GenericsType(ret);
            staticRet.setGenericsTypes(new GenericsType[]{gt});
            ret = staticRet;
        }
        return ret;
    }

    private ClassNode makeThis() {
        ClassNode ret = this.typeCheckingContext.getEnclosingClassNode();
        if (this.typeCheckingContext.isInStaticContext) {
            ClassNode staticRet = ClassHelper.CLASS_Type.getPlainNodeReference();
            GenericsType gt = new GenericsType(ret);
            staticRet.setGenericsTypes(new GenericsType[]{gt});
            ret = staticRet;
        }
        return ret;
    }

    private static ClassNode makeSelf(ClassNode trait) {
        ClassNode ret = trait;
        LinkedHashSet<ClassNode> selfTypes = new LinkedHashSet<ClassNode>();
        Traits.collectSelfTypes(ret, selfTypes);
        if (!selfTypes.isEmpty()) {
            selfTypes.add(ret);
            ret = new UnionTypeClassNode(selfTypes.toArray(ClassNode.EMPTY_ARRAY));
        }
        return ret;
    }

    protected ClassNode storeInferredReturnType(ASTNode node, ClassNode type) {
        if (!(node instanceof ClosureExpression)) {
            throw new IllegalArgumentException("Storing inferred return type is only allowed on closures but found " + node.getClass());
        }
        return (ClassNode)node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, type);
    }

    protected ClassNode getInferredReturnType(ASTNode exp) {
        return (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
    }

    protected ClassNode inferListExpressionType(ListExpression list2) {
        List<Expression> expressions = list2.getExpressions();
        if (expressions.isEmpty()) {
            return list2.getType();
        }
        ClassNode listType = list2.getType();
        GenericsType[] genericsTypes = listType.getGenericsTypes();
        if ((genericsTypes == null || genericsTypes.length == 0 || genericsTypes.length == 1 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType())) && !expressions.isEmpty()) {
            LinkedList<ClassNode> nodes2 = new LinkedList<ClassNode>();
            for (Expression expression2 : expressions) {
                if (StaticTypeCheckingVisitor.isNullConstant(expression2)) continue;
                nodes2.add(this.getType(expression2));
            }
            if (nodes2.isEmpty()) {
                return listType;
            }
            ClassNode superType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(nodes2));
            ClassNode inferred = listType.getPlainNodeReference();
            inferred.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(superType))});
            return inferred;
        }
        return listType;
    }

    protected static boolean isNullConstant(Expression expression2) {
        return expression2 instanceof ConstantExpression && ((ConstantExpression)expression2).isNullExpression();
    }

    protected ClassNode inferMapExpressionType(MapExpression map2) {
        ClassNode mapType2 = LINKEDHASHMAP_CLASSNODE.getPlainNodeReference();
        List<MapEntryExpression> entryExpressions = map2.getMapEntryExpressions();
        if (entryExpressions.isEmpty()) {
            return mapType2;
        }
        GenericsType[] genericsTypes = mapType2.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length < 2 || genericsTypes.length == 2 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType()) && ClassHelper.OBJECT_TYPE.equals(genericsTypes[1].getType())) {
            LinkedList<ClassNode> keyTypes = new LinkedList<ClassNode>();
            LinkedList<ClassNode> valueTypes = new LinkedList<ClassNode>();
            for (MapEntryExpression entryExpression : entryExpressions) {
                keyTypes.add(this.getType(entryExpression.getKeyExpression()));
                valueTypes.add(this.getType(entryExpression.getValueExpression()));
            }
            ClassNode keyType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(keyTypes));
            ClassNode valueType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(valueTypes));
            if (!ClassHelper.OBJECT_TYPE.equals(keyType) || !ClassHelper.OBJECT_TYPE.equals(valueType)) {
                ClassNode inferred = mapType2.getPlainNodeReference();
                inferred.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(keyType)), new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(valueType))});
                return inferred;
            }
        }
        return mapType2;
    }

    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments) {
        return this.inferReturnTypeGenerics(receiver, method, arguments, null);
    }

    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments, GenericsType[] explicitTypeHints) {
        ClassNode returnType = method.getReturnType();
        if (method instanceof ExtensionMethodNode && StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(returnType)) {
            ExtensionMethodNode emn = (ExtensionMethodNode)method;
            MethodNode dgmMethod = emn.getExtensionMethodNode();
            ClassNode dc = emn.getDeclaringClass();
            ArgumentListExpression argList = new ArgumentListExpression();
            VariableExpression vexp = GeneralUtils.varX("$foo", receiver);
            vexp.setNodeMetaData(ExtensionMethodDeclaringClass.class, dc);
            argList.addExpression(vexp);
            if (arguments instanceof ArgumentListExpression) {
                List<Expression> expressions = ((ArgumentListExpression)arguments).getExpressions();
                for (Expression arg : expressions) {
                    argList.addExpression(arg);
                }
            } else {
                argList.addExpression(arguments);
            }
            return this.inferReturnTypeGenerics(receiver, dgmMethod, argList);
        }
        if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(returnType)) {
            return returnType;
        }
        if (StaticTypeCheckingSupport.getGenericsWithoutArray(returnType) == null) {
            return returnType;
        }
        Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = this.resolvePlaceHoldersFromDeclaration(receiver, StaticTypeCheckingVisitor.getDeclaringClass(method, arguments), method, method.isStatic());
        if (!receiver.isGenericsPlaceHolder()) {
            GenericsUtils.extractPlaceholders(receiver, resolvedPlaceholders);
        }
        StaticTypeCheckingVisitor.resolvePlaceholdersFromExplicitTypeHints(method, explicitTypeHints, resolvedPlaceholders);
        if (resolvedPlaceholders.isEmpty()) {
            return StaticTypeCheckingSupport.boundUnboundedWildcards(returnType);
        }
        Map<GenericsType.GenericsTypeName, GenericsType> placeholdersFromContext = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext.getEnclosingMethod());
        StaticTypeCheckingSupport.applyGenericsConnections(placeholdersFromContext, resolvedPlaceholders);
        Parameter[] parameters = method.getParameters();
        boolean isVargs = StaticTypeCheckingSupport.isVargs(parameters);
        ArgumentListExpression argList = InvocationWriter.makeArgumentList(arguments);
        List<Expression> expressions = argList.getExpressions();
        int paramLength = parameters.length;
        if (expressions.size() >= paramLength) {
            for (int i = 0; i < paramLength; ++i) {
                boolean lastArg = i == paramLength - 1;
                ClassNode type = parameters[i].getType();
                ClassNode actualType = this.getType(expressions.get(i));
                while (!type.isUsingGenerics() && type.isArray() && actualType.isArray()) {
                    type = type.getComponentType();
                    actualType = actualType.getComponentType();
                }
                if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(type)) continue;
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(actualType, ClassHelper.CLOSURE_TYPE) && ClassHelper.isSAMType(type)) {
                    Map<GenericsType.GenericsTypeName, GenericsType> pholders = StaticTypeCheckingSupport.applyGenericsContextToParameterClass(resolvedPlaceholders, type);
                    actualType = StaticTypeCheckingVisitor.convertClosureTypeToSAMType(expressions.get(i), actualType, type, pholders);
                }
                if (isVargs && lastArg && actualType.isArray()) {
                    actualType = actualType.getComponentType();
                }
                if (isVargs && lastArg && type.isArray()) {
                    type = type.getComponentType();
                }
                actualType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(actualType);
                HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                StaticTypeCheckingSupport.extractGenericsConnections(connections, actualType, type);
                StaticTypeCheckingVisitor.extractGenericsConnectionsForSuperClassAndInterfaces(resolvedPlaceholders, connections);
                StaticTypeCheckingSupport.applyGenericsConnections(connections, resolvedPlaceholders);
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(resolvedPlaceholders, returnType);
    }

    private static void resolvePlaceholdersFromExplicitTypeHints(MethodNode method, GenericsType[] explicitTypeHints, Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders) {
        GenericsType[] methodGenericTypes;
        if (explicitTypeHints != null && (methodGenericTypes = method.getGenericsTypes()) != null && methodGenericTypes.length == explicitTypeHints.length) {
            for (int i = 0; i < explicitTypeHints.length; ++i) {
                GenericsType methodGenericType = methodGenericTypes[i];
                GenericsType explicitTypeHint = explicitTypeHints[i];
                resolvedPlaceholders.put(new GenericsType.GenericsTypeName(methodGenericType.getName()), explicitTypeHint);
            }
        }
    }

    private static void extractGenericsConnectionsForSuperClassAndInterfaces(Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders, Map<GenericsType.GenericsTypeName, GenericsType> connections) {
        for (GenericsType value2 : new HashSet<GenericsType>(connections.values())) {
            if (value2.isPlaceholder() || value2.isWildcard()) continue;
            ClassNode valueType = value2.getType();
            LinkedList<ClassNode> deepNodes = new LinkedList<ClassNode>();
            ClassNode unresolvedSuperClass = valueType.getUnresolvedSuperClass();
            if (unresolvedSuperClass != null && unresolvedSuperClass.isUsingGenerics()) {
                deepNodes.add(unresolvedSuperClass);
            }
            for (ClassNode classNode : valueType.getUnresolvedInterfaces()) {
                if (!classNode.isUsingGenerics()) continue;
                deepNodes.add(classNode);
            }
            if (deepNodes.isEmpty()) continue;
            for (GenericsType genericsType : resolvedPlaceholders.values()) {
                ClassNode[] classNodeArray;
                ClassNode lowerBound = genericsType.getLowerBound();
                if (lowerBound != null) {
                    for (ClassNode deepNode : deepNodes) {
                        if (!lowerBound.equals(deepNode)) continue;
                        StaticTypeCheckingSupport.extractGenericsConnections(connections, deepNode, lowerBound);
                    }
                }
                if ((classNodeArray = genericsType.getUpperBounds()) == null) continue;
                for (ClassNode upperBound : classNodeArray) {
                    for (ClassNode deepNode : deepNodes) {
                        if (!upperBound.equals(deepNode)) continue;
                        StaticTypeCheckingSupport.extractGenericsConnections(connections, deepNode, upperBound);
                    }
                }
            }
        }
    }

    private static ClassNode convertClosureTypeToSAMType(Expression expression2, ClassNode closureType, ClassNode samType, Map<GenericsType.GenericsTypeName, GenericsType> placeholders) {
        if (!samType.isUsingGenerics()) {
            return samType;
        }
        MethodNode sam = ClassHelper.findSAM(samType);
        if (closureType.isUsingGenerics() && sam != null) {
            ClassNode samReturnType = sam.getReturnType();
            ClassNode closureReturnType = (ClassNode)expression2.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (closureReturnType != null && closureReturnType.isUsingGenerics()) {
                ClassNode unwrapped = closureReturnType.getGenericsTypes()[0].getType();
                StaticTypeCheckingSupport.extractGenericsConnections(placeholders, unwrapped, samReturnType);
            } else if (samReturnType.isGenericsPlaceHolder()) {
                placeholders.put(new GenericsType.GenericsTypeName(samReturnType.getGenericsTypes()[0].getName()), closureType.getGenericsTypes()[0]);
            }
            if (expression2 instanceof ClosureExpression && sam.getParameters().length > 0) {
                LinkedList<ClassNode[]> genericsToConnect = new LinkedList<ClassNode[]>();
                Parameter[] closureParams = ((ClosureExpression)expression2).getParameters();
                ClassNode[] closureParamTypes = StaticTypeCheckingVisitor.extractTypesFromParameters(closureParams);
                if (expression2.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS) != null) {
                    closureParamTypes = (ClassNode[])expression2.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                }
                Parameter[] parameters = sam.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter parameter = parameters[i];
                    if (!parameter.getOriginType().isUsingGenerics() || closureParamTypes.length <= i) continue;
                    genericsToConnect.add(new ClassNode[]{closureParamTypes[i], parameter.getOriginType()});
                }
                for (ClassNode[] classNodes : genericsToConnect) {
                    ClassNode expected;
                    ClassNode found = classNodes[0];
                    if (!StaticTypeCheckingSupport.isAssignableTo(found, expected = classNodes[1])) continue;
                    ClassNode generifiedType = GenericsUtils.parameterizeType(found, expected);
                    while (expected.isArray()) {
                        expected = expected.getComponentType();
                        generifiedType = generifiedType.getComponentType();
                    }
                    if (expected.isGenericsPlaceHolder()) {
                        placeholders.put(new GenericsType.GenericsTypeName(expected.getGenericsTypes()[0].getName()), new GenericsType(generifiedType));
                        continue;
                    }
                    GenericsType[] expectedGenericsTypes = expected.getGenericsTypes();
                    GenericsType[] foundGenericsTypes = generifiedType.getGenericsTypes();
                    for (int i = 0; i < expectedGenericsTypes.length; ++i) {
                        GenericsType type = expectedGenericsTypes[i];
                        if (!type.isPlaceholder()) continue;
                        String name2 = type.getName();
                        placeholders.put(new GenericsType.GenericsTypeName(name2), foundGenericsTypes[i]);
                    }
                }
            }
        }
        ClassNode result2 = StaticTypeCheckingSupport.applyGenericsContext(placeholders, samType.redirect());
        return result2;
    }

    private ClassNode resolveGenericsWithContext(Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders, ClassNode currentType) {
        Map<GenericsType.GenericsTypeName, GenericsType> placeholdersFromContext = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext.getEnclosingMethod());
        return StaticTypeCheckingSupport.resolveClassNodeGenerics(resolvedPlaceholders, placeholdersFromContext, currentType);
    }

    private static ClassNode getDeclaringClass(MethodNode method, Expression arguments) {
        ClassNode declaringClass = method.getDeclaringClass();
        if (arguments instanceof ArgumentListExpression) {
            ArgumentListExpression al = (ArgumentListExpression)arguments;
            List<Expression> list2 = al.getExpressions();
            if (list2.isEmpty()) {
                return declaringClass;
            }
            Expression exp = list2.get(0);
            ClassNode cn = (ClassNode)exp.getNodeMetaData(ExtensionMethodDeclaringClass.class);
            if (cn != null) {
                return cn;
            }
        }
        return declaringClass;
    }

    private Map<GenericsType.GenericsTypeName, GenericsType> resolvePlaceHoldersFromDeclaration(ClassNode receiver, ClassNode declaration, MethodNode method, boolean isStaticTarget) {
        if (isStaticTarget && ClassHelper.CLASS_Type.equals(receiver) && receiver.isUsingGenerics() && receiver.getGenericsTypes().length > 0 && !ClassHelper.OBJECT_TYPE.equals(receiver.getGenericsTypes()[0].getType())) {
            return this.resolvePlaceHoldersFromDeclaration(receiver.getGenericsTypes()[0].getType(), declaration, method, isStaticTarget);
        }
        Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = StaticTypeCheckingVisitor.extractPlaceHolders(method, receiver, declaration);
        return resolvedPlaceholders;
    }

    private static boolean isGenericsPlaceHolderOrArrayOf(ClassNode cn) {
        if (cn.isArray()) {
            return StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(cn.getComponentType());
        }
        return cn.isGenericsPlaceHolder();
    }

    private static Map<GenericsType.GenericsTypeName, GenericsType> extractPlaceHolders(MethodNode method, ClassNode receiver, ClassNode declaringClass) {
        if (declaringClass.equals(ClassHelper.OBJECT_TYPE)) {
            HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
            if (method != null) {
                StaticTypeCheckingSupport.addMethodLevelDeclaredGenerics(method, resolvedPlaceholders);
            }
            return resolvedPlaceholders;
        }
        HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = null;
        if (ClassHelper.isPrimitiveType(receiver) && !ClassHelper.isPrimitiveType(declaringClass)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        List<ClassNode> queue = receiver instanceof UnionTypeClassNode ? Arrays.asList(((UnionTypeClassNode)receiver).getDelegates()) : Collections.singletonList(receiver);
        Iterator<ClassNode> iterator2 = queue.iterator();
        block0: while (iterator2.hasNext()) {
            ClassNode item;
            ClassNode current = item = iterator2.next();
            while (current != null) {
                boolean continueLoop = true;
                HashMap<GenericsType.GenericsTypeName, GenericsType> currentPlaceHolders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                if (StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(declaringClass) || declaringClass.equals(current)) {
                    StaticTypeCheckingSupport.extractGenericsConnections(currentPlaceHolders, current, declaringClass);
                    if (method != null) {
                        StaticTypeCheckingSupport.addMethodLevelDeclaredGenerics(method, currentPlaceHolders);
                    }
                    continueLoop = false;
                } else {
                    GenericsUtils.extractPlaceholders(current, currentPlaceHolders);
                }
                if (resolvedPlaceholders != null) {
                    Set entries = currentPlaceHolders.entrySet();
                    for (Map.Entry entry2 : entries) {
                        GenericsType referenced;
                        GenericsType gt = (GenericsType)entry2.getValue();
                        if (!gt.isPlaceholder() || (referenced = (GenericsType)resolvedPlaceholders.get(new GenericsType.GenericsTypeName(gt.getName()))) == null) continue;
                        entry2.setValue(referenced);
                    }
                }
                resolvedPlaceholders = currentPlaceHolders;
                if (!continueLoop) continue block0;
                if ((current = ClassHelper.getNextSuperClass(current, declaringClass)) != null || !ClassHelper.CLASS_Type.equals(declaringClass)) continue;
                current = declaringClass;
            }
        }
        if (resolvedPlaceholders == null) {
            String descriptor = "<>";
            if (method != null) {
                descriptor = method.getTypeDescriptor();
            }
            throw new GroovyBugError("Declaring class for method call to '" + descriptor + "' declared in " + declaringClass.getName() + " was not matched with found receiver " + receiver.getName() + ". This should not have happened!");
        }
        return resolvedPlaceholders;
    }

    protected boolean typeCheckMethodsWithGenericsOrFail(ClassNode receiver, ClassNode[] arguments, MethodNode candidateMethod, Expression location) {
        if (!StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver, arguments, candidateMethod)) {
            Map<GenericsType.GenericsTypeName, GenericsType> classGTs = GenericsUtils.extractPlaceholders(receiver);
            ClassNode[] ptypes = new ClassNode[candidateMethod.getParameters().length];
            Parameter[] parameters = candidateMethod.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                ClassNode type = parameter.getType();
                ptypes[i] = StaticTypeCheckingSupport.fullyResolveType(type, classGTs);
            }
            this.addStaticTypeError("Cannot call " + StaticTypeCheckingVisitor.toMethodGenericTypesString(candidateMethod) + receiver.toString(false) + "#" + StaticTypeCheckingSupport.toMethodParametersString(candidateMethod.getName(), ptypes) + " with arguments " + StaticTypeCheckingVisitor.formatArgumentList(arguments), location);
            return false;
        }
        return true;
    }

    private static String toMethodGenericTypesString(MethodNode node) {
        GenericsType[] genericsTypes = node.getGenericsTypes();
        if (genericsTypes == null) {
            return "";
        }
        return GenericsUtils.toGenericTypesString(genericsTypes);
    }

    protected static String formatArgumentList(ClassNode[] nodes2) {
        if (nodes2 == null || nodes2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(24 * nodes2.length);
        sb.append("[");
        for (ClassNode node : nodes2) {
            sb.append(StaticTypeCheckingSupport.prettyPrintType(node));
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setCharAt(sb.length() - 2, ']');
        }
        return sb.toString();
    }

    private static void putSetterInfo(Expression exp, SetterInfo info2) {
        exp.putNodeMetaData(SetterInfo.class, info2);
    }

    private static SetterInfo removeSetterInfo(Expression exp) {
        Object nodeMetaData = exp.getNodeMetaData(SetterInfo.class);
        if (nodeMetaData != null) {
            exp.removeNodeMetaData(SetterInfo.class);
            return (SetterInfo)nodeMetaData;
        }
        return null;
    }

    @Override
    public void addError(String msg, ASTNode expr2) {
        Long err2 = (long)expr2.getLineNumber() << 16 + expr2.getColumnNumber();
        if (DEBUG_GENERATED_CODE && expr2.getLineNumber() < 0 || !this.typeCheckingContext.reportedErrors.contains(err2)) {
            this.typeCheckingContext.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', expr2.getLineNumber(), expr2.getColumnNumber(), expr2.getLastLineNumber(), expr2.getLastColumnNumber()), this.typeCheckingContext.source));
            this.typeCheckingContext.reportedErrors.add(err2);
        }
    }

    protected void addStaticTypeError(String msg, ASTNode expr2) {
        if (expr2.getColumnNumber() > 0 && expr2.getLineNumber() > 0) {
            this.addError("[Static type checking] - " + msg, expr2);
        } else if (DEBUG_GENERATED_CODE) {
            this.addError("[Static type checking] - Error in generated code [" + expr2.getText() + "] - " + msg, expr2);
        }
    }

    protected void addNoMatchingMethodError(ClassNode receiver, String name2, ClassNode[] args2, Expression call2) {
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver)) {
            receiver = receiver.getGenericsTypes()[0].getType();
        }
        this.addStaticTypeError("Cannot find matching method " + receiver.getText() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name2, args2) + ". Please check if the declared type is correct and if the method exists.", call2);
    }

    protected void addAmbiguousErrorMessage(List<MethodNode> foundMethods, String name2, ClassNode[] args2, Expression expr2) {
        this.addStaticTypeError("Reference to method is ambiguous. Cannot choose between " + StaticTypeCheckingVisitor.prettyPrintMethodList(foundMethods), expr2);
    }

    protected void addCategoryMethodCallError(Expression call2) {
        this.addStaticTypeError("Due to their dynamic nature, usage of categories is not possible with static type checking active", call2);
    }

    protected void addAssignmentError(ClassNode leftType, ClassNode rightType, Expression assignmentExpression) {
        this.addStaticTypeError("Cannot assign value of type " + rightType.toString(false) + " to variable of type " + leftType.toString(false), assignmentExpression);
    }

    protected void addUnsupportedPreOrPostfixExpressionError(Expression expression2) {
        if (expression2 instanceof PostfixExpression) {
            this.addStaticTypeError("Unsupported postfix operation type [" + ((PostfixExpression)expression2).getOperation() + "]", expression2);
        } else if (expression2 instanceof PrefixExpression) {
            this.addStaticTypeError("Unsupported prefix operation type [" + ((PrefixExpression)expression2).getOperation() + "]", expression2);
        } else {
            throw new IllegalArgumentException("Method should be called with a PostfixExpression or a PrefixExpression");
        }
    }

    public void setMethodsToBeVisited(Set<MethodNode> methodsToBeVisited) {
        this.typeCheckingContext.methodsToBeVisited = methodsToBeVisited;
    }

    public void performSecondPass() {
        for (SecondPassExpression wrapper2 : this.typeCheckingContext.secondPassExpressions) {
            VariableExpression var;
            List<ClassNode> classNodes;
            Variable target;
            MethodCallExpression call2;
            Expression objectExpression;
            Expression expression2 = wrapper2.getExpression();
            if (expression2 instanceof BinaryExpression) {
                List<MethodNode> method;
                VariableExpression var2;
                List<ClassNode> classNodes2;
                Variable target2;
                Expression left = ((BinaryExpression)expression2).getLeftExpression();
                if (!(left instanceof VariableExpression) || !((target2 = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)left)) instanceof VariableExpression) || (classNodes2 = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var2 = (VariableExpression)target2)) == null || classNodes2.size() <= 1) continue;
                ClassNode lub3 = WideningCategories.lowestUpperBound(classNodes2);
                String message = StaticTypeCheckingSupport.getOperationName(((BinaryExpression)expression2).getOperation().getType());
                if (message == null || !(method = this.findMethod(lub3, message, this.getType(((BinaryExpression)expression2).getRightExpression()))).isEmpty()) continue;
                this.addStaticTypeError("A closure shared variable [" + target2.getName() + "] has been assigned with various types and the method [" + StaticTypeCheckingSupport.toMethodParametersString(message, this.getType(((BinaryExpression)expression2).getRightExpression())) + "] does not exist in the lowest upper bound of those types: [" + lub3.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot determine safely what is the type of the variable at the moment of the call in a multithreaded context.", expression2);
                continue;
            }
            if (!(expression2 instanceof MethodCallExpression) || !((objectExpression = (call2 = (MethodCallExpression)expression2).getObjectExpression()) instanceof VariableExpression) || !((target = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression)) instanceof VariableExpression) || (classNodes = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var = (VariableExpression)target)) == null || classNodes.size() <= 1) continue;
            ClassNode lub4 = WideningCategories.lowestUpperBound(classNodes);
            MethodNode methodNode = (MethodNode)call2.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            Parameter[] parameters = methodNode.getParameters();
            ClassNode[] params2 = StaticTypeCheckingVisitor.extractTypesFromParameters(parameters);
            ClassNode[] argTypes = (ClassNode[])wrapper2.getData();
            List<MethodNode> method = this.findMethod(lub4, methodNode.getName(), argTypes);
            if (method.size() == 1) continue;
            this.addStaticTypeError("A closure shared variable [" + target.getName() + "] has been assigned with various types and the method [" + StaticTypeCheckingSupport.toMethodParametersString(methodNode.getName(), params2) + "] does not exist in the lowest upper bound of those types: [" + lub4.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot determine safely what is the type of the variable at the moment of the call in a multithreaded context.", call2);
        }
        this.extension.finish();
    }

    protected static ClassNode[] extractTypesFromParameters(Parameter[] parameters) {
        ClassNode[] params2 = new ClassNode[parameters.length];
        for (int i = 0; i < params2.length; ++i) {
            params2[i] = parameters[i].getType();
        }
        return params2;
    }

    protected static ClassNode wrapTypeIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    protected static boolean isClassInnerClassOrEqualTo(ClassNode toBeChecked, ClassNode start) {
        if (start == toBeChecked) {
            return true;
        }
        if (start instanceof InnerClassNode) {
            return StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(toBeChecked, start.getOuterClass());
        }
        return false;
    }

    private static ClassNode infer(Variable variable2) {
        GenericsType gt;
        ClassNode[] upperBounds;
        GenericsType[] genericsTypes;
        ClassNode originType = variable2.getOriginType();
        if (originType.isGenericsPlaceHolder() && null != (genericsTypes = originType.getGenericsTypes()) && genericsTypes.length > 0 && null != (upperBounds = (gt = genericsTypes[0]).getUpperBounds()) && upperBounds.length > 0) {
            return upperBounds[0];
        }
        return variable2.getOriginType();
    }

    private static class ParameterVariableExpression
    extends VariableExpression {
        private final Parameter parameter;

        ParameterVariableExpression(Parameter parameter) {
            super(parameter);
            this.parameter = parameter;
            ClassNode inferred = (ClassNode)parameter.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (inferred == null) {
                inferred = StaticTypeCheckingVisitor.infer(parameter);
                parameter.setNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, inferred);
            }
        }

        @Override
        public void copyNodeMetaData(ASTNode other) {
            this.parameter.copyNodeMetaData(other);
        }

        @Override
        public Object putNodeMetaData(Object key, Object value2) {
            return this.parameter.putNodeMetaData(key, value2);
        }

        @Override
        public void removeNodeMetaData(Object key) {
            this.parameter.removeNodeMetaData(key);
        }

        @Override
        public Map<?, ?> getNodeMetaData() {
            return this.parameter.getNodeMetaData();
        }

        @Override
        public <T> T getNodeMetaData(Object key) {
            return this.parameter.getNodeMetaData(key);
        }

        @Override
        public void setNodeMetaData(Object key, Object value2) {
            this.parameter.setNodeMetaData(key, value2);
        }

        @Override
        public int hashCode() {
            return this.parameter.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            return this.parameter.equals(other);
        }
    }

    private static class SetterInfo {
        final ClassNode receiverType;
        final String name;
        final List<MethodNode> setters;

        private SetterInfo(ClassNode receiverType, String name2, List<MethodNode> setters) {
            this.receiverType = receiverType;
            this.setters = setters;
            this.name = name2;
        }
    }

    public static class SignatureCodecFactory {
        public static SignatureCodec getCodec(int version, ClassLoader classLoader) {
            switch (version) {
                case 1: {
                    return new SignatureCodecVersion1(classLoader);
                }
            }
            return null;
        }
    }

    protected class VariableExpressionTypeMemoizer
    extends ClassCodeVisitorSupport {
        private final Map<VariableExpression, ClassNode> varOrigType;

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType) {
            this.varOrigType = varOrigType;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return StaticTypeCheckingVisitor.this.typeCheckingContext.source;
        }

        @Override
        public void visitVariableExpression(VariableExpression expression2) {
            super.visitVariableExpression(expression2);
            Variable var = StaticTypeCheckingSupport.findTargetVariable(expression2);
            if (var instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)var;
                this.varOrigType.put(ve, (ClassNode)ve.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE));
            }
        }
    }

    private static class ExtensionMethodDeclaringClass {
        private ExtensionMethodDeclaringClass() {
        }
    }
}

