/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class VariableExpressionTransformer {
    public Expression transformVariableExpression(VariableExpression expr2) {
        Expression trn = VariableExpressionTransformer.tryTransformDelegateToProperty(expr2);
        if (trn != null) {
            return trn;
        }
        trn = VariableExpressionTransformer.tryTransformPrivateFieldAccess(expr2);
        if (trn != null) {
            return trn;
        }
        return expr2;
    }

    private static Expression tryTransformDelegateToProperty(VariableExpression expr2) {
        Object val = expr2.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
        if (val == null) {
            return null;
        }
        VariableExpression receiver = new VariableExpression("owner".equals(val) ? (String)val : ("delegate".equals(val) ? (String)val : "this"));
        PropertyExpression pexp = new PropertyExpression((Expression)receiver, expr2.getName());
        pexp.copyNodeMetaData(expr2);
        pexp.setImplicitThis(true);
        pexp.getProperty().setSourcePosition(expr2);
        ClassNode owner = (ClassNode)expr2.getNodeMetaData((Object)StaticCompilationMetadataKeys.PROPERTY_OWNER);
        if (owner != null) {
            receiver.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, owner);
            receiver.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, val);
        }
        return pexp;
    }

    private static Expression tryTransformPrivateFieldAccess(VariableExpression expr2) {
        FieldNode field2 = (FieldNode)expr2.getNodeMetaData((Object)StaticTypesMarker.PV_FIELDS_ACCESS);
        if (field2 == null) {
            field2 = (FieldNode)expr2.getNodeMetaData((Object)StaticTypesMarker.PV_FIELDS_MUTATION);
        }
        if (field2 != null) {
            VariableExpression receiver = new VariableExpression("this");
            PropertyExpression pexp = new PropertyExpression((Expression)receiver, expr2.getName());
            pexp.setImplicitThis(true);
            pexp.getProperty().setSourcePosition(expr2);
            receiver.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, field2.getDeclaringClass());
            pexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, field2.getOriginType());
            return pexp;
        }
        return null;
    }
}

