/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class ListExpressionTransformer {
    private final StaticCompilationTransformer transformer;

    public ListExpressionTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.transformer = staticCompilationTransformer;
    }

    Expression transformListExpression(ListExpression expr2) {
        MethodNode target = (MethodNode)expr2.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (target instanceof ConstructorNode) {
            if (target.getDeclaringClass().isArray()) {
                return this.transformArrayConstructor(expr2, target);
            }
            return this.transformRegularConstructor(expr2, target);
        }
        return this.transformer.superTransform(expr2);
    }

    private Expression transformArrayConstructor(ListExpression expr2, MethodNode target) {
        ArrayExpression aex = new ArrayExpression(target.getDeclaringClass().getComponentType(), this.transformArguments(expr2));
        aex.setSourcePosition(expr2);
        return aex;
    }

    private Expression transformRegularConstructor(ListExpression expr2, MethodNode target) {
        List<Expression> transformedArgs = this.transformArguments(expr2);
        ConstructorCallExpression cce = new ConstructorCallExpression(target.getDeclaringClass(), new ArgumentListExpression(transformedArgs));
        cce.setSourcePosition(expr2);
        cce.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, target);
        return cce;
    }

    private List<Expression> transformArguments(ListExpression expr2) {
        List<Expression> expressions = expr2.getExpressions();
        LinkedList<Expression> transformedArgs = new LinkedList<Expression>();
        for (Expression expression2 : expressions) {
            transformedArgs.add(this.transformer.transform(expression2));
        }
        return transformedArgs;
    }
}

