/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

public class CastExpressionOptimizer {
    private final StaticCompilationTransformer transformer;

    public CastExpressionOptimizer(StaticCompilationTransformer staticCompilationTransformer) {
        this.transformer = staticCompilationTransformer;
    }

    public Expression transformCastExpression(CastExpression cast2) {
        String val;
        ConstantExpression ce;
        Expression expression2;
        if (cast2.isCoerce()) {
            Expression expression3 = cast2.getExpression();
            ClassNode exprInferredType = this.transformer.getTypeChooser().resolveType(expression3, this.transformer.getClassNode());
            ClassNode castType = cast2.getType();
            if (castType.isArray() && expression3 instanceof ListExpression) {
                ArrayExpression arrayExpression = new ArrayExpression(castType.getComponentType(), ((ListExpression)expression3).getExpressions());
                arrayExpression.setSourcePosition(cast2);
                return this.transformer.transform(arrayExpression);
            }
            if (CastExpressionOptimizer.isOptimizable(exprInferredType, castType)) {
                CastExpression trn = new CastExpression(castType, this.transformer.transform(expression3));
                trn.setSourcePosition(cast2);
                trn.copyNodeMetaData(cast2);
                return trn;
            }
        } else if (ClassHelper.char_TYPE.equals(cast2.getType()) && (expression2 = cast2.getExpression()) instanceof ConstantExpression && ClassHelper.STRING_TYPE.equals((ce = (ConstantExpression)expression2).getType()) && (val = (String)ce.getValue()) != null && val.length() == 1) {
            ConstantExpression result2 = new ConstantExpression(Character.valueOf(val.charAt(0)), true);
            result2.setSourcePosition(cast2);
            return result2;
        }
        return this.transformer.superTransform(cast2);
    }

    private static boolean isOptimizable(ClassNode exprInferredType, ClassNode castType) {
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(exprInferredType, castType)) {
            return true;
        }
        return ClassHelper.isPrimitiveType(exprInferredType) && ClassHelper.isPrimitiveType(castType);
    }
}

