/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import groovy.transform.CompilationUnitAware;
import groovy.transform.MapConstructor;
import groovy.transform.TupleConstructor;
import groovy.transform.options.PropertyHandler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.VisibilityUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.transform.MapConstructorASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class TupleConstructorASTTransformation
extends AbstractASTTransformation
implements CompilationUnitAware {
    private CompilationUnit compilationUnit;
    static final Class MY_CLASS = TupleConstructor.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode LHMAP_TYPE = ClassHelper.makeWithoutCaching(LinkedHashMap.class, false);
    private static final ClassNode CHECK_METHOD_TYPE = ClassHelper.make(ImmutableASTTransformation.class);
    private static final Class<? extends Annotation> MAP_CONSTRUCTOR_CLASS = MapConstructor.class;
    private static final Map<Class<?>, Expression> primitivesInitialValues;

    @Override
    public String getAnnotationName() {
        return MY_TYPE_NAME;
    }

    @Override
    public void visit(ASTNode[] nodes2, SourceUnit source) {
        this.init(nodes2, source);
        AnnotatedNode parent = (AnnotatedNode)nodes2[1];
        AnnotationNode anno = (AnnotationNode)nodes2[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            boolean includeProperties = !this.memberHasValue(anno, "includeProperties", false);
            boolean includeSuperFields = this.memberHasValue(anno, "includeSuperFields", true);
            boolean includeSuperProperties = this.memberHasValue(anno, "includeSuperProperties", true);
            boolean allProperties = this.memberHasValue(anno, "allProperties", true);
            List<String> excludes = TupleConstructorASTTransformation.getMemberStringList(anno, "excludes");
            List<String> includes2 = TupleConstructorASTTransformation.getMemberStringList(anno, "includes");
            boolean allNames = this.memberHasValue(anno, "allNames", true);
            if (!this.checkIncludeExcludeUndefinedAware(anno, excludes, includes2, MY_TYPE_NAME)) {
                return;
            }
            if (!this.checkPropertyList(cNode, includes2, "includes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, allProperties, includeSuperFields, false)) {
                return;
            }
            if (!this.checkPropertyList(cNode, excludes, "excludes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, allProperties, includeSuperFields, false)) {
                return;
            }
            GroovyClassLoader classLoader = this.compilationUnit != null ? this.compilationUnit.getTransformLoader() : source.getClassLoader();
            PropertyHandler handler = PropertyHandler.createPropertyHandler(this, classLoader, cNode);
            if (handler == null) {
                return;
            }
            if (!handler.validateAttributes(this, anno)) {
                return;
            }
            Expression pre = anno.getMember("pre");
            if (pre != null && !(pre instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'pre'. Found " + pre, cNode);
                return;
            }
            Expression post2 = anno.getMember("post");
            if (post2 != null && !(post2 instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'post'. Found " + post2, cNode);
                return;
            }
            TupleConstructorASTTransformation.createConstructor(this, anno, cNode, includeFields, includeProperties, includeSuperFields, includeSuperProperties, excludes, includes2, allNames, allProperties, this.sourceUnit, handler, (ClosureExpression)pre, (ClosureExpression)post2);
            if (pre != null) {
                anno.setMember("pre", new ClosureExpression(Parameter.EMPTY_ARRAY, EmptyStatement.INSTANCE));
            }
            if (post2 != null) {
                anno.setMember("post", new ClosureExpression(Parameter.EMPTY_ARRAY, EmptyStatement.INSTANCE));
            }
        }
    }

    private static void createConstructor(AbstractASTTransformation xform, AnnotationNode anno, ClassNode cNode, boolean includeFields, boolean includeProperties, boolean includeSuperFields, boolean includeSuperProperties, List<String> excludes, final List<String> includes2, boolean allNames, boolean allProperties, SourceUnit sourceUnit, PropertyHandler handler, ClosureExpression pre, ClosureExpression post2) {
        FieldNode fNode;
        boolean specialNamedArgCase;
        boolean callSuper = xform.memberHasValue(anno, "callSuper", true);
        boolean force2 = xform.memberHasValue(anno, "force", true);
        boolean defaults = !xform.memberHasValue(anno, "defaults", false);
        HashSet<String> names = new HashSet<String>();
        List<Object> superList = includeSuperProperties || includeSuperFields ? GeneralUtils.getAllProperties(names, cNode.getSuperClass(), includeSuperProperties, includeSuperFields, false, allProperties, true, true) : new ArrayList();
        List<PropertyNode> list2 = GeneralUtils.getAllProperties(names, cNode, includeProperties, includeFields, false, allProperties, false, true);
        boolean makeImmutable = ImmutableASTTransformation.makeImmutable(cNode);
        boolean bl = ImmutableASTTransformation.isSpecialNamedArgCase(list2, !defaults) && superList.isEmpty() || ImmutableASTTransformation.isSpecialNamedArgCase(superList, !defaults) && list2.isEmpty() ? true : (specialNamedArgCase = false);
        if (ClassNodeUtils.hasExplicitConstructor(null, cNode) && !force2 && !makeImmutable) {
            return;
        }
        ArrayList<Parameter> params2 = new ArrayList<Parameter>();
        ArrayList<Expression> superParams = new ArrayList<Expression>();
        BlockStatement preBody = new BlockStatement();
        boolean superInPre = false;
        if (pre != null && (superInPre = GeneralUtils.copyStatementsWithSuperAdjustment(pre, preBody)) && callSuper) {
            xform.addError("Error during " + MY_TYPE_NAME + " processing, can't have a super call in 'pre' closure and also 'callSuper' enabled", cNode);
        }
        BlockStatement body2 = new BlockStatement();
        ArrayList<PropertyNode> tempList = new ArrayList<PropertyNode>(list2);
        tempList.addAll(superList);
        if (!handler.validateProperties(xform, body2, cNode, tempList)) {
            return;
        }
        for (PropertyNode propertyNode : superList) {
            Statement propInit;
            String name2 = propertyNode.getName();
            fNode = propertyNode.getField();
            if (TupleConstructorASTTransformation.shouldSkipUndefinedAware(name2, excludes, includes2, allNames)) continue;
            params2.add(TupleConstructorASTTransformation.createParam(fNode, name2, defaults, xform, makeImmutable));
            if (callSuper) {
                superParams.add(GeneralUtils.varX(name2));
                continue;
            }
            if (superInPre || specialNamedArgCase || (propInit = handler.createPropInit(xform, anno, cNode, propertyNode, null)) == null) continue;
            body2.addStatement(propInit);
        }
        if (callSuper) {
            body2.addStatement(GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.SUPER, GeneralUtils.args(superParams))));
        }
        if (!preBody.isEmpty()) {
            body2.addStatements(preBody.getStatements());
        }
        for (PropertyNode propertyNode : list2) {
            String name2 = propertyNode.getName();
            fNode = propertyNode.getField();
            if (TupleConstructorASTTransformation.shouldSkipUndefinedAware(name2, excludes, includes2, allNames)) continue;
            Parameter nextParam = TupleConstructorASTTransformation.createParam(fNode, name2, defaults, xform, makeImmutable);
            params2.add(nextParam);
            Statement propInit = handler.createPropInit(xform, anno, cNode, propertyNode, null);
            if (propInit == null) continue;
            body2.addStatement(propInit);
        }
        if (post2 != null) {
            body2.addStatement(post2.getCode());
        }
        if (includes2 != null) {
            Comparator<Parameter> includeComparator = new Comparator<Parameter>(){

                @Override
                public int compare(Parameter p1, Parameter p2) {
                    return Integer.compare(includes2.indexOf(p1.getName()), includes2.indexOf(p2.getName()));
                }
            };
            Collections.sort(params2, includeComparator);
        }
        boolean hasMapCons = AnnotatedNodeUtils.hasAnnotation(cNode, MapConstructorASTTransformation.MY_TYPE);
        int n = VisibilityUtils.getVisibility(anno, cNode, ConstructorNode.class, 1);
        ConstructorNode consNode = new ConstructorNode(n, params2.toArray(Parameter.EMPTY_ARRAY), ClassNode.EMPTY_ARRAY, body2);
        AnnotatedNodeUtils.markAsGenerated(cNode, consNode);
        cNode.addConstructor(consNode);
        if (sourceUnit != null && !body2.isEmpty()) {
            VariableScopeVisitor scopeVisitor = new VariableScopeVisitor(sourceUnit);
            scopeVisitor.visitClass(cNode);
        }
        if (body2.isEmpty()) {
            body2.addStatement(new ExpressionStatement(ConstantExpression.EMPTY_EXPRESSION));
        }
        if (!params2.isEmpty() && defaults && !hasMapCons && specialNamedArgCase) {
            ClassNode firstParamType = ((Parameter)params2.get(0)).getType();
            if (params2.size() > 1 || firstParamType.equals(ClassHelper.OBJECT_TYPE)) {
                String message = "The class " + cNode.getName() + " was incorrectly initialized via the map constructor with null.";
                TupleConstructorASTTransformation.addSpecialMapConstructors(n, cNode, message, false);
            }
        }
    }

    private static Parameter createParam(FieldNode fNode, String name2, boolean defaults, AbstractASTTransformation xform, boolean makeImmutable) {
        Parameter param2 = new Parameter(fNode.getType(), name2);
        if (defaults) {
            param2.setInitialExpression(TupleConstructorASTTransformation.providedOrDefaultInitialValue(fNode));
        } else if (!makeImmutable && fNode.getInitialExpression() != null) {
            xform.addError("Error during " + MY_TYPE_NAME + " processing, default value processing disabled but default value found for '" + fNode.getName() + "'", fNode);
        }
        return param2;
    }

    private static Expression providedOrDefaultInitialValue(FieldNode fNode) {
        Expression initialExp = fNode.getInitialExpression() != null ? fNode.getInitialExpression() : ConstantExpression.NULL;
        ClassNode paramType = fNode.getType();
        if (ClassHelper.isPrimitiveType(paramType) && initialExp.equals(ConstantExpression.NULL)) {
            initialExp = primitivesInitialValues.get(paramType.getTypeClass());
        }
        return initialExp;
    }

    public static void addSpecialMapConstructors(int modifiers, ClassNode cNode, String message, boolean addNoArg) {
        Parameter[] parameters = GeneralUtils.params(new Parameter(LHMAP_TYPE, "__namedArgs"));
        BlockStatement code = new BlockStatement();
        VariableExpression namedArgs = GeneralUtils.varX("__namedArgs");
        namedArgs.setAccessedVariable(parameters[0]);
        code.addStatement(GeneralUtils.ifElseS(GeneralUtils.equalsNullX(namedArgs), TupleConstructorASTTransformation.illegalArgumentBlock(message), TupleConstructorASTTransformation.processArgsBlock(cNode, namedArgs)));
        ConstructorNode init2 = new ConstructorNode(modifiers, parameters, ClassNode.EMPTY_ARRAY, code);
        AnnotatedNodeUtils.markAsGenerated(cNode, init2);
        cNode.addConstructor(init2);
        if (addNoArg) {
            code = new BlockStatement();
            code.addStatement(GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.THIS, GeneralUtils.ctorX(LHMAP_TYPE))));
            init2 = new ConstructorNode(modifiers, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, code);
            AnnotatedNodeUtils.markAsGenerated(cNode, init2);
            cNode.addConstructor(init2);
        }
    }

    private static BlockStatement illegalArgumentBlock(String message) {
        return GeneralUtils.block(GeneralUtils.throwS(GeneralUtils.ctorX(ClassHelper.make(IllegalArgumentException.class), GeneralUtils.args(GeneralUtils.constX(message)))));
    }

    private static BlockStatement processArgsBlock(ClassNode cNode, VariableExpression namedArgs) {
        BlockStatement block = new BlockStatement();
        for (PropertyNode pNode : cNode.getProperties()) {
            if (pNode.isStatic()) continue;
            Statement ifStatement = GeneralUtils.ifS((Expression)GeneralUtils.callX((Expression)namedArgs, "containsKey", (Expression)GeneralUtils.constX(pNode.getName())), GeneralUtils.assignS(GeneralUtils.varX(pNode), GeneralUtils.propX((Expression)namedArgs, pNode.getName())));
            block.addStatement(ifStatement);
        }
        block.addStatement(GeneralUtils.stmt(GeneralUtils.callX(CHECK_METHOD_TYPE, "checkPropNames", (Expression)GeneralUtils.args(GeneralUtils.varX("this"), namedArgs))));
        return block;
    }

    @Override
    public void setCompilationUnit(CompilationUnit unit) {
        this.compilationUnit = unit;
    }

    static {
        ConstantExpression zero2 = GeneralUtils.constX(0);
        ConstantExpression zeroDecimal = GeneralUtils.constX(0.0);
        primitivesInitialValues = new HashMap();
        primitivesInitialValues.put(Integer.TYPE, zero2);
        primitivesInitialValues.put(Long.TYPE, zero2);
        primitivesInitialValues.put(Short.TYPE, zero2);
        primitivesInitialValues.put(Byte.TYPE, zero2);
        primitivesInitialValues.put(Character.TYPE, zero2);
        primitivesInitialValues.put(Float.TYPE, zeroDecimal);
        primitivesInitialValues.put(Double.TYPE, zeroDecimal);
        primitivesInitialValues.put(Boolean.TYPE, ConstantExpression.FALSE);
    }
}

