/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.ToString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ToStringASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = ToString.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode STRINGBUILDER_TYPE = ClassHelper.make(StringBuilder.class);
    private static final ClassNode INVOKER_TYPE = ClassHelper.make(InvokerHelper.class);

    @Override
    public void visit(ASTNode[] nodes2, SourceUnit source) {
        this.init(nodes2, source);
        AnnotatedNode parent = (AnnotatedNode)nodes2[1];
        AnnotationNode anno = (AnnotationNode)nodes2[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            boolean includeSuper = this.memberHasValue(anno, "includeSuper", true);
            boolean includeSuperProperties = this.memberHasValue(anno, "includeSuperProperties", true);
            boolean includeSuperFields = this.memberHasValue(anno, "includeSuperFields", true);
            boolean cacheToString = this.memberHasValue(anno, "cache", true);
            List<String> excludes = ToStringASTTransformation.getMemberStringList(anno, "excludes");
            List<String> includes2 = ToStringASTTransformation.getMemberStringList(anno, "includes");
            if (includes2 != null && includes2.contains("super")) {
                includeSuper = true;
            }
            if (includeSuper && cNode.getSuperClass().getName().equals("java.lang.Object")) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: includeSuper=true but '" + cNode.getName() + "' has no super class.", anno);
            }
            boolean includeNames = this.memberHasValue(anno, "includeNames", true);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            boolean ignoreNulls = this.memberHasValue(anno, "ignoreNulls", true);
            boolean includePackage = !this.memberHasValue(anno, "includePackage", false);
            boolean allProperties = !this.memberHasValue(anno, "allProperties", false);
            boolean allNames = this.memberHasValue(anno, "allNames", true);
            if (!this.checkIncludeExcludeUndefinedAware(anno, excludes, includes2, MY_TYPE_NAME)) {
                return;
            }
            if (!this.checkPropertyList(cNode, includes2 != null ? DefaultGroovyMethods.minus(includes2, (Object)"super") : null, "includes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, allProperties)) {
                return;
            }
            if (!this.checkPropertyList(cNode, excludes, "excludes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, allProperties)) {
                return;
            }
            ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes2, includeNames, ignoreNulls, includePackage, cacheToString, includeSuperProperties, allProperties, allNames, includeSuperFields);
        }
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes2, boolean includeNames) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes2, includeNames, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes2, boolean includeNames, boolean ignoreNulls) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes2, includeNames, ignoreNulls, true);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes2, boolean includeNames, boolean ignoreNulls, boolean includePackage) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes2, includeNames, ignoreNulls, includePackage, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes2, boolean includeNames, boolean ignoreNulls, boolean includePackage, boolean cache2) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes2, includeNames, ignoreNulls, includePackage, cache2, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes2, boolean includeNames, boolean ignoreNulls, boolean includePackage, boolean cache2, boolean includeSuperProperties) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes2, includeNames, ignoreNulls, includePackage, cache2, includeSuperProperties, true);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes2, boolean includeNames, boolean ignoreNulls, boolean includePackage, boolean cache2, boolean includeSuperProperties, boolean allProperties) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes2, includeNames, ignoreNulls, includePackage, cache2, includeSuperProperties, allProperties, false, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes2, boolean includeNames, boolean ignoreNulls, boolean includePackage, boolean cache2, boolean includeSuperProperties, boolean allProperties, boolean allNames, boolean includeSuperFields) {
        Expression tempToString;
        boolean hasExistingToString = GeneralUtils.hasDeclaredMethod(cNode, "toString", 0);
        if (hasExistingToString && GeneralUtils.hasDeclaredMethod(cNode, "_toString", 0)) {
            return;
        }
        BlockStatement body2 = new BlockStatement();
        if (cache2) {
            FieldNode cacheField = cNode.addField("$to$string", 4098, ClassHelper.STRING_TYPE, null);
            VariableExpression savedToString = GeneralUtils.varX(cacheField);
            body2.addStatement(GeneralUtils.ifS((Expression)GeneralUtils.equalsNullX(savedToString), GeneralUtils.assignS(savedToString, ToStringASTTransformation.calculateToStringStatements(cNode, includeSuper, includeFields, includeSuperFields, excludes, includes2, includeNames, ignoreNulls, includePackage, includeSuperProperties, allProperties, body2, allNames))));
            tempToString = savedToString;
        } else {
            tempToString = ToStringASTTransformation.calculateToStringStatements(cNode, includeSuper, includeFields, includeSuperFields, excludes, includes2, includeNames, ignoreNulls, includePackage, includeSuperProperties, allProperties, body2, allNames);
        }
        body2.addStatement(GeneralUtils.returnS(tempToString));
        ClassNodeUtils.addGeneratedMethod(cNode, hasExistingToString ? "_toString" : "toString", hasExistingToString ? 2 : 1, ClassHelper.STRING_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body2);
    }

    private static Expression calculateToStringStatements(ClassNode cNode, boolean includeSuper, boolean includeFields, boolean includeSuperFields, List<String> excludes, final List<String> includes2, boolean includeNames, boolean ignoreNulls, boolean includePackage, boolean includeSuperProperties, boolean allProperties, BlockStatement body2, boolean allNames) {
        VariableExpression result2 = GeneralUtils.localVarX("_result");
        body2.addStatement(GeneralUtils.declS(result2, GeneralUtils.ctorX(STRINGBUILDER_TYPE)));
        ArrayList<ToStringElement> elements = new ArrayList<ToStringElement>();
        VariableExpression first = GeneralUtils.localVarX("$toStringFirst");
        body2.addStatement(GeneralUtils.declS(first, GeneralUtils.constX(Boolean.TRUE)));
        String className2 = includePackage ? cNode.getName() : cNode.getNameWithoutPackage();
        body2.addStatement(ToStringASTTransformation.appendS(result2, GeneralUtils.constX(className2 + "(")));
        HashSet<String> names = new HashSet<String>();
        List<Object> superList = includeSuperProperties || includeSuperFields ? GeneralUtils.getAllProperties(names, cNode, cNode.getSuperClass(), includeSuperProperties, includeSuperFields, allProperties, false, true, true, true, allNames, false) : new ArrayList();
        List<PropertyNode> list2 = GeneralUtils.getAllProperties(names, cNode, cNode, true, includeFields, allProperties, false, false, true, false, allNames, false);
        list2.addAll(superList);
        for (PropertyNode pNode : list2) {
            String name2 = pNode.getName();
            if (ToStringASTTransformation.shouldSkipUndefinedAware(name2, excludes, includes2, allNames)) continue;
            FieldNode fNode = pNode.getField();
            if (!cNode.hasProperty(name2) && fNode.getDeclaringClass() != null) {
                elements.add(new ToStringElement(GeneralUtils.varX(fNode), name2, ToStringASTTransformation.canBeSelf(cNode, fNode.getType())));
                continue;
            }
            Expression getter2 = GeneralUtils.getterThisX(cNode, pNode);
            elements.add(new ToStringElement(getter2, name2, ToStringASTTransformation.canBeSelf(cNode, pNode.getType())));
        }
        if (includeSuper) {
            elements.add(new ToStringElement(GeneralUtils.callSuperX("toString"), "super", false));
        }
        if (includes2 != null) {
            Comparator<ToStringElement> includeComparator = new Comparator<ToStringElement>(){

                @Override
                public int compare(ToStringElement tse1, ToStringElement tse2) {
                    return Integer.compare(includes2.indexOf(tse1.name), includes2.indexOf(tse2.name));
                }
            };
            Collections.sort(elements, includeComparator);
        }
        for (ToStringElement el : elements) {
            ToStringASTTransformation.appendValue(body2, result2, first, el.value, el.name, includeNames, ignoreNulls, el.canBeSelf);
        }
        body2.addStatement(ToStringASTTransformation.appendS(result2, GeneralUtils.constX(")")));
        MethodCallExpression toString2 = GeneralUtils.callX(result2, "toString");
        toString2.setImplicitThis(false);
        return toString2;
    }

    private static void appendValue(BlockStatement body2, Expression result2, VariableExpression first, Expression value2, String name2, boolean includeNames, boolean ignoreNulls, boolean canBeSelf) {
        BlockStatement thenBlock = new BlockStatement();
        BlockStatement appendValue = ignoreNulls ? GeneralUtils.ifS((Expression)GeneralUtils.notNullX(value2), thenBlock) : thenBlock;
        ToStringASTTransformation.appendCommaIfNotFirst(thenBlock, result2, first);
        ToStringASTTransformation.appendPrefix(thenBlock, result2, name2, includeNames);
        if (canBeSelf) {
            thenBlock.addStatement(GeneralUtils.ifElseS(GeneralUtils.sameX(value2, new VariableExpression("this")), ToStringASTTransformation.appendS(result2, GeneralUtils.constX("(this)")), ToStringASTTransformation.appendS(result2, GeneralUtils.callX(INVOKER_TYPE, "toString", value2))));
        } else {
            thenBlock.addStatement(ToStringASTTransformation.appendS(result2, GeneralUtils.callX(INVOKER_TYPE, "toString", value2)));
        }
        body2.addStatement(appendValue);
    }

    private static boolean canBeSelf(ClassNode cNode, ClassNode valueType) {
        return StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(valueType, cNode);
    }

    private static void appendCommaIfNotFirst(BlockStatement body2, Expression result2, VariableExpression first) {
        body2.addStatement(GeneralUtils.ifElseS(first, GeneralUtils.assignS(first, ConstantExpression.FALSE), ToStringASTTransformation.appendS(result2, GeneralUtils.constX(", "))));
    }

    private static void appendPrefix(BlockStatement body2, Expression result2, String name2, boolean includeNames) {
        if (includeNames) {
            body2.addStatement(ToStringASTTransformation.toStringPropertyName(result2, name2));
        }
    }

    private static Statement toStringPropertyName(Expression result2, String fName) {
        BlockStatement body2 = new BlockStatement();
        body2.addStatement(ToStringASTTransformation.appendS(result2, GeneralUtils.constX(fName + ":")));
        return body2;
    }

    private static Statement appendS(Expression result2, Expression expr2) {
        MethodCallExpression append2 = GeneralUtils.callX(result2, "append", expr2);
        append2.setImplicitThis(false);
        return GeneralUtils.stmt(append2);
    }

    private static class ToStringElement {
        Expression value;
        String name;
        boolean canBeSelf;

        ToStringElement(Expression value2, String name2, boolean canBeSelf) {
            this.value = value2;
            this.name = name2;
            this.canBeSelf = canBeSelf;
        }
    }
}

