/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.Synchronized;
import java.util.Collections;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class SynchronizedASTTransformation
extends AbstractASTTransformation {
    private static final Class MY_CLASS = Synchronized.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();

    @Override
    public void visit(ASTNode[] nodes2, SourceUnit source) {
        this.init(nodes2, source);
        AnnotatedNode parent = (AnnotatedNode)nodes2[1];
        AnnotationNode node = (AnnotationNode)nodes2[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        String value2 = SynchronizedASTTransformation.getMemberStringValue(node, "value");
        if (parent instanceof MethodNode) {
            MethodNode mNode = (MethodNode)parent;
            if (mNode.isAbstract()) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: annotation not allowed on abstract method '" + mNode.getName() + "'", mNode);
                return;
            }
            ClassNode cNode = mNode.getDeclaringClass();
            String lockExpr = this.determineLock(value2, cNode, mNode);
            if (lockExpr == null) {
                return;
            }
            Statement origCode = mNode.getCode();
            SynchronizedStatement newCode = new SynchronizedStatement(GeneralUtils.varX(lockExpr), origCode);
            mNode.setCode(newCode);
        }
    }

    private String determineLock(String value2, ClassNode cNode, MethodNode mNode) {
        boolean isStatic = mNode.isStatic();
        if (value2 != null && value2.length() > 0 && !value2.equalsIgnoreCase("$lock")) {
            if (cNode.getDeclaredField(value2) == null) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: lock field with name '" + value2 + "' not found in class " + cNode.getName(), mNode);
                return null;
            }
            FieldNode field2 = cNode.getDeclaredField(value2);
            if (isStatic && !field2.isStatic()) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: lock field with name '" + value2 + "' must be static for static method '" + mNode.getName() + "'", field2);
                return null;
            }
            return value2;
        }
        if (isStatic) {
            FieldNode field3 = cNode.getDeclaredField("$LOCK");
            if (field3 == null) {
                int visibility = 26;
                cNode.addField("$LOCK", visibility, ClassHelper.OBJECT_TYPE, SynchronizedASTTransformation.zeroLengthObjectArray());
            } else if (!field3.isStatic()) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: $LOCK field must be static", field3);
            }
            return "$LOCK";
        }
        FieldNode field4 = cNode.getDeclaredField("$lock");
        if (field4 == null) {
            int visibility = 18;
            cNode.addField("$lock", visibility, ClassHelper.OBJECT_TYPE, SynchronizedASTTransformation.zeroLengthObjectArray());
        } else if (field4.isStatic()) {
            this.addError("Error during " + MY_TYPE_NAME + " processing: $lock field must not be static", field4);
        }
        return "$lock";
    }

    private static Expression zeroLengthObjectArray() {
        return new ArrayExpression(ClassHelper.OBJECT_TYPE, null, Collections.singletonList(GeneralUtils.constX(0)));
    }
}

